/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.GooglePayResult;
import com.stripe.android.model.KlarnaSourceParams;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceOrderParams;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parceler;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b;\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0087\b\u0018\u0000 m2\u00020\u00012\u00020\u0002:\u0006lmnopqB\u00b9\u0001\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u0012\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b\u00a2\u0006\u0002\u0010\u001cJ\t\u0010L\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0017\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0015H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0017H\u00c2\u0003J\t\u0010P\u001a\u00020\u0019H\u00c2\u0003J\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u00c0\u0003\u00a2\u0006\u0002\bRJ\u0010\u0010S\u001a\u0004\u0018\u00010\u0006H\u00c0\u0003\u00a2\u0006\u0002\bTJ\u0010\u0010U\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u000b\u0010V\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010W\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010Y\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010Z\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010[\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u00c2\u0001\u0010\\\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u00c6\u0001\u00a2\u0006\u0002\u0010]J\t\u0010^\u001a\u00020_H\u00d6\u0001J\u0013\u0010`\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010c\u001a\u00020_H\u00d6\u0001J\u001e\u0010d\u001a\u00020\u00002\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010\u0015J\u0014\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#0\u0015H\u0016J\t\u0010f\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020_H\u00d6\u0001R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001f\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010#0\u00158F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R(\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010%\"\u0004\b1\u00102R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010)\"\u0004\b8\u0010+R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010)\"\u0004\b>\u0010+R\u0017\u0010?\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b@\u0010A\u001a\u0004\bB\u0010)R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010)R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/stripe/android/model/SourceParams;", "Lcom/stripe/android/model/StripeParamsModel;", "Landroid/os/Parcelable;", "typeRaw", "", "typeData", "Lcom/stripe/android/model/SourceParams$TypeData;", "amount", "", "currency", "owner", "Lcom/stripe/android/model/SourceParams$OwnerParams;", "usage", "Lcom/stripe/android/model/Source$Usage;", "returnUrl", "flow", "Lcom/stripe/android/model/SourceParams$Flow;", "sourceOrder", "Lcom/stripe/android/model/SourceOrderParams;", "token", "metadata", "", "weChatParams", "Lcom/stripe/android/model/SourceParams$WeChatParams;", "apiParams", "Lcom/stripe/android/model/SourceParams$ApiParams;", "attribution", "", "(Ljava/lang/String;Lcom/stripe/android/model/SourceParams$TypeData;Ljava/lang/Long;Ljava/lang/String;Lcom/stripe/android/model/SourceParams$OwnerParams;Lcom/stripe/android/model/Source$Usage;Ljava/lang/String;Lcom/stripe/android/model/SourceParams$Flow;Lcom/stripe/android/model/SourceOrderParams;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/model/SourceParams$WeChatParams;Lcom/stripe/android/model/SourceParams$ApiParams;Ljava/util/Set;)V", "getAmount", "()Ljava/lang/Long;", "setAmount", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "apiParameterMap", "", "getApiParameterMap", "()Ljava/util/Map;", "getAttribution$payments_core_release", "()Ljava/util/Set;", "getCurrency", "()Ljava/lang/String;", "setCurrency", "(Ljava/lang/String;)V", "getFlow", "()Lcom/stripe/android/model/SourceParams$Flow;", "setFlow", "(Lcom/stripe/android/model/SourceParams$Flow;)V", "getMetadata", "setMetadata", "(Ljava/util/Map;)V", "getOwner", "()Lcom/stripe/android/model/SourceParams$OwnerParams;", "setOwner", "(Lcom/stripe/android/model/SourceParams$OwnerParams;)V", "getReturnUrl", "setReturnUrl", "getSourceOrder", "()Lcom/stripe/android/model/SourceOrderParams;", "setSourceOrder", "(Lcom/stripe/android/model/SourceOrderParams;)V", "getToken", "setToken", "type", "getType$annotations", "()V", "getType", "getTypeData$payments_core_release", "()Lcom/stripe/android/model/SourceParams$TypeData;", "setTypeData$payments_core_release", "(Lcom/stripe/android/model/SourceParams$TypeData;)V", "getTypeRaw", "getUsage", "()Lcom/stripe/android/model/Source$Usage;", "setUsage", "(Lcom/stripe/android/model/Source$Usage;)V", "component1", "component10", "component11", "component12", "component13", "component14", "component14$payments_core_release", "component2", "component2$payments_core_release", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Lcom/stripe/android/model/SourceParams$TypeData;Ljava/lang/Long;Ljava/lang/String;Lcom/stripe/android/model/SourceParams$OwnerParams;Lcom/stripe/android/model/Source$Usage;Ljava/lang/String;Lcom/stripe/android/model/SourceParams$Flow;Lcom/stripe/android/model/SourceOrderParams;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/model/SourceParams$WeChatParams;Lcom/stripe/android/model/SourceParams$ApiParams;Ljava/util/Set;)Lcom/stripe/android/model/SourceParams;", "describeContents", "", "equals", "", "other", "hashCode", "setApiParameterMap", "toParamMap", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "ApiParams", "Companion", "Flow", "OwnerParams", "TypeData", "WeChatParams", "payments-core_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class SourceParams
implements StripeParamsModel,
Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String typeRaw;
    @Nullable
    private TypeData typeData;
    @Nullable
    private Long amount;
    @Nullable
    private String currency;
    @Nullable
    private OwnerParams owner;
    @Nullable
    private Source.Usage usage;
    @Nullable
    private String returnUrl;
    @Nullable
    private Flow flow;
    @Nullable
    private SourceOrderParams sourceOrder;
    @Nullable
    private String token;
    @Nullable
    private Map<String, String> metadata;
    @Nullable
    private WeChatParams weChatParams;
    @NotNull
    private ApiParams apiParams;
    @NotNull
    private final Set<String> attribution;
    @NotNull
    public static final Parcelable.Creator<SourceParams> CREATOR;
    public static final int $stable;
    @NotNull
    private static final String PARAM_AMOUNT = "amount";
    @NotNull
    private static final String PARAM_CLIENT_SECRET = "client_secret";
    @NotNull
    private static final String PARAM_CURRENCY = "currency";
    @NotNull
    private static final String PARAM_FLOW = "flow";
    @NotNull
    private static final String PARAM_METADATA = "metadata";
    @NotNull
    private static final String PARAM_OWNER = "owner";
    @NotNull
    private static final String PARAM_REDIRECT = "redirect";
    @NotNull
    private static final String PARAM_RETURN_URL = "return_url";
    @NotNull
    private static final String PARAM_SOURCE_ORDER = "source_order";
    @NotNull
    private static final String PARAM_TOKEN = "token";
    @NotNull
    private static final String PARAM_TYPE = "type";
    @NotNull
    private static final String PARAM_USAGE = "usage";
    @NotNull
    private static final String PARAM_WECHAT = "wechat";

    public SourceParams(@NotNull String typeRaw, @Nullable TypeData typeData, @Nullable Long amount, @Nullable String currency, @Nullable OwnerParams owner, @Nullable Source.Usage usage, @Nullable String returnUrl, @Nullable Flow flow, @Nullable SourceOrderParams sourceOrder, @Nullable String token, @Nullable Map<String, String> metadata, @Nullable WeChatParams weChatParams, @NotNull ApiParams apiParams, @NotNull Set<String> attribution) {
        Intrinsics.checkNotNullParameter((Object)typeRaw, (String)"typeRaw");
        Intrinsics.checkNotNullParameter((Object)apiParams, (String)"apiParams");
        Intrinsics.checkNotNullParameter(attribution, (String)"attribution");
        this.typeRaw = typeRaw;
        this.typeData = typeData;
        this.amount = amount;
        this.currency = currency;
        this.owner = owner;
        this.usage = usage;
        this.returnUrl = returnUrl;
        this.flow = flow;
        this.sourceOrder = sourceOrder;
        this.token = token;
        this.metadata = metadata;
        this.weChatParams = weChatParams;
        this.apiParams = apiParams;
        this.attribution = attribution;
    }

    public /* synthetic */ SourceParams(String string, TypeData typeData, Long l, String string2, OwnerParams ownerParams, Source.Usage usage, String string3, Flow flow, SourceOrderParams sourceOrderParams, String string4, Map map, WeChatParams weChatParams, ApiParams apiParams, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            typeData = null;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            ownerParams = null;
        }
        if ((n & 0x20) != 0) {
            usage = null;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        if ((n & 0x80) != 0) {
            flow = null;
        }
        if ((n & 0x100) != 0) {
            sourceOrderParams = null;
        }
        if ((n & 0x200) != 0) {
            string4 = null;
        }
        if ((n & 0x400) != 0) {
            map = null;
        }
        if ((n & 0x800) != 0) {
            weChatParams = null;
        }
        if ((n & 0x1000) != 0) {
            apiParams = new ApiParams(null, 1, null);
        }
        if ((n & 0x2000) != 0) {
            set = SetsKt.emptySet();
        }
        this(string, typeData, l, string2, ownerParams, usage, string3, flow, sourceOrderParams, string4, map, weChatParams, apiParams, set);
    }

    @NotNull
    public final String getTypeRaw() {
        return this.typeRaw;
    }

    @Nullable
    public final TypeData getTypeData$payments_core_release() {
        return this.typeData;
    }

    public final void setTypeData$payments_core_release(@Nullable TypeData typeData) {
        this.typeData = typeData;
    }

    @Nullable
    public final Long getAmount() {
        return this.amount;
    }

    public final void setAmount(@Nullable Long l) {
        this.amount = l;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    public final void setCurrency(@Nullable String string) {
        this.currency = string;
    }

    @Nullable
    public final OwnerParams getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable OwnerParams ownerParams) {
        this.owner = ownerParams;
    }

    @Nullable
    public final Source.Usage getUsage() {
        return this.usage;
    }

    public final void setUsage(@Nullable Source.Usage usage) {
        this.usage = usage;
    }

    @Nullable
    public final String getReturnUrl() {
        return this.returnUrl;
    }

    public final void setReturnUrl(@Nullable String string) {
        this.returnUrl = string;
    }

    @Nullable
    public final Flow getFlow() {
        return this.flow;
    }

    public final void setFlow(@Nullable Flow flow) {
        this.flow = flow;
    }

    @Nullable
    public final SourceOrderParams getSourceOrder() {
        return this.sourceOrder;
    }

    public final void setSourceOrder(@Nullable SourceOrderParams sourceOrderParams) {
        this.sourceOrder = sourceOrderParams;
    }

    @Nullable
    public final String getToken() {
        return this.token;
    }

    public final void setToken(@Nullable String string) {
        this.token = string;
    }

    @Nullable
    public final Map<String, String> getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@Nullable Map<String, String> map) {
        this.metadata = map;
    }

    @NotNull
    public final Set<String> getAttribution$payments_core_release() {
        return this.attribution;
    }

    @NotNull
    public final String getType() {
        return Source.Companion.asSourceType(this.typeRaw);
    }

    public static /* synthetic */ void getType$annotations() {
    }

    @NotNull
    public final Map<String, Object> getApiParameterMap() {
        return this.apiParams.getValue();
    }

    @NotNull
    public final SourceParams setApiParameterMap(@Nullable Map<String, ? extends Object> apiParameterMap) {
        SourceParams sourceParams;
        SourceParams $this$setApiParameterMap_u24lambda_u2d0 = sourceParams = this;
        boolean bl = false;
        Map map = apiParameterMap;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        $this$setApiParameterMap_u24lambda_u2d0.apiParams = new ApiParams(map);
        return sourceParams;
    }

    @NotNull
    public Map<String, Object> toParamMap() {
        Map map;
        Map map2;
        Map map3;
        Map map4;
        Map map5;
        Map map6;
        Map map7;
        Map map8;
        Map map9;
        Map map10;
        Map map11;
        Map map12;
        Map map13;
        Map map14;
        Map map15;
        Map map16;
        Map map17;
        Map map18;
        Map map19;
        Map map20;
        Map map21;
        Map map22;
        Map<String, Object> map23;
        Map<String, Object> it;
        Map<String, Object> map24;
        Map<String, Object> map25 = map24 = this.apiParams.getValue();
        Map map26 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_TYPE, (Object)this.typeRaw));
        boolean bl = false;
        boolean bl2 = !it.isEmpty();
        Map map27 = map26;
        Map<String, Object> map28 = map23 = bl2 ? map24 : null;
        if (map23 != null) {
            it = map23;
            map26 = map27;
            boolean bl3 = false;
            map22 = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.typeRaw, it));
            map27 = map26;
        } else {
            map22 = map21 = null;
        }
        if (map22 == null) {
            map21 = MapsKt.emptyMap();
        }
        Map map29 = MapsKt.plus((Map)map27, map21);
        TypeData typeData = this.typeData;
        Map map30 = typeData != null ? typeData.createParams() : null;
        if (map30 == null) {
            map30 = MapsKt.emptyMap();
        }
        Map map31 = MapsKt.plus((Map)map29, map30);
        Long l = this.amount;
        if (l != null) {
            long it2 = ((Number)l).longValue();
            map26 = map31;
            boolean bl4 = false;
            map20 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_AMOUNT, (Object)it2));
            map31 = map26;
        } else {
            map20 = map19 = null;
        }
        if (map20 == null) {
            map19 = MapsKt.emptyMap();
        }
        Map map32 = MapsKt.plus((Map)map31, map19);
        String string = this.currency;
        if (string != null) {
            String it3 = string;
            map26 = map32;
            boolean bl5 = false;
            map18 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_CURRENCY, (Object)it3));
            map32 = map26;
        } else {
            map18 = map17 = null;
        }
        if (map18 == null) {
            map17 = MapsKt.emptyMap();
        }
        Map map33 = MapsKt.plus((Map)map32, map17);
        Flow flow = this.flow;
        if (flow != null) {
            Flow it4 = flow;
            map26 = map33;
            boolean bl6 = false;
            map16 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_FLOW, (Object)it4.getCode$payments_core_release()));
            map33 = map26;
        } else {
            map16 = map15 = null;
        }
        if (map16 == null) {
            map15 = MapsKt.emptyMap();
        }
        Map map34 = MapsKt.plus((Map)map33, map15);
        SourceOrderParams sourceOrderParams = this.sourceOrder;
        if (sourceOrderParams != null) {
            SourceOrderParams it5 = sourceOrderParams;
            map26 = map34;
            boolean bl7 = false;
            map14 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_SOURCE_ORDER, it5.toParamMap()));
            map34 = map26;
        } else {
            map14 = map13 = null;
        }
        if (map14 == null) {
            map13 = MapsKt.emptyMap();
        }
        Map map35 = MapsKt.plus((Map)map34, map13);
        OwnerParams ownerParams = this.owner;
        if (ownerParams != null) {
            OwnerParams it6 = ownerParams;
            map26 = map35;
            boolean bl8 = false;
            map12 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_OWNER, it6.toParamMap()));
            map35 = map26;
        } else {
            map12 = map11 = null;
        }
        if (map12 == null) {
            map11 = MapsKt.emptyMap();
        }
        Map map36 = MapsKt.plus((Map)map35, map11);
        String string2 = this.returnUrl;
        if (string2 != null) {
            String it7 = string2;
            map26 = map36;
            boolean bl9 = false;
            map10 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_REDIRECT, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_RETURN_URL, (Object)it7))));
            map36 = map26;
        } else {
            map10 = map9 = null;
        }
        if (map10 == null) {
            map9 = MapsKt.emptyMap();
        }
        Map map37 = MapsKt.plus((Map)map36, map9);
        Map<String, String> map38 = this.metadata;
        if (map38 != null) {
            Map<String, String> it8 = map38;
            map26 = map37;
            boolean bl10 = false;
            map8 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_METADATA, it8));
            map37 = map26;
        } else {
            map8 = map7 = null;
        }
        if (map8 == null) {
            map7 = MapsKt.emptyMap();
        }
        Map map39 = MapsKt.plus((Map)map37, map7);
        String string3 = this.token;
        if (string3 != null) {
            String it9 = string3;
            map26 = map39;
            boolean bl11 = false;
            map6 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_TOKEN, (Object)it9));
            map39 = map26;
        } else {
            map6 = map5 = null;
        }
        if (map6 == null) {
            map5 = MapsKt.emptyMap();
        }
        Map map40 = MapsKt.plus((Map)map39, map5);
        Source.Usage usage = this.usage;
        if (usage != null) {
            Source.Usage it10 = usage;
            map26 = map40;
            boolean bl12 = false;
            map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_USAGE, (Object)it10.getCode$payments_core_release()));
            map40 = map26;
        } else {
            map4 = map3 = null;
        }
        if (map4 == null) {
            map3 = MapsKt.emptyMap();
        }
        Map map41 = MapsKt.plus((Map)map40, map3);
        WeChatParams weChatParams = this.weChatParams;
        if (weChatParams != null) {
            WeChatParams it11 = weChatParams;
            map26 = map41;
            boolean bl13 = false;
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_WECHAT, it11.toParamMap()));
            map41 = map26;
        } else {
            map2 = map = null;
        }
        if (map2 == null) {
            map = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map41, map);
    }

    @NotNull
    public final String component1() {
        return this.typeRaw;
    }

    @Nullable
    public final TypeData component2$payments_core_release() {
        return this.typeData;
    }

    @Nullable
    public final Long component3() {
        return this.amount;
    }

    @Nullable
    public final String component4() {
        return this.currency;
    }

    @Nullable
    public final OwnerParams component5() {
        return this.owner;
    }

    @Nullable
    public final Source.Usage component6() {
        return this.usage;
    }

    @Nullable
    public final String component7() {
        return this.returnUrl;
    }

    @Nullable
    public final Flow component8() {
        return this.flow;
    }

    @Nullable
    public final SourceOrderParams component9() {
        return this.sourceOrder;
    }

    @Nullable
    public final String component10() {
        return this.token;
    }

    @Nullable
    public final Map<String, String> component11() {
        return this.metadata;
    }

    private final WeChatParams component12() {
        return this.weChatParams;
    }

    private final ApiParams component13() {
        return this.apiParams;
    }

    @NotNull
    public final Set<String> component14$payments_core_release() {
        return this.attribution;
    }

    @NotNull
    public final SourceParams copy(@NotNull String typeRaw, @Nullable TypeData typeData, @Nullable Long amount, @Nullable String currency, @Nullable OwnerParams owner, @Nullable Source.Usage usage, @Nullable String returnUrl, @Nullable Flow flow, @Nullable SourceOrderParams sourceOrder, @Nullable String token, @Nullable Map<String, String> metadata, @Nullable WeChatParams weChatParams, @NotNull ApiParams apiParams, @NotNull Set<String> attribution) {
        Intrinsics.checkNotNullParameter((Object)typeRaw, (String)"typeRaw");
        Intrinsics.checkNotNullParameter((Object)apiParams, (String)"apiParams");
        Intrinsics.checkNotNullParameter(attribution, (String)"attribution");
        return new SourceParams(typeRaw, typeData, amount, currency, owner, usage, returnUrl, flow, sourceOrder, token, metadata, weChatParams, apiParams, attribution);
    }

    public static /* synthetic */ SourceParams copy$default(SourceParams sourceParams, String string, TypeData typeData, Long l, String string2, OwnerParams ownerParams, Source.Usage usage, String string3, Flow flow, SourceOrderParams sourceOrderParams, String string4, Map map, WeChatParams weChatParams, ApiParams apiParams, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = sourceParams.typeRaw;
        }
        if ((n & 2) != 0) {
            typeData = sourceParams.typeData;
        }
        if ((n & 4) != 0) {
            l = sourceParams.amount;
        }
        if ((n & 8) != 0) {
            string2 = sourceParams.currency;
        }
        if ((n & 0x10) != 0) {
            ownerParams = sourceParams.owner;
        }
        if ((n & 0x20) != 0) {
            usage = sourceParams.usage;
        }
        if ((n & 0x40) != 0) {
            string3 = sourceParams.returnUrl;
        }
        if ((n & 0x80) != 0) {
            flow = sourceParams.flow;
        }
        if ((n & 0x100) != 0) {
            sourceOrderParams = sourceParams.sourceOrder;
        }
        if ((n & 0x200) != 0) {
            string4 = sourceParams.token;
        }
        if ((n & 0x400) != 0) {
            map = sourceParams.metadata;
        }
        if ((n & 0x800) != 0) {
            weChatParams = sourceParams.weChatParams;
        }
        if ((n & 0x1000) != 0) {
            apiParams = sourceParams.apiParams;
        }
        if ((n & 0x2000) != 0) {
            set = sourceParams.attribution;
        }
        return sourceParams.copy(string, typeData, l, string2, ownerParams, usage, string3, flow, sourceOrderParams, string4, map, weChatParams, apiParams, set);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SourceParams(typeRaw=").append(this.typeRaw).append(", typeData=").append(this.typeData).append(", amount=").append(this.amount).append(", currency=").append(this.currency).append(", owner=").append(this.owner).append(", usage=").append((Object)this.usage).append(", returnUrl=").append(this.returnUrl).append(", flow=").append((Object)this.flow).append(", sourceOrder=").append(this.sourceOrder).append(", token=").append(this.token).append(", metadata=").append(this.metadata).append(", weChatParams=");
        stringBuilder.append(this.weChatParams).append(", apiParams=").append(this.apiParams).append(", attribution=").append(this.attribution).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result2 = this.typeRaw.hashCode();
        result2 = result2 * 31 + (this.typeData == null ? 0 : this.typeData.hashCode());
        result2 = result2 * 31 + (this.amount == null ? 0 : ((Object)this.amount).hashCode());
        result2 = result2 * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        result2 = result2 * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result2 = result2 * 31 + (this.usage == null ? 0 : this.usage.hashCode());
        result2 = result2 * 31 + (this.returnUrl == null ? 0 : this.returnUrl.hashCode());
        result2 = result2 * 31 + (this.flow == null ? 0 : this.flow.hashCode());
        result2 = result2 * 31 + (this.sourceOrder == null ? 0 : this.sourceOrder.hashCode());
        result2 = result2 * 31 + (this.token == null ? 0 : this.token.hashCode());
        result2 = result2 * 31 + (this.metadata == null ? 0 : ((Object)this.metadata).hashCode());
        result2 = result2 * 31 + (this.weChatParams == null ? 0 : this.weChatParams.hashCode());
        result2 = result2 * 31 + this.apiParams.hashCode();
        result2 = result2 * 31 + ((Object)this.attribution).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SourceParams)) {
            return false;
        }
        SourceParams sourceParams = (SourceParams)other;
        if (!Intrinsics.areEqual((Object)this.typeRaw, (Object)sourceParams.typeRaw)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.typeData, (Object)sourceParams.typeData)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.amount, (Object)sourceParams.amount)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currency, (Object)sourceParams.currency)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)sourceParams.owner)) {
            return false;
        }
        if (this.usage != sourceParams.usage) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.returnUrl, (Object)sourceParams.returnUrl)) {
            return false;
        }
        if (this.flow != sourceParams.flow) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceOrder, (Object)sourceParams.sourceOrder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.token, (Object)sourceParams.token)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.metadata, sourceParams.metadata)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.weChatParams, (Object)sourceParams.weChatParams)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.apiParams, (Object)sourceParams.apiParams)) {
            return false;
        }
        return Intrinsics.areEqual(this.attribution, sourceParams.attribution);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.typeRaw);
        out.writeParcelable((Parcelable)this.typeData, flags);
        Object object = this.amount;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeLong(((Long)object).longValue());
        }
        out.writeString(this.currency);
        object = this.owner;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((OwnerParams)object).writeToParcel(out, flags);
        }
        object = this.usage;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(((Enum)object).name());
        }
        out.writeString(this.returnUrl);
        object = this.flow;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(((Enum)object).name());
        }
        object = this.sourceOrder;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((SourceOrderParams)object).writeToParcel(out, flags);
        }
        out.writeString(this.token);
        object = this.metadata;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeInt(object.size());
            for (Map.Entry entry : object.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeString((String)entry.getValue());
            }
        }
        object = this.weChatParams;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((WeChatParams)object).writeToParcel(out, flags);
        }
        this.apiParams.writeToParcel(out, flags);
        object = this.attribution;
        out.writeInt(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            out.writeString((String)((Object)iterator.next()));
        }
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createP24Params(@IntRange(from=0L) long amount, @NotNull String currency, @Nullable String name, @NotNull String email, @NotNull String returnUrl) {
        return Companion.createP24Params(amount, currency, name, email, returnUrl);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createAlipayReusableParams(@NotNull String currency, @Nullable String name, @Nullable String email, @NotNull String returnUrl) {
        return Companion.createAlipayReusableParams(currency, name, email, returnUrl);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createAlipaySingleUseParams(@IntRange(from=0L) long amount, @NotNull String currency, @Nullable String name, @Nullable String email, @NotNull String returnUrl) {
        return Companion.createAlipaySingleUseParams(amount, currency, name, email, returnUrl);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createWeChatPayParams(@IntRange(from=0L) long amount, @NotNull String currency, @NotNull String weChatAppId, @Nullable String statementDescriptor) {
        return Companion.createWeChatPayParams(amount, currency, weChatAppId, statementDescriptor);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createKlarna(@NotNull String returnUrl, @NotNull String currency, @NotNull KlarnaSourceParams klarnaParams) {
        return Companion.createKlarna(returnUrl, currency, klarnaParams);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createBancontactParams(@IntRange(from=0L) long amount, @NotNull String name, @NotNull String returnUrl, @Nullable String statementDescriptor, @Nullable String preferredLanguage) {
        return Companion.createBancontactParams(amount, name, returnUrl, statementDescriptor, preferredLanguage);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createCustomParams(@NotNull String type) {
        return Companion.createCustomParams(type);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createSourceFromTokenParams(@NotNull String tokenId) {
        return Companion.createSourceFromTokenParams(tokenId);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createCardParams(@NotNull CardParams cardParams) {
        return Companion.createCardParams(cardParams);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createCardParamsFromGooglePay(@NotNull JSONObject googlePayPaymentData) throws JSONException {
        return Companion.createCardParamsFromGooglePay(googlePayPaymentData);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createEPSParams(@IntRange(from=0L) long amount, @NotNull String name, @NotNull String returnUrl, @Nullable String statementDescriptor) {
        return Companion.createEPSParams(amount, name, returnUrl, statementDescriptor);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createGiropayParams(@IntRange(from=0L) long amount, @NotNull String name, @NotNull String returnUrl, @Nullable String statementDescriptor) {
        return Companion.createGiropayParams(amount, name, returnUrl, statementDescriptor);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createIdealParams(@IntRange(from=0L) long amount, @Nullable String name, @NotNull String returnUrl, @Nullable String statementDescriptor, @Nullable String bank) {
        return Companion.createIdealParams(amount, name, returnUrl, statementDescriptor, bank);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createMultibancoParams(@IntRange(from=0L) long amount, @NotNull String returnUrl, @NotNull String email) {
        return Companion.createMultibancoParams(amount, returnUrl, email);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createSepaDebitParams(@NotNull String name, @NotNull String iban, @Nullable String addressLine1, @NotNull String city, @NotNull String postalCode, @Size(value=2L) @NotNull String country) {
        return Companion.createSepaDebitParams(name, iban, addressLine1, city, postalCode, country);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createSepaDebitParams(@NotNull String name, @NotNull String iban, @Nullable String email, @Nullable String addressLine1, @Nullable String city, @Nullable String postalCode, @Size(value=2L) @Nullable String country) {
        return Companion.createSepaDebitParams(name, iban, email, addressLine1, city, postalCode, country);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createSofortParams(@IntRange(from=0L) long amount, @NotNull String returnUrl, @Size(value=2L) @NotNull String country, @Nullable String statementDescriptor) {
        return Companion.createSofortParams(amount, returnUrl, country, statementDescriptor);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createThreeDSecureParams(@IntRange(from=0L) long amount, @NotNull String currency, @NotNull String returnUrl, @NotNull String cardId) {
        return Companion.createThreeDSecureParams(amount, currency, returnUrl, cardId);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createVisaCheckoutParams(@NotNull String callId) {
        return Companion.createVisaCheckoutParams(callId);
    }

    @JvmStatic
    @NotNull
    public static final SourceParams createMasterpassParams(@NotNull String transactionId, @NotNull String cartId) {
        return Companion.createMasterpassParams(transactionId, cartId);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> createRetrieveSourceParams(@Size(min=1L) @NotNull String clientSecret) {
        return Companion.createRetrieveSourceParams(clientSecret);
    }

    static {
        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<SourceParams> {
            @NotNull
            public final SourceParams[] newArray(int size) {
                return new SourceParams[size];
            }

            @NotNull
            public final SourceParams createFromParcel(@NotNull Parcel parcel) {
                int n;
                String string;
                TypeData typeData;
                Long l;
                String string2;
                OwnerParams ownerParams;
                Source.Usage usage;
                String string3;
                Flow flow;
                SourceOrderParams sourceOrderParams;
                String string4;
                Cloneable cloneable;
                int n2;
                Cloneable cloneable2;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                String string5 = parcel.readString();
                TypeData typeData2 = (TypeData)parcel.readParcelable(SourceParams.class.getClassLoader());
                Long l2 = parcel.readInt() == 0 ? null : Long.valueOf(parcel.readLong());
                String string6 = parcel.readString();
                OwnerParams ownerParams2 = (OwnerParams)(parcel.readInt() == 0 ? null : OwnerParams.CREATOR.createFromParcel(parcel));
                Source.Usage usage2 = parcel.readInt() == 0 ? null : Source.Usage.valueOf(parcel.readString());
                String string7 = parcel.readString();
                Flow flow2 = parcel.readInt() == 0 ? null : Flow.valueOf(parcel.readString());
                SourceOrderParams sourceOrderParams2 = (SourceOrderParams)(parcel.readInt() == 0 ? null : SourceOrderParams.CREATOR.createFromParcel(parcel));
                String string8 = parcel.readString();
                if (parcel.readInt() == 0) {
                    cloneable2 = null;
                } else {
                    n2 = parcel.readInt();
                    cloneable = new LinkedHashMap(n2);
                    string4 = string8;
                    sourceOrderParams = sourceOrderParams2;
                    flow = flow2;
                    string3 = string7;
                    usage = usage2;
                    ownerParams = ownerParams2;
                    string2 = string6;
                    l = l2;
                    typeData = typeData2;
                    string = string5;
                    for (n = 0; n != n2; ++n) {
                        ((HashMap)cloneable).put(parcel.readString(), parcel.readString());
                    }
                    string5 = string;
                    typeData2 = typeData;
                    l2 = l;
                    string6 = string2;
                    ownerParams2 = ownerParams;
                    usage2 = usage;
                    string7 = string3;
                    flow2 = flow;
                    sourceOrderParams2 = sourceOrderParams;
                    string8 = string4;
                    cloneable2 = cloneable;
                }
                n2 = parcel.readInt();
                cloneable = new LinkedHashSet(n2);
                ApiParams apiParams = (ApiParams)ApiParams.CREATOR.createFromParcel(parcel);
                WeChatParams weChatParams = (WeChatParams)(parcel.readInt() == 0 ? null : WeChatParams.CREATOR.createFromParcel(parcel));
                Map map = (Map)((Object)cloneable2);
                string4 = string8;
                sourceOrderParams = sourceOrderParams2;
                flow = flow2;
                string3 = string7;
                usage = usage2;
                ownerParams = ownerParams2;
                string2 = string6;
                l = l2;
                typeData = typeData2;
                string = string5;
                for (n = 0; n != n2; ++n) {
                    ((HashSet)cloneable).add(parcel.readString());
                }
                Set set = (Set)((Object)cloneable);
                ApiParams apiParams2 = apiParams;
                WeChatParams weChatParams2 = weChatParams;
                Map map2 = map;
                String string9 = string4;
                SourceOrderParams sourceOrderParams3 = sourceOrderParams;
                Flow flow3 = flow;
                String string10 = string3;
                Source.Usage usage3 = usage;
                OwnerParams ownerParams3 = ownerParams;
                String string11 = string2;
                Long l3 = l;
                TypeData typeData3 = typeData;
                String string12 = string;
                return new SourceParams(string12, typeData3, l3, string11, ownerParams3, usage3, string10, flow3, sourceOrderParams3, string9, map2, weChatParams2, apiParams2, set);
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u001d\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u00c2\u0003J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u00c2\u0003J!\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u000bH\u00d6\u0001J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u00d6\u0001R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/model/SourceParams$WeChatParams;", "Lcom/stripe/android/model/StripeParamsModel;", "Landroid/os/Parcelable;", "appId", "", "statementDescriptor", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toParamMap", "", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
    @Parcelize
    public static final class WeChatParams
    implements StripeParamsModel,
    Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String appId;
        @Nullable
        private final String statementDescriptor;
        @NotNull
        public static final Parcelable.Creator<WeChatParams> CREATOR;
        @NotNull
        private static final String PARAM_APPID = "appid";
        @NotNull
        private static final String PARAM_STATEMENT_DESCRIPTOR = "statement_descriptor";

        public WeChatParams(@Nullable String appId, @Nullable String statementDescriptor) {
            this.appId = appId;
            this.statementDescriptor = statementDescriptor;
        }

        public /* synthetic */ WeChatParams(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @NotNull
        public Map<String, Object> toParamMap() {
            Map map;
            Map map2;
            Map map3;
            Map map4;
            Map map5;
            String it;
            Map map6 = MapsKt.emptyMap();
            String string = this.appId;
            if (string != null) {
                it = string;
                map5 = map6;
                boolean bl = false;
                map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_APPID, (Object)it));
                map6 = map5;
            } else {
                map4 = map3 = null;
            }
            if (map4 == null) {
                map3 = MapsKt.emptyMap();
            }
            Map map7 = MapsKt.plus((Map)map6, map3);
            String string2 = this.statementDescriptor;
            if (string2 != null) {
                it = string2;
                map5 = map7;
                boolean bl = false;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_STATEMENT_DESCRIPTOR, (Object)it));
                map7 = map5;
            } else {
                map2 = map = null;
            }
            if (map2 == null) {
                map = MapsKt.emptyMap();
            }
            return MapsKt.plus((Map)map7, map);
        }

        private final String component1() {
            return this.appId;
        }

        private final String component2() {
            return this.statementDescriptor;
        }

        @NotNull
        public final WeChatParams copy(@Nullable String appId, @Nullable String statementDescriptor) {
            return new WeChatParams(appId, statementDescriptor);
        }

        public static /* synthetic */ WeChatParams copy$default(WeChatParams weChatParams, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = weChatParams.appId;
            }
            if ((n & 2) != 0) {
                string2 = weChatParams.statementDescriptor;
            }
            return weChatParams.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "WeChatParams(appId=" + this.appId + ", statementDescriptor=" + this.statementDescriptor + ')';
        }

        public int hashCode() {
            int result2 = this.appId == null ? 0 : this.appId.hashCode();
            result2 = result2 * 31 + (this.statementDescriptor == null ? 0 : this.statementDescriptor.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WeChatParams)) {
                return false;
            }
            WeChatParams weChatParams = (WeChatParams)other;
            if (!Intrinsics.areEqual((Object)this.appId, (Object)weChatParams.appId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.statementDescriptor, (Object)weChatParams.statementDescriptor);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.appId);
            out.writeString(this.statementDescriptor);
        }

        public WeChatParams() {
            this(null, null, 3, null);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<WeChatParams> {
                @NotNull
                public final WeChatParams[] newArray(int size) {
                    return new WeChatParams[size];
                }

                @NotNull
                public final WeChatParams createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new WeChatParams(parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/SourceParams$WeChatParams$Companion;", "", "()V", "PARAM_APPID", "", "PARAM_STATEMENT_DESCRIPTOR", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B7\b\u0007\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u00c0\u0003\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u001dJ9\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020 H\u00d6\u0001J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020$0'H\u0016J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001J\u0019\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 H\u00d6\u0001R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/stripe/android/model/SourceParams$OwnerParams;", "Lcom/stripe/android/model/StripeParamsModel;", "Landroid/os/Parcelable;", "address", "Lcom/stripe/android/model/Address;", "email", "", "name", "phone", "(Lcom/stripe/android/model/Address;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAddress$payments_core_release", "()Lcom/stripe/android/model/Address;", "setAddress$payments_core_release", "(Lcom/stripe/android/model/Address;)V", "getEmail$payments_core_release", "()Ljava/lang/String;", "setEmail$payments_core_release", "(Ljava/lang/String;)V", "getName$payments_core_release", "setName$payments_core_release", "getPhone$payments_core_release", "setPhone$payments_core_release", "component1", "component1$payments_core_release", "component2", "component2$payments_core_release", "component3", "component3$payments_core_release", "component4", "component4$payments_core_release", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toParamMap", "", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class OwnerParams
    implements StripeParamsModel,
    Parcelable {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private Address address;
        @Nullable
        private String email;
        @Nullable
        private String name;
        @Nullable
        private String phone;
        @NotNull
        public static final Parcelable.Creator<OwnerParams> CREATOR;
        public static final int $stable;
        @Deprecated
        @NotNull
        private static final String PARAM_ADDRESS = "address";
        @Deprecated
        @NotNull
        private static final String PARAM_EMAIL = "email";
        @Deprecated
        @NotNull
        private static final String PARAM_NAME = "name";
        @Deprecated
        @NotNull
        private static final String PARAM_PHONE = "phone";

        @JvmOverloads
        public OwnerParams(@Nullable Address address, @Nullable String email, @Nullable String name, @Nullable String phone) {
            this.address = address;
            this.email = email;
            this.name = name;
            this.phone = phone;
        }

        public /* synthetic */ OwnerParams(Address address, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                address = null;
            }
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            this(address, string, string2, string3);
        }

        @Nullable
        public final Address getAddress$payments_core_release() {
            return this.address;
        }

        public final void setAddress$payments_core_release(@Nullable Address address) {
            this.address = address;
        }

        @Nullable
        public final String getEmail$payments_core_release() {
            return this.email;
        }

        public final void setEmail$payments_core_release(@Nullable String string) {
            this.email = string;
        }

        @Nullable
        public final String getName$payments_core_release() {
            return this.name;
        }

        public final void setName$payments_core_release(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final String getPhone$payments_core_release() {
            return this.phone;
        }

        public final void setPhone$payments_core_release(@Nullable String string) {
            this.phone = string;
        }

        @NotNull
        public Map<String, Object> toParamMap() {
            Map map;
            Map map2;
            Map map3;
            Map map4;
            Map map5;
            Map map6;
            Map map7;
            Map map8;
            Map map9;
            Object it;
            Map map10 = MapsKt.emptyMap();
            Address address = this.address;
            if (address != null) {
                it = address;
                map9 = map10;
                boolean bl = false;
                map8 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_ADDRESS, ((Address)it).toParamMap()));
                map10 = map9;
            } else {
                map8 = map7 = null;
            }
            if (map8 == null) {
                map7 = MapsKt.emptyMap();
            }
            Map map11 = MapsKt.plus((Map)map10, map7);
            String string = this.email;
            if (string != null) {
                it = string;
                map9 = map11;
                boolean bl = false;
                map6 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_EMAIL, (Object)it));
                map11 = map9;
            } else {
                map6 = map5 = null;
            }
            if (map6 == null) {
                map5 = MapsKt.emptyMap();
            }
            Map map12 = MapsKt.plus((Map)map11, map5);
            String string2 = this.name;
            if (string2 != null) {
                it = string2;
                map9 = map12;
                boolean bl = false;
                map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_NAME, (Object)it));
                map12 = map9;
            } else {
                map4 = map3 = null;
            }
            if (map4 == null) {
                map3 = MapsKt.emptyMap();
            }
            Map map13 = MapsKt.plus((Map)map12, map3);
            String string3 = this.phone;
            if (string3 != null) {
                it = string3;
                map9 = map13;
                boolean bl = false;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_PHONE, (Object)it));
                map13 = map9;
            } else {
                map2 = map = null;
            }
            if (map2 == null) {
                map = MapsKt.emptyMap();
            }
            return MapsKt.plus((Map)map13, map);
        }

        @Nullable
        public final Address component1$payments_core_release() {
            return this.address;
        }

        @Nullable
        public final String component2$payments_core_release() {
            return this.email;
        }

        @Nullable
        public final String component3$payments_core_release() {
            return this.name;
        }

        @Nullable
        public final String component4$payments_core_release() {
            return this.phone;
        }

        @NotNull
        public final OwnerParams copy(@Nullable Address address, @Nullable String email, @Nullable String name, @Nullable String phone) {
            return new OwnerParams(address, email, name, phone);
        }

        public static /* synthetic */ OwnerParams copy$default(OwnerParams ownerParams, Address address, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                address = ownerParams.address;
            }
            if ((n & 2) != 0) {
                string = ownerParams.email;
            }
            if ((n & 4) != 0) {
                string2 = ownerParams.name;
            }
            if ((n & 8) != 0) {
                string3 = ownerParams.phone;
            }
            return ownerParams.copy(address, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "OwnerParams(address=" + this.address + ", email=" + this.email + ", name=" + this.name + ", phone=" + this.phone + ')';
        }

        public int hashCode() {
            int result2 = this.address == null ? 0 : this.address.hashCode();
            result2 = result2 * 31 + (this.email == null ? 0 : this.email.hashCode());
            result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
            result2 = result2 * 31 + (this.phone == null ? 0 : this.phone.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OwnerParams)) {
                return false;
            }
            OwnerParams ownerParams = (OwnerParams)other;
            if (!Intrinsics.areEqual((Object)this.address, (Object)ownerParams.address)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.email, (Object)ownerParams.email)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)ownerParams.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.phone, (Object)ownerParams.phone);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Address address = this.address;
            if (address == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                address.writeToParcel(out, flags);
            }
            out.writeString(this.email);
            out.writeString(this.name);
            out.writeString(this.phone);
        }

        @JvmOverloads
        public OwnerParams(@Nullable Address address, @Nullable String email, @Nullable String name) {
            this(address, email, name, null, 8, null);
        }

        @JvmOverloads
        public OwnerParams(@Nullable Address address, @Nullable String email) {
            this(address, email, null, null, 12, null);
        }

        @JvmOverloads
        public OwnerParams(@Nullable Address address) {
            this(address, null, null, null, 14, null);
        }

        @JvmOverloads
        public OwnerParams() {
            this(null, null, null, null, 15, null);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<OwnerParams> {
                @NotNull
                public final OwnerParams[] newArray(int size) {
                    return new OwnerParams[size];
                }

                @NotNull
                public final OwnerParams createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new OwnerParams((Address)(parcel.readInt() == 0 ? null : Address.CREATOR.createFromParcel(parcel)), parcel.readString(), parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/SourceParams$OwnerParams$Companion;", "", "()V", "PARAM_ADDRESS", "", "PARAM_EMAIL", "PARAM_NAME", "PARAM_PHONE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/SourceParams$Flow;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$payments_core_release", "()Ljava/lang/String;", "Redirect", "Receiver", "CodeVerification", "None", "payments-core_release"})
    public static final class Flow
    extends Enum<Flow> {
        @NotNull
        private final String code;
        public static final /* enum */ Flow Redirect = new Flow("redirect");
        public static final /* enum */ Flow Receiver = new Flow("receiver");
        public static final /* enum */ Flow CodeVerification = new Flow("code_verification");
        public static final /* enum */ Flow None = new Flow("none");
        private static final /* synthetic */ Flow[] $VALUES;

        private Flow(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode$payments_core_release() {
            return this.code;
        }

        public static Flow[] values() {
            return (Flow[])$VALUES.clone();
        }

        public static Flow valueOf(String value) {
            return Enum.valueOf(Flow.class, value);
        }

        static {
            $VALUES = flowArray = new Flow[]{Flow.Redirect, Flow.Receiver, Flow.CodeVerification, Flow.None};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J:\u0010\u0017\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J:\u0010\u001a\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0004H\u0007J.\u0010%\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J.\u0010&\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J<\u0010'\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010)\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0007J\u0018\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004H\u0007J\"\u0010/\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J4\u00100\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u001e\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004022\b\b\u0001\u00103\u001a\u00020\u0004H\u0007J<\u00104\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\b\u00106\u001a\u0004\u0018\u00010\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\b\b\u0001\u00109\u001a\u00020\u0004H\u0007JL\u00104\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u00010\u00042\b\u00107\u001a\u0004\u0018\u00010\u00042\b\u00108\u001a\u0004\u0018\u00010\u00042\n\b\u0001\u00109\u001a\u0004\u0018\u00010\u0004H\u0007J0\u0010:\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0001\u00109\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0004H\u0007J*\u0010=\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0004H\u0007J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\u0004H\u0007J.\u0010A\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/stripe/android/model/SourceParams$Companion;", "", "()V", "PARAM_AMOUNT", "", "PARAM_CLIENT_SECRET", "PARAM_CURRENCY", "PARAM_FLOW", "PARAM_METADATA", "PARAM_OWNER", "PARAM_REDIRECT", "PARAM_RETURN_URL", "PARAM_SOURCE_ORDER", "PARAM_TOKEN", "PARAM_TYPE", "PARAM_USAGE", "PARAM_WECHAT", "createAlipayReusableParams", "Lcom/stripe/android/model/SourceParams;", "currency", "name", "email", "returnUrl", "createAlipaySingleUseParams", "amount", "", "createBancontactParams", "statementDescriptor", "preferredLanguage", "createCardParams", "cardParams", "Lcom/stripe/android/model/CardParams;", "createCardParamsFromGooglePay", "googlePayPaymentData", "Lorg/json/JSONObject;", "createCustomParams", "type", "createEPSParams", "createGiropayParams", "createIdealParams", "bank", "createKlarna", "klarnaParams", "Lcom/stripe/android/model/KlarnaSourceParams;", "createMasterpassParams", "transactionId", "cartId", "createMultibancoParams", "createP24Params", "createRetrieveSourceParams", "", "clientSecret", "createSepaDebitParams", "iban", "addressLine1", "city", "postalCode", "country", "createSofortParams", "createSourceFromTokenParams", "tokenId", "createThreeDSecureParams", "cardId", "createVisaCheckoutParams", "callId", "createWeChatPayParams", "weChatAppId", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SourceParams createP24Params(@IntRange(from=0L) long amount, @NotNull String currency, @Nullable String name, @NotNull String email, @NotNull String returnUrl) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)SourceParams.PARAM_CURRENCY);
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            OwnerParams ownerParams = new OwnerParams(null, email, name, null, 9, null);
            return new SourceParams("p24", null, amount, currency, ownerParams, null, returnUrl, null, null, null, null, null, null, null, 16290, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createAlipayReusableParams(@NotNull String currency, @Nullable String name, @Nullable String email, @NotNull String returnUrl) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)SourceParams.PARAM_CURRENCY);
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            Source.Usage usage = Source.Usage.Reusable;
            OwnerParams ownerParams = new OwnerParams(null, email, name, null, 9, null);
            return new SourceParams("alipay", null, null, currency, ownerParams, usage, returnUrl, null, null, null, null, null, null, null, 16262, null);
        }

        public static /* synthetic */ SourceParams createAlipayReusableParams$default(Companion companion, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            return companion.createAlipayReusableParams(string, string2, string3, string4);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createAlipaySingleUseParams(@IntRange(from=0L) long amount, @NotNull String currency, @Nullable String name, @Nullable String email, @NotNull String returnUrl) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)SourceParams.PARAM_CURRENCY);
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            OwnerParams ownerParams = new OwnerParams(null, email, name, null, 9, null);
            return new SourceParams("alipay", null, amount, currency, ownerParams, null, returnUrl, null, null, null, null, null, null, null, 16290, null);
        }

        public static /* synthetic */ SourceParams createAlipaySingleUseParams$default(Companion companion, long l, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            return companion.createAlipaySingleUseParams(l, string, string2, string3, string4);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createWeChatPayParams(@IntRange(from=0L) long amount, @NotNull String currency, @NotNull String weChatAppId, @Nullable String statementDescriptor) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)SourceParams.PARAM_CURRENCY);
            Intrinsics.checkNotNullParameter((Object)weChatAppId, (String)"weChatAppId");
            WeChatParams weChatParams = new WeChatParams(weChatAppId, statementDescriptor);
            return new SourceParams(SourceParams.PARAM_WECHAT, null, amount, currency, null, null, null, null, null, null, null, weChatParams, null, null, 14322, null);
        }

        public static /* synthetic */ SourceParams createWeChatPayParams$default(Companion companion, long l, String string, String string2, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            return companion.createWeChatPayParams(l, string, string2, string3);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SourceParams createKlarna(@NotNull String returnUrl, @NotNull String currency, @NotNull KlarnaSourceParams klarnaParams) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            Intrinsics.checkNotNullParameter((Object)currency, (String)SourceParams.PARAM_CURRENCY);
            Intrinsics.checkNotNullParameter((Object)klarnaParams, (String)"klarnaParams");
            Iterable $this$sumBy$iv = klarnaParams.getLineItems();
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                KlarnaSourceParams.LineItem lineItem = (KlarnaSourceParams.LineItem)element$iv;
                int n = sum$iv;
                boolean bl = false;
                int n2 = it.getTotalAmount();
                sum$iv = n + n2;
            }
            int totalAmount = sum$iv;
            Iterable $this$map$iv = klarnaParams.getLineItems();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SourceOrderParams.Item.Type type;
                void it;
                KlarnaSourceParams.LineItem lineItem = (KlarnaSourceParams.LineItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[it.getItemType().ordinal()]) {
                    case 1: {
                        type = SourceOrderParams.Item.Type.Sku;
                        break;
                    }
                    case 2: {
                        type = SourceOrderParams.Item.Type.Tax;
                        break;
                    }
                    case 3: {
                        type = SourceOrderParams.Item.Type.Shipping;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                SourceOrderParams.Item.Type type2 = type;
                collection.add(new SourceOrderParams.Item(type2, it.getTotalAmount(), currency, it.getItemDescription(), null, it.getQuantity(), 16, null));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            SourceOrderParams.Shipping shipping = null;
            List list = (List)destination$iv$iv;
            SourceOrderParams sourceOrderParams = new SourceOrderParams(list, shipping, n, defaultConstructorMarker);
            Flow flow = Flow.Redirect;
            long l = totalAmount;
            OwnerParams ownerParams = new OwnerParams(klarnaParams.getBillingAddress(), klarnaParams.getBillingEmail(), null, klarnaParams.getBillingPhone(), 4, null);
            ApiParams apiParams = new ApiParams(klarnaParams.toParamMap());
            return new SourceParams("klarna", null, l, currency, ownerParams, null, returnUrl, flow, sourceOrderParams, null, null, null, apiParams, null, 11810, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createBancontactParams(@IntRange(from=0L) long amount, @NotNull String name, @NotNull String returnUrl, @Nullable String statementDescriptor, @Nullable String preferredLanguage) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            TypeData.Bancontact bancontact = new TypeData.Bancontact(statementDescriptor, preferredLanguage);
            OwnerParams ownerParams = new OwnerParams(null, null, name, null, 11, null);
            return new SourceParams("bancontact", bancontact, amount, "eur", ownerParams, null, returnUrl, null, null, null, null, null, null, null, 16288, null);
        }

        public static /* synthetic */ SourceParams createBancontactParams$default(Companion companion, long l, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            return companion.createBancontactParams(l, string, string2, string3, string4);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createCustomParams(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)SourceParams.PARAM_TYPE);
            return new SourceParams(type, null, null, null, null, null, null, null, null, null, null, null, null, null, 16382, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createSourceFromTokenParams(@NotNull String tokenId) {
            Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
            return new SourceParams("card", null, null, null, null, null, null, null, null, tokenId, null, null, null, null, 15870, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createCardParams(@NotNull CardParams cardParams) {
            Intrinsics.checkNotNullParameter((Object)((Object)cardParams), (String)"cardParams");
            TypeData.Card card = new TypeData.Card(cardParams.getNumber$payments_core_release(), cardParams.getExpMonth$payments_core_release(), cardParams.getExpYear$payments_core_release(), cardParams.getCvc$payments_core_release());
            Set set = cardParams.getAttribution();
            OwnerParams ownerParams = new OwnerParams(cardParams.getAddress(), null, cardParams.getName(), null, 10, null);
            Map<String, String> map = cardParams.getMetadata();
            return new SourceParams("card", card, null, null, ownerParams, null, null, null, null, null, map, null, null, set, 7148, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createCardParamsFromGooglePay(@NotNull JSONObject googlePayPaymentData) throws JSONException {
            Token token;
            Intrinsics.checkNotNullParameter((Object)googlePayPaymentData, (String)"googlePayPaymentData");
            GooglePayResult googlePayResult = GooglePayResult.Companion.fromJson(googlePayPaymentData);
            Token token2 = token = googlePayResult.getToken();
            String string = token2 != null ? token2.getId() : null;
            if (string == null) {
                string = "";
            }
            String string2 = string;
            Token token3 = token;
            Set set = SetsKt.setOfNotNull(token3 != null && (token3 = token3.getCard()) != null && (token3 = token3.getTokenizationMethod()) != null ? token3.toString() : null);
            OwnerParams ownerParams = new OwnerParams(googlePayResult.getAddress(), googlePayResult.getEmail(), googlePayResult.getName(), googlePayResult.getPhoneNumber());
            return new SourceParams("card", null, null, null, ownerParams, null, null, null, null, string2, null, null, null, set, 7662, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createEPSParams(@IntRange(from=0L) long amount, @NotNull String name, @NotNull String returnUrl, @Nullable String statementDescriptor) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            TypeData.Eps eps = new TypeData.Eps(statementDescriptor);
            OwnerParams ownerParams = new OwnerParams(null, null, name, null, 11, null);
            return new SourceParams("eps", eps, amount, "eur", ownerParams, null, returnUrl, null, null, null, null, null, null, null, 16288, null);
        }

        public static /* synthetic */ SourceParams createEPSParams$default(Companion companion, long l, String string, String string2, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            return companion.createEPSParams(l, string, string2, string3);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createGiropayParams(@IntRange(from=0L) long amount, @NotNull String name, @NotNull String returnUrl, @Nullable String statementDescriptor) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            TypeData.Giropay giropay = new TypeData.Giropay(statementDescriptor);
            OwnerParams ownerParams = new OwnerParams(null, null, name, null, 11, null);
            return new SourceParams("giropay", giropay, amount, "eur", ownerParams, null, returnUrl, null, null, null, null, null, null, null, 16288, null);
        }

        public static /* synthetic */ SourceParams createGiropayParams$default(Companion companion, long l, String string, String string2, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            return companion.createGiropayParams(l, string, string2, string3);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createIdealParams(@IntRange(from=0L) long amount, @Nullable String name, @NotNull String returnUrl, @Nullable String statementDescriptor, @Nullable String bank) {
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            TypeData.Ideal ideal = new TypeData.Ideal(statementDescriptor, bank);
            OwnerParams ownerParams = new OwnerParams(null, null, name, null, 11, null);
            return new SourceParams("ideal", ideal, amount, "eur", ownerParams, null, returnUrl, null, null, null, null, null, null, null, 16288, null);
        }

        public static /* synthetic */ SourceParams createIdealParams$default(Companion companion, long l, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            return companion.createIdealParams(l, string, string2, string3, string4);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createMultibancoParams(@IntRange(from=0L) long amount, @NotNull String returnUrl, @NotNull String email) {
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            OwnerParams ownerParams = new OwnerParams(null, email, null, null, 13, null);
            return new SourceParams("multibanco", null, amount, "eur", ownerParams, null, returnUrl, null, null, null, null, null, null, null, 16290, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createSepaDebitParams(@NotNull String name, @NotNull String iban, @Nullable String addressLine1, @NotNull String city, @NotNull String postalCode, @Size(value=2L) @NotNull String country) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
            Intrinsics.checkNotNullParameter((Object)city, (String)"city");
            Intrinsics.checkNotNullParameter((Object)postalCode, (String)"postalCode");
            Intrinsics.checkNotNullParameter((Object)country, (String)"country");
            return this.createSepaDebitParams(name, iban, null, addressLine1, city, postalCode, country);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createSepaDebitParams(@NotNull String name, @NotNull String iban, @Nullable String email, @Nullable String addressLine1, @Nullable String city, @Nullable String postalCode, @Size(value=2L) @Nullable String country) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
            TypeData.SepaDebit sepaDebit = new TypeData.SepaDebit(iban);
            OwnerParams ownerParams = new OwnerParams(new Address.Builder().setLine1(addressLine1).setCity(city).setPostalCode(postalCode).setCountry(country).build(), email, name, null, 8, null);
            return new SourceParams("sepa_debit", sepaDebit, null, "eur", ownerParams, null, null, null, null, null, null, null, null, null, 16356, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createSofortParams(@IntRange(from=0L) long amount, @NotNull String returnUrl, @Size(value=2L) @NotNull String country, @Nullable String statementDescriptor) {
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            Intrinsics.checkNotNullParameter((Object)country, (String)"country");
            TypeData.Sofort sofort = new TypeData.Sofort(country, statementDescriptor);
            return new SourceParams("sofort", sofort, amount, "eur", null, null, returnUrl, null, null, null, null, null, null, null, 16304, null);
        }

        public static /* synthetic */ SourceParams createSofortParams$default(Companion companion, long l, String string, String string2, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            return companion.createSofortParams(l, string, string2, string3);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createThreeDSecureParams(@IntRange(from=0L) long amount, @NotNull String currency, @NotNull String returnUrl, @NotNull String cardId) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)SourceParams.PARAM_CURRENCY);
            Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
            Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
            TypeData.ThreeDSecure threeDSecure = new TypeData.ThreeDSecure(cardId);
            return new SourceParams("three_d_secure", threeDSecure, amount, currency, null, null, returnUrl, null, null, null, null, null, null, null, 16304, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createVisaCheckoutParams(@NotNull String callId) {
            Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
            return new SourceParams("card", new TypeData.VisaCheckout(callId), null, null, null, null, null, null, null, null, null, null, null, null, 16380, null);
        }

        @JvmStatic
        @NotNull
        public final SourceParams createMasterpassParams(@NotNull String transactionId, @NotNull String cartId) {
            Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
            Intrinsics.checkNotNullParameter((Object)cartId, (String)"cartId");
            return new SourceParams("card", new TypeData.Masterpass(transactionId, cartId), null, null, null, null, null, null, null, null, null, null, null, null, 16380, null);
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> createRetrieveSourceParams(@Size(min=1L) @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)SourceParams.PARAM_CLIENT_SECRET, (Object)clientSecret));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KlarnaSourceParams.LineItem.Type.values().length];
                nArray[KlarnaSourceParams.LineItem.Type.Sku.ordinal()] = 1;
                nArray[KlarnaSourceParams.LineItem.Type.Tax.ordinal()] = 2;
                nArray[KlarnaSourceParams.LineItem.Type.Shipping.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u00c6\u0003J!\u0010\n\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u00c6\u0001J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/model/SourceParams$ApiParams;", "Landroid/os/Parcelable;", "value", "", "", "", "(Ljava/util/Map;)V", "getValue", "()Ljava/util/Map;", "component1", "copy", "describeContents", "", "equals", "", "other", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
    @Parcelize
    public static final class ApiParams
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, Object> value;
        @NotNull
        public static final Parcelable.Creator<ApiParams> CREATOR;

        public ApiParams(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.value = value;
        }

        public /* synthetic */ ApiParams(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @NotNull
        public final Map<String, Object> getValue() {
            return this.value;
        }

        @NotNull
        public final Map<String, Object> component1() {
            return this.value;
        }

        @NotNull
        public final ApiParams copy(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new ApiParams(value);
        }

        public static /* synthetic */ ApiParams copy$default(ApiParams apiParams, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = apiParams.value;
            }
            return apiParams.copy(map);
        }

        @NotNull
        public String toString() {
            return "ApiParams(value=" + this.value + ')';
        }

        public int hashCode() {
            return ((Object)this.value).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApiParams)) {
                return false;
            }
            ApiParams apiParams = (ApiParams)other;
            return Intrinsics.areEqual(this.value, apiParams.value);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Companion.write(this, out, flags);
        }

        public ApiParams() {
            this(null, 1, null);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<ApiParams> {
                @NotNull
                public final ApiParams[] newArray(int size) {
                    return new ApiParams[size];
                }

                @NotNull
                public final ApiParams createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return Companion.create(parcel);
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/SourceParams$ApiParams$Companion;", "Lkotlinx/parcelize/Parceler;", "Lcom/stripe/android/model/SourceParams$ApiParams;", "()V", "create", "parcel", "Landroid/os/Parcel;", "write", "", "flags", "", "payments-core_release"})
        public static final class Companion
        implements Parceler<ApiParams> {
            private Companion() {
            }

            public void write(@NotNull ApiParams $this$write, @NotNull Parcel parcel, int flags) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                JSONObject jSONObject = StripeJsonUtils.INSTANCE.mapToJsonObject($this$write.getValue());
                parcel.writeString(jSONObject != null ? jSONObject.toString() : null);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public ApiParams create(@NotNull Parcel parcel) {
                Map map;
                JSONObject jSONObject;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                StripeJsonUtils stripeJsonUtils = StripeJsonUtils.INSTANCE;
                String string = parcel.readString();
                if (string != null) {
                    void it;
                    String string2 = string;
                    StripeJsonUtils stripeJsonUtils2 = stripeJsonUtils;
                    boolean bl = false;
                    jSONObject = new JSONObject((String)it);
                    stripeJsonUtils = stripeJsonUtils2;
                } else {
                    jSONObject = null;
                }
                if ((map = stripeJsonUtils.jsonObjectToMap(jSONObject)) == null) {
                    map = MapsKt.emptyMap();
                }
                Map map2 = map;
                return new ApiParams(map2);
            }

            @NotNull
            public ApiParams[] newArray(int size) {
                return (ApiParams[])Parceler.DefaultImpls.newArray((Parceler)this, (int)size);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\n\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u000e0\u000eR&\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\n\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"\u00a8\u0006#"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData;", "Landroid/os/Parcelable;", "()V", "params", "", "Lkotlin/Pair;", "", "", "getParams", "()Ljava/util/List;", "type", "getType", "()Ljava/lang/String;", "createParams", "", "Bancontact", "Card", "Eps", "Giropay", "Ideal", "Masterpass", "SepaDebit", "Sofort", "ThreeDSecure", "VisaCheckout", "Lcom/stripe/android/model/SourceParams$TypeData$Bancontact;", "Lcom/stripe/android/model/SourceParams$TypeData$Card;", "Lcom/stripe/android/model/SourceParams$TypeData$Eps;", "Lcom/stripe/android/model/SourceParams$TypeData$Giropay;", "Lcom/stripe/android/model/SourceParams$TypeData$Ideal;", "Lcom/stripe/android/model/SourceParams$TypeData$Masterpass;", "Lcom/stripe/android/model/SourceParams$TypeData$SepaDebit;", "Lcom/stripe/android/model/SourceParams$TypeData$Sofort;", "Lcom/stripe/android/model/SourceParams$TypeData$ThreeDSecure;", "Lcom/stripe/android/model/SourceParams$TypeData$VisaCheckout;", "payments-core_release"})
    public static abstract class TypeData
    implements Parcelable {
        private TypeData() {
        }

        @NotNull
        public abstract String getType();

        @NotNull
        public abstract List<Pair<String, Object>> getParams();

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, Map<String, Object>> createParams() {
            Map map;
            Map map2;
            void $this$fold$iv;
            Object object = this.getParams();
            Map initial$iv = MapsKt.emptyMap();
            boolean $i$f$fold = false;
            Map accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                Map map3;
                Map map4;
                Pair pair = (Pair)element$iv;
                Map acc = accumulator$iv;
                boolean bl = false;
                String key = (String)pair.component1();
                Object value = pair.component2();
                Map map5 = acc;
                if (value != null) {
                    void it;
                    Map map6 = map5;
                    boolean bl2 = false;
                    map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)it));
                    map5 = map6;
                } else {
                    map4 = map3 = null;
                }
                if (map4 == null) {
                    map3 = MapsKt.emptyMap();
                }
                accumulator$iv = MapsKt.plus((Map)map5, map3);
            }
            Object it = object = accumulator$iv;
            boolean bl = false;
            Object object2 = !it.isEmpty() ? object : null;
            if (object2 != null) {
                it = object2;
                boolean bl3 = false;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.getType(), (Object)it));
            } else {
                map2 = map = null;
            }
            if (map2 == null) {
                map = MapsKt.emptyMap();
            }
            return map;
        }

        public /* synthetic */ TypeData(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 )2\u00020\u0001:\u0001)B1\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J>\u0010\u001c\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0007\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR(\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\n\u00a8\u0006*"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Card;", "Lcom/stripe/android/model/SourceParams$TypeData;", "number", "", "expMonth", "", "expYear", "cvc", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "getCvc", "()Ljava/lang/String;", "getExpMonth", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExpYear", "getNumber", "params", "", "Lkotlin/Pair;", "", "getParams", "()Ljava/util/List;", "type", "getType", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Lcom/stripe/android/model/SourceParams$TypeData$Card;", "describeContents", "equals", "", "other", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class Card
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Nullable
            private final String number;
            @Nullable
            private final Integer expMonth;
            @Nullable
            private final Integer expYear;
            @Nullable
            private final String cvc;
            @NotNull
            public static final Parcelable.Creator<Card> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_NUMBER = "number";
            @Deprecated
            @NotNull
            private static final String PARAM_EXP_MONTH = "exp_month";
            @Deprecated
            @NotNull
            private static final String PARAM_EXP_YEAR = "exp_year";
            @Deprecated
            @NotNull
            private static final String PARAM_CVC = "cvc";

            public Card(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
                super(null);
                this.number = number;
                this.expMonth = expMonth;
                this.expYear = expYear;
                this.cvc = cvc;
            }

            public /* synthetic */ Card(String string, Integer n, Integer n2, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    string = null;
                }
                if ((n3 & 8) != 0) {
                    string2 = null;
                }
                this(string, n, n2, string2);
            }

            @Nullable
            public final String getNumber() {
                return this.number;
            }

            @IntRange(from=1L, to=12L)
            @Nullable
            public final Integer getExpMonth() {
                return this.expMonth;
            }

            @Nullable
            public final Integer getExpYear() {
                return this.expYear;
            }

            @Nullable
            public final String getCvc() {
                return this.cvc;
            }

            @Override
            @NotNull
            public String getType() {
                return "card";
            }

            @Override
            @NotNull
            public List<Pair<String, Object>> getParams() {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)PARAM_NUMBER, (Object)this.number), TuplesKt.to((Object)PARAM_EXP_MONTH, (Object)this.expMonth), TuplesKt.to((Object)PARAM_EXP_YEAR, (Object)this.expYear), TuplesKt.to((Object)PARAM_CVC, (Object)this.cvc)};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            @Nullable
            public final String component1() {
                return this.number;
            }

            @Nullable
            public final Integer component2() {
                return this.expMonth;
            }

            @Nullable
            public final Integer component3() {
                return this.expYear;
            }

            @Nullable
            public final String component4() {
                return this.cvc;
            }

            @NotNull
            public final Card copy(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
                return new Card(number, expMonth, expYear, cvc);
            }

            public static /* synthetic */ Card copy$default(Card card, String string, Integer n, Integer n2, String string2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    string = card.number;
                }
                if ((n3 & 2) != 0) {
                    n = card.expMonth;
                }
                if ((n3 & 4) != 0) {
                    n2 = card.expYear;
                }
                if ((n3 & 8) != 0) {
                    string2 = card.cvc;
                }
                return card.copy(string, n, n2, string2);
            }

            @NotNull
            public String toString() {
                return "Card(number=" + this.number + ", expMonth=" + this.expMonth + ", expYear=" + this.expYear + ", cvc=" + this.cvc + ')';
            }

            public int hashCode() {
                int result2 = this.number == null ? 0 : this.number.hashCode();
                result2 = result2 * 31 + (this.expMonth == null ? 0 : ((Object)this.expMonth).hashCode());
                result2 = result2 * 31 + (this.expYear == null ? 0 : ((Object)this.expYear).hashCode());
                result2 = result2 * 31 + (this.cvc == null ? 0 : this.cvc.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Card)) {
                    return false;
                }
                Card card = (Card)other;
                if (!Intrinsics.areEqual((Object)this.number, (Object)card.number)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.expMonth, (Object)card.expMonth)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.expYear, (Object)card.expYear)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cvc, (Object)card.cvc);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.number);
                Integer n = this.expMonth;
                if (n == null) {
                    out.writeInt(0);
                } else {
                    out.writeInt(1);
                    out.writeInt(n.intValue());
                }
                n = this.expYear;
                if (n == null) {
                    out.writeInt(0);
                } else {
                    out.writeInt(1);
                    out.writeInt(n.intValue());
                }
                out.writeString(this.cvc);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Card> {
                    @NotNull
                    public final Card[] newArray(int size) {
                        return new Card[size];
                    }

                    @NotNull
                    public final Card createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Card(parcel.readString(), parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()), parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Card$Companion;", "", "()V", "PARAM_CVC", "", "PARAM_EXP_MONTH", "PARAM_EXP_YEAR", "PARAM_NUMBER", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R(\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Eps;", "Lcom/stripe/android/model/SourceParams$TypeData;", "statementDescriptor", "", "(Ljava/lang/String;)V", "params", "", "Lkotlin/Pair;", "getParams", "()Ljava/util/List;", "getStatementDescriptor", "()Ljava/lang/String;", "setStatementDescriptor", "type", "getType", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class Eps
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Nullable
            private String statementDescriptor;
            @NotNull
            public static final Parcelable.Creator<Eps> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_STATEMENT_DESCRIPTOR = "statement_descriptor";

            public Eps(@Nullable String statementDescriptor) {
                super(null);
                this.statementDescriptor = statementDescriptor;
            }

            public /* synthetic */ Eps(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                this(string);
            }

            @Nullable
            public final String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            public final void setStatementDescriptor(@Nullable String string) {
                this.statementDescriptor = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "eps";
            }

            @NotNull
            public List<Pair<String, String>> getParams() {
                return CollectionsKt.listOf((Object)TuplesKt.to((Object)PARAM_STATEMENT_DESCRIPTOR, (Object)this.statementDescriptor));
            }

            @Nullable
            public final String component1() {
                return this.statementDescriptor;
            }

            @NotNull
            public final Eps copy(@Nullable String statementDescriptor) {
                return new Eps(statementDescriptor);
            }

            public static /* synthetic */ Eps copy$default(Eps eps, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = eps.statementDescriptor;
                }
                return eps.copy(string);
            }

            @NotNull
            public String toString() {
                return "Eps(statementDescriptor=" + this.statementDescriptor + ')';
            }

            public int hashCode() {
                return this.statementDescriptor == null ? 0 : this.statementDescriptor.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Eps)) {
                    return false;
                }
                Eps eps = (Eps)other;
                return Intrinsics.areEqual((Object)this.statementDescriptor, (Object)eps.statementDescriptor);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.statementDescriptor);
            }

            public Eps() {
                this(null, 1, null);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Eps> {
                    @NotNull
                    public final Eps[] newArray(int size) {
                        return new Eps[size];
                    }

                    @NotNull
                    public final Eps createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Eps(parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Eps$Companion;", "", "()V", "PARAM_STATEMENT_DESCRIPTOR", "", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R(\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Giropay;", "Lcom/stripe/android/model/SourceParams$TypeData;", "statementDescriptor", "", "(Ljava/lang/String;)V", "params", "", "Lkotlin/Pair;", "getParams", "()Ljava/util/List;", "getStatementDescriptor", "()Ljava/lang/String;", "setStatementDescriptor", "type", "getType", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class Giropay
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Nullable
            private String statementDescriptor;
            @NotNull
            public static final Parcelable.Creator<Giropay> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_STATEMENT_DESCRIPTOR = "statement_descriptor";

            public Giropay(@Nullable String statementDescriptor) {
                super(null);
                this.statementDescriptor = statementDescriptor;
            }

            public /* synthetic */ Giropay(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                this(string);
            }

            @Nullable
            public final String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            public final void setStatementDescriptor(@Nullable String string) {
                this.statementDescriptor = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "giropay";
            }

            @NotNull
            public List<Pair<String, String>> getParams() {
                return CollectionsKt.listOf((Object)TuplesKt.to((Object)PARAM_STATEMENT_DESCRIPTOR, (Object)this.statementDescriptor));
            }

            @Nullable
            public final String component1() {
                return this.statementDescriptor;
            }

            @NotNull
            public final Giropay copy(@Nullable String statementDescriptor) {
                return new Giropay(statementDescriptor);
            }

            public static /* synthetic */ Giropay copy$default(Giropay giropay, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = giropay.statementDescriptor;
                }
                return giropay.copy(string);
            }

            @NotNull
            public String toString() {
                return "Giropay(statementDescriptor=" + this.statementDescriptor + ')';
            }

            public int hashCode() {
                return this.statementDescriptor == null ? 0 : this.statementDescriptor.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Giropay)) {
                    return false;
                }
                Giropay giropay = (Giropay)other;
                return Intrinsics.areEqual((Object)this.statementDescriptor, (Object)giropay.statementDescriptor);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.statementDescriptor);
            }

            public Giropay() {
                this(null, 1, null);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Giropay> {
                    @NotNull
                    public final Giropay[] newArray(int size) {
                        return new Giropay[size];
                    }

                    @NotNull
                    public final Giropay createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Giropay(parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Giropay$Companion;", "", "()V", "PARAM_STATEMENT_DESCRIPTOR", "", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u00d6\u0001R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Ideal;", "Lcom/stripe/android/model/SourceParams$TypeData;", "statementDescriptor", "", "bank", "(Ljava/lang/String;Ljava/lang/String;)V", "getBank", "()Ljava/lang/String;", "setBank", "(Ljava/lang/String;)V", "params", "", "Lkotlin/Pair;", "getParams", "()Ljava/util/List;", "getStatementDescriptor", "setStatementDescriptor", "type", "getType", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class Ideal
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Nullable
            private String statementDescriptor;
            @Nullable
            private String bank;
            @NotNull
            public static final Parcelable.Creator<Ideal> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_STATEMENT_DESCRIPTOR = "statement_descriptor";
            @Deprecated
            @NotNull
            private static final String PARAM_BANK = "bank";

            public Ideal(@Nullable String statementDescriptor, @Nullable String bank) {
                super(null);
                this.statementDescriptor = statementDescriptor;
                this.bank = bank;
            }

            public /* synthetic */ Ideal(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @Nullable
            public final String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            public final void setStatementDescriptor(@Nullable String string) {
                this.statementDescriptor = string;
            }

            @Nullable
            public final String getBank() {
                return this.bank;
            }

            public final void setBank(@Nullable String string) {
                this.bank = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "ideal";
            }

            @NotNull
            public List<Pair<String, String>> getParams() {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)PARAM_STATEMENT_DESCRIPTOR, (Object)this.statementDescriptor), TuplesKt.to((Object)PARAM_BANK, (Object)this.bank)};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            @Nullable
            public final String component1() {
                return this.statementDescriptor;
            }

            @Nullable
            public final String component2() {
                return this.bank;
            }

            @NotNull
            public final Ideal copy(@Nullable String statementDescriptor, @Nullable String bank) {
                return new Ideal(statementDescriptor, bank);
            }

            public static /* synthetic */ Ideal copy$default(Ideal ideal, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = ideal.statementDescriptor;
                }
                if ((n & 2) != 0) {
                    string2 = ideal.bank;
                }
                return ideal.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Ideal(statementDescriptor=" + this.statementDescriptor + ", bank=" + this.bank + ')';
            }

            public int hashCode() {
                int result2 = this.statementDescriptor == null ? 0 : this.statementDescriptor.hashCode();
                result2 = result2 * 31 + (this.bank == null ? 0 : this.bank.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ideal)) {
                    return false;
                }
                Ideal ideal = (Ideal)other;
                if (!Intrinsics.areEqual((Object)this.statementDescriptor, (Object)ideal.statementDescriptor)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.bank, (Object)ideal.bank);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.statementDescriptor);
                out.writeString(this.bank);
            }

            public Ideal() {
                this(null, null, 3, null);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Ideal> {
                    @NotNull
                    public final Ideal[] newArray(int size) {
                        return new Ideal[size];
                    }

                    @NotNull
                    public final Ideal createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Ideal(parcel.readString(), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Ideal$Companion;", "", "()V", "PARAM_BANK", "", "PARAM_STATEMENT_DESCRIPTOR", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR2\u0010\n\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r0\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Masterpass;", "Lcom/stripe/android/model/SourceParams$TypeData;", "transactionId", "", "cartId", "(Ljava/lang/String;Ljava/lang/String;)V", "getCartId", "()Ljava/lang/String;", "setCartId", "(Ljava/lang/String;)V", "params", "", "Lkotlin/Pair;", "", "getParams", "()Ljava/util/List;", "getTransactionId", "setTransactionId", "type", "getType", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class Masterpass
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @NotNull
            private String transactionId;
            @NotNull
            private String cartId;
            @NotNull
            public static final Parcelable.Creator<Masterpass> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_CART_ID = "cart_id";
            @Deprecated
            @NotNull
            private static final String PARAM_MASTERPASS = "masterpass";
            @Deprecated
            @NotNull
            private static final String PARAM_TRANSACTION_ID = "transaction_id";

            public Masterpass(@NotNull String transactionId, @NotNull String cartId) {
                Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
                Intrinsics.checkNotNullParameter((Object)cartId, (String)"cartId");
                super(null);
                this.transactionId = transactionId;
                this.cartId = cartId;
            }

            @NotNull
            public final String getTransactionId() {
                return this.transactionId;
            }

            public final void setTransactionId(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.transactionId = string;
            }

            @NotNull
            public final String getCartId() {
                return this.cartId;
            }

            public final void setCartId(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.cartId = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "card";
            }

            @NotNull
            public List<Pair<String, Map<String, String>>> getParams() {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PARAM_TRANSACTION_ID, (Object)this.transactionId), TuplesKt.to((Object)PARAM_CART_ID, (Object)this.cartId)};
                return CollectionsKt.listOf((Object)TuplesKt.to((Object)PARAM_MASTERPASS, (Object)MapsKt.mapOf((Pair[])pairArray)));
            }

            @NotNull
            public final String component1() {
                return this.transactionId;
            }

            @NotNull
            public final String component2() {
                return this.cartId;
            }

            @NotNull
            public final Masterpass copy(@NotNull String transactionId, @NotNull String cartId) {
                Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
                Intrinsics.checkNotNullParameter((Object)cartId, (String)"cartId");
                return new Masterpass(transactionId, cartId);
            }

            public static /* synthetic */ Masterpass copy$default(Masterpass masterpass, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = masterpass.transactionId;
                }
                if ((n & 2) != 0) {
                    string2 = masterpass.cartId;
                }
                return masterpass.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Masterpass(transactionId=" + this.transactionId + ", cartId=" + this.cartId + ')';
            }

            public int hashCode() {
                int result2 = this.transactionId.hashCode();
                result2 = result2 * 31 + this.cartId.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Masterpass)) {
                    return false;
                }
                Masterpass masterpass = (Masterpass)other;
                if (!Intrinsics.areEqual((Object)this.transactionId, (Object)masterpass.transactionId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cartId, (Object)masterpass.cartId);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.transactionId);
                out.writeString(this.cartId);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Masterpass> {
                    @NotNull
                    public final Masterpass[] newArray(int size) {
                        return new Masterpass[size];
                    }

                    @NotNull
                    public final Masterpass createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Masterpass(parcel.readString(), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Masterpass$Companion;", "", "()V", "PARAM_CART_ID", "", "PARAM_MASTERPASS", "PARAM_TRANSACTION_ID", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u0015\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Sofort;", "Lcom/stripe/android/model/SourceParams$TypeData;", "country", "", "statementDescriptor", "(Ljava/lang/String;Ljava/lang/String;)V", "getCountry", "()Ljava/lang/String;", "setCountry", "(Ljava/lang/String;)V", "params", "", "Lkotlin/Pair;", "getParams", "()Ljava/util/List;", "getStatementDescriptor", "setStatementDescriptor", "type", "getType", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class Sofort
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @NotNull
            private String country;
            @Nullable
            private String statementDescriptor;
            @NotNull
            public static final Parcelable.Creator<Sofort> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_COUNTRY = "country";
            @Deprecated
            @NotNull
            private static final String PARAM_STATEMENT_DESCRIPTOR = "statement_descriptor";

            public Sofort(@Size(value=2L) @NotNull String country, @Nullable String statementDescriptor) {
                Intrinsics.checkNotNullParameter((Object)country, (String)PARAM_COUNTRY);
                super(null);
                this.country = country;
                this.statementDescriptor = statementDescriptor;
            }

            public /* synthetic */ Sofort(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @NotNull
            public final String getCountry() {
                return this.country;
            }

            public final void setCountry(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.country = string;
            }

            @Nullable
            public final String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            public final void setStatementDescriptor(@Nullable String string) {
                this.statementDescriptor = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "sofort";
            }

            @NotNull
            public List<Pair<String, String>> getParams() {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)PARAM_COUNTRY, (Object)this.country), TuplesKt.to((Object)PARAM_STATEMENT_DESCRIPTOR, (Object)this.statementDescriptor)};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            @NotNull
            public final String component1() {
                return this.country;
            }

            @Nullable
            public final String component2() {
                return this.statementDescriptor;
            }

            @NotNull
            public final Sofort copy(@Size(value=2L) @NotNull String country, @Nullable String statementDescriptor) {
                Intrinsics.checkNotNullParameter((Object)country, (String)PARAM_COUNTRY);
                return new Sofort(country, statementDescriptor);
            }

            public static /* synthetic */ Sofort copy$default(Sofort sofort, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sofort.country;
                }
                if ((n & 2) != 0) {
                    string2 = sofort.statementDescriptor;
                }
                return sofort.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Sofort(country=" + this.country + ", statementDescriptor=" + this.statementDescriptor + ')';
            }

            public int hashCode() {
                int result2 = this.country.hashCode();
                result2 = result2 * 31 + (this.statementDescriptor == null ? 0 : this.statementDescriptor.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Sofort)) {
                    return false;
                }
                Sofort sofort = (Sofort)other;
                if (!Intrinsics.areEqual((Object)this.country, (Object)sofort.country)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.statementDescriptor, (Object)sofort.statementDescriptor);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.country);
                out.writeString(this.statementDescriptor);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Sofort> {
                    @NotNull
                    public final Sofort[] newArray(int size) {
                        return new Sofort[size];
                    }

                    @NotNull
                    public final Sofort createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Sofort(parcel.readString(), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Sofort$Companion;", "", "()V", "PARAM_COUNTRY", "", "PARAM_STATEMENT_DESCRIPTOR", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R(\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$SepaDebit;", "Lcom/stripe/android/model/SourceParams$TypeData;", "iban", "", "(Ljava/lang/String;)V", "getIban", "()Ljava/lang/String;", "setIban", "params", "", "Lkotlin/Pair;", "getParams", "()Ljava/util/List;", "type", "getType", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class SepaDebit
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @NotNull
            private String iban;
            @NotNull
            public static final Parcelable.Creator<SepaDebit> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_IBAN = "iban";

            public SepaDebit(@NotNull String iban) {
                Intrinsics.checkNotNullParameter((Object)iban, (String)PARAM_IBAN);
                super(null);
                this.iban = iban;
            }

            @NotNull
            public final String getIban() {
                return this.iban;
            }

            public final void setIban(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.iban = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "sepa_debit";
            }

            @NotNull
            public List<Pair<String, String>> getParams() {
                return CollectionsKt.listOf((Object)TuplesKt.to((Object)PARAM_IBAN, (Object)this.iban));
            }

            @NotNull
            public final String component1() {
                return this.iban;
            }

            @NotNull
            public final SepaDebit copy(@NotNull String iban) {
                Intrinsics.checkNotNullParameter((Object)iban, (String)PARAM_IBAN);
                return new SepaDebit(iban);
            }

            public static /* synthetic */ SepaDebit copy$default(SepaDebit sepaDebit, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sepaDebit.iban;
                }
                return sepaDebit.copy(string);
            }

            @NotNull
            public String toString() {
                return "SepaDebit(iban=" + this.iban + ')';
            }

            public int hashCode() {
                return this.iban.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit sepaDebit = (SepaDebit)other;
                return Intrinsics.areEqual((Object)this.iban, (Object)sepaDebit.iban);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.iban);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<SepaDebit> {
                    @NotNull
                    public final SepaDebit[] newArray(int size) {
                        return new SepaDebit[size];
                    }

                    @NotNull
                    public final SepaDebit createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new SepaDebit(parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$SepaDebit$Companion;", "", "()V", "PARAM_IBAN", "", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R(\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$ThreeDSecure;", "Lcom/stripe/android/model/SourceParams$TypeData;", "cardId", "", "(Ljava/lang/String;)V", "getCardId", "()Ljava/lang/String;", "setCardId", "params", "", "Lkotlin/Pair;", "getParams", "()Ljava/util/List;", "type", "getType", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class ThreeDSecure
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @NotNull
            private String cardId;
            @NotNull
            public static final Parcelable.Creator<ThreeDSecure> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_CARD = "card";

            public ThreeDSecure(@NotNull String cardId) {
                Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
                super(null);
                this.cardId = cardId;
            }

            @NotNull
            public final String getCardId() {
                return this.cardId;
            }

            public final void setCardId(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.cardId = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "three_d_secure";
            }

            @NotNull
            public List<Pair<String, String>> getParams() {
                return CollectionsKt.listOf((Object)TuplesKt.to((Object)PARAM_CARD, (Object)this.cardId));
            }

            @NotNull
            public final String component1() {
                return this.cardId;
            }

            @NotNull
            public final ThreeDSecure copy(@NotNull String cardId) {
                Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
                return new ThreeDSecure(cardId);
            }

            public static /* synthetic */ ThreeDSecure copy$default(ThreeDSecure threeDSecure, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = threeDSecure.cardId;
                }
                return threeDSecure.copy(string);
            }

            @NotNull
            public String toString() {
                return "ThreeDSecure(cardId=" + this.cardId + ')';
            }

            public int hashCode() {
                return this.cardId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ThreeDSecure)) {
                    return false;
                }
                ThreeDSecure threeDSecure = (ThreeDSecure)other;
                return Intrinsics.areEqual((Object)this.cardId, (Object)threeDSecure.cardId);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.cardId);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<ThreeDSecure> {
                    @NotNull
                    public final ThreeDSecure[] newArray(int size) {
                        return new ThreeDSecure[size];
                    }

                    @NotNull
                    public final ThreeDSecure createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new ThreeDSecure(parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$ThreeDSecure$Companion;", "", "()V", "PARAM_CARD", "", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R(\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$VisaCheckout;", "Lcom/stripe/android/model/SourceParams$TypeData;", "callId", "", "(Ljava/lang/String;)V", "getCallId", "()Ljava/lang/String;", "setCallId", "params", "", "Lkotlin/Pair;", "", "getParams", "()Ljava/util/List;", "type", "getType", "component1", "copy", "describeContents", "", "equals", "", "other", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class VisaCheckout
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @NotNull
            private String callId;
            @NotNull
            public static final Parcelable.Creator<VisaCheckout> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_VISA_CHECKOUT = "visa_checkout";
            @Deprecated
            @NotNull
            private static final String PARAM_CALL_ID = "callid";

            public VisaCheckout(@NotNull String callId) {
                Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
                super(null);
                this.callId = callId;
            }

            @NotNull
            public final String getCallId() {
                return this.callId;
            }

            public final void setCallId(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.callId = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "card";
            }

            @Override
            @NotNull
            public List<Pair<String, Object>> getParams() {
                return CollectionsKt.listOf((Object)TuplesKt.to((Object)PARAM_VISA_CHECKOUT, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_CALL_ID, (Object)this.callId))));
            }

            @NotNull
            public final String component1() {
                return this.callId;
            }

            @NotNull
            public final VisaCheckout copy(@NotNull String callId) {
                Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
                return new VisaCheckout(callId);
            }

            public static /* synthetic */ VisaCheckout copy$default(VisaCheckout visaCheckout, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = visaCheckout.callId;
                }
                return visaCheckout.copy(string);
            }

            @NotNull
            public String toString() {
                return "VisaCheckout(callId=" + this.callId + ')';
            }

            public int hashCode() {
                return this.callId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VisaCheckout)) {
                    return false;
                }
                VisaCheckout visaCheckout = (VisaCheckout)other;
                return Intrinsics.areEqual((Object)this.callId, (Object)visaCheckout.callId);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.callId);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<VisaCheckout> {
                    @NotNull
                    public final VisaCheckout[] newArray(int size) {
                        return new VisaCheckout[size];
                    }

                    @NotNull
                    public final VisaCheckout createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new VisaCheckout(parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$VisaCheckout$Companion;", "", "()V", "PARAM_CALL_ID", "", "PARAM_VISA_CHECKOUT", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u00d6\u0001R(\u0010\u0006\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006$"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Bancontact;", "Lcom/stripe/android/model/SourceParams$TypeData;", "statementDescriptor", "", "preferredLanguage", "(Ljava/lang/String;Ljava/lang/String;)V", "params", "", "Lkotlin/Pair;", "getParams", "()Ljava/util/List;", "getPreferredLanguage", "()Ljava/lang/String;", "setPreferredLanguage", "(Ljava/lang/String;)V", "getStatementDescriptor", "setStatementDescriptor", "type", "getType", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class Bancontact
        extends TypeData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Nullable
            private String statementDescriptor;
            @Nullable
            private String preferredLanguage;
            @NotNull
            public static final Parcelable.Creator<Bancontact> CREATOR;
            public static final int $stable;
            @Deprecated
            @NotNull
            private static final String PARAM_STATEMENT_DESCRIPTOR = "statement_descriptor";
            @Deprecated
            @NotNull
            private static final String PARAM_PREFERRED_LANGUAGE = "preferred_language";

            public Bancontact(@Nullable String statementDescriptor, @Nullable String preferredLanguage) {
                super(null);
                this.statementDescriptor = statementDescriptor;
                this.preferredLanguage = preferredLanguage;
            }

            public /* synthetic */ Bancontact(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @Nullable
            public final String getStatementDescriptor() {
                return this.statementDescriptor;
            }

            public final void setStatementDescriptor(@Nullable String string) {
                this.statementDescriptor = string;
            }

            @Nullable
            public final String getPreferredLanguage() {
                return this.preferredLanguage;
            }

            public final void setPreferredLanguage(@Nullable String string) {
                this.preferredLanguage = string;
            }

            @Override
            @NotNull
            public String getType() {
                return "bancontact";
            }

            @NotNull
            public List<Pair<String, String>> getParams() {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)PARAM_STATEMENT_DESCRIPTOR, (Object)this.statementDescriptor), TuplesKt.to((Object)PARAM_PREFERRED_LANGUAGE, (Object)this.preferredLanguage)};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            @Nullable
            public final String component1() {
                return this.statementDescriptor;
            }

            @Nullable
            public final String component2() {
                return this.preferredLanguage;
            }

            @NotNull
            public final Bancontact copy(@Nullable String statementDescriptor, @Nullable String preferredLanguage) {
                return new Bancontact(statementDescriptor, preferredLanguage);
            }

            public static /* synthetic */ Bancontact copy$default(Bancontact bancontact, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = bancontact.statementDescriptor;
                }
                if ((n & 2) != 0) {
                    string2 = bancontact.preferredLanguage;
                }
                return bancontact.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Bancontact(statementDescriptor=" + this.statementDescriptor + ", preferredLanguage=" + this.preferredLanguage + ')';
            }

            public int hashCode() {
                int result2 = this.statementDescriptor == null ? 0 : this.statementDescriptor.hashCode();
                result2 = result2 * 31 + (this.preferredLanguage == null ? 0 : this.preferredLanguage.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Bancontact)) {
                    return false;
                }
                Bancontact bancontact = (Bancontact)other;
                if (!Intrinsics.areEqual((Object)this.statementDescriptor, (Object)bancontact.statementDescriptor)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.preferredLanguage, (Object)bancontact.preferredLanguage);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.statementDescriptor);
                out.writeString(this.preferredLanguage);
            }

            public Bancontact() {
                this(null, null, 3, null);
            }

            static {
                @Metadata(mv={1, 7, 1}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Bancontact> {
                    @NotNull
                    public final Bancontact[] newArray(int size) {
                        return new Bancontact[size];
                    }

                    @NotNull
                    public final Bancontact createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Bancontact(parcel.readString(), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/SourceParams$TypeData$Bancontact$Companion;", "", "()V", "PARAM_PREFERRED_LANGUAGE", "", "PARAM_STATEMENT_DESCRIPTOR", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

