/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.PaymentMethodPreference;
import com.stripe.android.model.StripeIntent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u0010*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0017\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodPreferenceJsonParser;", "StripeIntentType", "Lcom/stripe/android/model/StripeIntent;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethodPreference;", "()V", "stripeIntentFieldName", "", "getStripeIntentFieldName", "()Ljava/lang/String;", "parse", "json", "Lorg/json/JSONObject;", "parseStripeIntent", "stripeIntentJson", "(Lorg/json/JSONObject;)Lcom/stripe/android/model/StripeIntent;", "Companion", "Lcom/stripe/android/model/parsers/PaymentMethodPreferenceForPaymentIntentJsonParser;", "Lcom/stripe/android/model/parsers/PaymentMethodPreferenceForSetupIntentJsonParser;", "payments-core_release"})
public abstract class PaymentMethodPreferenceJsonParser<StripeIntentType extends StripeIntent>
implements ModelJsonParser<PaymentMethodPreference> {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private static final String OBJECT_TYPE_PREFERENCE = "payment_method_preference";
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @NotNull
    private static final String FIELD_COUNTRY_CODE = "country_code";
    @NotNull
    private static final String FIELD_ORDERED_PAYMENT_METHOD_TYPES = "ordered_payment_method_types";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";
    @NotNull
    private static final String FIELD_TYPE_PAYMENT_METHOD_SCHEMA = "payment_method_specs";
    @NotNull
    private static final String FIELD_LINK_SETTINGS = "link_settings";
    @NotNull
    private static final String FIELD_LINK_FUNDING_SOURCES = "link_funding_sources";

    private PaymentMethodPreferenceJsonParser() {
    }

    @NotNull
    public abstract String getStripeIntentFieldName();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PaymentMethodPreference parse(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JSONObject paymentMethodPreference = StripeJsonUtils.INSTANCE.mapToJsonObject(StripeJsonUtils.INSTANCE.optMap(json, OBJECT_TYPE_PREFERENCE));
        String objectType = StripeJsonUtils.optString((JSONObject)paymentMethodPreference, (String)FIELD_OBJECT);
        if (paymentMethodPreference == null) return null;
        if (!Intrinsics.areEqual((Object)OBJECT_TYPE_PREFERENCE, (Object)objectType)) {
            return null;
        }
        String countryCode = paymentMethodPreference.optString(FIELD_COUNTRY_CODE);
        JSONArray paymentMethodSpecs = json.optJSONArray(FIELD_TYPE_PAYMENT_METHOD_SCHEMA);
        JSONObject jSONObject = json.optJSONObject(FIELD_LINK_SETTINGS);
        JSONArray linkFundingSources = jSONObject != null ? jSONObject.optJSONArray(FIELD_LINK_FUNDING_SOURCES) : null;
        JSONArray orderedPaymentMethodTypes = paymentMethodPreference.optJSONArray(FIELD_ORDERED_PAYMENT_METHOD_TYPES);
        JSONArray unactivatedPaymentMethods = json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES);
        JSONObject jSONObject2 = paymentMethodPreference.optJSONObject(this.getStripeIntentFieldName());
        if (jSONObject2 == null) return null;
        JSONObject stripeIntentJsonObject = jSONObject2;
        boolean bl = false;
        JSONArray jSONArray = orderedPaymentMethodTypes;
        if (jSONArray != null) {
            JSONArray it = jSONArray;
            boolean bl2 = false;
            stripeIntentJsonObject.put(FIELD_PAYMENT_METHOD_TYPES, (Object)orderedPaymentMethodTypes);
        }
        stripeIntentJsonObject.put(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES, (Object)unactivatedPaymentMethods);
        stripeIntentJsonObject.put(FIELD_LINK_FUNDING_SOURCES, (Object)linkFundingSources);
        stripeIntentJsonObject.put(FIELD_COUNTRY_CODE, (Object)countryCode);
        StripeIntentType StripeIntentType2 = this.parseStripeIntent(stripeIntentJsonObject);
        if (StripeIntentType2 == null) return null;
        StripeIntentType it = StripeIntentType2;
        boolean bl3 = false;
        JSONArray jSONArray2 = paymentMethodSpecs;
        PaymentMethodPreference paymentMethodPreference2 = new PaymentMethodPreference((StripeIntent)it, jSONArray2 != null ? jSONArray2.toString() : null);
        return paymentMethodPreference2;
    }

    @Nullable
    public abstract StripeIntentType parseStripeIntent(@NotNull JSONObject var1);

    public /* synthetic */ PaymentMethodPreferenceJsonParser(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodPreferenceJsonParser$Companion;", "", "()V", "FIELD_COUNTRY_CODE", "", "FIELD_LINK_FUNDING_SOURCES", "FIELD_LINK_SETTINGS", "FIELD_OBJECT", "FIELD_ORDERED_PAYMENT_METHOD_TYPES", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_TYPE_PAYMENT_METHOD_SCHEMA", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "OBJECT_TYPE_PREFERENCE", "payments-core_release"})
    protected static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

