/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.networking.NetworkConstantsKt;
import com.stripe.android.core.networking.RequestHeadersFactory;
import com.stripe.android.core.networking.StripeRequest;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\n\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/stripe/android/networking/FraudDetectionDataRequest;", "Lcom/stripe/android/core/networking/StripeRequest;", "params", "", "", "", "guid", "(Ljava/util/Map;Ljava/lang/String;)V", "headers", "getHeaders", "()Ljava/util/Map;", "headersFactory", "Lcom/stripe/android/core/networking/RequestHeadersFactory$FraudDetection;", "jsonBody", "getJsonBody", "()Ljava/lang/String;", "method", "Lcom/stripe/android/core/networking/StripeRequest$Method;", "getMethod", "()Lcom/stripe/android/core/networking/StripeRequest$Method;", "mimeType", "Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "getMimeType", "()Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "postBodyBytes", "", "getPostBodyBytes", "()[B", "postHeaders", "getPostHeaders", "setPostHeaders", "(Ljava/util/Map;)V", "retryResponseCodes", "", "", "getRetryResponseCodes", "()Ljava/lang/Iterable;", "url", "getUrl", "writePostBody", "", "outputStream", "Ljava/io/OutputStream;", "Companion", "payments-core_release"})
public final class FraudDetectionDataRequest
extends StripeRequest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> params;
    @NotNull
    private final RequestHeadersFactory.FraudDetection headersFactory;
    @NotNull
    private final StripeRequest.Method method;
    @NotNull
    private final StripeRequest.MimeType mimeType;
    @NotNull
    private final Iterable<Integer> retryResponseCodes;
    @NotNull
    private final String url;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private Map<String, String> postHeaders;
    @Deprecated
    @NotNull
    private static final String URL = "https://m.stripe.com/6";

    public FraudDetectionDataRequest(@NotNull Map<String, ? extends Object> params, @NotNull String guid) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)guid, (String)"guid");
        this.params = params;
        this.headersFactory = new RequestHeadersFactory.FraudDetection(guid);
        this.method = StripeRequest.Method.POST;
        this.mimeType = StripeRequest.MimeType.Json;
        this.retryResponseCodes = NetworkConstantsKt.getDEFAULT_RETRY_CODES();
        this.url = URL;
        this.headers = this.headersFactory.create();
        this.postHeaders = this.headersFactory.createPostHeader();
    }

    private final String getJsonBody() {
        return String.valueOf(StripeJsonUtils.INSTANCE.mapToJsonObject(this.params));
    }

    private final byte[] getPostBodyBytes() {
        try {
            byte[] byArray = this.getJsonBody().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException(null, null, 0, "Unable to encode parameters to " + Charsets.UTF_8.name() + ". Please contact support@stripe.com for assistance.", (Throwable)e, 7, null);
        }
    }

    @NotNull
    public StripeRequest.Method getMethod() {
        return this.method;
    }

    @NotNull
    public StripeRequest.MimeType getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public Iterable<Integer> getRetryResponseCodes() {
        return this.retryResponseCodes;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    public Map<String, String> getPostHeaders() {
        return this.postHeaders;
    }

    public void setPostHeaders(@Nullable Map<String, String> map) {
        this.postHeaders = map;
    }

    public void writePostBody(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        byte[] it = this.getPostBodyBytes();
        boolean bl = false;
        outputStream.write(it);
        outputStream.flush();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/FraudDetectionDataRequest$Companion;", "", "()V", "URL", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

