/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication.threeds2;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleKt;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.core.injection.InjectorKey;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2TransactionActivity;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "payments-core_release"})
public final class Stripe3ds2TransactionContract
extends ActivityResultContract<Args, PaymentFlowResult.Unvalidated> {
    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intent intent = new Intent(context, Stripe3ds2TransactionActivity.class).putExtras(input.toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, Stripe3d\u2026tExtras(input.toBundle())");
        return intent;
    }

    @NotNull
    public PaymentFlowResult.Unvalidated parseResult(int resultCode, @Nullable Intent intent) {
        return PaymentFlowResult.Unvalidated.Companion.fromIntent(intent);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 G2\u00020\u0001:\u0001GB_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014\u00a2\u0006\u0002\u0010\u0015J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0007H\u00c6\u0003J\t\u00102\u001a\u00020\tH\u00c6\u0003J\t\u00103\u001a\u00020\u000bH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\u0010\u00105\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010*J\t\u00106\u001a\u00020\u0011H\u00c6\u0003J\t\u00107\u001a\u00020\u0011H\u00c6\u0003Jz\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0003\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u00c6\u0001\u00a2\u0006\u0002\u00109J\t\u0010:\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010;\u001a\u00020\r2\b\u0010<\u001a\u0004\u0018\u00010=H\u00d6\u0003J\t\u0010>\u001a\u00020\u000fH\u00d6\u0001J\u0006\u0010?\u001a\u00020@J\t\u0010A\u001a\u00020\u0011H\u00d6\u0001J\u0019\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006H"}, d2={"Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "Landroid/os/Parcelable;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "config", "Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "enableLogging", "", "statusBarColor", "", "injectorKey", "", "publishableKey", "productUsage", "", "(Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;Lcom/stripe/android/core/networking/ApiRequest$Options;ZLjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getConfig", "()Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;", "getEnableLogging", "()Z", "fingerprint", "Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "getFingerprint", "()Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "getInjectorKey", "()Ljava/lang/String;", "getNextActionData", "()Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "getProductUsage", "()Ljava/util/Set;", "getPublishableKey", "getRequestOptions", "()Lcom/stripe/android/core/networking/ApiRequest$Options;", "getSdkTransactionId", "()Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "getStatusBarColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getStripeIntent", "()Lcom/stripe/android/model/StripeIntent;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Lcom/stripe/android/PaymentAuthConfig$Stripe3ds2Config;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;Lcom/stripe/android/core/networking/ApiRequest$Options;ZLjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "describeContents", "equals", "other", "", "hashCode", "toBundle", "Landroid/os/Bundle;", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Args
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SdkTransactionId sdkTransactionId;
        @NotNull
        private final PaymentAuthConfig.Stripe3ds2Config config;
        @NotNull
        private final StripeIntent stripeIntent;
        @NotNull
        private final StripeIntent.NextActionData.SdkData.Use3DS2 nextActionData;
        @NotNull
        private final ApiRequest.Options requestOptions;
        private final boolean enableLogging;
        @Nullable
        private final Integer statusBarColor;
        @NotNull
        private final String injectorKey;
        @NotNull
        private final String publishableKey;
        @NotNull
        private final Set<String> productUsage;
        @NotNull
        public static final Parcelable.Creator<Args> CREATOR;
        public static final int $stable;
        @NotNull
        private static final String EXTRA_ARGS = "extra_args";

        public Args(@NotNull SdkTransactionId sdkTransactionId, @NotNull PaymentAuthConfig.Stripe3ds2Config config, @NotNull StripeIntent stripeIntent, @NotNull StripeIntent.NextActionData.SdkData.Use3DS2 nextActionData, @NotNull ApiRequest.Options requestOptions, boolean enableLogging, @Nullable Integer statusBarColor, @InjectorKey @NotNull String injectorKey, @NotNull String publishableKey2, @NotNull Set<String> productUsage) {
            Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkNotNullParameter((Object)nextActionData, (String)"nextActionData");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkNotNullParameter((Object)injectorKey, (String)"injectorKey");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
            this.sdkTransactionId = sdkTransactionId;
            this.config = config;
            this.stripeIntent = stripeIntent;
            this.nextActionData = nextActionData;
            this.requestOptions = requestOptions;
            this.enableLogging = enableLogging;
            this.statusBarColor = statusBarColor;
            this.injectorKey = injectorKey;
            this.publishableKey = publishableKey2;
            this.productUsage = productUsage;
        }

        @NotNull
        public final SdkTransactionId getSdkTransactionId() {
            return this.sdkTransactionId;
        }

        @NotNull
        public final PaymentAuthConfig.Stripe3ds2Config getConfig() {
            return this.config;
        }

        @NotNull
        public final StripeIntent getStripeIntent() {
            return this.stripeIntent;
        }

        @NotNull
        public final StripeIntent.NextActionData.SdkData.Use3DS2 getNextActionData() {
            return this.nextActionData;
        }

        @NotNull
        public final ApiRequest.Options getRequestOptions() {
            return this.requestOptions;
        }

        public final boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Nullable
        public final Integer getStatusBarColor() {
            return this.statusBarColor;
        }

        @NotNull
        public final String getInjectorKey() {
            return this.injectorKey;
        }

        @NotNull
        public final String getPublishableKey() {
            return this.publishableKey;
        }

        @NotNull
        public final Set<String> getProductUsage() {
            return this.productUsage;
        }

        @NotNull
        public final Stripe3ds2Fingerprint getFingerprint() {
            return new Stripe3ds2Fingerprint(this.nextActionData);
        }

        @NotNull
        public final Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)EXTRA_ARGS, (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        @NotNull
        public final SdkTransactionId component1() {
            return this.sdkTransactionId;
        }

        @NotNull
        public final PaymentAuthConfig.Stripe3ds2Config component2() {
            return this.config;
        }

        @NotNull
        public final StripeIntent component3() {
            return this.stripeIntent;
        }

        @NotNull
        public final StripeIntent.NextActionData.SdkData.Use3DS2 component4() {
            return this.nextActionData;
        }

        @NotNull
        public final ApiRequest.Options component5() {
            return this.requestOptions;
        }

        public final boolean component6() {
            return this.enableLogging;
        }

        @Nullable
        public final Integer component7() {
            return this.statusBarColor;
        }

        @NotNull
        public final String component8() {
            return this.injectorKey;
        }

        @NotNull
        public final String component9() {
            return this.publishableKey;
        }

        @NotNull
        public final Set<String> component10() {
            return this.productUsage;
        }

        @NotNull
        public final Args copy(@NotNull SdkTransactionId sdkTransactionId, @NotNull PaymentAuthConfig.Stripe3ds2Config config, @NotNull StripeIntent stripeIntent, @NotNull StripeIntent.NextActionData.SdkData.Use3DS2 nextActionData, @NotNull ApiRequest.Options requestOptions, boolean enableLogging, @Nullable Integer statusBarColor, @InjectorKey @NotNull String injectorKey, @NotNull String publishableKey2, @NotNull Set<String> productUsage) {
            Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkNotNullParameter((Object)nextActionData, (String)"nextActionData");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkNotNullParameter((Object)injectorKey, (String)"injectorKey");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
            return new Args(sdkTransactionId, config, stripeIntent, nextActionData, requestOptions, enableLogging, statusBarColor, injectorKey, publishableKey2, productUsage);
        }

        public static /* synthetic */ Args copy$default(Args args2, SdkTransactionId sdkTransactionId, PaymentAuthConfig.Stripe3ds2Config stripe3ds2Config, StripeIntent stripeIntent, StripeIntent.NextActionData.SdkData.Use3DS2 use3DS2, ApiRequest.Options options, boolean bl, Integer n, String string2, String string3, Set set, int n2, Object object) {
            if ((n2 & 1) != 0) {
                sdkTransactionId = args2.sdkTransactionId;
            }
            if ((n2 & 2) != 0) {
                stripe3ds2Config = args2.config;
            }
            if ((n2 & 4) != 0) {
                stripeIntent = args2.stripeIntent;
            }
            if ((n2 & 8) != 0) {
                use3DS2 = args2.nextActionData;
            }
            if ((n2 & 0x10) != 0) {
                options = args2.requestOptions;
            }
            if ((n2 & 0x20) != 0) {
                bl = args2.enableLogging;
            }
            if ((n2 & 0x40) != 0) {
                n = args2.statusBarColor;
            }
            if ((n2 & 0x80) != 0) {
                string2 = args2.injectorKey;
            }
            if ((n2 & 0x100) != 0) {
                string3 = args2.publishableKey;
            }
            if ((n2 & 0x200) != 0) {
                set = args2.productUsage;
            }
            return args2.copy(sdkTransactionId, stripe3ds2Config, stripeIntent, use3DS2, options, bl, n, string2, string3, set);
        }

        @NotNull
        public String toString() {
            return "Args(sdkTransactionId=" + this.sdkTransactionId + ", config=" + this.config + ", stripeIntent=" + this.stripeIntent + ", nextActionData=" + this.nextActionData + ", requestOptions=" + this.requestOptions + ", enableLogging=" + this.enableLogging + ", statusBarColor=" + this.statusBarColor + ", injectorKey=" + this.injectorKey + ", publishableKey=" + this.publishableKey + ", productUsage=" + this.productUsage + ')';
        }

        public int hashCode() {
            int result2 = this.sdkTransactionId.hashCode();
            result2 = result2 * 31 + this.config.hashCode();
            result2 = result2 * 31 + this.stripeIntent.hashCode();
            result2 = result2 * 31 + this.nextActionData.hashCode();
            result2 = result2 * 31 + this.requestOptions.hashCode();
            int n = this.enableLogging ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.statusBarColor == null ? 0 : ((Object)this.statusBarColor).hashCode());
            result2 = result2 * 31 + this.injectorKey.hashCode();
            result2 = result2 * 31 + this.publishableKey.hashCode();
            result2 = result2 * 31 + ((Object)this.productUsage).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args2 = (Args)other;
            if (!Intrinsics.areEqual((Object)this.sdkTransactionId, (Object)args2.sdkTransactionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.config, (Object)args2.config)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stripeIntent, (Object)args2.stripeIntent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nextActionData, (Object)args2.nextActionData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestOptions, (Object)args2.requestOptions)) {
                return false;
            }
            if (this.enableLogging != args2.enableLogging) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statusBarColor, (Object)args2.statusBarColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.injectorKey, (Object)args2.injectorKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)args2.publishableKey)) {
                return false;
            }
            return Intrinsics.areEqual(this.productUsage, args2.productUsage);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeParcelable((Parcelable)this.sdkTransactionId, flags);
            this.config.writeToParcel(out, flags);
            out.writeParcelable((Parcelable)this.stripeIntent, flags);
            this.nextActionData.writeToParcel(out, flags);
            out.writeParcelable((Parcelable)this.requestOptions, flags);
            out.writeInt(this.enableLogging ? 1 : 0);
            Object object = this.statusBarColor;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeInt(((Integer)object).intValue());
            }
            out.writeString(this.injectorKey);
            out.writeString(this.publishableKey);
            object = this.productUsage;
            out.writeInt(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                out.writeString((String)iterator.next());
            }
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Args> {
                @NotNull
                public final Args[] newArray(int size) {
                    return new Args[size];
                }

                @NotNull
                public final Args createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n);
                    String string2 = parcel.readString();
                    String string3 = parcel.readString();
                    Integer n2 = parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt());
                    boolean bl = parcel.readInt() != 0;
                    ApiRequest.Options options = (ApiRequest.Options)parcel.readParcelable(Args.class.getClassLoader());
                    StripeIntent.NextActionData.SdkData.Use3DS2 use3DS2 = (StripeIntent.NextActionData.SdkData.Use3DS2)StripeIntent.NextActionData.SdkData.Use3DS2.CREATOR.createFromParcel(parcel);
                    StripeIntent stripeIntent = (StripeIntent)parcel.readParcelable(Args.class.getClassLoader());
                    PaymentAuthConfig.Stripe3ds2Config stripe3ds2Config = (PaymentAuthConfig.Stripe3ds2Config)PaymentAuthConfig.Stripe3ds2Config.CREATOR.createFromParcel(parcel);
                    SdkTransactionId sdkTransactionId = (SdkTransactionId)parcel.readParcelable(Args.class.getClassLoader());
                    for (int i = 0; i != n; ++i) {
                        linkedHashSet.add(parcel.readString());
                    }
                    Set set = linkedHashSet;
                    String string4 = string2;
                    String string5 = string3;
                    Integer n3 = n2;
                    boolean bl2 = bl;
                    ApiRequest.Options options2 = options;
                    StripeIntent.NextActionData.SdkData.Use3DS2 use3DS22 = use3DS2;
                    StripeIntent stripeIntent2 = stripeIntent;
                    PaymentAuthConfig.Stripe3ds2Config stripe3ds2Config2 = stripe3ds2Config;
                    SdkTransactionId sdkTransactionId2 = sdkTransactionId;
                    return new Args(sdkTransactionId2, stripe3ds2Config2, stripeIntent2, use3DS22, options2, bl2, n3, string5, string4, set);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args$Companion;", "", "()V", "EXTRA_ARGS", "", "fromIntent", "Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "intent", "Landroid/content/Intent;", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Args fromIntent(@NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                return (Args)intent.getParcelableExtra(Args.EXTRA_ARGS);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

