/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.injection;

import android.content.Context;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLoggerFactory;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.ApiRequest_Options_Factory;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.SetupIntentFlowResultProcessor;
import com.stripe.android.payments.SetupIntentFlowResultProcessor_Factory;
import com.stripe.android.payments.core.authentication.PaymentAuthenticatorRegistry;
import com.stripe.android.payments.core.injection.PaymentLauncherComponent;
import com.stripe.android.payments.core.injection.PaymentLauncherModule;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideDefaultReturnUrlFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideIsInstantAppFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvidePaymentAuthenticatorRegistryFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelSubcomponent;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel_Factory_MembersInjector;
import dagger.Lazy;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerPaymentLauncherComponent {
    private DaggerPaymentLauncherComponent() {
    }

    public static PaymentLauncherComponent.Builder builder() {
        return new Builder();
    }

    private static final class PaymentLauncherComponentImpl
    implements PaymentLauncherComponent {
        private final StripeRepository stripeRepository;
        private final CoroutineContext ioContext;
        private final PaymentAnalyticsRequestFactory analyticsRequestFactory;
        private final CoroutineContext uiContext;
        private final Context context;
        private final PaymentLauncherModule paymentLauncherModule;
        private final PaymentLauncherComponentImpl paymentLauncherComponentImpl = this;
        private Provider<PaymentLauncherViewModelSubcomponent.Builder> paymentLauncherViewModelSubcomponentBuilderProvider;
        private Provider<Context> contextProvider;
        private Provider<StripeRepository> stripeRepositoryProvider;
        private Provider<Boolean> enableLoggingProvider;
        private Provider<CoroutineContext> ioContextProvider;
        private Provider<CoroutineContext> uiContextProvider;
        private Provider<Map<String, String>> provideThreeDs1IntentReturnUrlMapProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<PaymentAnalyticsRequestFactory> analyticsRequestFactoryProvider;
        private Provider<Function0<String>> publishableKeyProvider;
        private Provider<Set<String>> productUsageProvider;
        private Provider<Boolean> provideIsInstantAppProvider;
        private Provider<PaymentAuthenticatorRegistry> providePaymentAuthenticatorRegistryProvider;
        private Provider<DefaultReturnUrl> provideDefaultReturnUrlProvider;
        private Provider<Function0<String>> stripeAccountIdProvider;
        private Provider<PaymentIntentFlowResultProcessor> paymentIntentFlowResultProcessorProvider;
        private Provider<SetupIntentFlowResultProcessor> setupIntentFlowResultProcessorProvider;

        private PaymentLauncherComponentImpl(PaymentLauncherModule paymentLauncherModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Boolean enableLoggingParam, CoroutineContext ioContextParam, CoroutineContext uiContextParam, StripeRepository stripeRepositoryParam, PaymentAnalyticsRequestFactory analyticsRequestFactoryParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam) {
            this.stripeRepository = stripeRepositoryParam;
            this.ioContext = ioContextParam;
            this.analyticsRequestFactory = analyticsRequestFactoryParam;
            this.uiContext = uiContextParam;
            this.context = contextParam;
            this.paymentLauncherModule = paymentLauncherModuleParam;
            this.initialize(paymentLauncherModuleParam, coreCommonModuleParam, contextParam, enableLoggingParam, ioContextParam, uiContextParam, stripeRepositoryParam, analyticsRequestFactoryParam, publishableKeyProviderParam, stripeAccountIdProviderParam, productUsageParam);
        }

        private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
            return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), this.ioContext);
        }

        private boolean namedBoolean() {
            return this.paymentLauncherModule.provideIsInstantApp(this.context);
        }

        private void initialize(PaymentLauncherModule paymentLauncherModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Boolean enableLoggingParam, CoroutineContext ioContextParam, CoroutineContext uiContextParam, StripeRepository stripeRepositoryParam, PaymentAnalyticsRequestFactory analyticsRequestFactoryParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, Set<String> productUsageParam) {
            this.paymentLauncherViewModelSubcomponentBuilderProvider = new Provider<PaymentLauncherViewModelSubcomponent.Builder>(){

                public PaymentLauncherViewModelSubcomponent.Builder get() {
                    return new PaymentLauncherViewModelSubcomponentBuilder(paymentLauncherComponentImpl);
                }
            };
            this.contextProvider = InstanceFactory.create((Object)contextParam);
            this.stripeRepositoryProvider = InstanceFactory.create((Object)stripeRepositoryParam);
            this.enableLoggingProvider = InstanceFactory.create((Object)enableLoggingParam);
            this.ioContextProvider = InstanceFactory.create((Object)ioContextParam);
            this.uiContextProvider = InstanceFactory.create((Object)uiContextParam);
            this.provideThreeDs1IntentReturnUrlMapProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideThreeDs1IntentReturnUrlMapFactory.create(paymentLauncherModuleParam));
            this.provideLoggerProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLoggerFactory.create((CoreCommonModule)coreCommonModuleParam, this.enableLoggingProvider));
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.ioContextProvider);
            this.analyticsRequestFactoryProvider = InstanceFactory.create((Object)((Object)analyticsRequestFactoryParam));
            this.publishableKeyProvider = InstanceFactory.create(publishableKeyProviderParam);
            this.productUsageProvider = InstanceFactory.create(productUsageParam);
            this.provideIsInstantAppProvider = PaymentLauncherModule_ProvideIsInstantAppFactory.create(paymentLauncherModuleParam, this.contextProvider);
            this.providePaymentAuthenticatorRegistryProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvidePaymentAuthenticatorRegistryFactory.create(paymentLauncherModuleParam, this.contextProvider, this.stripeRepositoryProvider, this.enableLoggingProvider, this.ioContextProvider, this.uiContextProvider, this.provideThreeDs1IntentReturnUrlMapProvider, this.defaultAnalyticsRequestExecutorProvider, this.analyticsRequestFactoryProvider, this.publishableKeyProvider, this.productUsageProvider, this.provideIsInstantAppProvider));
            this.provideDefaultReturnUrlProvider = DoubleCheck.provider((Provider)PaymentLauncherModule_ProvideDefaultReturnUrlFactory.create(paymentLauncherModuleParam, this.contextProvider));
            this.stripeAccountIdProvider = InstanceFactory.create(stripeAccountIdProviderParam);
            this.paymentIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)PaymentIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider, this.stripeRepositoryProvider, this.provideLoggerProvider, this.ioContextProvider));
            this.setupIntentFlowResultProcessorProvider = DoubleCheck.provider((Provider)SetupIntentFlowResultProcessor_Factory.create(this.contextProvider, this.publishableKeyProvider, this.stripeRepositoryProvider, this.provideLoggerProvider, this.ioContextProvider));
        }

        @Override
        public void inject(PaymentLauncherViewModel.Factory factory) {
            this.injectFactory(factory);
        }

        private PaymentLauncherViewModel.Factory injectFactory(PaymentLauncherViewModel.Factory instance) {
            PaymentLauncherViewModel_Factory_MembersInjector.injectSubComponentBuilderProvider(instance, this.paymentLauncherViewModelSubcomponentBuilderProvider);
            return instance;
        }
    }

    private static final class PaymentLauncherViewModelSubcomponentImpl
    implements PaymentLauncherViewModelSubcomponent {
        private final Boolean isPaymentIntent;
        private final SavedStateHandle savedStateHandle;
        private final PaymentLauncherComponentImpl paymentLauncherComponentImpl;
        private final PaymentLauncherViewModelSubcomponentImpl paymentLauncherViewModelSubcomponentImpl = this;
        private Provider<ApiRequest.Options> optionsProvider;

        private PaymentLauncherViewModelSubcomponentImpl(PaymentLauncherComponentImpl paymentLauncherComponentImpl, Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam) {
            this.paymentLauncherComponentImpl = paymentLauncherComponentImpl;
            this.isPaymentIntent = isPaymentIntentParam;
            this.savedStateHandle = savedStateHandleParam;
            this.initialize(isPaymentIntentParam, savedStateHandleParam);
        }

        private void initialize(Boolean isPaymentIntentParam, SavedStateHandle savedStateHandleParam) {
            this.optionsProvider = ApiRequest_Options_Factory.create((Provider)this.paymentLauncherComponentImpl.publishableKeyProvider, (Provider)this.paymentLauncherComponentImpl.stripeAccountIdProvider);
        }

        @Override
        public PaymentLauncherViewModel getViewModel() {
            return new PaymentLauncherViewModel(this.isPaymentIntent, this.paymentLauncherComponentImpl.stripeRepository, (PaymentAuthenticatorRegistry)this.paymentLauncherComponentImpl.providePaymentAuthenticatorRegistryProvider.get(), (DefaultReturnUrl)this.paymentLauncherComponentImpl.provideDefaultReturnUrlProvider.get(), this.optionsProvider, (Map)this.paymentLauncherComponentImpl.provideThreeDs1IntentReturnUrlMapProvider.get(), (Lazy<PaymentIntentFlowResultProcessor>)DoubleCheck.lazy((Provider)this.paymentLauncherComponentImpl.paymentIntentFlowResultProcessorProvider), (Lazy<SetupIntentFlowResultProcessor>)DoubleCheck.lazy((Provider)this.paymentLauncherComponentImpl.setupIntentFlowResultProcessorProvider), this.paymentLauncherComponentImpl.defaultAnalyticsRequestExecutor(), this.paymentLauncherComponentImpl.analyticsRequestFactory, this.paymentLauncherComponentImpl.uiContext, this.savedStateHandle, this.paymentLauncherComponentImpl.namedBoolean());
        }
    }

    private static final class PaymentLauncherViewModelSubcomponentBuilder
    implements PaymentLauncherViewModelSubcomponent.Builder {
        private final PaymentLauncherComponentImpl paymentLauncherComponentImpl;
        private Boolean isPaymentIntent;
        private SavedStateHandle savedStateHandle;

        private PaymentLauncherViewModelSubcomponentBuilder(PaymentLauncherComponentImpl paymentLauncherComponentImpl) {
            this.paymentLauncherComponentImpl = paymentLauncherComponentImpl;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder isPaymentIntent(boolean isPaymentIntent) {
            this.isPaymentIntent = (Boolean)Preconditions.checkNotNull((Object)isPaymentIntent);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponentBuilder savedStateHandle(SavedStateHandle handle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)handle);
            return this;
        }

        @Override
        public PaymentLauncherViewModelSubcomponent build() {
            Preconditions.checkBuilderRequirement((Object)this.isPaymentIntent, Boolean.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            return new PaymentLauncherViewModelSubcomponentImpl(this.paymentLauncherComponentImpl, this.isPaymentIntent, this.savedStateHandle);
        }
    }

    private static final class Builder
    implements PaymentLauncherComponent.Builder {
        private Context context;
        private Boolean enableLogging;
        private CoroutineContext ioContext;
        private CoroutineContext uiContext;
        private StripeRepository stripeRepository;
        private PaymentAnalyticsRequestFactory analyticsRequestFactory;
        private Function0<String> publishableKeyProvider;
        private Function0<String> stripeAccountIdProvider;
        private Set<String> productUsage;

        private Builder() {
        }

        @Override
        public Builder context(Context context) {
            this.context = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder enableLogging(boolean enableLogging) {
            this.enableLogging = (Boolean)Preconditions.checkNotNull((Object)enableLogging);
            return this;
        }

        @Override
        public Builder ioContext(CoroutineContext workContext) {
            this.ioContext = (CoroutineContext)Preconditions.checkNotNull((Object)workContext);
            return this;
        }

        @Override
        public Builder uiContext(CoroutineContext uiContext) {
            this.uiContext = (CoroutineContext)Preconditions.checkNotNull((Object)uiContext);
            return this;
        }

        @Override
        public Builder stripeRepository(StripeRepository stripeRepository2) {
            this.stripeRepository = (StripeRepository)Preconditions.checkNotNull((Object)stripeRepository2);
            return this;
        }

        @Override
        public Builder analyticsRequestFactory(PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory) {
            this.analyticsRequestFactory = (PaymentAnalyticsRequestFactory)((Object)Preconditions.checkNotNull((Object)((Object)paymentAnalyticsRequestFactory)));
            return this;
        }

        @Override
        public Builder publishableKeyProvider(Function0<String> publishableKeyProvider) {
            this.publishableKeyProvider = (Function0)Preconditions.checkNotNull(publishableKeyProvider);
            return this;
        }

        @Override
        public Builder stripeAccountIdProvider(Function0<String> stripeAccountIdProvider) {
            this.stripeAccountIdProvider = (Function0)Preconditions.checkNotNull(stripeAccountIdProvider);
            return this;
        }

        @Override
        public Builder productUsage(Set<String> productUsage) {
            this.productUsage = (Set)Preconditions.checkNotNull(productUsage);
            return this;
        }

        @Override
        public PaymentLauncherComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.context, Context.class);
            Preconditions.checkBuilderRequirement((Object)this.enableLogging, Boolean.class);
            Preconditions.checkBuilderRequirement((Object)this.ioContext, CoroutineContext.class);
            Preconditions.checkBuilderRequirement((Object)this.uiContext, CoroutineContext.class);
            Preconditions.checkBuilderRequirement((Object)this.stripeRepository, StripeRepository.class);
            Preconditions.checkBuilderRequirement((Object)((Object)this.analyticsRequestFactory), PaymentAnalyticsRequestFactory.class);
            Preconditions.checkBuilderRequirement(this.publishableKeyProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.stripeAccountIdProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.productUsage, Set.class);
            return new PaymentLauncherComponentImpl(new PaymentLauncherModule(), new CoreCommonModule(), this.context, this.enableLogging, this.ioContext, this.uiContext, this.stripeRepository, this.analyticsRequestFactory, this.publishableKeyProvider, this.stripeAccountIdProvider, this.productUsage);
        }
    }
}

