/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.paymentlauncher;

import android.app.Application;
import android.content.Context;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.savedstate.SavedStateRegistryOwner;
import com.stripe.android.StripeIntentResult;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.injection.InjectWithFallbackKt;
import com.stripe.android.core.injection.Injectable;
import com.stripe.android.core.injection.UIContext;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.PaymentFlowResultProcessor;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor;
import com.stripe.android.payments.SetupIntentFlowResultProcessor;
import com.stripe.android.payments.core.authentication.PaymentAuthenticatorRegistry;
import com.stripe.android.payments.core.injection.DaggerPaymentLauncherViewModelFactoryComponent;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelSubcomponent;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherContract;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel;
import com.stripe.android.payments.paymentlauncher.PaymentResult;
import com.stripe.android.view.AuthActivityStarterHost;
import dagger.Lazy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 C2\u00020\u0001:\u0002CDB\u0093\u0001\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0001\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0001\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u001eJ\r\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J#\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u001d\u00100\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3J\u001d\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u000f2\u0006\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b6J\u0012\u00107\u001a\u00020(2\b\u0010.\u001a\u0004\u0018\u00010\u000fH\u0002J\u0015\u00108\u001a\u00020(2\u0006\u00109\u001a\u00020:H\u0001\u00a2\u0006\u0002\b;J\u0016\u0010<\u001a\u00020(2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020+0>H\u0002J\u0015\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0002\bBR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006E"}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "isPaymentIntent", "", "stripeApiRepository", "Lcom/stripe/android/networking/StripeRepository;", "authenticatorRegistry", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticatorRegistry;", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "apiRequestOptionsProvider", "Ljavax/inject/Provider;", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "threeDs1IntentReturnUrlMap", "", "", "lazyPaymentIntentFlowResultProcessor", "Ldagger/Lazy;", "Lcom/stripe/android/payments/PaymentIntentFlowResultProcessor;", "lazySetupIntentFlowResultProcessor", "Lcom/stripe/android/payments/SetupIntentFlowResultProcessor;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/DefaultAnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "uiContext", "Lkotlin/coroutines/CoroutineContext;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "isInstantApp", "(ZLcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/payments/core/authentication/PaymentAuthenticatorRegistry;Lcom/stripe/android/payments/DefaultReturnUrl;Ljavax/inject/Provider;Ljava/util/Map;Ldagger/Lazy;Ldagger/Lazy;Lcom/stripe/android/core/networking/DefaultAnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Lkotlin/coroutines/CoroutineContext;Landroidx/lifecycle/SavedStateHandle;Z)V", "hasStarted", "getHasStarted", "()Z", "paymentLauncherResult", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/payments/paymentlauncher/PaymentResult;", "getPaymentLauncherResult$payments_core_release", "()Landroidx/lifecycle/MutableLiveData;", "cleanUp", "", "cleanUp$payments_core_release", "confirmIntent", "Lcom/stripe/android/model/StripeIntent;", "confirmStripeIntentParams", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "returnUrl", "(Lcom/stripe/android/model/ConfirmStripeIntentParams;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmStripeIntent", "host", "Lcom/stripe/android/view/AuthActivityStarterHost;", "confirmStripeIntent$payments_core_release", "handleNextActionForStripeIntent", "clientSecret", "handleNextActionForStripeIntent$payments_core_release", "logReturnUrl", "onPaymentFlowResult", "paymentFlowResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "onPaymentFlowResult$payments_core_release", "postResult", "stripeIntentResult", "Lcom/stripe/android/StripeIntentResult;", "register", "caller", "Landroidx/activity/result/ActivityResultCaller;", "register$payments_core_release", "Companion", "Factory", "payments-core_release"})
public final class PaymentLauncherViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isPaymentIntent;
    @NotNull
    private final StripeRepository stripeApiRepository;
    @NotNull
    private final PaymentAuthenticatorRegistry authenticatorRegistry;
    @NotNull
    private final DefaultReturnUrl defaultReturnUrl;
    @NotNull
    private final Provider<ApiRequest.Options> apiRequestOptionsProvider;
    @NotNull
    private final Map<String, String> threeDs1IntentReturnUrlMap;
    @NotNull
    private final Lazy<PaymentIntentFlowResultProcessor> lazyPaymentIntentFlowResultProcessor;
    @NotNull
    private final Lazy<SetupIntentFlowResultProcessor> lazySetupIntentFlowResultProcessor;
    @NotNull
    private final DefaultAnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @NotNull
    private final CoroutineContext uiContext;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    private final boolean isInstantApp;
    @NotNull
    private final MutableLiveData<PaymentResult> paymentLauncherResult;
    @NotNull
    public static final String TIMEOUT_ERROR = "Payment fails due to time out. \n";
    @NotNull
    public static final String UNKNOWN_ERROR = "Payment fails due to unknown error. \n";
    @NotNull
    public static final String REQUIRED_ERROR = "API request returned an invalid response.";
    @NotNull
    private static final List<String> EXPAND_PAYMENT_METHOD = CollectionsKt.listOf((Object)"payment_method");
    @NotNull
    public static final String KEY_HAS_STARTED = "key_has_started";

    @Inject
    public PaymentLauncherViewModel(@Named(value="isPaymentIntent") boolean isPaymentIntent, @NotNull StripeRepository stripeApiRepository, @NotNull PaymentAuthenticatorRegistry authenticatorRegistry, @NotNull DefaultReturnUrl defaultReturnUrl, @NotNull Provider<ApiRequest.Options> apiRequestOptionsProvider, @NotNull Map<String, String> threeDs1IntentReturnUrlMap, @NotNull Lazy<PaymentIntentFlowResultProcessor> lazyPaymentIntentFlowResultProcessor, @NotNull Lazy<SetupIntentFlowResultProcessor> lazySetupIntentFlowResultProcessor, @NotNull DefaultAnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @UIContext @NotNull CoroutineContext uiContext, @NotNull SavedStateHandle savedStateHandle, @Named(value="isInstantApp") boolean isInstantApp) {
        Intrinsics.checkNotNullParameter((Object)stripeApiRepository, (String)"stripeApiRepository");
        Intrinsics.checkNotNullParameter((Object)authenticatorRegistry, (String)"authenticatorRegistry");
        Intrinsics.checkNotNullParameter((Object)defaultReturnUrl, (String)"defaultReturnUrl");
        Intrinsics.checkNotNullParameter(apiRequestOptionsProvider, (String)"apiRequestOptionsProvider");
        Intrinsics.checkNotNullParameter(threeDs1IntentReturnUrlMap, (String)"threeDs1IntentReturnUrlMap");
        Intrinsics.checkNotNullParameter(lazyPaymentIntentFlowResultProcessor, (String)"lazyPaymentIntentFlowResultProcessor");
        Intrinsics.checkNotNullParameter(lazySetupIntentFlowResultProcessor, (String)"lazySetupIntentFlowResultProcessor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentAnalyticsRequestFactory), (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.isPaymentIntent = isPaymentIntent;
        this.stripeApiRepository = stripeApiRepository;
        this.authenticatorRegistry = authenticatorRegistry;
        this.defaultReturnUrl = defaultReturnUrl;
        this.apiRequestOptionsProvider = apiRequestOptionsProvider;
        this.threeDs1IntentReturnUrlMap = threeDs1IntentReturnUrlMap;
        this.lazyPaymentIntentFlowResultProcessor = lazyPaymentIntentFlowResultProcessor;
        this.lazySetupIntentFlowResultProcessor = lazySetupIntentFlowResultProcessor;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.uiContext = uiContext;
        this.savedStateHandle = savedStateHandle;
        this.isInstantApp = isInstantApp;
        this.paymentLauncherResult = new MutableLiveData();
    }

    private final boolean getHasStarted() {
        Boolean bl = (Boolean)this.savedStateHandle.get(KEY_HAS_STARTED);
        return bl != null ? bl : false;
    }

    @NotNull
    public final MutableLiveData<PaymentResult> getPaymentLauncherResult$payments_core_release() {
        return this.paymentLauncherResult;
    }

    public final void register$payments_core_release(@NotNull ActivityResultCaller caller) {
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        this.authenticatorRegistry.onNewActivityResultCaller(caller, (ActivityResultCallback<PaymentFlowResult.Unvalidated>)((ActivityResultCallback)this::onPaymentFlowResult$payments_core_release));
    }

    public final void confirmStripeIntent$payments_core_release(@NotNull ConfirmStripeIntentParams confirmStripeIntentParams, @NotNull AuthActivityStarterHost host) {
        Intrinsics.checkNotNullParameter((Object)confirmStripeIntentParams, (String)"confirmStripeIntentParams");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.getHasStarted()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, confirmStripeIntentParams, host, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentLauncherViewModel this$0;
            final /* synthetic */ ConfirmStripeIntentParams $confirmStripeIntentParams;
            final /* synthetic */ AuthActivityStarterHost $host;
            {
                this.this$0 = $receiver;
                this.$confirmStripeIntentParams = $confirmStripeIntentParams;
                this.$host = $host;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block17: {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            PaymentLauncherViewModel.access$getSavedStateHandle$p(this.this$0).set("key_has_started", (Object)Boxing.boxBoolean((boolean)true));
                            PaymentLauncherViewModel.access$logReturnUrl(this.this$0, this.$confirmStripeIntentParams.getReturnUrl());
                            if (PaymentLauncherViewModel.access$isInstantApp$p(this.this$0)) {
                                v0 /* !! */  = this.$confirmStripeIntentParams.getReturnUrl();
                            } else {
                                it /* !! */  = var5_4 /* !! */  = this.$confirmStripeIntentParams.getReturnUrl();
                                $i$a$-takeUnless-PaymentLauncherViewModel$confirmStripeIntent$1$returnUrl$1 = false;
                                var8_8 = (CharSequence)it /* !! */ ;
                                v0 /* !! */  = (var8_8 == null || StringsKt.isBlank((CharSequence)var8_8)) == false ? var5_4 /* !! */  : null;
                                if (v0 /* !! */  == null) {
                                    v0 /* !! */  = PaymentLauncherViewModel.access$getDefaultReturnUrl$p(this.this$0).getValue();
                                }
                            }
                            returnUrl = v0 /* !! */ ;
                            var4_14 = $this$launch;
                            var5_4 /* !! */  = this.this$0;
                            var6_5 = this.$confirmStripeIntentParams;
                            $i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$1$1 = false;
                            this.L$0 = returnUrl;
                            this.label = 1;
                            v1 = PaymentLauncherViewModel.access$confirmIntent(var5_4 /* !! */ , (ConfirmStripeIntentParams)var6_5, returnUrl, (Continuation)this);
                            ** if (v1 != var14_2) goto lbl30
lbl29:
                            // 1 sources

                            return var14_2;
lbl30:
                            // 1 sources

                            ** GOTO lbl38
                        }
                        case 1: {
                            $i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$1$1 = false;
                            returnUrl = (String)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl38:
                                // 2 sources

                                var7_7 = Result.constructor-impl((Object)((StripeIntent)v1));
                            }
                            catch (Throwable $i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$1$1) {
                                var7_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$1$1));
                            }
                            var4_14 = var7_7;
                            var5_4 /* !! */  = this.this$0;
                            var6_5 = this.$host;
                            var7_7 = this.this$0;
                            v2 = Result.exceptionOrNull-impl((Object)var4_14);
                            if (v2 != null) break;
                            intent = (StripeIntent)var4_14;
                            $i$a$-fold-PaymentLauncherViewModel$confirmStripeIntent$1$2 = false;
                            v3 = intent.getNextActionData();
                            if (v3 != null) {
                                it = v3;
                                $i$a$-let-PaymentLauncherViewModel$confirmStripeIntent$1$2$1 = false;
                                if (it instanceof StripeIntent.NextActionData.SdkData.Use3DS1) {
                                    v4 = intent.getId();
                                    if (v4 != null) {
                                        intentId = v4;
                                        $i$a$-let-PaymentLauncherViewModel$confirmStripeIntent$1$2$1$1 = false;
                                        v5 = PaymentLauncherViewModel.access$getThreeDs1IntentReturnUrlMap$p(var5_4 /* !! */ );
                                        v6 = returnUrl;
                                        if (v6 == null) {
                                            v6 = "";
                                        }
                                        v5.put(intentId, v6);
                                    }
                                }
                            }
                            v7 = PaymentLauncherViewModel.access$getAuthenticatorRegistry$p(var5_4 /* !! */ ).getAuthenticator(intent);
                            v8 = PaymentLauncherViewModel.access$getApiRequestOptionsProvider$p(var5_4 /* !! */ ).get();
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"apiRequestOptionsProvider.get()");
                            this.L$0 = null;
                            this.label = 2;
                            v9 = v7.authenticate((AuthActivityStarterHost)var6_5, intent, (ApiRequest.Options)v8, (Continuation<Unit>)this);
                            if (v9 == var14_2) {
                                return var14_2;
                            }
                            break block17;
                        }
                        case 2: {
                            $i$a$-fold-PaymentLauncherViewModel$confirmStripeIntent$1$2 = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v9 = $result;
                            break block17;
                        }
                    }
                    it = v2;
                    $i$a$-fold-PaymentLauncherViewModel$confirmStripeIntent$1$3 = false;
                    var7_7.getPaymentLauncherResult$payments_core_release().postValue((Object)new PaymentResult.Failed(it));
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object confirmIntent(ConfirmStripeIntentParams var1_1, String var2_2, Continuation<? super StripeIntent> var3_3) {
        block10: {
            block11: {
                if (!(var3_3 instanceof confirmIntent.1)) ** GOTO lbl-1000
                var10_4 = var3_3;
                if ((var10_4.label & -2147483648) != 0) {
                    var10_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var3_3){
                        /* synthetic */ Object result;
                        final /* synthetic */ PaymentLauncherViewModel this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return PaymentLauncherViewModel.access$confirmIntent(this.this$0, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        it = var4_7 = confirmStripeIntentParams;
                        $i$a$-also-PaymentLauncherViewModel$confirmIntent$2 = false;
                        it.setReturnUrl((String)returnUrl);
                        decoratedParams = var4_7.withShouldUseStripeSdk(true);
                        $i$a$-let-PaymentLauncherViewModel$confirmIntent$3 = false;
                        var7_12 = decoratedParams;
                        if (!(var7_12 instanceof ConfirmPaymentIntentParams)) break;
                        v0 = (ConfirmPaymentIntentParams)decoratedParams;
                        var8_13 = this.apiRequestOptionsProvider.get();
                        Intrinsics.checkNotNullExpressionValue((Object)var8_13, (String)"apiRequestOptionsProvider.get()");
                        $continuation.label = 1;
                        v1 = this.stripeApiRepository.confirmPaymentIntent$payments_core_release(v0, (ApiRequest.Options)var8_13, PaymentLauncherViewModel.EXPAND_PAYMENT_METHOD, (Continuation<? super PaymentIntent>)$continuation);
                        if (v1 == var11_6) {
                            return var11_6;
                        }
                        ** GOTO lbl32
                    }
                    case 1: {
                        $i$a$-let-PaymentLauncherViewModel$confirmIntent$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        v2 = (StripeIntent)v1;
                        break block10;
                    }
                }
                if (!(var7_12 instanceof ConfirmSetupIntentParams)) break block11;
                v3 = (ConfirmSetupIntentParams)decoratedParams;
                var8_13 = this.apiRequestOptionsProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)var8_13, (String)"apiRequestOptionsProvider.get()");
                $continuation.label = 2;
                v4 = this.stripeApiRepository.confirmSetupIntent$payments_core_release(v3, (ApiRequest.Options)var8_13, PaymentLauncherViewModel.EXPAND_PAYMENT_METHOD, (Continuation<? super SetupIntent>)$continuation);
                if (v4 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl47
                {
                    case 2: {
                        $i$a$-let-PaymentLauncherViewModel$confirmIntent$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl47:
                        // 2 sources

                        v2 = (StripeIntent)v4;
                        break block10;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (v2 == null) {
            $i$a$-requireNotNull-PaymentLauncherViewModel$confirmIntent$3$1 = false;
            var8_15 = "API request returned an invalid response.";
            throw new IllegalArgumentException(var8_15.toString());
        }
        return v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void handleNextActionForStripeIntent$payments_core_release(@NotNull String clientSecret, @NotNull AuthActivityStarterHost host) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.getHasStarted()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, clientSecret, host, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentLauncherViewModel this$0;
            final /* synthetic */ String $clientSecret;
            final /* synthetic */ AuthActivityStarterHost $host;
            {
                this.this$0 = $receiver;
                this.$clientSecret = $clientSecret;
                this.$host = $host;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block11: {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            PaymentLauncherViewModel.access$getSavedStateHandle$p(this.this$0).set("key_has_started", (Object)Boxing.boxBoolean((boolean)true));
                            var3_4 = $this$launch;
                            var4_5 = this.this$0;
                            var5_6 = this.$clientSecret;
                            $i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$1$1 = false;
                            v0 = PaymentLauncherViewModel.access$getStripeApiRepository$p(var4_5);
                            v1 = PaymentLauncherViewModel.access$getApiRequestOptionsProvider$p(var4_5).get();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"apiRequestOptionsProvider.get()");
                            this.label = 1;
                            v2 = StripeRepository.retrieveStripeIntent$payments_core_release$default(v0, (String)var5_6, (ApiRequest.Options)v1, null, (Continuation)this, 4, null);
                            ** if (v2 != var10_2) goto lbl21
lbl20:
                            // 1 sources

                            return var10_2;
lbl21:
                            // 1 sources

                            ** GOTO lbl28
                        }
                        case 1: {
                            $i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$1$1 = false;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl28:
                                // 2 sources

                                if (v2 == null) {
                                    var9_11 = "Required value was null.";
                                    throw new IllegalArgumentException(var9_11.toString());
                                }
                                var6_12 = Result.constructor-impl((Object)((StripeIntent)v2));
                            }
                            catch (Throwable $i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$1$1) {
                                var6_12 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$1$1));
                            }
                            var3_4 = var6_12;
                            var4_5 = this.this$0;
                            var5_6 = this.$host;
                            var6_12 = this.this$0;
                            v3 = Result.exceptionOrNull-impl((Object)var3_4);
                            if (v3 != null) break;
                            intent = (StripeIntent)var3_4;
                            $i$a$-fold-PaymentLauncherViewModel$handleNextActionForStripeIntent$1$2 = false;
                            v4 = PaymentLauncherViewModel.access$getAuthenticatorRegistry$p(var4_5).getAuthenticator(intent);
                            v5 = PaymentLauncherViewModel.access$getApiRequestOptionsProvider$p(var4_5).get();
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"apiRequestOptionsProvider.get()");
                            this.label = 2;
                            v6 = v4.authenticate((AuthActivityStarterHost)var5_6, intent, (ApiRequest.Options)v5, (Continuation<Unit>)this);
                            if (v6 == var10_2) {
                                return var10_2;
                            }
                            break block11;
                        }
                        case 2: {
                            $i$a$-fold-PaymentLauncherViewModel$handleNextActionForStripeIntent$1$2 = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
                            break block11;
                        }
                    }
                    it = v3;
                    $i$a$-fold-PaymentLauncherViewModel$handleNextActionForStripeIntent$1$3 = false;
                    var6_12.getPaymentLauncherResult$payments_core_release().postValue((Object)new PaymentResult.Failed(it));
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @VisibleForTesting
    public final void onPaymentFlowResult$payments_core_release(@NotNull PaymentFlowResult.Unvalidated paymentFlowResult) {
        Intrinsics.checkNotNullParameter((Object)paymentFlowResult, (String)"paymentFlowResult");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentFlowResult, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentLauncherViewModel this$0;
            final /* synthetic */ PaymentFlowResult.Unvalidated $paymentFlowResult;
            {
                this.this$0 = $receiver;
                this.$paymentFlowResult = $paymentFlowResult;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                        var4_5 = this.this$0;
                        var5_6 /* !! */  = this.$paymentFlowResult;
                        $i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1 = false;
                        this.label = 1;
                        v0 = (PaymentLauncherViewModel.access$isPaymentIntent$p(var4_5) != false ? (PaymentFlowResultProcessor)PaymentLauncherViewModel.access$getLazyPaymentIntentFlowResultProcessor$p(var4_5).get() : (PaymentFlowResultProcessor)PaymentLauncherViewModel.access$getLazySetupIntentFlowResultProcessor$p(var4_5).get()).processResult(var5_6 /* !! */ , this);
                        ** if (v0 != var8_2) goto lbl16
lbl15:
                        // 1 sources

                        return var8_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            var6_11 = Result.constructor-impl((Object)((StripeIntentResult)v0));
                        }
                        catch (Throwable $i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1) {
                            var6_11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1));
                        }
                        var3_4 /* !! */  = var6_11;
                        var4_5 = this.this$0;
                        var5_6 /* !! */  = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v1 != null) break;
                        it = (StripeIntentResult)var3_4 /* !! */ ;
                        $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$2 = false;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)PaymentLauncherViewModel.access$getUiContext$p(var4_5), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var4_5, (StripeIntentResult<? extends StripeIntent>)it, null){
                            int label;
                            final /* synthetic */ PaymentLauncherViewModel this$0;
                            final /* synthetic */ StripeIntentResult<StripeIntent> $it;
                            {
                                this.this$0 = $receiver;
                                this.$it = $it;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        PaymentLauncherViewModel.access$postResult(this.this$0, this.$it);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl57
                    }
                    case 2: {
                        $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl57
                    }
                }
                it = v1;
                $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$3 = false;
                this.label = 3;
                v3 = BuildersKt.withContext((CoroutineContext)PaymentLauncherViewModel.access$getUiContext$p((PaymentLauncherViewModel)var5_6 /* !! */ ), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((PaymentLauncherViewModel)var5_6 /* !! */ , (Throwable)it, null){
                    int label;
                    final /* synthetic */ PaymentLauncherViewModel this$0;
                    final /* synthetic */ Throwable $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.getPaymentLauncherResult$payments_core_release().postValue((Object)new PaymentResult.Failed(this.$it));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)this);
                if (v3 == var8_2) {
                    return var8_2;
                }
                ** GOTO lbl57
                {
                    case 3: {
                        $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl57:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void cleanUp$payments_core_release() {
        this.authenticatorRegistry.onLauncherInvalidated();
    }

    private final void postResult(StripeIntentResult<? extends StripeIntent> stripeIntentResult) {
        PaymentResult paymentResult;
        switch (stripeIntentResult.getOutcome()) {
            case 1: {
                paymentResult = PaymentResult.Completed.INSTANCE;
                break;
            }
            case 2: {
                paymentResult = new PaymentResult.Failed((Throwable)new APIException(null, null, 0, stripeIntentResult.getFailureMessage(), null, 23, null));
                break;
            }
            case 3: {
                paymentResult = PaymentResult.Canceled.INSTANCE;
                break;
            }
            case 4: {
                paymentResult = new PaymentResult.Failed((Throwable)new APIException(null, null, 0, TIMEOUT_ERROR + stripeIntentResult.getFailureMessage(), null, 23, null));
                break;
            }
            default: {
                paymentResult = new PaymentResult.Failed((Throwable)new APIException(null, null, 0, UNKNOWN_ERROR + stripeIntentResult.getFailureMessage(), null, 23, null));
            }
        }
        this.paymentLauncherResult.postValue((Object)paymentResult);
    }

    private final void logReturnUrl(String returnUrl) {
        String string2 = returnUrl;
        PaymentAnalyticsEvent event = Intrinsics.areEqual((Object)string2, (Object)this.defaultReturnUrl.getValue()) ? PaymentAnalyticsEvent.ConfirmReturnUrlDefault : (string2 == null ? PaymentAnalyticsEvent.ConfirmReturnUrlNull : PaymentAnalyticsEvent.ConfirmReturnUrlCustom);
        boolean bl = false;
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(this.paymentAnalyticsRequestFactory, event, null, null, null, null, 30, null));
    }

    public static final /* synthetic */ SavedStateHandle access$getSavedStateHandle$p(PaymentLauncherViewModel $this) {
        return $this.savedStateHandle;
    }

    public static final /* synthetic */ void access$logReturnUrl(PaymentLauncherViewModel $this, String returnUrl) {
        $this.logReturnUrl(returnUrl);
    }

    public static final /* synthetic */ boolean access$isInstantApp$p(PaymentLauncherViewModel $this) {
        return $this.isInstantApp;
    }

    public static final /* synthetic */ DefaultReturnUrl access$getDefaultReturnUrl$p(PaymentLauncherViewModel $this) {
        return $this.defaultReturnUrl;
    }

    public static final /* synthetic */ Object access$confirmIntent(PaymentLauncherViewModel $this, ConfirmStripeIntentParams confirmStripeIntentParams, String returnUrl, Continuation $completion) {
        return $this.confirmIntent(confirmStripeIntentParams, returnUrl, (Continuation<? super StripeIntent>)$completion);
    }

    public static final /* synthetic */ Map access$getThreeDs1IntentReturnUrlMap$p(PaymentLauncherViewModel $this) {
        return $this.threeDs1IntentReturnUrlMap;
    }

    public static final /* synthetic */ PaymentAuthenticatorRegistry access$getAuthenticatorRegistry$p(PaymentLauncherViewModel $this) {
        return $this.authenticatorRegistry;
    }

    public static final /* synthetic */ Provider access$getApiRequestOptionsProvider$p(PaymentLauncherViewModel $this) {
        return $this.apiRequestOptionsProvider;
    }

    public static final /* synthetic */ StripeRepository access$getStripeApiRepository$p(PaymentLauncherViewModel $this) {
        return $this.stripeApiRepository;
    }

    public static final /* synthetic */ boolean access$isPaymentIntent$p(PaymentLauncherViewModel $this) {
        return $this.isPaymentIntent;
    }

    public static final /* synthetic */ Lazy access$getLazyPaymentIntentFlowResultProcessor$p(PaymentLauncherViewModel $this) {
        return $this.lazyPaymentIntentFlowResultProcessor;
    }

    public static final /* synthetic */ Lazy access$getLazySetupIntentFlowResultProcessor$p(PaymentLauncherViewModel $this) {
        return $this.lazySetupIntentFlowResultProcessor;
    }

    public static final /* synthetic */ CoroutineContext access$getUiContext$p(PaymentLauncherViewModel $this) {
        return $this.uiContext;
    }

    public static final /* synthetic */ void access$postResult(PaymentLauncherViewModel $this, StripeIntentResult stripeIntentResult) {
        $this.postResult(stripeIntentResult);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001 B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ7\u0010\u0013\u001a\u0002H\u0014\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Factory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "Lcom/stripe/android/core/injection/Injectable;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Factory$FallbackInitializeParam;", "argsSupplier", "Lkotlin/Function0;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherContract$Args;", "applicationSupplier", "Landroid/app/Application;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Landroidx/savedstate/SavedStateRegistryOwner;)V", "subComponentBuilderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/android/payments/core/injection/PaymentLauncherViewModelSubcomponent$Builder;", "getSubComponentBuilderProvider", "()Ljavax/inject/Provider;", "setSubComponentBuilderProvider", "(Ljavax/inject/Provider;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "fallbackInitialize", "", "arg", "FallbackInitializeParam", "payments-core_release"})
    public static final class Factory
    extends AbstractSavedStateViewModelFactory
    implements Injectable<FallbackInitializeParam> {
        @NotNull
        private final Function0<PaymentLauncherContract.Args> argsSupplier;
        @NotNull
        private final Function0<Application> applicationSupplier;
        @Inject
        public Provider<PaymentLauncherViewModelSubcomponent.Builder> subComponentBuilderProvider;

        public Factory(@NotNull Function0<? extends PaymentLauncherContract.Args> argsSupplier, @NotNull Function0<? extends Application> applicationSupplier, @NotNull SavedStateRegistryOwner owner) {
            Intrinsics.checkNotNullParameter(argsSupplier, (String)"argsSupplier");
            Intrinsics.checkNotNullParameter(applicationSupplier, (String)"applicationSupplier");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, null);
            this.argsSupplier = argsSupplier;
            this.applicationSupplier = applicationSupplier;
        }

        @NotNull
        public final Provider<PaymentLauncherViewModelSubcomponent.Builder> getSubComponentBuilderProvider() {
            Provider<PaymentLauncherViewModelSubcomponent.Builder> provider = this.subComponentBuilderProvider;
            if (provider != null) {
                return provider;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"subComponentBuilderProvider");
            return null;
        }

        public final void setSubComponentBuilderProvider(@NotNull Provider<PaymentLauncherViewModelSubcomponent.Builder> provider) {
            Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
            this.subComponentBuilderProvider = provider;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle handle) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            PaymentLauncherContract.Args arg = (PaymentLauncherContract.Args)this.argsSupplier.invoke();
            InjectWithFallbackKt.injectWithFallback((Injectable)this, (String)arg.getInjectorKey(), (Object)new FallbackInitializeParam((Application)this.applicationSupplier.invoke(), arg.getEnableLogging(), arg.getPublishableKey(), arg.getStripeAccountId(), arg.getProductUsage()));
            PaymentLauncherViewModelSubcomponent.Builder builder = (PaymentLauncherViewModelSubcomponent.Builder)this.getSubComponentBuilderProvider().get();
            PaymentLauncherContract.Args args2 = arg;
            if (args2 instanceof PaymentLauncherContract.Args.IntentConfirmationArgs) {
                ConfirmStripeIntentParams confirmStripeIntentParams = ((PaymentLauncherContract.Args.IntentConfirmationArgs)arg).getConfirmStripeIntentParams();
                if (confirmStripeIntentParams instanceof ConfirmPaymentIntentParams) {
                    bl = true;
                    return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).build().getViewModel());
                } else {
                    if (!(confirmStripeIntentParams instanceof ConfirmSetupIntentParams)) throw new NoWhenBranchMatchedException();
                    bl = false;
                }
                return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).build().getViewModel());
            } else if (args2 instanceof PaymentLauncherContract.Args.PaymentIntentNextActionArgs) {
                bl = true;
                return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).build().getViewModel());
            } else {
                if (!(args2 instanceof PaymentLauncherContract.Args.SetupIntentNextActionArgs)) throw new NoWhenBranchMatchedException();
                bl = false;
            }
            return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).build().getViewModel());
        }

        public void fallbackInitialize(@NotNull FallbackInitializeParam arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            DaggerPaymentLauncherViewModelFactoryComponent.builder().context((Context)arg.getApplication()).enableLogging(arg.getEnableLogging()).publishableKeyProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInitializeParam $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$arg.getPublishableKey();
                }
            })).stripeAccountIdProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInitializeParam $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    return this.$arg.getStripeAccountId();
                }
            })).productUsage(arg.getProductUsage()).build().inject(this);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u00c6\u0003JC\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Factory$FallbackInitializeParam;", "", "application", "Landroid/app/Application;", "enableLogging", "", "publishableKey", "", "stripeAccountId", "productUsage", "", "(Landroid/app/Application;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getApplication", "()Landroid/app/Application;", "getEnableLogging", "()Z", "getProductUsage", "()Ljava/util/Set;", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "payments-core_release"})
        public static final class FallbackInitializeParam {
            @NotNull
            private final Application application;
            private final boolean enableLogging;
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final Set<String> productUsage;

            public FallbackInitializeParam(@NotNull Application application, boolean enableLogging, @NotNull String publishableKey2, @Nullable String stripeAccountId2, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                this.application = application;
                this.enableLogging = enableLogging;
                this.publishableKey = publishableKey2;
                this.stripeAccountId = stripeAccountId2;
                this.productUsage = productUsage;
            }

            @NotNull
            public final Application getApplication() {
                return this.application;
            }

            public final boolean getEnableLogging() {
                return this.enableLogging;
            }

            @NotNull
            public final String getPublishableKey() {
                return this.publishableKey;
            }

            @Nullable
            public final String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> getProductUsage() {
                return this.productUsage;
            }

            @NotNull
            public final Application component1() {
                return this.application;
            }

            public final boolean component2() {
                return this.enableLogging;
            }

            @NotNull
            public final String component3() {
                return this.publishableKey;
            }

            @Nullable
            public final String component4() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> component5() {
                return this.productUsage;
            }

            @NotNull
            public final FallbackInitializeParam copy(@NotNull Application application, boolean enableLogging, @NotNull String publishableKey2, @Nullable String stripeAccountId2, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                return new FallbackInitializeParam(application, enableLogging, publishableKey2, stripeAccountId2, productUsage);
            }

            public static /* synthetic */ FallbackInitializeParam copy$default(FallbackInitializeParam fallbackInitializeParam, Application application, boolean bl, String string2, String string3, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    application = fallbackInitializeParam.application;
                }
                if ((n & 2) != 0) {
                    bl = fallbackInitializeParam.enableLogging;
                }
                if ((n & 4) != 0) {
                    string2 = fallbackInitializeParam.publishableKey;
                }
                if ((n & 8) != 0) {
                    string3 = fallbackInitializeParam.stripeAccountId;
                }
                if ((n & 0x10) != 0) {
                    set = fallbackInitializeParam.productUsage;
                }
                return fallbackInitializeParam.copy(application, bl, string2, string3, set);
            }

            @NotNull
            public String toString() {
                return "FallbackInitializeParam(application=" + this.application + ", enableLogging=" + this.enableLogging + ", publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", productUsage=" + this.productUsage + ')';
            }

            public int hashCode() {
                int result2 = this.application.hashCode();
                int n = this.enableLogging ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                result2 = result2 * 31 + this.publishableKey.hashCode();
                result2 = result2 * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result2 = result2 * 31 + ((Object)this.productUsage).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FallbackInitializeParam)) {
                    return false;
                }
                FallbackInitializeParam fallbackInitializeParam = (FallbackInitializeParam)other;
                if (!Intrinsics.areEqual((Object)this.application, (Object)fallbackInitializeParam.application)) {
                    return false;
                }
                if (this.enableLogging != fallbackInitializeParam.enableLogging) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)fallbackInitializeParam.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)fallbackInitializeParam.stripeAccountId)) {
                    return false;
                }
                return Intrinsics.areEqual(this.productUsage, fallbackInitializeParam.productUsage);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Companion;", "", "()V", "EXPAND_PAYMENT_METHOD", "", "", "getEXPAND_PAYMENT_METHOD", "()Ljava/util/List;", "KEY_HAS_STARTED", "getKEY_HAS_STARTED$payments_core_release$annotations", "REQUIRED_ERROR", "TIMEOUT_ERROR", "UNKNOWN_ERROR", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXPAND_PAYMENT_METHOD() {
            return EXPAND_PAYMENT_METHOD;
        }

        @VisibleForTesting
        public static /* synthetic */ void getKEY_HAS_STARTED$payments_core_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

