/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.text.ParcelableSpan;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.ThemeConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/view/CardDisplayTextFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "resources", "Landroid/content/res/Resources;", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "(Landroid/content/res/Resources;Lcom/stripe/android/view/ThemeConfig;)V", "createStyled", "Landroid/text/SpannableString;", "brand", "Lcom/stripe/android/model/CardBrand;", "last4", "", "isSelected", "", "createStyled$payments_core_release", "createUnstyled", "card", "Lcom/stripe/android/model/PaymentMethod$Card;", "createUnstyled$payments_core_release", "setSpan", "", "displayString", "span", "Landroid/text/ParcelableSpan;", "start", "", "end", "payments-core_release"})
public final class CardDisplayTextFactory {
    @NotNull
    private final Resources resources;
    @NotNull
    private final ThemeConfig themeConfig;

    public CardDisplayTextFactory(@NotNull Resources resources, @NotNull ThemeConfig themeConfig) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Intrinsics.checkNotNullParameter((Object)themeConfig, (String)"themeConfig");
        this.resources = resources;
        this.themeConfig = themeConfig;
    }

    public CardDisplayTextFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        this(resources, new ThemeConfig(context));
    }

    public final /* synthetic */ SpannableString createStyled$payments_core_release(CardBrand brand, String last4, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
        String brandText = brand.getDisplayName();
        int brandLength = brandText.length();
        CharSequence charSequence = last4;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            SpannableString displayString = new SpannableString((CharSequence)brandText);
            this.setSpan(displayString, (ParcelableSpan)new TypefaceSpan("sans-serif-medium"), 0, brandLength);
            return displayString;
        }
        Object[] objectArray = new Object[]{brandText, last4};
        String string2 = this.resources.getString(R.string.card_ending_in, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026ing_in, brandText, last4)");
        String cardEndingIn = string2;
        int totalLength = cardEndingIn.length();
        int last4Start = StringsKt.indexOf$default((CharSequence)cardEndingIn, (String)last4, (int)0, (boolean)false, (int)6, null);
        int last4End = last4Start + last4.length();
        int brandStart = StringsKt.indexOf$default((CharSequence)cardEndingIn, (String)brandText, (int)0, (boolean)false, (int)6, null);
        int brandEnd = brandStart + brandText.length();
        int textColor = this.themeConfig.getTextColor$payments_core_release(isSelected);
        int lightTextColor = this.themeConfig.getTextAlphaColor$payments_core_release(isSelected);
        SpannableString displayString = new SpannableString((CharSequence)cardEndingIn);
        this.setSpan(displayString, (ParcelableSpan)new ForegroundColorSpan(lightTextColor), 0, totalLength);
        this.setSpan(displayString, (ParcelableSpan)new TypefaceSpan("sans-serif-medium"), brandStart, brandEnd);
        this.setSpan(displayString, (ParcelableSpan)new ForegroundColorSpan(textColor), brandStart, brandEnd);
        this.setSpan(displayString, (ParcelableSpan)new TypefaceSpan("sans-serif-medium"), last4Start, last4End);
        this.setSpan(displayString, (ParcelableSpan)new ForegroundColorSpan(textColor), last4Start, last4End);
        return displayString;
    }

    public final /* synthetic */ String createUnstyled$payments_core_release(PaymentMethod.Card card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Object[] objectArray = new Object[]{card.brand.getDisplayName(), card.last4};
        String string2 = this.resources.getString(R.string.card_ending_in, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(\n   \u2026     card.last4\n        )");
        return string2;
    }

    private final void setSpan(SpannableString displayString, ParcelableSpan span, int start, int end) {
        displayString.setSpan((Object)span, start, end, 33);
    }
}

