/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.CardAccountRangeService;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.cards.DefaultStaticCardAccountRanges;
import com.stripe.android.cards.StaticCardAccountRanges;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.model.AccountRange;
import com.stripe.android.model.CardBrand;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.util.Collection;
import java.util.Set;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u00002\u00020\u0001:\u0001]B%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB7\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eBO\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J/\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u00072\b\b\u0002\u0010C\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bUJ\b\u0010V\u001a\u00020$H\u0014J\r\u0010W\u001a\u00020$H\u0000\u00a2\u0006\u0002\bXJ\b\u0010Y\u001a\u00020$H\u0014J\u0017\u0010Z\u001a\u00020$2\b\b\u0002\u0010[\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\\R\u0014\u0010\u0018\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010%\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010+\u001a\u00020#2\u0006\u0010*\u001a\u00020#8\u0006@@X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b,\u0010\u001e\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R \u00101\u001a\b\u0012\u0004\u0012\u00020$0\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001e\u0010;\u001a\u00020:2\u0006\u00109\u001a\u00020:@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R&\u0010=\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020$0\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010'\"\u0004\b?\u0010)R\u0014\u0010@\u001a\u00020:8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010<R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u00108R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u00020F8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0016\u0010I\u001a\u0004\u0018\u00010J8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u001c\u0010\t\u001a\u00020\n8\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010P\u00a8\u0006^"}, d2={"Lcom/stripe/android/view/CardNumberEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "workContext", "Lkotlin/coroutines/CoroutineContext;", "publishableKeySupplier", "Lkotlin/Function0;", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)V", "cardAccountRangeRepository", "Lcom/stripe/android/cards/CardAccountRangeRepository;", "staticCardAccountRanges", "Lcom/stripe/android/cards/StaticCardAccountRanges;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lcom/stripe/android/cards/CardAccountRangeRepository;Lcom/stripe/android/cards/StaticCardAccountRanges;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;)V", "accessibilityText", "getAccessibilityText", "()Ljava/lang/String;", "accountRangeService", "Lcom/stripe/android/cards/CardAccountRangeService;", "getAccountRangeService$annotations", "()V", "getAccountRangeService", "()Lcom/stripe/android/cards/CardAccountRangeService;", "callback", "Lkotlin/Function1;", "Lcom/stripe/android/model/CardBrand;", "", "brandChangeCallback", "getBrandChangeCallback$payments_core_release", "()Lkotlin/jvm/functions/Function1;", "setBrandChangeCallback$payments_core_release", "(Lkotlin/jvm/functions/Function1;)V", "value", "cardBrand", "getCardBrand$annotations", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "setCardBrand$payments_core_release", "(Lcom/stripe/android/model/CardBrand;)V", "completionCallback", "getCompletionCallback$payments_core_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$payments_core_release", "(Lkotlin/jvm/functions/Function0;)V", "formattedPanLength", "getFormattedPanLength", "()I", "<set-?>", "", "isCardNumberValid", "()Z", "isLoadingCallback", "isLoadingCallback$payments_core_release", "setLoadingCallback$payments_core_release", "isValid", "loadingJob", "Lkotlinx/coroutines/Job;", "panLength", "getPanLength$payments_core_release", "unvalidatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "getUnvalidatedCardNumber", "()Lcom/stripe/android/cards/CardNumber$Unvalidated;", "validatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Validated;", "getValidatedCardNumber$payments_core_release", "()Lcom/stripe/android/cards/CardNumber$Validated;", "getWorkContext", "()Lkotlin/coroutines/CoroutineContext;", "setWorkContext", "(Lkotlin/coroutines/CoroutineContext;)V", "calculateCursorPosition", "newFormattedLength", "start", "addedDigits", "calculateCursorPosition$payments_core_release", "onAttachedToWindow", "onCardMetadataLoadedTooSlow", "onCardMetadataLoadedTooSlow$payments_core_release", "onDetachedFromWindow", "updateLengthFilter", "maxLength", "updateLengthFilter$payments_core_release", "CardNumberTextWatcher", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class CardNumberEditText
extends StripeEditText {
    @NotNull
    private CoroutineContext workContext;
    @NotNull
    private final CardAccountRangeRepository cardAccountRangeRepository;
    @NotNull
    private final StaticCardAccountRanges staticCardAccountRanges;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @NotNull
    private CardBrand cardBrand;
    private /* synthetic */ Function1<? super CardBrand, Unit> brandChangeCallback;
    private /* synthetic */ Function0<Unit> completionCallback;
    private boolean isCardNumberValid;
    @NotNull
    private final CardAccountRangeService accountRangeService;
    private /* synthetic */ Function1<? super Boolean, Unit> isLoadingCallback;
    @Nullable
    private Job loadingJob;
    public static final int $stable = 8;

    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull CoroutineContext workContext, @NotNull CardAccountRangeRepository cardAccountRangeRepository2, @NotNull StaticCardAccountRanges staticCardAccountRanges, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)cardAccountRangeRepository2, (String)"cardAccountRangeRepository");
        Intrinsics.checkNotNullParameter((Object)staticCardAccountRanges, (String)"staticCardAccountRanges");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentAnalyticsRequestFactory), (String)"paymentAnalyticsRequestFactory");
        super(context, attrs, defStyleAttr);
        this.workContext = workContext;
        this.cardAccountRangeRepository = cardAccountRangeRepository2;
        this.staticCardAccountRanges = staticCardAccountRanges;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.cardBrand = CardBrand.Unknown;
        this.brandChangeCallback = brandChangeCallback.1.INSTANCE;
        this.completionCallback = completionCallback.1.INSTANCE;
        this.accountRangeService = new CardAccountRangeService(this.cardAccountRangeRepository, this.workContext, this.staticCardAccountRanges, new CardAccountRangeService.AccountRangeResultListener(this){
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAccountRangeResult(@Nullable AccountRange newAccountRange) {
                CardNumberEditText.updateLengthFilter$payments_core_release$default(this.this$0, 0, 1, null);
                AccountRange accountRange = newAccountRange;
                if (accountRange == null || (accountRange = accountRange.getBrand()) == null) {
                    accountRange = CardBrand.Unknown;
                }
                this.this$0.setCardBrand$payments_core_release((CardBrand)accountRange);
            }
        });
        this.isLoadingCallback = isLoadingCallback.1.INSTANCE;
        this.setNumberOnlyInputType();
        this.setErrorMessage(this.getResources().getString(R.string.invalid_card_number));
        this.addTextChangedListener(new CardNumberTextWatcher());
        this.getInternalFocusChangeListeners().add((arg_0, arg_1) -> CardNumberEditText._init_$lambda-1(this, arg_0, arg_1));
        if (Build.VERSION.SDK_INT >= 26) {
            String[] stringArray = new String[]{"creditCardNumber"};
            this.setAutofillHints(stringArray);
        }
        CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        this.setLayoutDirection(0);
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, CoroutineContext coroutineContext, CardAccountRangeRepository cardAccountRangeRepository2, StaticCardAccountRanges staticCardAccountRanges, AnalyticsRequestExecutor analyticsRequestExecutor, PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        if ((n2 & 0x20) != 0) {
            staticCardAccountRanges = new DefaultStaticCardAccountRanges();
        }
        this(context, attributeSet, n, coroutineContext, cardAccountRangeRepository2, staticCardAccountRanges, analyticsRequestExecutor, paymentAnalyticsRequestFactory);
    }

    @VisibleForTesting
    @NotNull
    public final CoroutineContext getWorkContext() {
        return this.workContext;
    }

    public final void setWorkContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"<set-?>");
        this.workContext = coroutineContext;
    }

    @JvmOverloads
    public CardNumberEditText(final @NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, (CoroutineContext)Dispatchers.getIO(), (Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return PaymentConfiguration.Companion.getInstance(context).getPublishableKey();
            }
        }));
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    private CardNumberEditText(Context context, AttributeSet attrs, int defStyleAttr, CoroutineContext workContext, Function0<String> publishableKeySupplier) {
        this(context, attrs, defStyleAttr, workContext, new DefaultCardAccountRangeRepositoryFactory(context).create(), new DefaultStaticCardAccountRanges(), (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor(), new PaymentAnalyticsRequestFactory(context, (Provider<String>)((Provider)() -> CardNumberEditText._init_$lambda-0(publishableKeySupplier))));
    }

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public final void setCardBrand$payments_core_release(@NotNull CardBrand value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CardBrand prevBrand = this.cardBrand;
        this.cardBrand = value;
        if (value != prevBrand) {
            this.brandChangeCallback.invoke((Object)this.cardBrand);
            CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        }
    }

    @VisibleForTesting
    public static /* synthetic */ void getCardBrand$annotations() {
    }

    @NotNull
    public final Function1<CardBrand, Unit> getBrandChangeCallback$payments_core_release() {
        return this.brandChangeCallback;
    }

    public final void setBrandChangeCallback$payments_core_release(@NotNull Function1<? super CardBrand, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.brandChangeCallback = callback;
        callback.invoke((Object)this.cardBrand);
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$payments_core_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$payments_core_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    public final int getPanLength$payments_core_release() {
        int n;
        AccountRange accountRange = this.accountRangeService.getAccountRange();
        if (accountRange != null) {
            n = accountRange.getPanLength();
        } else {
            AccountRange accountRange2 = this.accountRangeService.getStaticCardAccountRanges().first(this.getUnvalidatedCardNumber());
            n = accountRange2 != null ? accountRange2.getPanLength() : 16;
        }
        return n;
    }

    private final int getFormattedPanLength() {
        return this.getPanLength$payments_core_release() + CardNumber.Companion.getSpacePositions(this.getPanLength$payments_core_release()).size();
    }

    public final boolean isCardNumberValid() {
        return this.isCardNumberValid;
    }

    @Nullable
    public final CardNumber.Validated getValidatedCardNumber$payments_core_release() {
        return this.getUnvalidatedCardNumber().validate(this.getPanLength$payments_core_release());
    }

    private final CardNumber.Unvalidated getUnvalidatedCardNumber() {
        return new CardNumber.Unvalidated(this.getFieldText$payments_core_release());
    }

    private final boolean isValid() {
        return this.getValidatedCardNumber$payments_core_release() != null;
    }

    @NotNull
    public final CardAccountRangeService getAccountRangeService() {
        return this.accountRangeService;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAccountRangeService$annotations() {
    }

    @NotNull
    public final Function1<Boolean, Unit> isLoadingCallback$payments_core_release() {
        return this.isLoadingCallback;
    }

    public final void setLoadingCallback$payments_core_release(@NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.isLoadingCallback = function1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.loadingJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CardNumberEditText.access$getCardAccountRangeRepository$p(this.this$0).getLoading().collect((FlowCollector)new FlowCollector<Boolean>(this.this$0){
                            final /* synthetic */ CardNumberEditText this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(boolean it, @NotNull Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                                    int label;
                                    final /* synthetic */ CardNumberEditText this$0;
                                    final /* synthetic */ boolean $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.this$0.isLoadingCallback$payments_core_release().invoke((Object)Boxing.boxBoolean((boolean)this.$it));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    protected String getAccessibilityText() {
        Object[] objectArray = new Object[]{this.getText()};
        String string2 = this.getResources().getString(R.string.acc_label_card_number_node, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026l_card_number_node, text)");
        return string2;
    }

    protected void onDetachedFromWindow() {
        Job job = this.loadingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.loadingJob = null;
        this.accountRangeService.cancelAccountRangeRepositoryJob();
        super.onDetachedFromWindow();
    }

    public final /* synthetic */ void updateLengthFilter$payments_core_release(int maxLength) {
        InputFilter[] inputFilterArray = new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(maxLength)};
        this.setFilters(inputFilterArray);
    }

    public static /* synthetic */ void updateLengthFilter$payments_core_release$default(CardNumberEditText cardNumberEditText, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = cardNumberEditText.getFormattedPanLength();
        }
        cardNumberEditText.updateLengthFilter$payments_core_release(n);
    }

    public final /* synthetic */ int calculateCursorPosition$payments_core_release(int newFormattedLength, int start, int addedDigits, int panLength) {
        boolean bl;
        int gapsJumped;
        block7: {
            int gap;
            int n;
            Set gapSet = CardNumber.Companion.getSpacePositions(panLength);
            Iterable $this$count$iv = gapSet;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!(start <= gap && start + addedDigits >= gap) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            gapsJumped = n;
            Iterable $this$any$iv = gapSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (!(addedDigits == 0 && start == gap + 1)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean skipBack = bl;
        int newPosition = start + addedDigits + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newFormattedLength ? newPosition : newFormattedLength;
    }

    public static /* synthetic */ int calculateCursorPosition$payments_core_release$default(CardNumberEditText cardNumberEditText, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = cardNumberEditText.getPanLength$payments_core_release();
        }
        return cardNumberEditText.calculateCursorPosition$payments_core_release(n, n2, n3, n4);
    }

    public final /* synthetic */ void onCardMetadataLoadedTooSlow$payments_core_release() {
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(this.paymentAnalyticsRequestFactory, PaymentAnalyticsEvent.CardMetadataLoadedTooSlow, null, null, null, null, 30, null));
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final String _init_$lambda-0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke();
    }

    private static final void _init_$lambda-1(CardNumberEditText this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!hasFocus && this$0.getUnvalidatedCardNumber().isPartialEntry(this$0.getPanLength$payments_core_release())) {
            this$0.setShouldShowError(true);
        }
    }

    public static final /* synthetic */ CardAccountRangeRepository access$getCardAccountRangeRepository$p(CardNumberEditText $this) {
        return $this.cardAccountRangeRepository;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J(\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0004H\u0002J*\u0010\"\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\u00a8\u0006$"}, d2={"Lcom/stripe/android/view/CardNumberEditText$CardNumberTextWatcher;", "Lcom/stripe/android/view/StripeTextWatcher;", "(Lcom/stripe/android/view/CardNumberEditText;)V", "beforeCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "digitsAdded", "", "getDigitsAdded", "()Z", "formattedNumber", "", "isPastedPan", "latestChangeStart", "", "latestInsertionSize", "newCursorPosition", "Ljava/lang/Integer;", "shouldUpdateAfterChange", "getShouldUpdateAfterChange", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "isComplete", "wasCardNumberValid", "startPosition", "previousCount", "currentCount", "cardNumber", "onTextChanged", "before", "payments-core_release"})
    private final class CardNumberTextWatcher
    extends StripeTextWatcher {
        private int latestChangeStart;
        private int latestInsertionSize;
        @Nullable
        private Integer newCursorPosition;
        @Nullable
        private String formattedNumber;
        @NotNull
        private CardNumber.Unvalidated beforeCardNumber;
        private boolean isPastedPan;

        public CardNumberTextWatcher() {
            this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
        }

        @Override
        public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            this.isPastedPan = false;
            this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
            this.latestChangeStart = start;
            this.latestInsertionSize = after;
        }

        @Override
        public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
            CharSequence charSequence = s;
            String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
            if (string2 == null) {
                string2 = "";
            }
            CardNumber.Unvalidated cardNumber = new CardNumber.Unvalidated(string2);
            CardNumberEditText.this.getAccountRangeService().onCardNumberChanged(cardNumber);
            this.isPastedPan = this.isPastedPan(start, before, count, cardNumber);
            if (this.isPastedPan) {
                CardNumberEditText.this.updateLengthFilter$payments_core_release(cardNumber.getFormatted(cardNumber.getLength()).length());
            }
            int n = this.isPastedPan ? cardNumber.getLength() : CardNumberEditText.this.getPanLength$payments_core_release();
            CardNumberEditText cardNumberEditText = CardNumberEditText.this;
            int maxPanLength = n;
            boolean bl = false;
            String formattedNumber = cardNumber.getFormatted(maxPanLength);
            this.newCursorPosition = cardNumberEditText.calculateCursorPosition$payments_core_release(formattedNumber.length(), this.latestChangeStart, this.latestInsertionSize, maxPanLength);
            this.formattedNumber = formattedNumber;
        }

        @Override
        public void afterTextChanged(@Nullable Editable s) {
            if (this.getShouldUpdateAfterChange()) {
                CardNumberEditText.this.setTextSilent$payments_core_release(this.formattedNumber);
                Integer n = this.newCursorPosition;
                if (n != null) {
                    Integer n2 = n;
                    CardNumberEditText cardNumberEditText = CardNumberEditText.this;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    cardNumberEditText.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)cardNumberEditText.getFieldText$payments_core_release().length()));
                }
            }
            this.formattedNumber = null;
            this.newCursorPosition = null;
            if (CardNumberEditText.this.getUnvalidatedCardNumber().getLength() == CardNumberEditText.this.getPanLength$payments_core_release()) {
                boolean wasCardNumberValid = CardNumberEditText.this.isCardNumberValid();
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(!CardNumberEditText.this.isValid());
                if (CardNumberEditText.this.getAccountRangeService().getAccountRange() == null && CardNumberEditText.this.getUnvalidatedCardNumber().isValidLuhn()) {
                    CardNumberEditText.this.onCardMetadataLoadedTooSlow$payments_core_release();
                }
                if (this.isComplete(wasCardNumberValid)) {
                    CardNumberEditText.this.getCompletionCallback$payments_core_release().invoke();
                }
            } else if (CardNumberEditText.this.getUnvalidatedCardNumber().isPartialEntry(CardNumberEditText.this.getPanLength$payments_core_release()) && !CardNumberEditText.this.getUnvalidatedCardNumber().isPossibleCardBrand()) {
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(true);
            } else {
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(false);
            }
        }

        private final boolean getShouldUpdateAfterChange() {
            return (this.getDigitsAdded() || !CardNumberEditText.this.isLastKeyDelete()) && this.formattedNumber != null;
        }

        private final boolean getDigitsAdded() {
            return CardNumberEditText.this.getUnvalidatedCardNumber().getLength() > this.beforeCardNumber.getLength();
        }

        private final boolean isComplete(boolean wasCardNumberValid) {
            return !wasCardNumberValid && (CardNumberEditText.this.getUnvalidatedCardNumber().isMaxLength() || CardNumberEditText.this.isValid() && CardNumberEditText.this.getAccountRangeService().getAccountRange() != null);
        }

        private final boolean isPastedPan(int startPosition, int previousCount, int currentCount, CardNumber.Unvalidated cardNumber) {
            return currentCount > previousCount && startPosition == 0 && cardNumber.getNormalized().length() >= 14;
        }
    }
}

