/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import com.stripe.android.R;
import com.stripe.android.databinding.MaskedCardViewBinding;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.ThemeConfig;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001bH\u0002J\b\u0010%\u001a\u00020\u001bH\u0002J\b\u0010&\u001a\u00020\u001bH\u0002R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u00108G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/stripe/android/view/MaskedCardView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "Lcom/stripe/android/model/CardBrand;", "cardBrand", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "cardDisplayFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "", "last4", "getLast4", "()Ljava/lang/String;", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "viewBinding", "Lcom/stripe/android/databinding/MaskedCardViewBinding;", "getViewBinding$payments_core_release", "()Lcom/stripe/android/databinding/MaskedCardViewBinding;", "applyTint", "", "imageView", "Landroid/widget/ImageView;", "setPaymentMethod", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "", "updateBrandIcon", "updateCheckMark", "updateUi", "payments-core_release"})
public final class MaskedCardView
extends LinearLayout {
    @NotNull
    private CardBrand cardBrand;
    @Nullable
    private String last4;
    @NotNull
    private final MaskedCardViewBinding viewBinding;
    @NotNull
    private final ThemeConfig themeConfig;
    @NotNull
    private final CardDisplayTextFactory cardDisplayFactory;

    @JvmOverloads
    public MaskedCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.cardBrand = CardBrand.Unknown;
        MaskedCardViewBinding maskedCardViewBinding = MaskedCardViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)maskedCardViewBinding, (String)"inflate(\n        LayoutI\u2026text),\n        this\n    )");
        this.viewBinding = maskedCardViewBinding;
        this.themeConfig = new ThemeConfig(context);
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        this.cardDisplayFactory = new CardDisplayTextFactory(resources, this.themeConfig);
        AppCompatImageView appCompatImageView = this.viewBinding.brandIcon;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"viewBinding.brandIcon");
        this.applyTint((ImageView)appCompatImageView);
        AppCompatImageView appCompatImageView2 = this.viewBinding.checkIcon;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView2, (String)"viewBinding.checkIcon");
        this.applyTint((ImageView)appCompatImageView2);
    }

    public /* synthetic */ MaskedCardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    @VisibleForTesting
    @Nullable
    public final String getLast4() {
        return this.last4;
    }

    @NotNull
    public final MaskedCardViewBinding getViewBinding$payments_core_release() {
        return this.viewBinding;
    }

    private final void applyTint(ImageView imageView) {
        ImageViewCompat.setImageTintList((ImageView)imageView, (ColorStateList)ColorStateList.valueOf((int)this.themeConfig.getTintColor$payments_core_release(true)));
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateCheckMark();
        this.updateUi();
    }

    public final void setPaymentMethod(@NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        PaymentMethod.Card card = paymentMethod.card;
        if (card == null || (card = card.brand) == null) {
            card = CardBrand.Unknown;
        }
        this.cardBrand = card;
        PaymentMethod.Card card2 = paymentMethod.card;
        this.last4 = card2 != null ? card2.last4 : null;
        this.updateUi();
    }

    private final void updateUi() {
        this.updateBrandIcon();
        this.viewBinding.details.setText((CharSequence)this.cardDisplayFactory.createStyled$payments_core_release(this.cardBrand, this.last4, this.isSelected()));
    }

    private final void updateBrandIcon() {
        int n;
        AppCompatImageView appCompatImageView = this.viewBinding.brandIcon;
        Context context = this.getContext();
        switch (WhenMappings.$EnumSwitchMapping$0[this.cardBrand.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_amex_template_32;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_discover_template_32;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_jcb_template_32;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_diners_template_32;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_visa_template_32;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_mastercard_template_32;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_unionpay_template_32;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_unknown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)n));
    }

    private final void updateCheckMark() {
        this.viewBinding.checkIcon.setVisibility(this.isSelected() ? 0 : 4);
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CardBrand.values().length];
            nArray[CardBrand.AmericanExpress.ordinal()] = 1;
            nArray[CardBrand.Discover.ordinal()] = 2;
            nArray[CardBrand.JCB.ordinal()] = 3;
            nArray[CardBrand.DinersClub.ordinal()] = 4;
            nArray[CardBrand.Visa.ordinal()] = 5;
            nArray[CardBrand.MasterCard.ordinal()] = 6;
            nArray[CardBrand.UnionPay.ordinal()] = 7;
            nArray[CardBrand.Unknown.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

