/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.ApiKeyValidator;
import com.stripe.android.core.ApiVersion;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/GooglePayConfig;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "paymentConfiguration", "Lcom/stripe/android/PaymentConfiguration;", "(Lcom/stripe/android/PaymentConfiguration;)V", "publishableKey", "", "connectedAccountId", "(Ljava/lang/String;Ljava/lang/String;)V", "apiVersion", "key", "getKey", "()Ljava/lang/String;", "tokenizationSpecification", "Lorg/json/JSONObject;", "getTokenizationSpecification", "()Lorg/json/JSONObject;", "validPublishableKey", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class GooglePayConfig {
    @Nullable
    private final String connectedAccountId;
    @NotNull
    private final String validPublishableKey;
    @NotNull
    private final String apiVersion;
    public static final int $stable;

    @JvmOverloads
    public GooglePayConfig(@NotNull String publishableKey2, @Nullable String connectedAccountId) {
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        this.connectedAccountId = connectedAccountId;
        this.validPublishableKey = ApiKeyValidator.Companion.get().requireValid(publishableKey2);
        this.apiVersion = ApiVersion.Companion.get().getCode();
    }

    public /* synthetic */ GooglePayConfig(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final JSONObject getTokenizationSpecification() throws JSONException {
        JSONObject jSONObject = new JSONObject().put("type", (Object)"PAYMENT_GATEWAY").put("parameters", (Object)new JSONObject().put("gateway", (Object)"stripe").put("stripe:version", (Object)this.apiVersion).put("stripe:publishableKey", (Object)this.getKey()));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"JSONObject()\n           \u2026eKey\", key)\n            )");
        return jSONObject;
    }

    private final String getKey() {
        String string;
        String string2 = this.connectedAccountId;
        if (string2 == null) {
            string = null;
        } else {
            String it = string2;
            boolean bl = false;
            string = this.validPublishableKey + '/' + it;
        }
        String string3 = string;
        if (string == null) {
            string3 = this.validPublishableKey;
        }
        return string3;
    }

    public GooglePayConfig(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(PaymentConfiguration.Companion.getInstance(context));
    }

    private GooglePayConfig(PaymentConfiguration paymentConfiguration) {
        this(paymentConfiguration.getPublishableKey(), paymentConfiguration.getStripeAccountId());
    }

    @JvmOverloads
    public GooglePayConfig(@NotNull String publishableKey2) {
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        this(publishableKey2, null, 2, null);
    }
}

