/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.cards;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.CardAccountRangeSource;
import com.stripe.android.cards.CardAccountRangeStore;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.cards.DefaultCardAccountRangeRepository;
import com.stripe.android.cards.DefaultCardAccountRangeStore;
import com.stripe.android.cards.InMemoryCardAccountRangeSource;
import com.stripe.android.cards.RemoteCardAccountRangeSource;
import com.stripe.android.cards.StaticCardAccountRangeSource;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.model.AccountRange;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeRepositoryFactory;", "Lcom/stripe/android/cards/CardAccountRangeRepository$Factory;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "(Landroid/content/Context;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;)V", "appContext", "kotlin.jvm.PlatformType", "create", "Lcom/stripe/android/cards/CardAccountRangeRepository;", "createRemoteCardAccountRangeSource", "Lcom/stripe/android/cards/CardAccountRangeSource;", "fireAnalyticsEvent", "", "publishableKey", "", "event", "Lcom/stripe/android/networking/PaymentAnalyticsEvent;", "NullCardAccountRangeSource", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class DefaultCardAccountRangeRepositoryFactory
implements CardAccountRangeRepository.Factory {
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final Context appContext;
    public static final int $stable = 8;

    public DefaultCardAccountRangeRepositoryFactory(@NotNull Context context, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.appContext = context.getApplicationContext();
    }

    public DefaultCardAccountRangeRepositoryFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor());
    }

    @Override
    @NotNull
    public CardAccountRangeRepository create() throws IllegalStateException {
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        DefaultCardAccountRangeStore store = new DefaultCardAccountRangeStore(context);
        return new DefaultCardAccountRangeRepository(new InMemoryCardAccountRangeSource(store), this.createRemoteCardAccountRangeSource(), new StaticCardAccountRangeSource(null, 1, null), store);
    }

    private final CardAccountRangeSource createRemoteCardAccountRangeSource() {
        CardAccountRangeSource cardAccountRangeSource;
        Object object;
        Context context;
        Object object2 = this;
        try {
            DefaultCardAccountRangeRepositoryFactory $this$createRemoteCardAccountRangeSource_u24lambda_u2d0 = object2;
            boolean bl = false;
            context = $this$createRemoteCardAccountRangeSource_u24lambda_u2d0.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            object = Result.constructor-impl((Object)PaymentConfiguration.Companion.getInstance(context).getPublishableKey());
        }
        catch (Throwable $this$createRemoteCardAccountRangeSource_u24lambda_u2d0) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$createRemoteCardAccountRangeSource_u24lambda_u2d0));
        }
        object2 = object;
        if (Result.isSuccess-impl((Object)object2)) {
            String publishableKey2 = (String)object2;
            boolean bl = false;
            this.fireAnalyticsEvent(publishableKey2, PaymentAnalyticsEvent.CardMetadataPublishableKeyAvailable);
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.fireAnalyticsEvent("pk_undefined", PaymentAnalyticsEvent.CardMetadataPublishableKeyUnavailable);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            String publishableKey3 = (String)object2;
            boolean bl = false;
            context = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            StripeRepository stripeRepository2 = new StripeApiRepository(context, (Function0)new Function0<String>(publishableKey3){
                final /* synthetic */ String $publishableKey;
                {
                    this.$publishableKey = $publishableKey;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$publishableKey;
                }
            }, null, null, null, null, null, null, null, null, null, null, null, null, 16380, null);
            ApiRequest.Options options = new ApiRequest.Options(publishableKey3, null, null, 6, null);
            context = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            CardAccountRangeStore cardAccountRangeStore = new DefaultCardAccountRangeStore(context);
            AnalyticsRequestExecutor analyticsRequestExecutor = (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor();
            context = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            cardAccountRangeSource = new RemoteCardAccountRangeSource(stripeRepository2, options, cardAccountRangeStore, analyticsRequestExecutor, new PaymentAnalyticsRequestFactory(context, publishableKey3, null, 4, null));
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            cardAccountRangeSource = new NullCardAccountRangeSource();
        }
        return cardAccountRangeSource;
    }

    private final void fireAnalyticsEvent(String publishableKey2, PaymentAnalyticsEvent event) {
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(new PaymentAnalyticsRequestFactory(context, publishableKey2, null, 4, null), event, null, null, null, null, 30, null));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeRepositoryFactory$NullCardAccountRangeSource;", "Lcom/stripe/android/cards/CardAccountRangeSource;", "()V", "loading", "Lkotlinx/coroutines/flow/Flow;", "", "getLoading", "()Lkotlinx/coroutines/flow/Flow;", "getAccountRange", "Lcom/stripe/android/model/AccountRange;", "cardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "(Lcom/stripe/android/cards/CardNumber$Unvalidated;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "payments-core_release"})
    private static final class NullCardAccountRangeSource
    implements CardAccountRangeSource {
        @NotNull
        private final Flow<Boolean> loading = FlowKt.flowOf((Object)false);

        @Override
        @Nullable
        public Object getAccountRange(@NotNull CardNumber.Unvalidated cardNumber, @NotNull Continuation<? super AccountRange> $completion) {
            return null;
        }

        @Override
        @NotNull
        public Flow<Boolean> getLoading() {
            return this.loading;
        }
    }
}

