/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Size;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeModel;
import java.io.Serializable;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B5\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tB3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006("}, d2={"Lcom/stripe/android/model/ShippingMethod;", "Lcom/stripe/android/core/model/StripeModel;", "label", "", "identifier", "amount", "", "currencyCode", "detail", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;)V", "currency", "Ljava/util/Currency;", "(Ljava/lang/String;Ljava/lang/String;JLjava/util/Currency;Ljava/lang/String;)V", "getAmount", "()J", "getCurrency", "()Ljava/util/Currency;", "getDetail", "()Ljava/lang/String;", "getIdentifier", "getLabel", "component1", "component2", "component3", "component4", "component5", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class ShippingMethod
implements StripeModel {
    @NotNull
    private final String label;
    @NotNull
    private final String identifier;
    private final long amount;
    @NotNull
    private final Currency currency;
    @Nullable
    private final String detail;
    @NotNull
    public static final Parcelable.Creator<ShippingMethod> CREATOR;
    public static final int $stable;

    @JvmOverloads
    public ShippingMethod(@NotNull String label, @NotNull String identifier, long amount, @NotNull Currency currency, @Nullable String detail) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        this.label = label;
        this.identifier = identifier;
        this.amount = amount;
        this.currency = currency;
        this.detail = detail;
    }

    public /* synthetic */ ShippingMethod(String string, String string2, long l, Currency currency, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        this(string, string2, l, currency, string3);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    public final long getAmount() {
        return this.amount;
    }

    @NotNull
    public final Currency getCurrency() {
        return this.currency;
    }

    @Nullable
    public final String getDetail() {
        return this.detail;
    }

    @JvmOverloads
    public ShippingMethod(@NotNull String label, @NotNull String identifier, long amount, @Size(min=0L, max=3L) @NotNull String currencyCode, @Nullable String detail) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        Currency currency = Currency.getInstance(currencyCode);
        Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(currencyCode)");
        this(label, identifier, amount, currency, detail);
    }

    public /* synthetic */ ShippingMethod(String string, String string2, long l, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        this(string, string2, l, string3, string4);
    }

    @NotNull
    public final String component1() {
        return this.label;
    }

    @NotNull
    public final String component2() {
        return this.identifier;
    }

    public final long component3() {
        return this.amount;
    }

    @NotNull
    public final Currency component4() {
        return this.currency;
    }

    @Nullable
    public final String component5() {
        return this.detail;
    }

    @NotNull
    public final ShippingMethod copy(@NotNull String label, @NotNull String identifier, long amount, @NotNull Currency currency, @Nullable String detail) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return new ShippingMethod(label, identifier, amount, currency, detail);
    }

    public static /* synthetic */ ShippingMethod copy$default(ShippingMethod shippingMethod, String string, String string2, long l, Currency currency, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = shippingMethod.label;
        }
        if ((n & 2) != 0) {
            string2 = shippingMethod.identifier;
        }
        if ((n & 4) != 0) {
            l = shippingMethod.amount;
        }
        if ((n & 8) != 0) {
            currency = shippingMethod.currency;
        }
        if ((n & 0x10) != 0) {
            string3 = shippingMethod.detail;
        }
        return shippingMethod.copy(string, string2, l, currency, string3);
    }

    @NotNull
    public String toString() {
        return "ShippingMethod(label=" + this.label + ", identifier=" + this.identifier + ", amount=" + this.amount + ", currency=" + this.currency + ", detail=" + this.detail + ')';
    }

    public int hashCode() {
        int result2 = this.label.hashCode();
        result2 = result2 * 31 + this.identifier.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.amount);
        result2 = result2 * 31 + this.currency.hashCode();
        result2 = result2 * 31 + (this.detail == null ? 0 : this.detail.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShippingMethod)) {
            return false;
        }
        ShippingMethod shippingMethod = (ShippingMethod)other;
        if (!Intrinsics.areEqual((Object)this.label, (Object)shippingMethod.label)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)shippingMethod.identifier)) {
            return false;
        }
        if (this.amount != shippingMethod.amount) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currency, (Object)shippingMethod.currency)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.detail, (Object)shippingMethod.detail);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.label);
        out.writeString(this.identifier);
        out.writeLong(this.amount);
        out.writeSerializable((Serializable)this.currency);
        out.writeString(this.detail);
    }

    @JvmOverloads
    public ShippingMethod(@NotNull String label, @NotNull String identifier, long amount, @NotNull Currency currency) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        this(label, identifier, amount, currency, null, 16, null);
    }

    @JvmOverloads
    public ShippingMethod(@NotNull String label, @NotNull String identifier, long amount, @Size(min=0L, max=3L) @NotNull String currencyCode) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        this(label, identifier, amount, currencyCode, null, 16, null);
    }

    static {
        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<ShippingMethod> {
            @NotNull
            public final ShippingMethod[] newArray(int size) {
                return new ShippingMethod[size];
            }

            @NotNull
            public final ShippingMethod createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new ShippingMethod(parcel.readString(), parcel.readString(), parcel.readLong(), (Currency)parcel.readSerializable(), parcel.readString());
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

