/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.model.MicrodepositType;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.WeChat;
import com.stripe.android.utils.StripeUrlUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004./01J\b\u0010,\u001a\u00020\u000fH&J\b\u0010-\u001a\u00020\u000fH&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0005R\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u0004\u0018\u00010'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010%\u0082\u0001\u000223\u00a8\u00064"}, d2={"Lcom/stripe/android/model/StripeIntent;", "Lcom/stripe/android/core/model/StripeModel;", "clientSecret", "", "getClientSecret", "()Ljava/lang/String;", "created", "", "getCreated", "()J", "description", "getDescription", "id", "getId", "isConfirmed", "", "()Z", "isLiveMode", "lastErrorMessage", "getLastErrorMessage", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "getNextActionData", "()Lcom/stripe/android/model/StripeIntent$NextActionData;", "nextActionType", "Lcom/stripe/android/model/StripeIntent$NextActionType;", "getNextActionType", "()Lcom/stripe/android/model/StripeIntent$NextActionType;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "getPaymentMethodId", "paymentMethodTypes", "", "getPaymentMethodTypes", "()Ljava/util/List;", "status", "Lcom/stripe/android/model/StripeIntent$Status;", "getStatus", "()Lcom/stripe/android/model/StripeIntent$Status;", "unactivatedPaymentMethods", "getUnactivatedPaymentMethods", "requiresAction", "requiresConfirmation", "NextActionData", "NextActionType", "Status", "Usage", "Lcom/stripe/android/model/PaymentIntent;", "Lcom/stripe/android/model/SetupIntent;", "payments-core_release"})
public interface StripeIntent
extends StripeModel {
    @Nullable
    public String getId();

    public long getCreated();

    @Nullable
    public String getDescription();

    public boolean isLiveMode();

    @Nullable
    public PaymentMethod getPaymentMethod();

    @Nullable
    public String getPaymentMethodId();

    @NotNull
    public List<String> getPaymentMethodTypes();

    @Nullable
    public NextActionType getNextActionType();

    @Nullable
    public String getClientSecret();

    @Nullable
    public Status getStatus();

    @Nullable
    public NextActionData getNextActionData();

    public boolean isConfirmed();

    @Nullable
    public String getLastErrorMessage();

    @NotNull
    public List<String> getUnactivatedPaymentMethods();

    public boolean requiresAction();

    public boolean requiresConfirmation();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionType;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "toString", "RedirectToUrl", "UseStripeSdk", "DisplayOxxoDetails", "AlipayRedirect", "BlikAuthorize", "WeChatPayRedirect", "VerifyWithMicrodeposits", "Companion", "payments-core_release"})
    public static final class NextActionType
    extends Enum<NextActionType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ NextActionType RedirectToUrl;
        public static final /* enum */ NextActionType UseStripeSdk;
        public static final /* enum */ NextActionType DisplayOxxoDetails;
        public static final /* enum */ NextActionType AlipayRedirect;
        public static final /* enum */ NextActionType BlikAuthorize;
        public static final /* enum */ NextActionType WeChatPayRedirect;
        public static final /* enum */ NextActionType VerifyWithMicrodeposits;
        private static final /* synthetic */ NextActionType[] $VALUES;

        private NextActionType(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public String toString() {
            return this.code;
        }

        public static NextActionType[] values() {
            return (NextActionType[])$VALUES.clone();
        }

        public static NextActionType valueOf(String value) {
            return Enum.valueOf(NextActionType.class, value);
        }

        static {
            RedirectToUrl = new NextActionType("redirect_to_url");
            UseStripeSdk = new NextActionType("use_stripe_sdk");
            DisplayOxxoDetails = new NextActionType("oxxo_display_details");
            AlipayRedirect = new NextActionType("alipay_handle_redirect");
            BlikAuthorize = new NextActionType("blik_authorize");
            WeChatPayRedirect = new NextActionType("wechat_pay_redirect_to_android_app");
            VerifyWithMicrodeposits = new NextActionType("verify_with_microdeposits");
            $VALUES = nextActionTypeArray = new NextActionType[]{NextActionType.RedirectToUrl, NextActionType.UseStripeSdk, NextActionType.DisplayOxxoDetails, NextActionType.AlipayRedirect, NextActionType.BlikAuthorize, NextActionType.WeChatPayRedirect, NextActionType.VerifyWithMicrodeposits};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionType$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/StripeIntent$NextActionType;", "code", "", "fromCode$payments_core_release", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final NextActionType fromCode$payments_core_release(@Nullable String code) {
                NextActionType nextActionType;
                block1: {
                    NextActionType[] $this$firstOrNull$iv = NextActionType.values();
                    boolean $i$f$firstOrNull = false;
                    for (NextActionType element$iv : $this$firstOrNull$iv) {
                        NextActionType it = element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getCode(), (Object)code)) continue;
                        nextActionType = element$iv;
                        break block1;
                    }
                    nextActionType = null;
                }
                return nextActionType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/model/StripeIntent$Status;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "toString", "Canceled", "Processing", "RequiresAction", "RequiresConfirmation", "RequiresPaymentMethod", "Succeeded", "RequiresCapture", "Companion", "payments-core_release"})
    public static final class Status
    extends Enum<Status> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ Status Canceled;
        public static final /* enum */ Status Processing;
        public static final /* enum */ Status RequiresAction;
        public static final /* enum */ Status RequiresConfirmation;
        public static final /* enum */ Status RequiresPaymentMethod;
        public static final /* enum */ Status Succeeded;
        public static final /* enum */ Status RequiresCapture;
        private static final /* synthetic */ Status[] $VALUES;

        private Status(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public String toString() {
            return this.code;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            Canceled = new Status("canceled");
            Processing = new Status("processing");
            RequiresAction = new Status("requires_action");
            RequiresConfirmation = new Status("requires_confirmation");
            RequiresPaymentMethod = new Status("requires_payment_method");
            Succeeded = new Status("succeeded");
            RequiresCapture = new Status("requires_capture");
            $VALUES = statusArray = new Status[]{Status.Canceled, Status.Processing, Status.RequiresAction, Status.RequiresConfirmation, Status.RequiresPaymentMethod, Status.Succeeded, Status.RequiresCapture};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/StripeIntent$Status$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/StripeIntent$Status;", "code", "", "fromCode$payments_core_release", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Status fromCode$payments_core_release(@Nullable String code) {
                Status status;
                block1: {
                    Status[] $this$firstOrNull$iv = Status.values();
                    boolean $i$f$firstOrNull = false;
                    for (Status element$iv : $this$firstOrNull$iv) {
                        Status it = element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getCode(), (Object)code)) continue;
                        status = element$iv;
                        break block1;
                    }
                    status = null;
                }
                return status;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/StripeIntent$Usage;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "toString", "OnSession", "OffSession", "OneTime", "Companion", "payments-core_release"})
    public static final class Usage
    extends Enum<Usage> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ Usage OnSession;
        public static final /* enum */ Usage OffSession;
        public static final /* enum */ Usage OneTime;
        private static final /* synthetic */ Usage[] $VALUES;

        private Usage(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public String toString() {
            return this.code;
        }

        public static Usage[] values() {
            return (Usage[])$VALUES.clone();
        }

        public static Usage valueOf(String value) {
            return Enum.valueOf(Usage.class, value);
        }

        static {
            OnSession = new Usage("on_session");
            OffSession = new Usage("off_session");
            OneTime = new Usage("one_time");
            $VALUES = usageArray = new Usage[]{Usage.OnSession, Usage.OffSession, Usage.OneTime};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/StripeIntent$Usage$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/StripeIntent$Usage;", "code", "", "fromCode$payments_core_release", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Usage fromCode$payments_core_release(@Nullable String code) {
                Usage usage;
                block1: {
                    Usage[] $this$firstOrNull$iv = Usage.values();
                    boolean $i$f$firstOrNull = false;
                    for (Usage element$iv : $this$firstOrNull$iv) {
                        Usage it = element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getCode(), (Object)code)) continue;
                        usage = element$iv;
                        break block1;
                    }
                    usage = null;
                }
                return usage;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0007\u0003\u0004\u0005\u0006\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0007\n\u000b\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData;", "Lcom/stripe/android/core/model/StripeModel;", "()V", "AlipayRedirect", "BlikAuthorize", "DisplayOxxoDetails", "RedirectToUrl", "SdkData", "VerifyWithMicrodeposits", "WeChatPayRedirect", "Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayOxxoDetails;", "Lcom/stripe/android/model/StripeIntent$NextActionData$RedirectToUrl;", "Lcom/stripe/android/model/StripeIntent$NextActionData$AlipayRedirect;", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData;", "Lcom/stripe/android/model/StripeIntent$NextActionData$BlikAuthorize;", "Lcom/stripe/android/model/StripeIntent$NextActionData$WeChatPayRedirect;", "Lcom/stripe/android/model/StripeIntent$NextActionData$VerifyWithMicrodeposits;", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static abstract class NextActionData
    implements StripeModel {
        public static final int $stable;

        private NextActionData() {
        }

        public /* synthetic */ NextActionData(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayOxxoDetails;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "expiresAfter", "", "number", "", "hostedVoucherUrl", "(ILjava/lang/String;Ljava/lang/String;)V", "getExpiresAfter", "()I", "getHostedVoucherUrl", "()Ljava/lang/String;", "getNumber", "component1", "component2", "component3", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class DisplayOxxoDetails
        extends NextActionData {
            private final int expiresAfter;
            @Nullable
            private final String number;
            @Nullable
            private final String hostedVoucherUrl;
            @NotNull
            public static final Parcelable.Creator<DisplayOxxoDetails> CREATOR;
            public static final int $stable;

            public DisplayOxxoDetails(int expiresAfter, @Nullable String number, @Nullable String hostedVoucherUrl) {
                super(null);
                this.expiresAfter = expiresAfter;
                this.number = number;
                this.hostedVoucherUrl = hostedVoucherUrl;
            }

            public /* synthetic */ DisplayOxxoDetails(int n, String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    n = 0;
                }
                if ((n2 & 2) != 0) {
                    string = null;
                }
                if ((n2 & 4) != 0) {
                    string2 = null;
                }
                this(n, string, string2);
            }

            public final int getExpiresAfter() {
                return this.expiresAfter;
            }

            @Nullable
            public final String getNumber() {
                return this.number;
            }

            @Nullable
            public final String getHostedVoucherUrl() {
                return this.hostedVoucherUrl;
            }

            public final int component1() {
                return this.expiresAfter;
            }

            @Nullable
            public final String component2() {
                return this.number;
            }

            @Nullable
            public final String component3() {
                return this.hostedVoucherUrl;
            }

            @NotNull
            public final DisplayOxxoDetails copy(int expiresAfter, @Nullable String number, @Nullable String hostedVoucherUrl) {
                return new DisplayOxxoDetails(expiresAfter, number, hostedVoucherUrl);
            }

            public static /* synthetic */ DisplayOxxoDetails copy$default(DisplayOxxoDetails displayOxxoDetails, int n, String string, String string2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = displayOxxoDetails.expiresAfter;
                }
                if ((n2 & 2) != 0) {
                    string = displayOxxoDetails.number;
                }
                if ((n2 & 4) != 0) {
                    string2 = displayOxxoDetails.hostedVoucherUrl;
                }
                return displayOxxoDetails.copy(n, string, string2);
            }

            @NotNull
            public String toString() {
                return "DisplayOxxoDetails(expiresAfter=" + this.expiresAfter + ", number=" + this.number + ", hostedVoucherUrl=" + this.hostedVoucherUrl + ')';
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.expiresAfter);
                result2 = result2 * 31 + (this.number == null ? 0 : this.number.hashCode());
                result2 = result2 * 31 + (this.hostedVoucherUrl == null ? 0 : this.hostedVoucherUrl.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DisplayOxxoDetails)) {
                    return false;
                }
                DisplayOxxoDetails displayOxxoDetails = (DisplayOxxoDetails)other;
                if (this.expiresAfter != displayOxxoDetails.expiresAfter) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.number, (Object)displayOxxoDetails.number)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.hostedVoucherUrl, (Object)displayOxxoDetails.hostedVoucherUrl);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeInt(this.expiresAfter);
                out.writeString(this.number);
                out.writeString(this.hostedVoucherUrl);
            }

            public DisplayOxxoDetails() {
                this(0, null, null, 7, null);
            }

            static {
                @Metadata(mv={1, 6, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<DisplayOxxoDetails> {
                    @NotNull
                    public final DisplayOxxoDetails[] newArray(int size) {
                        return new DisplayOxxoDetails[size];
                    }

                    @NotNull
                    public final DisplayOxxoDetails createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new DisplayOxxoDetails(parcel.readInt(), parcel.readString(), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$RedirectToUrl;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "url", "Landroid/net/Uri;", "returnUrl", "", "(Landroid/net/Uri;Ljava/lang/String;)V", "getReturnUrl", "()Ljava/lang/String;", "getUrl", "()Landroid/net/Uri;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class RedirectToUrl
        extends NextActionData {
            @NotNull
            private final Uri url;
            @Nullable
            private final String returnUrl;
            @NotNull
            public static final Parcelable.Creator<RedirectToUrl> CREATOR;
            public static final int $stable;

            public RedirectToUrl(@NotNull Uri url, @Nullable String returnUrl) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(null);
                this.url = url;
                this.returnUrl = returnUrl;
            }

            @NotNull
            public final Uri getUrl() {
                return this.url;
            }

            @Nullable
            public final String getReturnUrl() {
                return this.returnUrl;
            }

            @NotNull
            public final Uri component1() {
                return this.url;
            }

            @Nullable
            public final String component2() {
                return this.returnUrl;
            }

            @NotNull
            public final RedirectToUrl copy(@NotNull Uri url, @Nullable String returnUrl) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return new RedirectToUrl(url, returnUrl);
            }

            public static /* synthetic */ RedirectToUrl copy$default(RedirectToUrl redirectToUrl, Uri uri, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    uri = redirectToUrl.url;
                }
                if ((n & 2) != 0) {
                    string = redirectToUrl.returnUrl;
                }
                return redirectToUrl.copy(uri, string);
            }

            @NotNull
            public String toString() {
                return "RedirectToUrl(url=" + this.url + ", returnUrl=" + this.returnUrl + ')';
            }

            public int hashCode() {
                int result2 = this.url.hashCode();
                result2 = result2 * 31 + (this.returnUrl == null ? 0 : this.returnUrl.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RedirectToUrl)) {
                    return false;
                }
                RedirectToUrl redirectToUrl = (RedirectToUrl)other;
                if (!Intrinsics.areEqual((Object)this.url, (Object)redirectToUrl.url)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.returnUrl, (Object)redirectToUrl.returnUrl);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeParcelable((Parcelable)this.url, flags);
                out.writeString(this.returnUrl);
            }

            static {
                @Metadata(mv={1, 6, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<RedirectToUrl> {
                    @NotNull
                    public final RedirectToUrl[] newArray(int size) {
                        return new RedirectToUrl[size];
                    }

                    @NotNull
                    public final RedirectToUrl createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new RedirectToUrl((Uri)parcel.readParcelable(RedirectToUrl.class.getClassLoader()), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B#\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$AlipayRedirect;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "data", "", "webViewUrl", "returnUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "authCompleteUrl", "Landroid/net/Uri;", "(Ljava/lang/String;Ljava/lang/String;Landroid/net/Uri;Ljava/lang/String;)V", "getAuthCompleteUrl", "()Ljava/lang/String;", "getData", "getReturnUrl", "getWebViewUrl", "()Landroid/net/Uri;", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        public static final class AlipayRedirect
        extends NextActionData {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @NotNull
            private final String data;
            @Nullable
            private final String authCompleteUrl;
            @NotNull
            private final Uri webViewUrl;
            @Nullable
            private final String returnUrl;
            @NotNull
            public static final Parcelable.Creator<AlipayRedirect> CREATOR;

            public AlipayRedirect(@NotNull String data, @Nullable String authCompleteUrl, @NotNull Uri webViewUrl, @Nullable String returnUrl) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)webViewUrl, (String)"webViewUrl");
                super(null);
                this.data = data;
                this.authCompleteUrl = authCompleteUrl;
                this.webViewUrl = webViewUrl;
                this.returnUrl = returnUrl;
            }

            public /* synthetic */ AlipayRedirect(String string, String string2, Uri uri, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    string3 = null;
                }
                this(string, string2, uri, string3);
            }

            @NotNull
            public final String getData() {
                return this.data;
            }

            @Nullable
            public final String getAuthCompleteUrl() {
                return this.authCompleteUrl;
            }

            @NotNull
            public final Uri getWebViewUrl() {
                return this.webViewUrl;
            }

            @Nullable
            public final String getReturnUrl() {
                return this.returnUrl;
            }

            public AlipayRedirect(@NotNull String data, @NotNull String webViewUrl, @Nullable String returnUrl) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)webViewUrl, (String)"webViewUrl");
                String string = AlipayRedirect.Companion.extractReturnUrl(data);
                Uri uri = Uri.parse((String)webViewUrl);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(webViewUrl)");
                this(data, string, uri, returnUrl);
            }

            public /* synthetic */ AlipayRedirect(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string3 = null;
                }
                this(string, string2, string3);
            }

            @NotNull
            public final String component1() {
                return this.data;
            }

            @Nullable
            public final String component2() {
                return this.authCompleteUrl;
            }

            @NotNull
            public final Uri component3() {
                return this.webViewUrl;
            }

            @Nullable
            public final String component4() {
                return this.returnUrl;
            }

            @NotNull
            public final AlipayRedirect copy(@NotNull String data, @Nullable String authCompleteUrl, @NotNull Uri webViewUrl, @Nullable String returnUrl) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)webViewUrl, (String)"webViewUrl");
                return new AlipayRedirect(data, authCompleteUrl, webViewUrl, returnUrl);
            }

            public static /* synthetic */ AlipayRedirect copy$default(AlipayRedirect alipayRedirect, String string, String string2, Uri uri, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = alipayRedirect.data;
                }
                if ((n & 2) != 0) {
                    string2 = alipayRedirect.authCompleteUrl;
                }
                if ((n & 4) != 0) {
                    uri = alipayRedirect.webViewUrl;
                }
                if ((n & 8) != 0) {
                    string3 = alipayRedirect.returnUrl;
                }
                return alipayRedirect.copy(string, string2, uri, string3);
            }

            @NotNull
            public String toString() {
                return "AlipayRedirect(data=" + this.data + ", authCompleteUrl=" + this.authCompleteUrl + ", webViewUrl=" + this.webViewUrl + ", returnUrl=" + this.returnUrl + ')';
            }

            public int hashCode() {
                int result2 = this.data.hashCode();
                result2 = result2 * 31 + (this.authCompleteUrl == null ? 0 : this.authCompleteUrl.hashCode());
                result2 = result2 * 31 + this.webViewUrl.hashCode();
                result2 = result2 * 31 + (this.returnUrl == null ? 0 : this.returnUrl.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AlipayRedirect)) {
                    return false;
                }
                AlipayRedirect alipayRedirect = (AlipayRedirect)other;
                if (!Intrinsics.areEqual((Object)this.data, (Object)alipayRedirect.data)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.authCompleteUrl, (Object)alipayRedirect.authCompleteUrl)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.webViewUrl, (Object)alipayRedirect.webViewUrl)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.returnUrl, (Object)alipayRedirect.returnUrl);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeString(this.data);
                out.writeString(this.authCompleteUrl);
                out.writeParcelable((Parcelable)this.webViewUrl, flags);
                out.writeString(this.returnUrl);
            }

            static {
                @Metadata(mv={1, 6, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<AlipayRedirect> {
                    @NotNull
                    public final AlipayRedirect[] newArray(int size) {
                        return new AlipayRedirect[size];
                    }

                    @NotNull
                    public final AlipayRedirect createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new AlipayRedirect(parcel.readString(), parcel.readString(), (Uri)parcel.readParcelable(AlipayRedirect.class.getClassLoader()), parcel.readString());
                    }
                }
                CREATOR = new Creator();
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$AlipayRedirect$Companion;", "", "()V", "extractReturnUrl", "", "data", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                private final String extractReturnUrl(String data) {
                    Object object;
                    Object object2 = this;
                    try {
                        String string;
                        Companion $this$extractReturnUrl_u24lambda_u2d1 = object2;
                        boolean bl = false;
                        String string2 = Uri.parse((String)Intrinsics.stringPlus((String)"alipay://url?", (Object)data)).getQueryParameter("return_url");
                        if (string2 == null) {
                            string = null;
                        } else {
                            String string3;
                            String it = string3 = string2;
                            boolean bl2 = false;
                            string = StripeUrlUtils.INSTANCE.isStripeUrl$payments_core_release(it) ? string3 : null;
                        }
                        object = Result.constructor-impl(string);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object2 = object;
                    return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "()V", "Use3DS1", "Use3DS2", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS1;", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "payments-core_release"})
        @StabilityInferred(parameters=0)
        public static abstract class SdkData
        extends NextActionData {
            public static final int $stable;

            private SdkData() {
                super(null);
            }

            public /* synthetic */ SdkData(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS1;", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData;", "url", "", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
            @Parcelize
            @StabilityInferred(parameters=0)
            public static final class Use3DS1
            extends SdkData {
                @NotNull
                private final String url;
                @NotNull
                public static final Parcelable.Creator<Use3DS1> CREATOR;
                public static final int $stable;

                public Use3DS1(@NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    super(null);
                    this.url = url;
                }

                @NotNull
                public final String getUrl() {
                    return this.url;
                }

                @NotNull
                public final String component1() {
                    return this.url;
                }

                @NotNull
                public final Use3DS1 copy(@NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    return new Use3DS1(url);
                }

                public static /* synthetic */ Use3DS1 copy$default(Use3DS1 use3DS1, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = use3DS1.url;
                    }
                    return use3DS1.copy(string);
                }

                @NotNull
                public String toString() {
                    return "Use3DS1(url=" + this.url + ')';
                }

                public int hashCode() {
                    return this.url.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Use3DS1)) {
                        return false;
                    }
                    Use3DS1 use3DS1 = (Use3DS1)other;
                    return Intrinsics.areEqual((Object)this.url, (Object)use3DS1.url);
                }

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(@NotNull Parcel out, int flags) {
                    Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                    out.writeString(this.url);
                }

                static {
                    @Metadata(mv={1, 6, 0}, k=3, xi=48)
                    public final class Creator
                    implements Parcelable.Creator<Use3DS1> {
                        @NotNull
                        public final Use3DS1[] newArray(int size) {
                            return new Use3DS1[size];
                        }

                        @NotNull
                        public final Use3DS1 createFromParcel(@NotNull Parcel parcel) {
                            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                            return new Use3DS1(parcel.readString());
                        }
                    }
                    CREATOR = new Creator();
                    $stable = 8;
                }
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001!B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\""}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData;", "source", "", "serverName", "transactionId", "serverEncryption", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2$DirectoryServerEncryption;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2$DirectoryServerEncryption;)V", "getServerEncryption", "()Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2$DirectoryServerEncryption;", "getServerName", "()Ljava/lang/String;", "getSource", "getTransactionId", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "DirectoryServerEncryption", "payments-core_release"})
            @Parcelize
            @StabilityInferred(parameters=0)
            public static final class Use3DS2
            extends SdkData {
                @NotNull
                private final String source;
                @NotNull
                private final String serverName;
                @NotNull
                private final String transactionId;
                @NotNull
                private final DirectoryServerEncryption serverEncryption;
                @NotNull
                public static final Parcelable.Creator<Use3DS2> CREATOR;
                public static final int $stable;

                public Use3DS2(@NotNull String source, @NotNull String serverName, @NotNull String transactionId, @NotNull DirectoryServerEncryption serverEncryption) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
                    Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
                    Intrinsics.checkNotNullParameter((Object)serverEncryption, (String)"serverEncryption");
                    super(null);
                    this.source = source;
                    this.serverName = serverName;
                    this.transactionId = transactionId;
                    this.serverEncryption = serverEncryption;
                }

                @NotNull
                public final String getSource() {
                    return this.source;
                }

                @NotNull
                public final String getServerName() {
                    return this.serverName;
                }

                @NotNull
                public final String getTransactionId() {
                    return this.transactionId;
                }

                @NotNull
                public final DirectoryServerEncryption getServerEncryption() {
                    return this.serverEncryption;
                }

                @NotNull
                public final String component1() {
                    return this.source;
                }

                @NotNull
                public final String component2() {
                    return this.serverName;
                }

                @NotNull
                public final String component3() {
                    return this.transactionId;
                }

                @NotNull
                public final DirectoryServerEncryption component4() {
                    return this.serverEncryption;
                }

                @NotNull
                public final Use3DS2 copy(@NotNull String source, @NotNull String serverName, @NotNull String transactionId, @NotNull DirectoryServerEncryption serverEncryption) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
                    Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
                    Intrinsics.checkNotNullParameter((Object)serverEncryption, (String)"serverEncryption");
                    return new Use3DS2(source, serverName, transactionId, serverEncryption);
                }

                public static /* synthetic */ Use3DS2 copy$default(Use3DS2 use3DS2, String string, String string2, String string3, DirectoryServerEncryption directoryServerEncryption, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = use3DS2.source;
                    }
                    if ((n & 2) != 0) {
                        string2 = use3DS2.serverName;
                    }
                    if ((n & 4) != 0) {
                        string3 = use3DS2.transactionId;
                    }
                    if ((n & 8) != 0) {
                        directoryServerEncryption = use3DS2.serverEncryption;
                    }
                    return use3DS2.copy(string, string2, string3, directoryServerEncryption);
                }

                @NotNull
                public String toString() {
                    return "Use3DS2(source=" + this.source + ", serverName=" + this.serverName + ", transactionId=" + this.transactionId + ", serverEncryption=" + this.serverEncryption + ')';
                }

                public int hashCode() {
                    int result2 = this.source.hashCode();
                    result2 = result2 * 31 + this.serverName.hashCode();
                    result2 = result2 * 31 + this.transactionId.hashCode();
                    result2 = result2 * 31 + this.serverEncryption.hashCode();
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Use3DS2)) {
                        return false;
                    }
                    Use3DS2 use3DS2 = (Use3DS2)other;
                    if (!Intrinsics.areEqual((Object)this.source, (Object)use3DS2.source)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.serverName, (Object)use3DS2.serverName)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)this.transactionId, (Object)use3DS2.transactionId)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.serverEncryption, (Object)use3DS2.serverEncryption);
                }

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(@NotNull Parcel out, int flags) {
                    Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                    out.writeString(this.source);
                    out.writeString(this.serverName);
                    out.writeString(this.transactionId);
                    this.serverEncryption.writeToParcel(out, flags);
                }

                static {
                    @Metadata(mv={1, 6, 0}, k=3, xi=48)
                    public final class Creator
                    implements Parcelable.Creator<Use3DS2> {
                        @NotNull
                        public final Use3DS2[] newArray(int size) {
                            return new Use3DS2[size];
                        }

                        @NotNull
                        public final Use3DS2 createFromParcel(@NotNull Parcel parcel) {
                            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                            return new Use3DS2(parcel.readString(), parcel.readString(), parcel.readString(), (DirectoryServerEncryption)DirectoryServerEncryption.CREATOR.createFromParcel(parcel));
                        }
                    }
                    CREATOR = new Creator();
                    $stable = 8;
                }

                @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J9\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2$DirectoryServerEncryption;", "Landroid/os/Parcelable;", "directoryServerId", "", "dsCertificateData", "rootCertsData", "", "keyId", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getDirectoryServerId", "()Ljava/lang/String;", "getDsCertificateData", "getKeyId", "getRootCertsData", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
                @Parcelize
                @StabilityInferred(parameters=0)
                public static final class DirectoryServerEncryption
                implements Parcelable {
                    @NotNull
                    private final String directoryServerId;
                    @NotNull
                    private final String dsCertificateData;
                    @NotNull
                    private final List<String> rootCertsData;
                    @Nullable
                    private final String keyId;
                    @NotNull
                    public static final Parcelable.Creator<DirectoryServerEncryption> CREATOR;
                    public static final int $stable;

                    public DirectoryServerEncryption(@NotNull String directoryServerId, @NotNull String dsCertificateData, @NotNull List<String> rootCertsData, @Nullable String keyId) {
                        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
                        Intrinsics.checkNotNullParameter((Object)dsCertificateData, (String)"dsCertificateData");
                        Intrinsics.checkNotNullParameter(rootCertsData, (String)"rootCertsData");
                        this.directoryServerId = directoryServerId;
                        this.dsCertificateData = dsCertificateData;
                        this.rootCertsData = rootCertsData;
                        this.keyId = keyId;
                    }

                    @NotNull
                    public final String getDirectoryServerId() {
                        return this.directoryServerId;
                    }

                    @NotNull
                    public final String getDsCertificateData() {
                        return this.dsCertificateData;
                    }

                    @NotNull
                    public final List<String> getRootCertsData() {
                        return this.rootCertsData;
                    }

                    @Nullable
                    public final String getKeyId() {
                        return this.keyId;
                    }

                    @NotNull
                    public final String component1() {
                        return this.directoryServerId;
                    }

                    @NotNull
                    public final String component2() {
                        return this.dsCertificateData;
                    }

                    @NotNull
                    public final List<String> component3() {
                        return this.rootCertsData;
                    }

                    @Nullable
                    public final String component4() {
                        return this.keyId;
                    }

                    @NotNull
                    public final DirectoryServerEncryption copy(@NotNull String directoryServerId, @NotNull String dsCertificateData, @NotNull List<String> rootCertsData, @Nullable String keyId) {
                        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
                        Intrinsics.checkNotNullParameter((Object)dsCertificateData, (String)"dsCertificateData");
                        Intrinsics.checkNotNullParameter(rootCertsData, (String)"rootCertsData");
                        return new DirectoryServerEncryption(directoryServerId, dsCertificateData, rootCertsData, keyId);
                    }

                    public static /* synthetic */ DirectoryServerEncryption copy$default(DirectoryServerEncryption directoryServerEncryption, String string, String string2, List list, String string3, int n, Object object) {
                        if ((n & 1) != 0) {
                            string = directoryServerEncryption.directoryServerId;
                        }
                        if ((n & 2) != 0) {
                            string2 = directoryServerEncryption.dsCertificateData;
                        }
                        if ((n & 4) != 0) {
                            list = directoryServerEncryption.rootCertsData;
                        }
                        if ((n & 8) != 0) {
                            string3 = directoryServerEncryption.keyId;
                        }
                        return directoryServerEncryption.copy(string, string2, list, string3);
                    }

                    @NotNull
                    public String toString() {
                        return "DirectoryServerEncryption(directoryServerId=" + this.directoryServerId + ", dsCertificateData=" + this.dsCertificateData + ", rootCertsData=" + this.rootCertsData + ", keyId=" + this.keyId + ')';
                    }

                    public int hashCode() {
                        int result2 = this.directoryServerId.hashCode();
                        result2 = result2 * 31 + this.dsCertificateData.hashCode();
                        result2 = result2 * 31 + ((Object)this.rootCertsData).hashCode();
                        result2 = result2 * 31 + (this.keyId == null ? 0 : this.keyId.hashCode());
                        return result2;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof DirectoryServerEncryption)) {
                            return false;
                        }
                        DirectoryServerEncryption directoryServerEncryption = (DirectoryServerEncryption)other;
                        if (!Intrinsics.areEqual((Object)this.directoryServerId, (Object)directoryServerEncryption.directoryServerId)) {
                            return false;
                        }
                        if (!Intrinsics.areEqual((Object)this.dsCertificateData, (Object)directoryServerEncryption.dsCertificateData)) {
                            return false;
                        }
                        if (!Intrinsics.areEqual(this.rootCertsData, directoryServerEncryption.rootCertsData)) {
                            return false;
                        }
                        return Intrinsics.areEqual((Object)this.keyId, (Object)directoryServerEncryption.keyId);
                    }

                    public int describeContents() {
                        return 0;
                    }

                    public void writeToParcel(@NotNull Parcel out, int flags) {
                        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                        out.writeString(this.directoryServerId);
                        out.writeString(this.dsCertificateData);
                        out.writeStringList(this.rootCertsData);
                        out.writeString(this.keyId);
                    }

                    static {
                        @Metadata(mv={1, 6, 0}, k=3, xi=48)
                        public final class Creator
                        implements Parcelable.Creator<DirectoryServerEncryption> {
                            @NotNull
                            public final DirectoryServerEncryption[] newArray(int size) {
                                return new DirectoryServerEncryption[size];
                            }

                            @NotNull
                            public final DirectoryServerEncryption createFromParcel(@NotNull Parcel parcel) {
                                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                                return new DirectoryServerEncryption(parcel.readString(), parcel.readString(), parcel.createStringArrayList(), parcel.readString());
                            }
                        }
                        CREATOR = new Creator();
                        $stable = 8;
                    }
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$BlikAuthorize;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "()V", "describeContents", "", "equals", "", "other", "", "hashCode", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class BlikAuthorize
        extends NextActionData {
            @NotNull
            public static final BlikAuthorize INSTANCE = new BlikAuthorize();
            @NotNull
            public static final Parcelable.Creator<BlikAuthorize> CREATOR;
            public static final int $stable;

            private BlikAuthorize() {
                super(null);
            }

            public int hashCode() {
                return 0;
            }

            public boolean equals(@Nullable Object other) {
                return this == other;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeInt(1);
            }

            static {
                @Metadata(mv={1, 6, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<BlikAuthorize> {
                    @NotNull
                    public final BlikAuthorize[] newArray(int size) {
                        return new BlikAuthorize[size];
                    }

                    @NotNull
                    public final BlikAuthorize createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        parcel.readInt();
                        return INSTANCE;
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$WeChatPayRedirect;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "weChat", "Lcom/stripe/android/model/WeChat;", "(Lcom/stripe/android/model/WeChat;)V", "getWeChat", "()Lcom/stripe/android/model/WeChat;", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class WeChatPayRedirect
        extends NextActionData {
            @NotNull
            private final WeChat weChat;
            @NotNull
            public static final Parcelable.Creator<WeChatPayRedirect> CREATOR;
            public static final int $stable;

            public WeChatPayRedirect(@NotNull WeChat weChat) {
                Intrinsics.checkNotNullParameter((Object)weChat, (String)"weChat");
                super(null);
                this.weChat = weChat;
            }

            @NotNull
            public final WeChat getWeChat() {
                return this.weChat;
            }

            @NotNull
            public final WeChat component1() {
                return this.weChat;
            }

            @NotNull
            public final WeChatPayRedirect copy(@NotNull WeChat weChat) {
                Intrinsics.checkNotNullParameter((Object)weChat, (String)"weChat");
                return new WeChatPayRedirect(weChat);
            }

            public static /* synthetic */ WeChatPayRedirect copy$default(WeChatPayRedirect weChatPayRedirect, WeChat weChat, int n, Object object) {
                if ((n & 1) != 0) {
                    weChat = weChatPayRedirect.weChat;
                }
                return weChatPayRedirect.copy(weChat);
            }

            @NotNull
            public String toString() {
                return "WeChatPayRedirect(weChat=" + this.weChat + ')';
            }

            public int hashCode() {
                return this.weChat.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WeChatPayRedirect)) {
                    return false;
                }
                WeChatPayRedirect weChatPayRedirect = (WeChatPayRedirect)other;
                return Intrinsics.areEqual((Object)this.weChat, (Object)weChatPayRedirect.weChat);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                this.weChat.writeToParcel(out, flags);
            }

            static {
                @Metadata(mv={1, 6, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<WeChatPayRedirect> {
                    @NotNull
                    public final WeChatPayRedirect[] newArray(int size) {
                        return new WeChatPayRedirect[size];
                    }

                    @NotNull
                    public final WeChatPayRedirect createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new WeChatPayRedirect((WeChat)WeChat.CREATOR.createFromParcel(parcel));
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/stripe/android/model/StripeIntent$NextActionData$VerifyWithMicrodeposits;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "arrivalDate", "", "hostedVerificationUrl", "", "microdepositType", "Lcom/stripe/android/model/MicrodepositType;", "(JLjava/lang/String;Lcom/stripe/android/model/MicrodepositType;)V", "getArrivalDate", "()J", "getHostedVerificationUrl", "()Ljava/lang/String;", "getMicrodepositType", "()Lcom/stripe/android/model/MicrodepositType;", "component1", "component2", "component3", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class VerifyWithMicrodeposits
        extends NextActionData {
            private final long arrivalDate;
            @NotNull
            private final String hostedVerificationUrl;
            @NotNull
            private final MicrodepositType microdepositType;
            @NotNull
            public static final Parcelable.Creator<VerifyWithMicrodeposits> CREATOR;
            public static final int $stable;

            public VerifyWithMicrodeposits(long arrivalDate, @NotNull String hostedVerificationUrl, @NotNull MicrodepositType microdepositType) {
                Intrinsics.checkNotNullParameter((Object)hostedVerificationUrl, (String)"hostedVerificationUrl");
                Intrinsics.checkNotNullParameter((Object)((Object)microdepositType), (String)"microdepositType");
                super(null);
                this.arrivalDate = arrivalDate;
                this.hostedVerificationUrl = hostedVerificationUrl;
                this.microdepositType = microdepositType;
            }

            public final long getArrivalDate() {
                return this.arrivalDate;
            }

            @NotNull
            public final String getHostedVerificationUrl() {
                return this.hostedVerificationUrl;
            }

            @NotNull
            public final MicrodepositType getMicrodepositType() {
                return this.microdepositType;
            }

            public final long component1() {
                return this.arrivalDate;
            }

            @NotNull
            public final String component2() {
                return this.hostedVerificationUrl;
            }

            @NotNull
            public final MicrodepositType component3() {
                return this.microdepositType;
            }

            @NotNull
            public final VerifyWithMicrodeposits copy(long arrivalDate, @NotNull String hostedVerificationUrl, @NotNull MicrodepositType microdepositType) {
                Intrinsics.checkNotNullParameter((Object)hostedVerificationUrl, (String)"hostedVerificationUrl");
                Intrinsics.checkNotNullParameter((Object)((Object)microdepositType), (String)"microdepositType");
                return new VerifyWithMicrodeposits(arrivalDate, hostedVerificationUrl, microdepositType);
            }

            public static /* synthetic */ VerifyWithMicrodeposits copy$default(VerifyWithMicrodeposits verifyWithMicrodeposits, long l, String string, MicrodepositType microdepositType, int n, Object object) {
                if ((n & 1) != 0) {
                    l = verifyWithMicrodeposits.arrivalDate;
                }
                if ((n & 2) != 0) {
                    string = verifyWithMicrodeposits.hostedVerificationUrl;
                }
                if ((n & 4) != 0) {
                    microdepositType = verifyWithMicrodeposits.microdepositType;
                }
                return verifyWithMicrodeposits.copy(l, string, microdepositType);
            }

            @NotNull
            public String toString() {
                return "VerifyWithMicrodeposits(arrivalDate=" + this.arrivalDate + ", hostedVerificationUrl=" + this.hostedVerificationUrl + ", microdepositType=" + (Object)((Object)this.microdepositType) + ')';
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.arrivalDate);
                result2 = result2 * 31 + this.hostedVerificationUrl.hashCode();
                result2 = result2 * 31 + this.microdepositType.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VerifyWithMicrodeposits)) {
                    return false;
                }
                VerifyWithMicrodeposits verifyWithMicrodeposits = (VerifyWithMicrodeposits)other;
                if (this.arrivalDate != verifyWithMicrodeposits.arrivalDate) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.hostedVerificationUrl, (Object)verifyWithMicrodeposits.hostedVerificationUrl)) {
                    return false;
                }
                return this.microdepositType == verifyWithMicrodeposits.microdepositType;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeLong(this.arrivalDate);
                out.writeString(this.hostedVerificationUrl);
                out.writeString(this.microdepositType.name());
            }

            static {
                @Metadata(mv={1, 6, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<VerifyWithMicrodeposits> {
                    @NotNull
                    public final VerifyWithMicrodeposits[] newArray(int size) {
                        return new VerifyWithMicrodeposits[size];
                    }

                    @NotNull
                    public final VerifyWithMicrodeposits createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new VerifyWithMicrodeposits(parcel.readLong(), parcel.readString(), MicrodepositType.valueOf(parcel.readString()));
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }
        }
    }
}

