/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.Customer;
import com.stripe.android.model.CustomerPaymentSource;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.TokenizationMethod;
import com.stripe.android.model.parsers.CustomerPaymentSourceJsonParser;
import com.stripe.android.model.parsers.ShippingInformationJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/CustomerJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Customer;", "()V", "customerSourceJsonParser", "Lcom/stripe/android/model/parsers/CustomerPaymentSourceJsonParser;", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
public final class CustomerJsonParser
implements ModelJsonParser<Customer> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomerPaymentSourceJsonParser customerSourceJsonParser = new CustomerPaymentSourceJsonParser();
    @Deprecated
    @NotNull
    private static final String FIELD_ID = "id";
    @Deprecated
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @Deprecated
    @NotNull
    private static final String FIELD_DESCRIPTION = "description";
    @Deprecated
    @NotNull
    private static final String FIELD_DEFAULT_SOURCE = "default_source";
    @Deprecated
    @NotNull
    private static final String FIELD_EMAIL = "email";
    @Deprecated
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @Deprecated
    @NotNull
    private static final String FIELD_SHIPPING = "shipping";
    @Deprecated
    @NotNull
    private static final String FIELD_SOURCES = "sources";
    @Deprecated
    @NotNull
    private static final String FIELD_DATA = "data";
    @Deprecated
    @NotNull
    private static final String FIELD_HAS_MORE = "has_more";
    @Deprecated
    @NotNull
    private static final String FIELD_TOTAL_COUNT = "total_count";
    @Deprecated
    @NotNull
    private static final String FIELD_URL = "url";
    @Deprecated
    @NotNull
    private static final String VALUE_LIST = "list";
    @Deprecated
    @NotNull
    private static final String VALUE_CUSTOMER = "customer";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Customer parse(@NotNull JSONObject json) {
        ShippingInformation shippingInformation;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String objectType = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_OBJECT);
        if (!Intrinsics.areEqual((Object)VALUE_CUSTOMER, (Object)objectType)) {
            return null;
        }
        String id = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ID);
        String defaultSource = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DEFAULT_SOURCE);
        JSONObject jSONObject = json.optJSONObject(FIELD_SHIPPING);
        if (jSONObject == null) {
            shippingInformation = null;
        } else {
            JSONObject it = jSONObject;
            boolean bl = false;
            shippingInformation = new ShippingInformationJsonParser().parse(it);
        }
        ShippingInformation shippingInformation2 = shippingInformation;
        JSONObject sourcesJson = json.optJSONObject(FIELD_SOURCES);
        boolean hasMore = false;
        Integer totalCount = null;
        String url = null;
        List sources = null;
        if (sourcesJson != null && Intrinsics.areEqual((Object)VALUE_LIST, (Object)StripeJsonUtils.optString((JSONObject)sourcesJson, (String)FIELD_OBJECT))) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            hasMore = StripeJsonUtils.INSTANCE.optBoolean(sourcesJson, FIELD_HAS_MORE);
            totalCount = StripeJsonUtils.INSTANCE.optInteger(sourcesJson, FIELD_TOTAL_COUNT);
            url = StripeJsonUtils.optString((JSONObject)sourcesJson, (String)FIELD_URL);
            JSONArray jSONArray = sourcesJson.optJSONArray(FIELD_DATA);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            JSONArray dataArray = jSONArray;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)dataArray.length());
            boolean $i$f$map = false;
            void var14_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void idx;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(dataArray.getJSONObject((int)idx));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator idx = $this$forEach$iv$iv$iv.iterator();
            while (idx.hasNext()) {
                CustomerPaymentSource it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = idx.next();
                boolean bl = false;
                JSONObject it = (JSONObject)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (this.customerSourceJsonParser.parse(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                CustomerPaymentSource it = (CustomerPaymentSource)element$iv$iv;
                boolean bl = false;
                if (it.getTokenizationMethod() == TokenizationMethod.ApplePay) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            sources = (List)destination$iv$iv;
        } else {
            hasMore = false;
            totalCount = null;
            url = null;
            sources = CollectionsKt.emptyList();
        }
        return new Customer(id, defaultSource, shippingInformation2, sources, hasMore, totalCount, url, StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DESCRIPTION), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_EMAIL), json.optBoolean(FIELD_LIVEMODE, false));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/model/parsers/CustomerJsonParser$Companion;", "", "()V", "FIELD_DATA", "", "FIELD_DEFAULT_SOURCE", "FIELD_DESCRIPTION", "FIELD_EMAIL", "FIELD_HAS_MORE", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_OBJECT", "FIELD_SHIPPING", "FIELD_SOURCES", "FIELD_TOTAL_COUNT", "FIELD_URL", "VALUE_CUSTOMER", "VALUE_LIST", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

