/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.Address;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.NextActionDataParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "ErrorJsonParser", "ShippingJsonParser", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class PaymentIntentJsonParser
implements ModelJsonParser<PaymentIntent> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @Deprecated
    @NotNull
    private static final String OBJECT_TYPE = "payment_intent";
    @Deprecated
    @NotNull
    private static final String FIELD_ID = "id";
    @Deprecated
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @Deprecated
    @NotNull
    private static final String FIELD_AMOUNT = "amount";
    @Deprecated
    @NotNull
    private static final String FIELD_CREATED = "created";
    @Deprecated
    @NotNull
    private static final String FIELD_CANCELED_AT = "canceled_at";
    @Deprecated
    @NotNull
    private static final String FIELD_CANCELLATION_REASON = "cancellation_reason";
    @Deprecated
    @NotNull
    private static final String FIELD_CAPTURE_METHOD = "capture_method";
    @Deprecated
    @NotNull
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    @Deprecated
    @NotNull
    private static final String FIELD_CONFIRMATION_METHOD = "confirmation_method";
    @Deprecated
    @NotNull
    private static final String FIELD_CURRENCY = "currency";
    @Deprecated
    @NotNull
    private static final String FIELD_DESCRIPTION = "description";
    @Deprecated
    @NotNull
    private static final String FIELD_LAST_PAYMENT_ERROR = "last_payment_error";
    @Deprecated
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @Deprecated
    @NotNull
    private static final String FIELD_NEXT_ACTION = "next_action";
    @Deprecated
    @NotNull
    private static final String FIELD_PAYMENT_METHOD = "payment_method";
    @Deprecated
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @Deprecated
    @NotNull
    private static final String FIELD_RECEIPT_EMAIL = "receipt_email";
    @Deprecated
    @NotNull
    private static final String FIELD_SHIPPING = "shipping";
    @Deprecated
    @NotNull
    private static final String FIELD_STATUS = "status";
    @Deprecated
    @NotNull
    private static final String FIELD_SETUP_FUTURE_USAGE = "setup_future_usage";
    @Deprecated
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";

    @Nullable
    public PaymentIntent parse(@NotNull JSONObject json) {
        StripeIntent.NextActionData nextActionData;
        PaymentIntent.Shipping shipping;
        PaymentIntent.Error error;
        Object object;
        Object object2;
        Object it;
        PaymentMethod paymentMethod;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String objectType = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_OBJECT);
        if (!Intrinsics.areEqual((Object)OBJECT_TYPE, (Object)objectType)) {
            return null;
        }
        String id = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ID);
        List paymentMethodTypes = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        Long amount = StripeJsonUtils.INSTANCE.optLong(json, FIELD_AMOUNT);
        long canceledAt = json.optLong(FIELD_CANCELED_AT);
        PaymentIntent.CancellationReason cancellationReason = PaymentIntent.CancellationReason.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CANCELLATION_REASON));
        PaymentIntent.CaptureMethod captureMethod = PaymentIntent.CaptureMethod.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CAPTURE_METHOD));
        String clientSecret = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CLIENT_SECRET);
        PaymentIntent.ConfirmationMethod confirmationMethod = PaymentIntent.ConfirmationMethod.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CONFIRMATION_METHOD));
        long created = json.optLong(FIELD_CREATED);
        String currency = StripeJsonUtils.optCurrency((JSONObject)json, (String)FIELD_CURRENCY);
        String description = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DESCRIPTION);
        boolean livemode = StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_LIVEMODE);
        JSONObject jSONObject = json.optJSONObject(FIELD_PAYMENT_METHOD);
        if (jSONObject == null) {
            paymentMethod = null;
        } else {
            it = jSONObject;
            boolean bl = false;
            paymentMethod = new PaymentMethodJsonParser().parse((JSONObject)it);
        }
        PaymentMethod paymentMethod2 = paymentMethod;
        Object it2 = it = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAYMENT_METHOD);
        boolean bl = false;
        Object object3 = object2 = paymentMethod2 == null ? it : null;
        if (object2 == null) {
            PaymentMethod paymentMethod3 = paymentMethod2;
            object = paymentMethod3 == null ? null : paymentMethod3.id;
        } else {
            object = object2;
        }
        Object paymentMethodId = object;
        String receiptEmail = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_RECEIPT_EMAIL);
        StripeIntent.Status status = StripeIntent.Status.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_STATUS));
        StripeIntent.Usage setupFutureUsage = StripeIntent.Usage.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_SETUP_FUTURE_USAGE));
        JSONObject jSONObject2 = json.optJSONObject(FIELD_LAST_PAYMENT_ERROR);
        if (jSONObject2 == null) {
            error = null;
        } else {
            JSONObject it3 = jSONObject2;
            boolean bl2 = false;
            error = new ErrorJsonParser().parse(it3);
        }
        PaymentIntent.Error lastPaymentError = error;
        JSONObject jSONObject3 = json.optJSONObject(FIELD_SHIPPING);
        if (jSONObject3 == null) {
            shipping = null;
        } else {
            JSONObject it4 = jSONObject3;
            boolean bl3 = false;
            shipping = new ShippingJsonParser().parse(it4);
        }
        PaymentIntent.Shipping shipping2 = shipping;
        JSONObject jSONObject4 = json.optJSONObject(FIELD_NEXT_ACTION);
        if (jSONObject4 == null) {
            nextActionData = null;
        } else {
            JSONObject it5 = jSONObject4;
            boolean bl4 = false;
            nextActionData = new NextActionDataParser().parse(it5);
        }
        StripeIntent.NextActionData nextActionData2 = nextActionData;
        List unactivatedPaymentMethods = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES));
        return new PaymentIntent(id, paymentMethodTypes, amount, canceledAt, cancellationReason, captureMethod, clientSecret, confirmationMethod, created, currency, description, livemode, paymentMethod2, (String)paymentMethodId, receiptEmail, status, setupFutureUsage, lastPaymentError, shipping2, unactivatedPaymentMethods, nextActionData2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ErrorJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent$Error;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class ErrorJsonParser
    implements ModelJsonParser<PaymentIntent.Error> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_CHARGE = "charge";
        @Deprecated
        @NotNull
        private static final String FIELD_CODE = "code";
        @Deprecated
        @NotNull
        private static final String FIELD_DECLINE_CODE = "decline_code";
        @Deprecated
        @NotNull
        private static final String FIELD_DOC_URL = "doc_url";
        @Deprecated
        @NotNull
        private static final String FIELD_MESSAGE = "message";
        @Deprecated
        @NotNull
        private static final String FIELD_PARAM = "param";
        @Deprecated
        @NotNull
        private static final String FIELD_PAYMENT_METHOD = "payment_method";
        @Deprecated
        @NotNull
        private static final String FIELD_TYPE = "type";

        /*
         * WARNING - void declaration
         */
        @NotNull
        public PaymentIntent.Error parse(@NotNull JSONObject json) {
            PaymentMethod paymentMethod;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CHARGE);
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CODE);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DECLINE_CODE);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DOC_URL);
            String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_MESSAGE);
            String string6 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PARAM);
            JSONObject jSONObject = json.optJSONObject("payment_method");
            if (jSONObject == null) {
                paymentMethod = null;
            } else {
                void it;
                JSONObject jSONObject2 = jSONObject;
                String string7 = string6;
                String string8 = string5;
                String string9 = string4;
                String string10 = string3;
                String string11 = string2;
                String string12 = string;
                boolean bl = false;
                PaymentMethod paymentMethod2 = new PaymentMethodJsonParser().parse((JSONObject)it);
                string = string12;
                string2 = string11;
                string3 = string10;
                string4 = string9;
                string5 = string8;
                string6 = string7;
                paymentMethod = paymentMethod2;
            }
            PaymentIntent.Error.Type type = PaymentIntent.Error.Type.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TYPE));
            PaymentMethod paymentMethod3 = paymentMethod;
            String string13 = string6;
            String string14 = string5;
            String string15 = string4;
            String string16 = string3;
            String string17 = string2;
            String string18 = string;
            return new PaymentIntent.Error(string18, string17, string16, string15, string14, string13, paymentMethod3, type);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ErrorJsonParser$Companion;", "", "()V", "FIELD_CHARGE", "", "FIELD_CODE", "FIELD_DECLINE_CODE", "FIELD_DOC_URL", "FIELD_MESSAGE", "FIELD_PARAM", "FIELD_PAYMENT_METHOD", "FIELD_TYPE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ShippingJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent$Shipping;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class ShippingJsonParser
    implements ModelJsonParser<PaymentIntent.Shipping> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @Deprecated
        @NotNull
        private static final String FIELD_CARRIER = "carrier";
        @Deprecated
        @NotNull
        private static final String FIELD_NAME = "name";
        @Deprecated
        @NotNull
        private static final String FIELD_PHONE = "phone";
        @Deprecated
        @NotNull
        private static final String FIELD_TRACKING_NUMBER = "tracking_number";

        @NotNull
        public PaymentIntent.Shipping parse(@NotNull JSONObject json) {
            Address address;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject jSONObject = json.optJSONObject(FIELD_ADDRESS);
            if (jSONObject == null) {
                address = null;
            } else {
                JSONObject it = jSONObject;
                boolean bl = false;
                address = new AddressJsonParser().parse(it);
            }
            Address address2 = address;
            String string = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TRACKING_NUMBER);
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PHONE);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NAME);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CARRIER);
            Address address3 = address2 == null ? new Address(null, null, null, null, null, null, 63, null) : address2;
            return new PaymentIntent.Shipping(address3, string4, string3, string2, string);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ShippingJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_CARRIER", "FIELD_NAME", "FIELD_PHONE", "FIELD_TRACKING_NUMBER", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CANCELED_AT", "FIELD_CANCELLATION_REASON", "FIELD_CAPTURE_METHOD", "FIELD_CLIENT_SECRET", "FIELD_CONFIRMATION_METHOD", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_DESCRIPTION", "FIELD_ID", "FIELD_LAST_PAYMENT_ERROR", "FIELD_LIVEMODE", "FIELD_NEXT_ACTION", "FIELD_OBJECT", "FIELD_PAYMENT_METHOD", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_RECEIPT_EMAIL", "FIELD_SETUP_FUTURE_USAGE", "FIELD_SHIPPING", "FIELD_STATUS", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "OBJECT_TYPE", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

