/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.authentication.NoOpIntentAuthenticator;
import com.stripe.android.payments.core.authentication.PaymentAuthenticator;
import com.stripe.android.payments.core.authentication.WebIntentAuthenticator;
import com.stripe.android.view.AuthActivityStarterHost;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/payments/core/authentication/OxxoAuthenticator;", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticator;", "Lcom/stripe/android/model/StripeIntent;", "webIntentAuthenticator", "Lcom/stripe/android/payments/core/authentication/WebIntentAuthenticator;", "noOpIntentAuthenticator", "Lcom/stripe/android/payments/core/authentication/NoOpIntentAuthenticator;", "(Lcom/stripe/android/payments/core/authentication/WebIntentAuthenticator;Lcom/stripe/android/payments/core/authentication/NoOpIntentAuthenticator;)V", "authenticate", "", "host", "Lcom/stripe/android/view/AuthActivityStarterHost;", "authenticatable", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/core/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "payments-core_release"})
public final class OxxoAuthenticator
implements PaymentAuthenticator<StripeIntent> {
    @NotNull
    private final WebIntentAuthenticator webIntentAuthenticator;
    @NotNull
    private final NoOpIntentAuthenticator noOpIntentAuthenticator;

    @Inject
    public OxxoAuthenticator(@NotNull WebIntentAuthenticator webIntentAuthenticator, @NotNull NoOpIntentAuthenticator noOpIntentAuthenticator) {
        Intrinsics.checkNotNullParameter((Object)webIntentAuthenticator, (String)"webIntentAuthenticator");
        Intrinsics.checkNotNullParameter((Object)noOpIntentAuthenticator, (String)"noOpIntentAuthenticator");
        this.webIntentAuthenticator = webIntentAuthenticator;
        this.noOpIntentAuthenticator = noOpIntentAuthenticator;
    }

    @Override
    @Nullable
    public Object authenticate(@NotNull AuthActivityStarterHost host, @NotNull StripeIntent authenticatable, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        StripeIntent.NextActionData nextActionData = authenticatable.getNextActionData();
        if (nextActionData == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.stripe.android.model.StripeIntent.NextActionData.DisplayOxxoDetails");
        }
        StripeIntent.NextActionData.DisplayOxxoDetails oxxoDetailsData = (StripeIntent.NextActionData.DisplayOxxoDetails)nextActionData;
        boolean bl = false;
        if (oxxoDetailsData.getHostedVoucherUrl() == null) {
            Object object = this.noOpIntentAuthenticator.authenticate(host, authenticatable, requestOptions, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        } else {
            Object object = this.webIntentAuthenticator.authenticate(host, authenticatable, requestOptions, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    public void onNewActivityResultCaller(@NotNull ActivityResultCaller activityResultCaller, @NotNull ActivityResultCallback<PaymentFlowResult.Unvalidated> activityResultCallback) {
        PaymentAuthenticator.DefaultImpls.onNewActivityResultCaller(this, activityResultCaller, activityResultCallback);
    }

    @Override
    public void onLauncherInvalidated() {
        PaymentAuthenticator.DefaultImpls.onLauncherInvalidated(this);
    }
}

