/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.core.os.BundleKt;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.databinding.StripeCardFormViewBinding;
import com.stripe.android.databinding.StripeHorizontalDividerBinding;
import com.stripe.android.databinding.StripeVerticalDividerBinding;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.ExpirationDate;
import com.stripe.android.view.CardFormView;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.CardValidCallback;
import com.stripe.android.view.CountryTextInputLayout;
import com.stripe.android.view.PostalCodeEditText;
import com.stripe.android.view.PostalCodeValidator;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b9\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0019\b\u0007\u0018\u0000 M2\u00020\u0001:\u0002MNB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000207H\u0002J\b\u00109\u001a\u00020:H\u0002J\u001a\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020#2\b\u0010=\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010>\u001a\u0002072\b\u0010?\u001a\u0004\u0018\u00010@H\u0014J\b\u0010A\u001a\u00020@H\u0014J\u0010\u0010B\u001a\u0002072\b\u0010C\u001a\u0004\u0018\u00010\u0017J\u0010\u0010D\u001a\u0002072\u0006\u0010E\u001a\u00020:H\u0016J\b\u0010F\u001a\u000207H\u0002J\b\u0010G\u001a\u000207H\u0002J\b\u0010H\u001a\u000207H\u0002J\u0012\u0010I\u001a\u0002072\b\u0010=\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010J\u001a\u0002072\b\u0010K\u001a\u0004\u0018\u00010LH\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010$0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0016\u0010)\u001a\n +*\u0004\u0018\u00010*0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/stripe/android/view/CardFormView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "allEditTextFields", "", "Lcom/stripe/android/view/StripeEditText;", "getAllEditTextFields", "()Ljava/util/Collection;", "cardContainer", "Lcom/google/android/material/card/MaterialCardView;", "cardMultilineWidget", "Lcom/stripe/android/view/CardMultilineWidget;", "cardParams", "Lcom/stripe/android/model/CardParams;", "getCardParams", "()Lcom/stripe/android/model/CardParams;", "cardValidCallback", "Lcom/stripe/android/view/CardValidCallback;", "cardValidTextWatcher", "com/stripe/android/view/CardFormView$cardValidTextWatcher$1", "Lcom/stripe/android/view/CardFormView$cardValidTextWatcher$1;", "countryLayout", "Lcom/stripe/android/view/CountryTextInputLayout;", "countryPostalDivider", "Landroid/view/View;", "errors", "Landroid/widget/TextView;", "errorsMap", "", "Lcom/stripe/android/view/CardValidCallback$Fields;", "", "invalidFields", "", "getInvalidFields", "()Ljava/util/Set;", "layoutInflater", "Landroid/view/LayoutInflater;", "kotlin.jvm.PlatformType", "postalCodeContainer", "Lcom/google/android/material/textfield/TextInputLayout;", "postalCodeValidator", "Lcom/stripe/android/view/PostalCodeValidator;", "postalCodeView", "Lcom/stripe/android/view/PostalCodeEditText;", "style", "Lcom/stripe/android/view/CardFormView$Style;", "viewBinding", "Lcom/stripe/android/databinding/StripeCardFormViewBinding;", "applyBorderlessStyle", "", "applyStandardStyle", "isPostalValid", "", "onFieldError", "field", "errorMessage", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setCardValidCallback", "callback", "setEnabled", "enabled", "setupCardWidget", "setupCountryAndPostal", "showPostalError", "updateErrorsView", "updatePostalCodeViewLocale", "countryCode", "Lcom/stripe/android/core/model/CountryCode;", "Companion", "Style", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class CardFormView
extends LinearLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final LayoutInflater layoutInflater;
    @NotNull
    private final StripeCardFormViewBinding viewBinding;
    @NotNull
    private final MaterialCardView cardContainer;
    @NotNull
    private final CardMultilineWidget cardMultilineWidget;
    @NotNull
    private final View countryPostalDivider;
    @NotNull
    private final TextInputLayout postalCodeContainer;
    @NotNull
    private final TextView errors;
    @NotNull
    private final PostalCodeEditText postalCodeView;
    @NotNull
    private final CountryTextInputLayout countryLayout;
    @NotNull
    private final PostalCodeValidator postalCodeValidator;
    @NotNull
    private Style style;
    @NotNull
    private final Map<CardValidCallback.Fields, String> errorsMap;
    @Nullable
    private CardValidCallback cardValidCallback;
    @NotNull
    private final cardValidTextWatcher.1 cardValidTextWatcher;
    public static final int $stable = 8;
    @NotNull
    public static final String CARD_FORM_VIEW = "CardFormView";
    @NotNull
    private static final String STATE_ENABLED = "state_enabled";
    @NotNull
    private static final String STATE_SUPER_STATE = "state_super_state";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CardFormView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void attrs$iv;
        void $this$withStyledAttributes_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.layoutInflater = LayoutInflater.from((Context)context);
        Object object = StripeCardFormViewBinding.inflate(this.layoutInflater, (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(layoutInflater, this)");
        this.viewBinding = object;
        object = this.viewBinding.cardMultilineWidgetContainer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewBinding.cardMultilineWidgetContainer");
        this.cardContainer = object;
        object = this.viewBinding.cardMultilineWidget;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewBinding.cardMultilineWidget");
        this.cardMultilineWidget = object;
        object = this.viewBinding.countryPostalDivider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewBinding.countryPostalDivider");
        this.countryPostalDivider = object;
        object = this.viewBinding.postalCodeContainer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewBinding.postalCodeContainer");
        this.postalCodeContainer = object;
        object = this.viewBinding.errors;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewBinding.errors");
        this.errors = object;
        object = this.viewBinding.postalCode;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewBinding.postalCode");
        this.postalCodeView = object;
        object = this.viewBinding.countryLayout;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewBinding.countryLayout");
        this.countryLayout = object;
        this.postalCodeValidator = new PostalCodeValidator();
        this.style = Style.Standard;
        this.errorsMap = new LinkedHashMap();
        this.cardValidTextWatcher = new StripeTextWatcher(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterTextChanged(@Nullable Editable s) {
                super.afterTextChanged(s);
                CardValidCallback cardValidCallback = CardFormView.access$getCardValidCallback$p(this.this$0);
                if (cardValidCallback != null) {
                    cardValidCallback.onInputChanged(CardFormView.access$getInvalidFields(this.this$0).isEmpty(), CardFormView.access$getInvalidFields(this.this$0));
                }
            }
        };
        this.setOrientation(1);
        this.setupCountryAndPostal();
        this.setupCardWidget();
        ColorStateList backgroundColorStateList = null;
        Context context2 = context;
        int[] nArray = R.styleable.StripeCardFormView;
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"StripeCardFormView");
        int defStyleAttr$iv = 0;
        int defStyleRes$iv = 0;
        boolean $i$f$withStyledAttributes = false;
        TypedArray typedArray = $this$withStyledAttributes_u24default$iv.obtainStyledAttributes(attrs, (int[])attrs$iv, defStyleAttr$iv, defStyleRes$iv);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(s\u2026efStyleAttr, defStyleRes)");
        TypedArray $this$_init__u24lambda_u2d1 = typedArray;
        boolean bl = false;
        backgroundColorStateList = $this$_init__u24lambda_u2d1.getColorStateList(R.styleable.StripeCardFormView_backgroundColorStateList);
        this.style = Style.values()[$this$_init__u24lambda_u2d1.getInt(R.styleable.StripeCardFormView_cardFormStyle, 0)];
        typedArray.recycle();
        ColorStateList colorStateList = backgroundColorStateList;
        if (colorStateList != null) {
            ColorStateList it = colorStateList;
            boolean bl2 = false;
            this.cardContainer.setCardBackgroundColor(it);
            this.cardMultilineWidget.setBackgroundColor(0);
            this.countryLayout.setBackgroundColor(0);
            this.postalCodeContainer.setBackgroundColor(0);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.style.ordinal()]) {
            case 1: {
                this.applyStandardStyle();
                break;
            }
            case 2: {
                this.applyBorderlessStyle();
            }
        }
    }

    public /* synthetic */ CardFormView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final Collection<StripeEditText> getAllEditTextFields() {
        StripeEditText[] stripeEditTextArray = new StripeEditText[]{this.cardMultilineWidget.getCardNumberEditText(), this.cardMultilineWidget.getExpiryDateEditText(), this.cardMultilineWidget.getCvcEditText(), this.postalCodeView};
        return CollectionsKt.listOf((Object[])stripeEditTextArray);
    }

    private final Set<CardValidCallback.Fields> getInvalidFields() {
        CardValidCallback.Fields fields;
        CardValidCallback.Fields fields2 = fields = CardValidCallback.Fields.Postal;
        Collection collection = CollectionsKt.toList((Iterable)this.cardMultilineWidget.getInvalidFields$payments_core_release());
        boolean bl = false;
        boolean bl2 = !this.isPostalValid();
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object)((Object)(bl2 ? fields : null)))));
    }

    @Nullable
    public final CardParams getCardParams() {
        if (!this.cardMultilineWidget.validateAllFields()) {
            this.cardMultilineWidget.setShouldShowErrorIcon$payments_core_release(true);
            return null;
        }
        this.cardMultilineWidget.setShouldShowErrorIcon$payments_core_release(false);
        if (!this.isPostalValid()) {
            this.showPostalError();
            return null;
        }
        this.updateErrorsView(null);
        ExpirationDate.Validated validated = this.cardMultilineWidget.getExpiryDateEditText().getValidatedDate();
        if (validated == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        ExpirationDate.Validated expirationDate = validated;
        CardBrand cardBrand = this.cardMultilineWidget.getBrand$payments_core_release();
        Set set = SetsKt.setOf((Object)CARD_FORM_VIEW);
        CardNumber.Validated validated2 = this.cardMultilineWidget.getValidatedCardNumber$payments_core_release();
        String string3 = validated2 == null ? null : validated2.getValue();
        if (string3 == null) {
            string3 = "";
        }
        Editable editable = this.cardMultilineWidget.getCvcEditText().getText();
        Editable editable2 = this.postalCodeView.getText();
        return new CardParams(cardBrand, set, string3, expirationDate.getMonth(), expirationDate.getYear(), (String)(editable == null ? null : editable.toString()), null, new Address.Builder().setCountryCode(this.countryLayout.getSelectedCountryCode$payments_core_release()).setPostalCode((String)(editable2 == null ? null : editable2.toString())).build(), null, null, 832, null);
    }

    public final void setCardValidCallback(@Nullable CardValidCallback callback) {
        StripeEditText it;
        this.cardValidCallback = callback;
        Iterable $this$forEach$iv = this.getAllEditTextFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StripeEditText)((Object)element$iv);
            boolean bl = false;
            it.removeTextChangedListener(this.cardValidTextWatcher);
        }
        if (callback != null) {
            $this$forEach$iv = this.getAllEditTextFields();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StripeEditText)((Object)element$iv);
                boolean bl = false;
                it.addTextChangedListener(this.cardValidTextWatcher);
            }
        }
        CardValidCallback cardValidCallback = this.cardValidCallback;
        if (cardValidCallback != null) {
            cardValidCallback.onInputChanged(this.getInvalidFields().isEmpty(), this.getInvalidFields());
        }
    }

    private final void setupCountryAndPostal() {
        this.updatePostalCodeViewLocale(this.countryLayout.getSelectedCountryCode$payments_core_release());
        this.postalCodeView.setErrorColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stripe_card_form_view_form_error));
        this.postalCodeView.getInternalFocusChangeListeners().add((arg_0, arg_1) -> CardFormView.setupCountryAndPostal$lambda-5(this, arg_0, arg_1));
        TextView $this$doAfterTextChanged$iv = (TextView)this.postalCodeView;
        boolean $i$f$doAfterTextChanged = false;
        TextView $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = cardFormView;
            }

            public void afterTextChanged(@Nullable Editable s) {
                Editable it = s;
                boolean bl = false;
                CardFormView.access$onFieldError(this.this$0, CardValidCallback.Fields.Postal, null);
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                int n = after;
                int n2 = count;
                int n3 = start;
                CharSequence $noName_0 = text;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                int n = count;
                int n2 = before;
                int n3 = start;
                CharSequence $noName_0 = text;
            }
        };
        $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        this.postalCodeView.setErrorMessageListener(new StripeEditText.ErrorMessageListener(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void displayErrorMessage(@Nullable String errorMessage) {
                CardFormView.access$onFieldError(this.this$0, CardValidCallback.Fields.Postal, errorMessage);
            }
        });
        this.countryLayout.setCountryCodeChangeCallback((Function1<? super CountryCode, Unit>)((Function1)new Function1<CountryCode, Unit>(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CountryCode countryCode) {
                void $this$isVisible$iv;
                Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
                CardFormView.access$updatePostalCodeViewLocale(this.this$0, countryCode);
                View view = (View)CardFormView.access$getPostalCodeContainer$p(this.this$0);
                boolean value$iv = CountryUtils.INSTANCE.doesCountryUsePostalCode(countryCode);
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
                CardFormView.access$getPostalCodeView$p(this.this$0).setShouldShowError(false);
                CardFormView.access$getPostalCodeView$p(this.this$0).setText(null);
            }
        }));
    }

    private final void updatePostalCodeViewLocale(CountryCode countryCode) {
        if (CountryCode.Companion.isUS(countryCode)) {
            this.postalCodeView.setConfig$payments_core_release(PostalCodeEditText.Config.US);
            this.postalCodeView.setErrorMessage(this.getResources().getString(R.string.address_zip_invalid));
        } else {
            this.postalCodeView.setConfig$payments_core_release(PostalCodeEditText.Config.Global);
            this.postalCodeView.setErrorMessage(this.getResources().getString(R.string.address_postal_code_invalid));
        }
    }

    private final boolean isPostalValid() {
        boolean bl;
        CountryCode countryCode = this.countryLayout.getSelectedCountryCode$payments_core_release();
        if (countryCode == null) {
            bl = false;
        } else {
            boolean bl2;
            CountryCode countryCode2 = countryCode;
            boolean bl3 = false;
            String string2 = this.postalCodeView.getPostalCode$payments_core_release();
            if (string2 == null) {
                string2 = "";
            }
            bl = bl2 = this.postalCodeValidator.isValid(string2, countryCode2.getValue());
        }
        return bl;
    }

    private final void showPostalError() {
        this.onFieldError(CardValidCallback.Fields.Postal, this.postalCodeView.getErrorMessage$payments_core_release());
    }

    private final void setupCardWidget() {
        StripeEditText[] stripeEditTextArray = new StripeEditText[]{this.cardMultilineWidget.getCardNumberEditText(), this.cardMultilineWidget.getExpiryDateEditText(), this.cardMultilineWidget.getCvcEditText()};
        Iterable $this$forEach$iv = SetsKt.setOf((Object[])stripeEditTextArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StripeEditText editText = (StripeEditText)((Object)element$iv);
            boolean bl = false;
            editText.setTextSize(0, this.getResources().getDimension(R.dimen.stripe_card_form_view_textsize));
            editText.setTextColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.stripe_card_form_view_text_color));
            editText.setBackgroundResource(17170445);
            editText.setErrorColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stripe_card_form_view_form_error));
        }
        this.cardMultilineWidget.getExpiryDateEditText().setIncludeSeparatorGaps$payments_core_release(true);
        this.cardMultilineWidget.setExpirationDatePlaceholderRes$payments_core_release(null);
        this.cardMultilineWidget.getExpiryTextInputLayout().setHint((CharSequence)this.getContext().getString(R.string.stripe_paymentsheet_expiration_date_hint));
        this.cardMultilineWidget.getCardNumberTextInputLayout().setPlaceholderText(null);
        this.cardMultilineWidget.setCvcPlaceholderText("");
        this.cardMultilineWidget.getCvcEditText().setImeOptions(5);
        this.cardMultilineWidget.setBackgroundResource(R.drawable.stripe_card_form_view_text_input_layout_background);
        Object[] $this$doAfterTextChanged$iv = (Object[])this.cardMultilineWidget.getCvcEditText();
        boolean $i$f$doAfterTextChanged = false;
        Object[] $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = cardFormView;
            }

            public void afterTextChanged(@Nullable Editable s) {
                Editable cvcText = s;
                boolean bl = false;
                View $this$isVisible$iv = (View)CardFormView.access$getPostalCodeContainer$p(this.this$0);
                boolean $i$f$isVisible = false;
                if ($this$isVisible$iv.getVisibility() == 0 && CardFormView.access$getCardMultilineWidget$p(this.this$0).getBrand$payments_core_release().isMaxCvc(String.valueOf(cvcText))) {
                    CardFormView.access$getPostalCodeView$p(this.this$0).requestFocus();
                }
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                int n = after;
                int n2 = count;
                int n3 = start;
                CharSequence $noName_0 = text;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                int n = count;
                int n2 = before;
                int n3 = start;
                CharSequence $noName_0 = text;
            }
        };
        $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        int layoutMarginHorizontal = this.getResources().getDimensionPixelSize(R.dimen.stripe_card_form_view_text_margin_horizontal);
        int layoutMarginVertical = this.getResources().getDimensionPixelSize(R.dimen.stripe_card_form_view_text_margin_vertical);
        $this$addTextChangedListener_u24default$iv$iv = new TextInputLayout[]{this.cardMultilineWidget.getCardNumberTextInputLayout(), this.cardMultilineWidget.getExpiryTextInputLayout(), this.cardMultilineWidget.getCvcInputLayout()};
        Iterable $this$forEach$iv2 = SetsKt.setOf((Object[])$this$addTextChangedListener_u24default$iv$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            TextInputLayout layout2 = (TextInputLayout)element$iv;
            boolean bl = false;
            View $this$updateLayoutParams$iv = (View)layout2;
            boolean $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            }
            ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((LinearLayout.LayoutParams)layoutParams);
            LinearLayout.LayoutParams $this$setupCardWidget_u24lambda_u2d11_u24lambda_u2d10 = (LinearLayout.LayoutParams)params$iv;
            boolean bl2 = false;
            $this$setupCardWidget_u24lambda_u2d11_u24lambda_u2d10.setMarginStart(layoutMarginHorizontal);
            $this$setupCardWidget_u24lambda_u2d11_u24lambda_u2d10.setMarginEnd(layoutMarginHorizontal);
            $this$setupCardWidget_u24lambda_u2d11_u24lambda_u2d10.topMargin = layoutMarginVertical;
            $this$setupCardWidget_u24lambda_u2d11_u24lambda_u2d10.bottomMargin = layoutMarginVertical;
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
            layout2.setErrorEnabled(false);
            layout2.setError(null);
        }
        this.cardMultilineWidget.setCvcIcon(R.drawable.stripe_ic_paymentsheet_cvc);
        this.cardMultilineWidget.setCardNumberErrorListener$payments_core_release(new StripeEditText.ErrorMessageListener(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void displayErrorMessage(@Nullable String errorMessage) {
                CardFormView.access$onFieldError(this.this$0, CardValidCallback.Fields.Number, errorMessage);
            }
        });
        this.cardMultilineWidget.setExpirationDateErrorListener$payments_core_release(new StripeEditText.ErrorMessageListener(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void displayErrorMessage(@Nullable String errorMessage) {
                CardFormView.access$onFieldError(this.this$0, CardValidCallback.Fields.Expiry, errorMessage);
            }
        });
        this.cardMultilineWidget.setCvcErrorListener$payments_core_release(new StripeEditText.ErrorMessageListener(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void displayErrorMessage(@Nullable String errorMessage) {
                CardFormView.access$onFieldError(this.this$0, CardValidCallback.Fields.Cvc, errorMessage);
            }
        });
        this.cardMultilineWidget.setPostalCodeErrorListener$payments_core_release(null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cardContainer.setEnabled(enabled);
        this.cardMultilineWidget.setEnabled(enabled);
        this.countryLayout.setEnabled(enabled);
        this.postalCodeContainer.setEnabled(enabled);
        this.errors.setEnabled(enabled);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)STATE_SUPER_STATE, (Object)super.onSaveInstanceState()), TuplesKt.to((Object)STATE_ENABLED, (Object)this.isEnabled())};
        return (Parcelable)BundleKt.bundleOf((Pair[])pairArray);
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (state instanceof Bundle) {
            super.onRestoreInstanceState(((Bundle)state).getParcelable(STATE_SUPER_STATE));
            this.setEnabled(((Bundle)state).getBoolean(STATE_ENABLED));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    private final void applyStandardStyle() {
        this.cardMultilineWidget.addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.cardMultilineWidget.getSecondRowLayout().addView(StripeVerticalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget.getSecondRowLayout(), false).getRoot(), 1);
        this.cardMultilineWidget.addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), this.cardMultilineWidget.getChildCount());
        this.cardContainer.setCardElevation(this.getResources().getDimension(R.dimen.stripe_card_form_view_card_elevation));
    }

    /*
     * WARNING - void declaration
     */
    private final void applyBorderlessStyle() {
        void $this$isVisible$iv;
        this.cardMultilineWidget.getCardNumberTextInputLayout().addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.cardMultilineWidget.getExpiryTextInputLayout().addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.cardMultilineWidget.getCvcInputLayout().addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.countryLayout.addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.countryLayout, false).getRoot());
        View view = this.countryPostalDivider;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.cardContainer.setCardElevation(0.0f);
    }

    /*
     * WARNING - void declaration
     */
    private final void onFieldError(CardValidCallback.Fields field, String errorMessage) {
        Object v1;
        block2: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            this.errorsMap.put(field, errorMessage);
            CardValidCallback.Fields[] fieldsArray = CardValidCallback.Fields.values();
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void var13_15 = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.errorsMap.get(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
                if (!bl2) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        String error = v1;
        this.updateErrorsView(error);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateErrorsView(String errorMessage) {
        void $this$isVisible$iv;
        this.errors.setText((CharSequence)errorMessage);
        View view = (View)this.errors;
        boolean value$iv = errorMessage != null;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
    }

    @JvmOverloads
    public CardFormView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardFormView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void setupCountryAndPostal$lambda-5(CardFormView this$0, View $noName_0, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!hasFocus) {
            this$0.postalCodeView.setShouldShowError(!StringsKt.isBlank((CharSequence)this$0.postalCodeView.getFieldText$payments_core_release()) && !this$0.isPostalValid());
            if (this$0.postalCodeView.getShouldShowError()) {
                this$0.showPostalError();
            } else {
                this$0.onFieldError(CardValidCallback.Fields.Postal, null);
            }
        }
    }

    public static final /* synthetic */ void access$onFieldError(CardFormView $this, CardValidCallback.Fields field, String errorMessage) {
        $this.onFieldError(field, errorMessage);
    }

    public static final /* synthetic */ void access$updatePostalCodeViewLocale(CardFormView $this, CountryCode countryCode) {
        $this.updatePostalCodeViewLocale(countryCode);
    }

    public static final /* synthetic */ TextInputLayout access$getPostalCodeContainer$p(CardFormView $this) {
        return $this.postalCodeContainer;
    }

    public static final /* synthetic */ PostalCodeEditText access$getPostalCodeView$p(CardFormView $this) {
        return $this.postalCodeView;
    }

    public static final /* synthetic */ CardMultilineWidget access$getCardMultilineWidget$p(CardFormView $this) {
        return $this.cardMultilineWidget;
    }

    public static final /* synthetic */ CardValidCallback access$getCardValidCallback$p(CardFormView $this) {
        return $this.cardValidCallback;
    }

    public static final /* synthetic */ Set access$getInvalidFields(CardFormView $this) {
        return $this.getInvalidFields();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/view/CardFormView$Style;", "", "attrValue", "", "(Ljava/lang/String;II)V", "getAttrValue$payments_core_release", "()I", "Standard", "Borderless", "payments-core_release"})
    private static final class Style
    extends Enum<Style> {
        private final int attrValue;
        public static final /* enum */ Style Standard = new Style(0);
        public static final /* enum */ Style Borderless = new Style(1);
        private static final /* synthetic */ Style[] $VALUES;

        private Style(int attrValue) {
            this.attrValue = attrValue;
        }

        public final int getAttrValue$payments_core_release() {
            return this.attrValue;
        }

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }

        public static Style valueOf(String value) {
            return Enum.valueOf(Style.class, value);
        }

        static {
            $VALUES = styleArray = new Style[]{Style.Standard, Style.Borderless};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/CardFormView$Companion;", "", "()V", "CARD_FORM_VIEW", "", "STATE_ENABLED", "STATE_SUPER_STATE", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Style.values().length];
            nArray[Style.Standard.ordinal()] = 1;
            nArray[Style.Borderless.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

