/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.StripeIntent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB-\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent;", "elementsSessionId", "", "paymentMode", "Lcom/stripe/android/model/DeferredIntentParams$Mode$Payment;", "apiKey", "timeProvider", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lcom/stripe/android/model/DeferredIntentParams$Mode$Payment;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDeferredPaymentIntentJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeferredPaymentIntentJsonParser.kt\ncom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1549#2:62\n1620#2,3:63\n*S KotlinDebug\n*F\n+ 1 DeferredPaymentIntentJsonParser.kt\ncom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser\n*L\n28#1:62\n28#1:63,3\n*E\n"})
public final class DeferredPaymentIntentJsonParser
implements ModelJsonParser<PaymentIntent> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String elementsSessionId;
    @NotNull
    private final DeferredIntentParams.Mode.Payment paymentMode;
    @NotNull
    private final String apiKey;
    @NotNull
    private final Function0<Long> timeProvider;
    public static final int $stable;
    @NotNull
    private static final String FIELD_COUNTRY_CODE = "country_code";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";
    @NotNull
    private static final String FIELD_LINK_FUNDING_SOURCES = "link_funding_sources";

    public DeferredPaymentIntentJsonParser(@Nullable String elementsSessionId, @NotNull DeferredIntentParams.Mode.Payment paymentMode, @NotNull String apiKey, @NotNull Function0<Long> timeProvider) {
        Intrinsics.checkNotNullParameter((Object)paymentMode, (String)"paymentMode");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this.elementsSessionId = elementsSessionId;
        this.paymentMode = paymentMode;
        this.apiKey = apiKey;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PaymentIntent parse(@NotNull JSONObject json) {
        PaymentIntent.CaptureMethod captureMethod;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        List paymentMethodTypes = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        List unactivatedPaymentMethods = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES));
        Iterable iterable = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_LINK_FUNDING_SOURCES));
        boolean $i$f$map = false;
        String string2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string4 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            collection.add(string4);
        }
        List linkFundingSources = (List)destination$iv$iv;
        String countryCode = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY_CODE);
        switch (WhenMappings.$EnumSwitchMapping$0[this.paymentMode.getCaptureMethod().ordinal()]) {
            case 1: {
                captureMethod = PaymentIntent.CaptureMethod.Automatic;
                break;
            }
            case 2: {
                captureMethod = PaymentIntent.CaptureMethod.AutomaticAsync;
                break;
            }
            case 3: {
                captureMethod = PaymentIntent.CaptureMethod.Manual;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PaymentIntent.CaptureMethod captureMethod2 = captureMethod;
        string2 = this.elementsSessionId;
        boolean bl = StringsKt.contains$default((CharSequence)this.apiKey, (CharSequence)"live", (boolean)false, (int)2, null);
        long l = ((Number)this.timeProvider.invoke()).longValue();
        StripeIntent.Usage usage = this.paymentMode.getSetupFutureUsage();
        long l2 = this.paymentMode.getAmount();
        String string5 = this.paymentMode.getCurrency();
        return new PaymentIntent(string2, paymentMethodTypes, l2, 0L, null, captureMethod2, null, null, countryCode, l, string5, null, bl, null, null, null, null, usage, null, null, unactivatedPaymentMethods, linkFundingSources, null, null, 13494424, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser$Companion;", "", "()V", "FIELD_COUNTRY_CODE", "", "FIELD_LINK_FUNDING_SOURCES", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentIntent.CaptureMethod.values().length];
            try {
                nArray[PaymentIntent.CaptureMethod.Automatic.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentIntent.CaptureMethod.AutomaticAsync.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentIntent.CaptureMethod.Manual.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

