/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.ElementsSession;
import com.stripe.android.model.ElementsSessionParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.DeferredPaymentIntentJsonParser;
import com.stripe.android.model.parsers.DeferredSetupIntentJsonParser;
import com.stripe.android.model.parsers.PaymentIntentJsonParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import com.stripe.android.model.parsers.SetupIntentJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002JH\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\r2\b\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#2\b\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/model/parsers/ElementsSessionJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/ElementsSession;", "params", "Lcom/stripe/android/model/ElementsSessionParams;", "apiKey", "", "timeProvider", "Lkotlin/Function0;", "", "(Lcom/stripe/android/model/ElementsSessionParams;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "parse", "json", "Lorg/json/JSONObject;", "parseCardBrandChoiceEligibility", "", "parseComponents", "Lcom/stripe/android/model/ElementsSession$Customer$Components;", "parseCustomer", "Lcom/stripe/android/model/ElementsSession$Customer;", "parseCustomerSession", "Lcom/stripe/android/model/ElementsSession$Customer$Session;", "parseCustomerSheetComponent", "Lcom/stripe/android/model/ElementsSession$Customer$Components$CustomerSheet;", "parseLinkFlags", "", "parsePaymentSheetComponent", "Lcom/stripe/android/model/ElementsSession$Customer$Components$PaymentSheet;", "parseStripeIntent", "Lcom/stripe/android/model/StripeIntent;", "elementsSessionId", "paymentMethodPreference", "orderedPaymentMethodTypes", "Lorg/json/JSONArray;", "unactivatedPaymentMethodTypes", "", "linkFundingSources", "countryCode", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nElementsSessionJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementsSessionJsonParser.kt\ncom/stripe/android/model/parsers/ElementsSessionJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,321:1\n1549#2:322\n1620#2,3:323\n1603#2,9:326\n1855#2:335\n1856#2:337\n1612#2:338\n288#2,2:339\n1#3:336\n32#4,2:341\n*S KotlinDebug\n*F\n+ 1 ElementsSessionJsonParser.kt\ncom/stripe/android/model/parsers/ElementsSessionJsonParser\n*L\n35#1:322\n35#1:323,3\n155#1:326,9\n155#1:335\n155#1:337\n155#1:338\n227#1:339,2\n155#1:336\n269#1:341,2\n*E\n"})
public final class ElementsSessionJsonParser
implements ModelJsonParser<ElementsSession> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ElementsSessionParams params;
    @NotNull
    private final String apiKey;
    @NotNull
    private final Function0<Long> timeProvider;
    public static final int $stable = 8;
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @NotNull
    private static final String FIELD_ELEMENTS_SESSION_ID = "session_id";
    @NotNull
    private static final String FIELD_COUNTRY_CODE = "country_code";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @NotNull
    private static final String FIELD_ORDERED_PAYMENT_METHOD_TYPES = "ordered_payment_method_types";
    @NotNull
    private static final String FIELD_LINK_SETTINGS = "link_settings";
    @NotNull
    private static final String FIELD_LINK_FUNDING_SOURCES = "link_funding_sources";
    @NotNull
    private static final String FIELD_LINK_PASSTHROUGH_MODE_ENABLED = "link_passthrough_mode_enabled";
    @NotNull
    private static final String FIELD_DISABLE_LINK_SIGNUP = "link_mobile_disable_signup";
    @NotNull
    private static final String FIELD_MERCHANT_COUNTRY = "merchant_country";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_PREFERENCE = "payment_method_preference";
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_SPECS = "payment_method_specs";
    @NotNull
    private static final String FIELD_CARD_BRAND_CHOICE = "card_brand_choice";
    @NotNull
    private static final String FIELD_ELIGIBLE = "eligible";
    @NotNull
    private static final String FIELD_EXTERNAL_PAYMENT_METHOD_DATA = "external_payment_method_data";
    @NotNull
    private static final String FIELD_CUSTOMER = "customer";
    @NotNull
    private static final String FIELD_CUSTOMER_PAYMENT_METHODS = "payment_methods";
    @NotNull
    private static final String FIELD_CUSTOMER_SESSION = "customer_session";
    @NotNull
    private static final String FIELD_DEFAULT_PAYMENT_METHOD = "default_payment_method";
    @NotNull
    private static final String FIELD_CUSTOMER_ID = "id";
    @NotNull
    private static final String FIELD_CUSTOMER_LIVE_MODE = "livemode";
    @NotNull
    private static final String FIELD_CUSTOMER_API_KEY = "api_key";
    @NotNull
    private static final String FIELD_CUSTOMER_API_KEY_EXPIRY = "api_key_expiry";
    @NotNull
    private static final String FIELD_CUSTOMER_NAME = "customer";
    @NotNull
    private static final String FIELD_COMPONENTS = "components";
    @NotNull
    private static final String FIELD_PAYMENT_SHEET = "payment_sheet";
    @NotNull
    private static final String FIELD_CUSTOMER_SHEET = "customer_sheet";
    @NotNull
    private static final String FIELD_ENABLED = "enabled";
    @NotNull
    private static final String FIELD_FEATURES = "features";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_SAVE = "payment_method_save";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_REMOVE = "payment_method_remove";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_ALLOW_REDISPLAY_OVERRIDE = "payment_method_save_allow_redisplay_override";
    @NotNull
    private static final String VALUE_ENABLED = "enabled";
    @NotNull
    public static final String FIELD_GOOGLE_PAY_PREFERENCE = "google_pay_preference";
    @NotNull
    private static final PaymentMethodJsonParser PAYMENT_METHOD_JSON_PARSER = new PaymentMethodJsonParser();

    public ElementsSessionJsonParser(@NotNull ElementsSessionParams params, @NotNull String apiKey, @NotNull Function0<Long> timeProvider) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this.params = params;
        this.apiKey = apiKey;
        this.timeProvider = timeProvider;
    }

    public /* synthetic */ ElementsSessionJsonParser(ElementsSessionParams elementsSessionParams, String string2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(elementsSessionParams, string2, (Function0<Long>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ElementsSession parse(@NotNull JSONObject json) {
        ElementsSession elementsSession;
        Object object;
        boolean disableLinkSignup;
        boolean linkPassthroughModeEnabled;
        JSONArray linkFundingSources;
        String externalPaymentMethodData;
        String paymentMethodSpecs;
        List unactivatedPaymentMethodTypes;
        String countryCode;
        JSONObject paymentMethodPreference;
        block8: {
            block7: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                paymentMethodPreference = StripeJsonUtils.INSTANCE.mapToJsonObject(StripeJsonUtils.INSTANCE.optMap(json, FIELD_PAYMENT_METHOD_PREFERENCE));
                String objectType = StripeJsonUtils.optString((JSONObject)paymentMethodPreference, (String)FIELD_OBJECT);
                if (paymentMethodPreference == null || !Intrinsics.areEqual((Object)FIELD_PAYMENT_METHOD_PREFERENCE, (Object)objectType)) {
                    return null;
                }
                countryCode = paymentMethodPreference.optString(FIELD_COUNTRY_CODE);
                Iterable iterable = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES));
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string3 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    collection.add(string3);
                }
                unactivatedPaymentMethodTypes = (List)destination$iv$iv;
                JSONArray jSONArray = json.optJSONArray(FIELD_PAYMENT_METHOD_SPECS);
                paymentMethodSpecs = jSONArray != null ? jSONArray.toString() : null;
                JSONArray jSONArray2 = json.optJSONArray(FIELD_EXTERNAL_PAYMENT_METHOD_DATA);
                externalPaymentMethodData = jSONArray2 != null ? jSONArray2.toString() : null;
                JSONObject jSONObject = json.optJSONObject(FIELD_LINK_SETTINGS);
                linkFundingSources = jSONObject != null ? jSONObject.optJSONArray(FIELD_LINK_FUNDING_SOURCES) : null;
                JSONObject $i$f$mapTo22 = json.optJSONObject(FIELD_LINK_SETTINGS);
                linkPassthroughModeEnabled = $i$f$mapTo22 != null ? $i$f$mapTo22.optBoolean(FIELD_LINK_PASSTHROUGH_MODE_ENABLED) : false;
                JSONObject jSONObject2 = json.optJSONObject(FIELD_LINK_SETTINGS);
                disableLinkSignup = jSONObject2 != null ? jSONObject2.optBoolean(FIELD_DISABLE_LINK_SIGNUP) : false;
                object = json.optJSONObject(FIELD_LINK_SETTINGS);
                if (object == null) break block7;
                JSONObject linkSettingsJson = object;
                boolean bl = false;
                Map<String, Boolean> map = this.parseLinkFlags(linkSettingsJson);
                object = map;
                if (map != null) break block8;
            }
            object = MapsKt.emptyMap();
        }
        Object linkFlags = object;
        JSONArray orderedPaymentMethodTypes = paymentMethodPreference.optJSONArray(FIELD_ORDERED_PAYMENT_METHOD_TYPES);
        String elementsSessionId = json.optString(FIELD_ELEMENTS_SESSION_ID);
        ElementsSession.Customer customer = this.parseCustomer(json.optJSONObject("customer"));
        Intrinsics.checkNotNull((Object)countryCode);
        StripeIntent stripeIntent = this.parseStripeIntent(elementsSessionId, paymentMethodPreference, orderedPaymentMethodTypes, unactivatedPaymentMethodTypes, linkFundingSources, countryCode);
        String merchantCountry = json.optString(FIELD_MERCHANT_COUNTRY);
        boolean isEligibleForCardBrandChoice = this.parseCardBrandChoiceEligibility(json);
        String googlePayPreference = json.optString(FIELD_GOOGLE_PAY_PREFERENCE);
        if (stripeIntent != null) {
            ElementsSession.LinkSettings linkSettings = new ElementsSession.LinkSettings(ModelJsonParser.Companion.jsonArrayToList(linkFundingSources), linkPassthroughModeEnabled, (Map<String, Boolean>)linkFlags, disableLinkSignup);
            boolean bl = !Intrinsics.areEqual((Object)googlePayPreference, (Object)"disabled");
            elementsSession = new ElementsSession(linkSettings, paymentMethodSpecs, externalPaymentMethodData, stripeIntent, customer, merchantCountry, isEligibleForCardBrandChoice, bl, null, 256, null);
        } else {
            elementsSession = null;
        }
        return elementsSession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final StripeIntent parseStripeIntent(String elementsSessionId, JSONObject paymentMethodPreference, JSONArray orderedPaymentMethodTypes, List<String> unactivatedPaymentMethodTypes, JSONArray linkFundingSources, String countryCode) {
        StripeIntent stripeIntent;
        JSONObject jSONObject = paymentMethodPreference;
        JSONObject jSONObject2 = jSONObject != null ? jSONObject.optJSONObject(this.params.getType()) : null;
        if (jSONObject2 == null) {
            jSONObject2 = new JSONObject();
        }
        JSONObject json = jSONObject2;
        boolean bl = false;
        JSONArray jSONArray = orderedPaymentMethodTypes;
        if (jSONArray != null) {
            JSONArray it = jSONArray;
            boolean bl2 = false;
            json.put(FIELD_PAYMENT_METHOD_TYPES, (Object)orderedPaymentMethodTypes);
        }
        json.put(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES, unactivatedPaymentMethodTypes);
        json.put(FIELD_LINK_FUNDING_SOURCES, (Object)linkFundingSources);
        json.put(FIELD_COUNTRY_CODE, (Object)countryCode);
        ElementsSessionParams elementsSessionParams = this.params;
        if (elementsSessionParams instanceof ElementsSessionParams.PaymentIntentType) {
            stripeIntent = new PaymentIntentJsonParser().parse(json);
            return stripeIntent;
        } else if (elementsSessionParams instanceof ElementsSessionParams.SetupIntentType) {
            stripeIntent = new SetupIntentJsonParser().parse(json);
            return stripeIntent;
        } else {
            if (!(elementsSessionParams instanceof ElementsSessionParams.DeferredIntentType)) throw new NoWhenBranchMatchedException();
            DeferredIntentParams.Mode mode = ((ElementsSessionParams.DeferredIntentType)this.params).getDeferredIntentParams().getMode();
            if (mode instanceof DeferredIntentParams.Mode.Payment) {
                stripeIntent = new DeferredPaymentIntentJsonParser(elementsSessionId, (DeferredIntentParams.Mode.Payment)((ElementsSessionParams.DeferredIntentType)this.params).getDeferredIntentParams().getMode(), this.apiKey, this.timeProvider).parse(json);
                return stripeIntent;
            } else {
                if (!(mode instanceof DeferredIntentParams.Mode.Setup)) throw new NoWhenBranchMatchedException();
                stripeIntent = new DeferredSetupIntentJsonParser(elementsSessionId, (DeferredIntentParams.Mode.Setup)((ElementsSessionParams.DeferredIntentType)this.params).getDeferredIntentParams().getMode(), this.apiKey, this.timeProvider).parse(json);
            }
        }
        return stripeIntent;
    }

    /*
     * WARNING - void declaration
     */
    private final ElementsSession.Customer parseCustomer(JSONObject json) {
        String string2;
        List list;
        JSONArray paymentMethodsJson;
        if (json == null) {
            return null;
        }
        JSONArray jSONArray = paymentMethodsJson = json.optJSONArray(FIELD_CUSTOMER_PAYMENT_METHODS);
        if (jSONArray != null) {
            void $this$mapNotNullTo$iv$iv;
            JSONArray pmsJson = jSONArray;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)pmsJson.length());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PaymentMethod it$iv$iv;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                int index = element$iv$iv;
                boolean bl3 = false;
                JSONObject jSONObject = pmsJson.optJSONObject(index);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"optJSONObject(...)");
                if (PAYMENT_METHOD_JSON_PARSER.parse(jSONObject) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List paymentMethods = list;
        ElementsSession.Customer.Session session = this.parseCustomerSession(json.optJSONObject(FIELD_CUSTOMER_SESSION));
        if (session == null) {
            return null;
        }
        ElementsSession.Customer.Session customerSession2 = session;
        String it = string2 = json.optString(FIELD_DEFAULT_PAYMENT_METHOD);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String defaultPaymentMethod = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        return new ElementsSession.Customer(paymentMethods, defaultPaymentMethod, customerSession2);
    }

    private final ElementsSession.Customer.Session parseCustomerSession(JSONObject json) {
        if (json == null) {
            return null;
        }
        String string2 = json.optString(FIELD_CUSTOMER_ID);
        if (string2 == null) {
            return null;
        }
        String id2 = string2;
        boolean liveMode = json.optBoolean(FIELD_CUSTOMER_LIVE_MODE);
        String string3 = json.optString(FIELD_CUSTOMER_API_KEY);
        if (string3 == null) {
            return null;
        }
        String apiKey = string3;
        int apiKeyExpiry = json.optInt(FIELD_CUSTOMER_API_KEY_EXPIRY);
        String string4 = json.optString("customer");
        if (string4 == null) {
            return null;
        }
        String name = string4;
        ElementsSession.Customer.Components components = this.parseComponents(json.optJSONObject(FIELD_COMPONENTS));
        if (components == null) {
            return null;
        }
        ElementsSession.Customer.Components components2 = components;
        return new ElementsSession.Customer.Session(id2, liveMode, apiKey, apiKeyExpiry, name, components2);
    }

    private final ElementsSession.Customer.Components parseComponents(JSONObject json) {
        if (json == null) {
            return null;
        }
        ElementsSession.Customer.Components.PaymentSheet paymentSheet = this.parsePaymentSheetComponent(json.optJSONObject(FIELD_PAYMENT_SHEET));
        if (paymentSheet == null) {
            return null;
        }
        ElementsSession.Customer.Components.PaymentSheet paymentSheetComponent = paymentSheet;
        ElementsSession.Customer.Components.CustomerSheet customerSheet = this.parseCustomerSheetComponent(json.optJSONObject(FIELD_CUSTOMER_SHEET));
        if (customerSheet == null) {
            return null;
        }
        ElementsSession.Customer.Components.CustomerSheet customerSheetComponent = customerSheet;
        return new ElementsSession.Customer.Components(paymentSheetComponent, customerSheetComponent);
    }

    private final ElementsSession.Customer.Components.PaymentSheet parsePaymentSheetComponent(JSONObject json) {
        ElementsSession.Customer.Components.PaymentSheet paymentSheet;
        if (json == null) {
            return null;
        }
        boolean paymentSheetEnabled = json.optBoolean("enabled");
        if (paymentSheetEnabled) {
            Object v1;
            String paymentMethodRemoveFeature;
            String paymentMethodSaveFeature;
            block5: {
                JSONObject jSONObject = json.optJSONObject(FIELD_FEATURES);
                if (jSONObject == null) {
                    return null;
                }
                JSONObject paymentSheetFeatures = jSONObject;
                paymentMethodSaveFeature = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_SAVE);
                paymentMethodRemoveFeature = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_REMOVE);
                String allowRedisplayOverrideValue = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_ALLOW_REDISPLAY_OVERRIDE);
                Iterable $this$firstOrNull$iv = (Iterable)PaymentMethod.AllowRedisplay.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethod.AllowRedisplay allowRedisplay = (PaymentMethod.AllowRedisplay)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)allowRedisplay.getValue$payments_core_release(), (Object)allowRedisplayOverrideValue)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            PaymentMethod.AllowRedisplay allowRedisplayOverride = v1;
            paymentSheet = new ElementsSession.Customer.Components.PaymentSheet.Enabled(Intrinsics.areEqual((Object)paymentMethodSaveFeature, (Object)"enabled"), Intrinsics.areEqual((Object)paymentMethodRemoveFeature, (Object)"enabled"), allowRedisplayOverride);
        } else {
            paymentSheet = ElementsSession.Customer.Components.PaymentSheet.Disabled.INSTANCE;
        }
        return paymentSheet;
    }

    private final ElementsSession.Customer.Components.CustomerSheet parseCustomerSheetComponent(JSONObject json) {
        ElementsSession.Customer.Components.CustomerSheet customerSheet;
        if (json == null) {
            return null;
        }
        boolean customerSheetEnabled = json.optBoolean("enabled");
        if (customerSheetEnabled) {
            JSONObject jSONObject = json.optJSONObject(FIELD_FEATURES);
            if (jSONObject == null) {
                return null;
            }
            JSONObject customerSheetFeatures = jSONObject;
            String paymentMethodRemoveFeature = customerSheetFeatures.optString(FIELD_PAYMENT_METHOD_REMOVE);
            customerSheet = new ElementsSession.Customer.Components.CustomerSheet.Enabled(Intrinsics.areEqual((Object)paymentMethodRemoveFeature, (Object)"enabled"));
        } else {
            customerSheet = ElementsSession.Customer.Components.CustomerSheet.Disabled.INSTANCE;
        }
        return customerSheet;
    }

    private final boolean parseCardBrandChoiceEligibility(JSONObject json) {
        JSONObject jSONObject = json.optJSONObject(FIELD_CARD_BRAND_CHOICE);
        if (jSONObject == null) {
            return false;
        }
        JSONObject cardBrandChoice = jSONObject;
        return cardBrandChoice.optBoolean(FIELD_ELIGIBLE, false);
    }

    private final Map<String, Boolean> parseLinkFlags(JSONObject json) {
        Map flags = new LinkedHashMap();
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String key = (String)element$iv;
            boolean bl = false;
            Object value = json.get(key);
            if (!(value instanceof Boolean)) continue;
            Intrinsics.checkNotNull((Object)key);
            flags.put(key, value);
        }
        return MapsKt.toMap((Map)flags);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/stripe/android/model/parsers/ElementsSessionJsonParser$Companion;", "", "()V", "FIELD_CARD_BRAND_CHOICE", "", "FIELD_COMPONENTS", "FIELD_COUNTRY_CODE", "FIELD_CUSTOMER", "FIELD_CUSTOMER_API_KEY", "FIELD_CUSTOMER_API_KEY_EXPIRY", "FIELD_CUSTOMER_ID", "FIELD_CUSTOMER_LIVE_MODE", "FIELD_CUSTOMER_NAME", "FIELD_CUSTOMER_PAYMENT_METHODS", "FIELD_CUSTOMER_SESSION", "FIELD_CUSTOMER_SHEET", "FIELD_DEFAULT_PAYMENT_METHOD", "FIELD_DISABLE_LINK_SIGNUP", "FIELD_ELEMENTS_SESSION_ID", "FIELD_ELIGIBLE", "FIELD_ENABLED", "FIELD_EXTERNAL_PAYMENT_METHOD_DATA", "FIELD_FEATURES", "FIELD_GOOGLE_PAY_PREFERENCE", "FIELD_LINK_FUNDING_SOURCES", "FIELD_LINK_PASSTHROUGH_MODE_ENABLED", "FIELD_LINK_SETTINGS", "FIELD_MERCHANT_COUNTRY", "FIELD_OBJECT", "FIELD_ORDERED_PAYMENT_METHOD_TYPES", "FIELD_PAYMENT_METHOD_ALLOW_REDISPLAY_OVERRIDE", "FIELD_PAYMENT_METHOD_PREFERENCE", "FIELD_PAYMENT_METHOD_REMOVE", "FIELD_PAYMENT_METHOD_SAVE", "FIELD_PAYMENT_METHOD_SPECS", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_PAYMENT_SHEET", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "PAYMENT_METHOD_JSON_PARSER", "Lcom/stripe/android/model/parsers/PaymentMethodJsonParser;", "VALUE_ENABLED", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

