/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import android.net.Uri;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.MicrodepositType;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.WeChat;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000e\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "()V", "parse", "json", "Lorg/json/JSONObject;", "AlipayRedirectParser", "BlikAuthorizeParser", "CashAppRedirectParser", "Companion", "DisplayBoletoDetailsJsonParser", "DisplayKonbiniDetailsJsonParser", "DisplayMultibancoDetailsJsonParser", "DisplayOxxoDetailsJsonParser", "RedirectToUrlParser", "SdkDataJsonParser", "SwishRedirectParser", "UpiAwaitNotificationParser", "VerifyWithMicrodepositsParser", "WeChatPayRedirectParser", "payments-core_release"})
@StabilityInferred(parameters=1)
public final class NextActionDataParser
implements ModelJsonParser<StripeIntent.NextActionData> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String FIELD_NEXT_ACTION_TYPE = "type";

    @Nullable
    public StripeIntent.NextActionData parse(@NotNull JSONObject json) {
        ModelJsonParser modelJsonParser;
        StripeIntent.NextActionType nextActionType;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        StripeIntent.NextActionType nextActionType2 = nextActionType = StripeIntent.NextActionType.Companion.fromCode$payments_core_release(json.optString(FIELD_NEXT_ACTION_TYPE));
        switch (nextActionType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[nextActionType2.ordinal()]) {
            case 1: {
                modelJsonParser = new DisplayOxxoDetailsJsonParser();
                break;
            }
            case 2: {
                modelJsonParser = new DisplayBoletoDetailsJsonParser();
                break;
            }
            case 3: {
                modelJsonParser = new DisplayKonbiniDetailsJsonParser();
                break;
            }
            case 4: {
                modelJsonParser = new DisplayMultibancoDetailsJsonParser();
                break;
            }
            case 5: {
                modelJsonParser = new RedirectToUrlParser();
                break;
            }
            case 6: {
                modelJsonParser = new SdkDataJsonParser();
                break;
            }
            case 7: {
                modelJsonParser = new AlipayRedirectParser();
                break;
            }
            case 8: {
                modelJsonParser = new BlikAuthorizeParser();
                break;
            }
            case 9: {
                modelJsonParser = new WeChatPayRedirectParser();
                break;
            }
            case 10: {
                modelJsonParser = new VerifyWithMicrodepositsParser();
                break;
            }
            case 11: {
                modelJsonParser = new UpiAwaitNotificationParser();
                break;
            }
            case 12: {
                modelJsonParser = new CashAppRedirectParser();
                break;
            }
            case 13: {
                modelJsonParser = new SwishRedirectParser();
                break;
            }
            case -1: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ModelJsonParser parser = modelJsonParser;
        JSONObject jSONObject = json.optJSONObject(nextActionType.getCode());
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return (StripeIntent.NextActionData)parser.parse(jSONObject);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$AlipayRedirectParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$AlipayRedirect;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class AlipayRedirectParser
    implements ModelJsonParser<StripeIntent.NextActionData.AlipayRedirect> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @Deprecated
        @NotNull
        public static final String FIELD_NATIVE_DATA = "native_data";
        @Deprecated
        @NotNull
        public static final String FIELD_RETURN_URL = "return_url";
        @Deprecated
        @NotNull
        public static final String FIELD_URL = "url";

        @NotNull
        public StripeIntent.NextActionData.AlipayRedirect parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = json.getString(FIELD_NATIVE_DATA);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            String string3 = json.getString(FIELD_URL);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            return new StripeIntent.NextActionData.AlipayRedirect(string2, string3, StripeJsonUtils.optString((JSONObject)json, (String)FIELD_RETURN_URL));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$AlipayRedirectParser$Companion;", "", "()V", "FIELD_NATIVE_DATA", "", "FIELD_RETURN_URL", "FIELD_URL", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$BlikAuthorizeParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$BlikAuthorize;", "()V", "parse", "json", "Lorg/json/JSONObject;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class BlikAuthorizeParser
    implements ModelJsonParser<StripeIntent.NextActionData.BlikAuthorize> {
        public static final int $stable;

        @NotNull
        public StripeIntent.NextActionData.BlikAuthorize parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return StripeIntent.NextActionData.BlikAuthorize.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$CashAppRedirectParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$CashAppRedirect;", "()V", "parse", "json", "Lorg/json/JSONObject;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class CashAppRedirectParser
    implements ModelJsonParser<StripeIntent.NextActionData.CashAppRedirect> {
        public static final int $stable;

        @NotNull
        public StripeIntent.NextActionData.CashAppRedirect parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = json.optString("mobile_auth_url");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(...)");
            return new StripeIntent.NextActionData.CashAppRedirect(string2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$Companion;", "", "()V", "FIELD_NEXT_ACTION_TYPE", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayBoletoDetailsJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayBoletoDetails;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    private static final class DisplayBoletoDetailsJsonParser
    implements ModelJsonParser<StripeIntent.NextActionData.DisplayBoletoDetails> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final String FIELD_HOSTED_VOUCHER_URL = "hosted_voucher_url";

        @NotNull
        public StripeIntent.NextActionData.DisplayBoletoDetails parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new StripeIntent.NextActionData.DisplayBoletoDetails(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_HOSTED_VOUCHER_URL));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayBoletoDetailsJsonParser$Companion;", "", "()V", "FIELD_HOSTED_VOUCHER_URL", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayKonbiniDetailsJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayKonbiniDetails;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    private static final class DisplayKonbiniDetailsJsonParser
    implements ModelJsonParser<StripeIntent.NextActionData.DisplayKonbiniDetails> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final String FIELD_HOSTED_VOUCHER_URL = "hosted_voucher_url";

        @NotNull
        public StripeIntent.NextActionData.DisplayKonbiniDetails parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new StripeIntent.NextActionData.DisplayKonbiniDetails(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_HOSTED_VOUCHER_URL));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayKonbiniDetailsJsonParser$Companion;", "", "()V", "FIELD_HOSTED_VOUCHER_URL", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayMultibancoDetailsJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayMultibancoDetails;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    private static final class DisplayMultibancoDetailsJsonParser
    implements ModelJsonParser<StripeIntent.NextActionData.DisplayMultibancoDetails> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final String FIELD_HOSTED_VOUCHER_URL = "hosted_voucher_url";

        @NotNull
        public StripeIntent.NextActionData.DisplayMultibancoDetails parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new StripeIntent.NextActionData.DisplayMultibancoDetails(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_HOSTED_VOUCHER_URL));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayMultibancoDetailsJsonParser$Companion;", "", "()V", "FIELD_HOSTED_VOUCHER_URL", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayOxxoDetailsJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$DisplayOxxoDetails;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    private static final class DisplayOxxoDetailsJsonParser
    implements ModelJsonParser<StripeIntent.NextActionData.DisplayOxxoDetails> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final String FIELD_EXPIRES_AFTER = "expires_after";
        @NotNull
        private static final String FIELD_NUMBER = "number";
        @NotNull
        private static final String FIELD_HOSTED_VOUCHER_URL = "hosted_voucher_url";

        @NotNull
        public StripeIntent.NextActionData.DisplayOxxoDetails parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new StripeIntent.NextActionData.DisplayOxxoDetails(json.optInt(FIELD_EXPIRES_AFTER), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NUMBER), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_HOSTED_VOUCHER_URL));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$DisplayOxxoDetailsJsonParser$Companion;", "", "()V", "FIELD_EXPIRES_AFTER", "", "FIELD_HOSTED_VOUCHER_URL", "FIELD_NUMBER", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$RedirectToUrlParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$RedirectToUrl;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class RedirectToUrlParser
    implements ModelJsonParser<StripeIntent.NextActionData.RedirectToUrl> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @Deprecated
        @NotNull
        public static final String FIELD_URL = "url";
        @Deprecated
        @NotNull
        public static final String FIELD_RETURN_URL = "return_url";

        @Nullable
        public StripeIntent.NextActionData.RedirectToUrl parse(@NotNull JSONObject json) {
            StripeIntent.NextActionData.RedirectToUrl redirectToUrl;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            if (json.has(FIELD_URL)) {
                Uri uri = Uri.parse((String)json.getString(FIELD_URL));
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
                redirectToUrl = new StripeIntent.NextActionData.RedirectToUrl(uri, json.optString(FIELD_RETURN_URL));
            } else {
                redirectToUrl = null;
            }
            return redirectToUrl;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$RedirectToUrlParser$Companion;", "", "()V", "FIELD_RETURN_URL", "", "FIELD_URL", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$SdkDataJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData;", "()V", "parse", "json", "Lorg/json/JSONObject;", "parseDirectoryServerEncryption", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2$DirectoryServerEncryption;", "Companion", "payments-core_release"})
    @SourceDebugExtension(value={"SMAP\nNextActionDataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextActionDataParser.kt\ncom/stripe/android/model/parsers/NextActionDataParser$SdkDataJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n1789#2,3:300\n*S KotlinDebug\n*F\n+ 1 NextActionDataParser.kt\ncom/stripe/android/model/parsers/NextActionDataParser$SdkDataJsonParser\n*L\n168#1:300,3\n*E\n"})
    private static final class SdkDataJsonParser
    implements ModelJsonParser<StripeIntent.NextActionData.SdkData> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final String FIELD_TYPE = "type";
        @NotNull
        private static final String TYPE_3DS2 = "stripe_3ds2_fingerprint";
        @NotNull
        private static final String TYPE_3DS1 = "three_d_secure_redirect";
        @NotNull
        private static final String FIELD_THREE_D_SECURE_2_SOURCE = "three_d_secure_2_source";
        @NotNull
        private static final String FIELD_DIRECTORY_SERVER_NAME = "directory_server_name";
        @NotNull
        private static final String FIELD_SERVER_TRANSACTION_ID = "server_transaction_id";
        @NotNull
        private static final String FIELD_DIRECTORY_SERVER_ENCRYPTION = "directory_server_encryption";
        @NotNull
        private static final String FIELD_DIRECTORY_SERVER_ID = "directory_server_id";
        @NotNull
        private static final String FIELD_CERTIFICATE = "certificate";
        @NotNull
        private static final String FIELD_KEY_ID = "key_id";
        @NotNull
        private static final String FIELD_ROOT_CAS = "root_certificate_authorities";
        @NotNull
        private static final String FIELD_THREE_D_SECURE_2_INTENT = "three_d_secure_2_intent";
        @NotNull
        private static final String FIELD_PUBLISHABLE_KEY = "publishable_key";
        @NotNull
        private static final String FIELD_STRIPE_JS = "stripe_js";

        @Nullable
        public StripeIntent.NextActionData.SdkData parse(@NotNull JSONObject json) {
            StripeIntent.NextActionData.SdkData sdkData;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)"type");
            if (Intrinsics.areEqual((Object)string2, (Object)TYPE_3DS1)) {
                String string3 = json.optString(FIELD_STRIPE_JS);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"optString(...)");
                sdkData = new StripeIntent.NextActionData.SdkData.Use3DS1(string3);
            } else if (Intrinsics.areEqual((Object)string2, (Object)TYPE_3DS2)) {
                String string4 = json.optString(FIELD_THREE_D_SECURE_2_SOURCE);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"optString(...)");
                String string5 = json.optString(FIELD_DIRECTORY_SERVER_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"optString(...)");
                String string6 = json.optString(FIELD_SERVER_TRANSACTION_ID);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"optString(...)");
                JSONObject jSONObject = json.optJSONObject(FIELD_DIRECTORY_SERVER_ENCRYPTION);
                sdkData = new StripeIntent.NextActionData.SdkData.Use3DS2(string4, string5, string6, this.parseDirectoryServerEncryption(jSONObject == null ? new JSONObject() : jSONObject), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_THREE_D_SECURE_2_INTENT), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PUBLISHABLE_KEY));
            } else {
                sdkData = null;
            }
            return sdkData;
        }

        /*
         * Unable to fully structure code
         */
        private final StripeIntent.NextActionData.SdkData.Use3DS2.DirectoryServerEncryption parseDirectoryServerEncryption(JSONObject json) {
            var3_2 = StripeJsonUtils.INSTANCE.jsonArrayToList(json.optJSONArray("root_certificate_authorities"));
            if (var3_2 == null) ** GOTO lbl-1000
            var5_3 = var3_2;
            initial$iv = CollectionsKt.emptyList();
            $i$f$fold = false;
            accumulator$iv = initial$iv;
            var9_7 = $this$fold$iv.iterator();
            while (var9_7.hasNext()) {
                var11_9 = element$iv = var9_7.next();
                acc = accumulator$iv;
                $i$a$-fold-NextActionDataParser$SdkDataJsonParser$parseDirectoryServerEncryption$rootCert$1 = false;
                accumulator$iv = entry instanceof String ? CollectionsKt.plus((Collection)acc, (Object)entry) : acc;
            }
            var4_12 = accumulator$iv;
            if (var4_12 != null) {
                v0 = var4_12;
            } else lbl-1000:
            // 2 sources

            {
                v0 = CollectionsKt.emptyList();
            }
            rootCert = v0;
            v1 = json.optString("directory_server_id");
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"optString(...)");
            v2 = json.optString("certificate");
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"optString(...)");
            return new StripeIntent.NextActionData.SdkData.Use3DS2.DirectoryServerEncryption(v1, v2, rootCert, json.optString("key_id"));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$SdkDataJsonParser$Companion;", "", "()V", "FIELD_CERTIFICATE", "", "FIELD_DIRECTORY_SERVER_ENCRYPTION", "FIELD_DIRECTORY_SERVER_ID", "FIELD_DIRECTORY_SERVER_NAME", "FIELD_KEY_ID", "FIELD_PUBLISHABLE_KEY", "FIELD_ROOT_CAS", "FIELD_SERVER_TRANSACTION_ID", "FIELD_STRIPE_JS", "FIELD_THREE_D_SECURE_2_INTENT", "FIELD_THREE_D_SECURE_2_SOURCE", "FIELD_TYPE", "TYPE_3DS1", "TYPE_3DS2", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$SwishRedirectParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$SwishRedirect;", "()V", "parse", "json", "Lorg/json/JSONObject;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class SwishRedirectParser
    implements ModelJsonParser<StripeIntent.NextActionData.SwishRedirect> {
        public static final int $stable;

        @NotNull
        public StripeIntent.NextActionData.SwishRedirect parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = json.optString("mobile_auth_url");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(...)");
            return new StripeIntent.NextActionData.SwishRedirect(string2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$UpiAwaitNotificationParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$UpiAwaitNotification;", "()V", "parse", "json", "Lorg/json/JSONObject;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class UpiAwaitNotificationParser
    implements ModelJsonParser<StripeIntent.NextActionData.UpiAwaitNotification> {
        public static final int $stable;

        @NotNull
        public StripeIntent.NextActionData.UpiAwaitNotification parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return StripeIntent.NextActionData.UpiAwaitNotification.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$VerifyWithMicrodepositsParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$VerifyWithMicrodeposits;", "()V", "parse", "json", "Lorg/json/JSONObject;", "parseMicrodepositType", "Lcom/stripe/android/model/MicrodepositType;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class VerifyWithMicrodepositsParser
    implements ModelJsonParser<StripeIntent.NextActionData.VerifyWithMicrodeposits> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String ARRIVAL_DATE = "arrival_date";
        @NotNull
        private static final String HOSTED_VERIFICATION_URL = "hosted_verification_url";
        @NotNull
        private static final String MICRODEPOSIT_TYPE = "microdeposit_type";

        @NotNull
        public StripeIntent.NextActionData.VerifyWithMicrodeposits parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            long l = json.optLong(ARRIVAL_DATE);
            String string2 = json.optString(HOSTED_VERIFICATION_URL);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(...)");
            return new StripeIntent.NextActionData.VerifyWithMicrodeposits(l, string2, this.parseMicrodepositType(json));
        }

        private final MicrodepositType parseMicrodepositType(JSONObject json) {
            MicrodepositType microdepositType;
            Object v0;
            block2: {
                Iterable iterable = (Iterable)MicrodepositType.getEntries();
                for (Object t : iterable) {
                    MicrodepositType it = (MicrodepositType)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getValue(), (Object)json.optString(MICRODEPOSIT_TYPE))) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((microdepositType = (MicrodepositType)v0) == null) {
                microdepositType = MicrodepositType.UNKNOWN;
            }
            return microdepositType;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$VerifyWithMicrodepositsParser$Companion;", "", "()V", "ARRIVAL_DATE", "", "HOSTED_VERIFICATION_URL", "MICRODEPOSIT_TYPE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$WeChatPayRedirectParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/StripeIntent$NextActionData$WeChatPayRedirect;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class WeChatPayRedirectParser
    implements ModelJsonParser<StripeIntent.NextActionData.WeChatPayRedirect> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String APP_ID = "app_id";
        @NotNull
        private static final String NONCE_STR = "nonce_str";
        @NotNull
        private static final String PACKAGE = "package";
        @NotNull
        private static final String PARTNER_ID = "partner_id";
        @NotNull
        private static final String PREPAY_ID = "prepay_id";
        @NotNull
        private static final String TIMESTAMP = "timestamp";
        @NotNull
        private static final String SIGN = "sign";

        @NotNull
        public StripeIntent.NextActionData.WeChatPayRedirect parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = json.optString(APP_ID);
            String string3 = json.optString(NONCE_STR);
            String string4 = json.optString(PACKAGE);
            String string5 = json.optString(PARTNER_ID);
            String string6 = json.optString(PREPAY_ID);
            String string7 = json.optString(TIMESTAMP);
            String string8 = json.optString(SIGN);
            return new StripeIntent.NextActionData.WeChatPayRedirect(new WeChat(null, string2, string3, string4, string5, string6, string8, string7, null, 257, null));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/parsers/NextActionDataParser$WeChatPayRedirectParser$Companion;", "", "()V", "APP_ID", "", "NONCE_STR", "PACKAGE", "PARTNER_ID", "PREPAY_ID", "SIGN", "TIMESTAMP", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StripeIntent.NextActionType.values().length];
            try {
                nArray[StripeIntent.NextActionType.DisplayOxxoDetails.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.DisplayBoletoDetails.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.DisplayKonbiniDetails.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.DisplayMultibancoDetails.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.RedirectToUrl.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.UseStripeSdk.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.AlipayRedirect.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.BlikAuthorize.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.WeChatPayRedirect.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.VerifyWithMicrodeposits.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.UpiAwaitNotification.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.CashAppRedirect.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.SwishRedirect.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

