/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.Address;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.NextActionDataParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "ErrorJsonParser", "ShippingJsonParser", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nPaymentIntentJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentIntentJsonParser.kt\ncom/stripe/android/model/parsers/PaymentIntentJsonParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1#2:191\n1549#3:192\n1620#3,3:193\n*S KotlinDebug\n*F\n+ 1 PaymentIntentJsonParser.kt\ncom/stripe/android/model/parsers/PaymentIntentJsonParser\n*L\n76#1:192\n76#1:193,3\n*E\n"})
public final class PaymentIntentJsonParser
implements ModelJsonParser<PaymentIntent> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String OBJECT_TYPE = "payment_intent";
    @NotNull
    private static final String FIELD_ID = "id";
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @NotNull
    private static final String FIELD_AMOUNT = "amount";
    @NotNull
    private static final String FIELD_CREATED = "created";
    @NotNull
    private static final String FIELD_CANCELED_AT = "canceled_at";
    @NotNull
    private static final String FIELD_CANCELLATION_REASON = "cancellation_reason";
    @NotNull
    private static final String FIELD_CAPTURE_METHOD = "capture_method";
    @NotNull
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    @NotNull
    private static final String FIELD_CONFIRMATION_METHOD = "confirmation_method";
    @NotNull
    private static final String FIELD_COUNTRY_CODE = "country_code";
    @NotNull
    private static final String FIELD_CURRENCY = "currency";
    @NotNull
    private static final String FIELD_DESCRIPTION = "description";
    @NotNull
    private static final String FIELD_LAST_PAYMENT_ERROR = "last_payment_error";
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @NotNull
    private static final String FIELD_NEXT_ACTION = "next_action";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD = "payment_method";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_OPTIONS = "payment_method_options";
    @NotNull
    private static final String FIELD_RECEIPT_EMAIL = "receipt_email";
    @NotNull
    private static final String FIELD_SHIPPING = "shipping";
    @NotNull
    private static final String FIELD_STATUS = "status";
    @NotNull
    private static final String FIELD_SETUP_FUTURE_USAGE = "setup_future_usage";
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";
    @NotNull
    private static final String FIELD_LINK_FUNDING_SOURCES = "link_funding_sources";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PaymentIntent parse(@NotNull JSONObject json) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StripeIntent.NextActionData nextActionData;
        PaymentIntent.Shipping shipping;
        PaymentIntent.Error error;
        PaymentMethod paymentMethod;
        Object it;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String objectType = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_OBJECT);
        if (!Intrinsics.areEqual((Object)OBJECT_TYPE, (Object)objectType)) {
            return null;
        }
        String id2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ID);
        List paymentMethodTypes = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        Long amount = StripeJsonUtils.INSTANCE.optLong(json, FIELD_AMOUNT);
        long canceledAt = json.optLong(FIELD_CANCELED_AT);
        PaymentIntent.CancellationReason cancellationReason = PaymentIntent.CancellationReason.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CANCELLATION_REASON));
        PaymentIntent.CaptureMethod captureMethod = PaymentIntent.CaptureMethod.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CAPTURE_METHOD));
        String clientSecret = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CLIENT_SECRET);
        PaymentIntent.ConfirmationMethod confirmationMethod = PaymentIntent.ConfirmationMethod.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CONFIRMATION_METHOD));
        long created = json.optLong(FIELD_CREATED);
        String currency = StripeJsonUtils.optCurrency((JSONObject)json, (String)FIELD_CURRENCY);
        String description = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DESCRIPTION);
        boolean livemode = StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_LIVEMODE);
        JSONObject jSONObject = json.optJSONObject(FIELD_PAYMENT_METHOD);
        if (jSONObject != null) {
            it = jSONObject;
            boolean bl = false;
            paymentMethod = new PaymentMethodJsonParser().parse((JSONObject)it);
        } else {
            paymentMethod = null;
        }
        PaymentMethod paymentMethod2 = paymentMethod;
        Object it2 = it = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAYMENT_METHOD);
        boolean bl = false;
        Object object = paymentMethod2 == null ? it : null;
        if (object == null) {
            PaymentMethod paymentMethod3 = paymentMethod2;
            object = paymentMethod3 != null ? paymentMethod3.id : null;
        }
        Object paymentMethodId = object;
        String receiptEmail = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_RECEIPT_EMAIL);
        StripeIntent.Status status = StripeIntent.Status.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_STATUS));
        JSONObject jSONObject2 = json.optJSONObject(FIELD_PAYMENT_METHOD_OPTIONS);
        String paymentMethodOptions = jSONObject2 != null ? jSONObject2.toString() : null;
        StripeIntent.Usage setupFutureUsage = StripeIntent.Usage.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_SETUP_FUTURE_USAGE));
        JSONObject jSONObject3 = json.optJSONObject(FIELD_LAST_PAYMENT_ERROR);
        if (jSONObject3 != null) {
            JSONObject it3 = jSONObject3;
            boolean bl2 = false;
            error = new ErrorJsonParser().parse(it3);
        } else {
            error = null;
        }
        PaymentIntent.Error lastPaymentError = error;
        JSONObject jSONObject4 = json.optJSONObject(FIELD_SHIPPING);
        if (jSONObject4 != null) {
            JSONObject it4 = jSONObject4;
            boolean bl3 = false;
            shipping = new ShippingJsonParser().parse(it4);
        } else {
            shipping = null;
        }
        PaymentIntent.Shipping shipping2 = shipping;
        JSONObject jSONObject5 = json.optJSONObject(FIELD_NEXT_ACTION);
        if (jSONObject5 != null) {
            JSONObject it5 = jSONObject5;
            boolean bl4 = false;
            nextActionData = new NextActionDataParser().parse(it5);
        } else {
            nextActionData = null;
        }
        StripeIntent.NextActionData nextActionData2 = nextActionData;
        List unactivatedPaymentMethods = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES));
        Iterable it5 = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_LINK_FUNDING_SOURCES));
        boolean $i$f$map = false;
        void var30_34 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it6;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            String string3 = it6.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(string3);
        }
        List linkFundingSources = (List)destination$iv$iv;
        String countryCode = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY_CODE);
        return new PaymentIntent(id2, paymentMethodTypes, amount, canceledAt, cancellationReason, captureMethod, clientSecret, confirmationMethod, countryCode, created, currency, description, livemode, paymentMethod2, (String)paymentMethodId, receiptEmail, status, setupFutureUsage, lastPaymentError, shipping2, unactivatedPaymentMethods, linkFundingSources, nextActionData2, paymentMethodOptions);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0019\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CANCELED_AT", "FIELD_CANCELLATION_REASON", "FIELD_CAPTURE_METHOD", "FIELD_CLIENT_SECRET", "FIELD_CONFIRMATION_METHOD", "FIELD_COUNTRY_CODE", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_DESCRIPTION", "FIELD_ID", "FIELD_LAST_PAYMENT_ERROR", "FIELD_LINK_FUNDING_SOURCES", "FIELD_LIVEMODE", "FIELD_NEXT_ACTION", "FIELD_OBJECT", "FIELD_PAYMENT_METHOD", "FIELD_PAYMENT_METHOD_OPTIONS", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_RECEIPT_EMAIL", "FIELD_SETUP_FUTURE_USAGE", "FIELD_SHIPPING", "FIELD_STATUS", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "OBJECT_TYPE", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ErrorJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent$Error;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class ErrorJsonParser
    implements ModelJsonParser<PaymentIntent.Error> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_CHARGE = "charge";
        @NotNull
        private static final String FIELD_CODE = "code";
        @NotNull
        private static final String FIELD_DECLINE_CODE = "decline_code";
        @NotNull
        private static final String FIELD_DOC_URL = "doc_url";
        @NotNull
        private static final String FIELD_MESSAGE = "message";
        @NotNull
        private static final String FIELD_PARAM = "param";
        @NotNull
        private static final String FIELD_PAYMENT_METHOD = "payment_method";
        @NotNull
        private static final String FIELD_TYPE = "type";

        /*
         * WARNING - void declaration
         */
        @NotNull
        public PaymentIntent.Error parse(@NotNull JSONObject json) {
            PaymentMethod paymentMethod;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CHARGE);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CODE);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DECLINE_CODE);
            String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DOC_URL);
            String string6 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_MESSAGE);
            String string7 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PARAM);
            JSONObject jSONObject = json.optJSONObject("payment_method");
            if (jSONObject != null) {
                void it;
                JSONObject jSONObject2 = jSONObject;
                String string8 = string7;
                String string9 = string6;
                String string10 = string5;
                String string11 = string4;
                String string12 = string3;
                String string13 = string2;
                boolean bl = false;
                PaymentMethod paymentMethod2 = new PaymentMethodJsonParser().parse((JSONObject)it);
                string2 = string13;
                string3 = string12;
                string4 = string11;
                string5 = string10;
                string6 = string9;
                string7 = string8;
                paymentMethod = paymentMethod2;
            } else {
                paymentMethod = null;
            }
            PaymentIntent.Error.Type type = PaymentIntent.Error.Type.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TYPE));
            PaymentMethod paymentMethod3 = paymentMethod;
            String string14 = string7;
            String string15 = string6;
            String string16 = string5;
            String string17 = string4;
            String string18 = string3;
            String string19 = string2;
            return new PaymentIntent.Error(string19, string18, string17, string16, string15, string14, paymentMethod3, type);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ErrorJsonParser$Companion;", "", "()V", "FIELD_CHARGE", "", "FIELD_CODE", "FIELD_DECLINE_CODE", "FIELD_DOC_URL", "FIELD_MESSAGE", "FIELD_PARAM", "FIELD_PAYMENT_METHOD", "FIELD_TYPE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ShippingJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent$Shipping;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class ShippingJsonParser
    implements ModelJsonParser<PaymentIntent.Shipping> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @NotNull
        private static final String FIELD_CARRIER = "carrier";
        @NotNull
        private static final String FIELD_NAME = "name";
        @NotNull
        private static final String FIELD_PHONE = "phone";
        @NotNull
        private static final String FIELD_TRACKING_NUMBER = "tracking_number";

        @NotNull
        public PaymentIntent.Shipping parse(@NotNull JSONObject json) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                    object = json.optJSONObject(FIELD_ADDRESS);
                    if (object == null) break block2;
                    JSONObject it = object;
                    boolean bl = false;
                    Address address = new AddressJsonParser().parse(it);
                    object = address;
                    if (address != null) break block3;
                }
                object = new Address(null, null, null, null, null, null, 63, null);
            }
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TRACKING_NUMBER);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PHONE);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NAME);
            String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CARRIER);
            Object object2 = object;
            return new PaymentIntent.Shipping((Address)object2, string5, string4, string3, string2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ShippingJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_CARRIER", "FIELD_NAME", "FIELD_PHONE", "FIELD_TRACKING_NUMBER", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

