/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.payments.StripeBrowserLauncherActivity;
import com.stripe.android.payments.StripeBrowserLauncherViewModel;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "viewModel", "Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "getViewModel", "()Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "finishWithFailure", "", "args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "finishWithSuccess", "launchBrowser", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStripeBrowserLauncherActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StripeBrowserLauncherActivity.kt\ncom/stripe/android/payments/StripeBrowserLauncherActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,88:1\n75#2,13:89\n*S KotlinDebug\n*F\n+ 1 StripeBrowserLauncherActivity.kt\ncom/stripe/android/payments/StripeBrowserLauncherActivity\n*L\n27#1:89,13\n*E\n"})
public final class StripeBrowserLauncherActivity
extends AppCompatActivity {
    @NotNull
    private final Lazy viewModel$delegate;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public StripeBrowserLauncherActivity() {
        void $this$viewModels_u24default$iv;
        ComponentActivity componentActivity = (ComponentActivity)this;
        Function0 factoryProducer$iv = viewModel.2.INSTANCE;
        Function0 extrasProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 function0 = factoryProducer$iv;
        if (function0 == null) {
            function0 = (Function0)new Function0<ViewModelProvider.Factory>((ComponentActivity)$this$viewModels_u24default$iv){
                final /* synthetic */ ComponentActivity $this_viewModels;
                {
                    this.$this_viewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    return this.$this_viewModels.getDefaultViewModelProviderFactory();
                }
            };
        }
        Function0 factoryPromise$iv = function0;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(StripeBrowserLauncherViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, (ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
    }

    private final StripeBrowserLauncherViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (StripeBrowserLauncherViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        PaymentBrowserAuthContract.Args args2 = PaymentBrowserAuthContract.Companion.parseArgs$payments_core_release(intent);
        if (args2 == null) {
            this.finish();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.BROWSER_LAUNCHER_NULL_ARGS, null, null, 6, null);
            return;
        }
        if (this.getViewModel().getHasLaunched()) {
            this.finishWithSuccess(args2);
        } else {
            this.launchBrowser(args2);
        }
    }

    private final void launchBrowser(PaymentBrowserAuthContract.Args args2) {
        ActivityResultContracts.StartActivityForResult contract = new ActivityResultContracts.StartActivityForResult();
        ActivityResultLauncher activityResultLauncher2 = this.registerForActivityResult((ActivityResultContract)contract, arg_0 -> StripeBrowserLauncherActivity.launchBrowser$lambda$0(this, args2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher2, (String)"registerForActivityResult(...)");
        ActivityResultLauncher launcher = activityResultLauncher2;
        Intent intent = this.getViewModel().createLaunchIntent(args2);
        try {
            launcher.launch((Object)intent);
            this.getViewModel().setHasLaunched(true);
        }
        catch (ActivityNotFoundException e) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.BROWSER_LAUNCHER_ACTIVITY_NOT_FOUND, StripeException.Companion.create((Throwable)e), null, 4, null);
            this.finishWithFailure(args2);
        }
    }

    private final void finishWithSuccess(PaymentBrowserAuthContract.Args args2) {
        this.setResult(-1, this.getViewModel().getResultIntent(args2));
        this.finish();
    }

    private final void finishWithFailure(PaymentBrowserAuthContract.Args args2) {
        this.setResult(-1, this.getViewModel().getFailureIntent(args2));
        this.finish();
    }

    private static final void launchBrowser$lambda$0(StripeBrowserLauncherActivity this$0, PaymentBrowserAuthContract.Args $args, ActivityResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$args, (String)"$args");
        this$0.finishWithSuccess($args);
    }
}

