/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.databinding.StripeCardBrandViewBinding;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BrandAdapter;
import com.stripe.android.view.CardBrandSelectorKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002FGB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00108\u001a\u0004\u0018\u000109J\b\u0010:\u001a\u00020;H\u0002J\u0012\u0010<\u001a\u00020;2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010=\u001a\u00020;H\u0002J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020@H\u0002J\u0012\u0010A\u001a\u00020;2\b\u0010*\u001a\u0004\u0018\u00010BH\u0014J\b\u0010C\u001a\u00020BH\u0014J\b\u0010D\u001a\u00020;H\u0002J\b\u0010E\u001a\u00020;H\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR0\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR$\u0010#\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u0015\"\u0004\b%\u0010\u0017R$\u0010&\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0015\"\u0004\b(\u0010\u0017R$\u0010*\u001a\u00020)2\u0006\u0010\t\u001a\u00020)8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020)00X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/stripe/android/view/CardBrandView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "Lcom/stripe/android/model/CardBrand;", "brand", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "setBrand", "(Lcom/stripe/android/model/CardBrand;)V", "chevron", "Landroid/widget/ImageView;", "iconView", "", "isCbcEligible", "()Z", "setCbcEligible", "(Z)V", "listPopup", "Landroid/widget/ListPopupWindow;", "", "merchantPreferredNetworks", "getMerchantPreferredNetworks", "()Ljava/util/List;", "setMerchantPreferredNetworks", "(Ljava/util/List;)V", "possibleBrands", "getPossibleBrands", "setPossibleBrands", "shouldShowCvc", "getShouldShowCvc", "setShouldShowCvc", "shouldShowErrorIcon", "getShouldShowErrorIcon", "setShouldShowErrorIcon", "Lcom/stripe/android/view/CardBrandView$State;", "state", "getState", "()Lcom/stripe/android/view/CardBrandView$State;", "setState", "(Lcom/stripe/android/view/CardBrandView$State;)V", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "tintColorInt", "getTintColorInt$payments_core_release", "()I", "setTintColorInt$payments_core_release", "(I)V", "viewBinding", "Lcom/stripe/android/databinding/StripeCardBrandViewBinding;", "createNetworksParam", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card$Networks;", "determineCardBrandToDisplay", "", "handleBrandSelected", "initListPopup", "measureContentWidth", "adapter", "Lcom/stripe/android/view/BrandAdapter;", "onRestoreInstanceState", "Landroid/os/Parcelable;", "onSaveInstanceState", "setCardBrandIconAndTint", "updateBrandSpinner", "SavedState", "State", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCardBrandView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardBrandView.kt\ncom/stripe/android/view/CardBrandView\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n230#2,5:287\n230#2,5:292\n230#2,5:297\n230#2,5:302\n230#2,5:307\n230#2,5:312\n230#2,5:317\n230#2,5:323\n1#3:322\n*S KotlinDebug\n*F\n+ 1 CardBrandView.kt\ncom/stripe/android/view/CardBrandView\n*L\n61#1:287,5\n68#1:292,5\n76#1:297,5\n84#1:302,5\n91#1:307,5\n98#1:312,5\n105#1:317,5\n126#1:323,5\n*E\n"})
public final class CardBrandView
extends FrameLayout {
    @NotNull
    private final StripeCardBrandViewBinding viewBinding;
    @NotNull
    private final ImageView iconView;
    @NotNull
    private final ImageView chevron;
    @NotNull
    private final ListPopupWindow listPopup;
    @NotNull
    private MutableStateFlow<State> stateFlow;
    public static final int $stable = 8;

    @JvmOverloads
    public CardBrandView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        StripeCardBrandViewBinding stripeCardBrandViewBinding = StripeCardBrandViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripeCardBrandViewBinding, (String)"inflate(...)");
        this.viewBinding = stripeCardBrandViewBinding;
        ImageView imageView = this.viewBinding.icon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"icon");
        this.iconView = imageView;
        ImageView imageView2 = this.viewBinding.chevron;
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"chevron");
        this.chevron = imageView2;
        this.listPopup = new ListPopupWindow(context);
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)new State(false, false, null, null, null, null, false, false, 0, 511, null));
        this.setClickable(false);
        this.setFocusable(false);
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner();
    }

    public /* synthetic */ CardBrandView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final State getState() {
        return (State)this.stateFlow.getValue();
    }

    private final void setState(State value) {
        this.stateFlow.setValue((Object)value);
    }

    public final boolean isCbcEligible() {
        return this.getState().isCbcEligible();
    }

    public final void setCbcEligible(boolean value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, value, false, null, null, null, null, false, false, 0, 510, null))));
        this.updateBrandSpinner();
    }

    @NotNull
    public final CardBrand getBrand() {
        return this.getState().getBrand();
    }

    public final void setBrand(@NotNull CardBrand value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, value, null, null, null, false, false, 0, 507, null))));
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner();
    }

    @NotNull
    public final List<CardBrand> getPossibleBrands() {
        return this.getState().getPossibleBrands();
    }

    public final void setPossibleBrands(@NotNull List<? extends CardBrand> value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, value, null, false, false, 0, 495, null))));
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner();
    }

    @NotNull
    public final List<CardBrand> getMerchantPreferredNetworks() {
        return this.getState().getMerchantPreferredNetworks();
    }

    public final void setMerchantPreferredNetworks(@NotNull List<? extends CardBrand> value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, null, value, false, false, 0, 479, null))));
        this.determineCardBrandToDisplay();
    }

    public final boolean getShouldShowCvc() {
        return this.getState().getShouldShowCvc();
    }

    public final void setShouldShowCvc(boolean value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, null, null, value, false, 0, 447, null))));
        this.setCardBrandIconAndTint();
    }

    public final boolean getShouldShowErrorIcon() {
        return this.getState().getShouldShowErrorIcon();
    }

    public final void setShouldShowErrorIcon(boolean value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, null, null, false, value, 0, 383, null))));
        this.setCardBrandIconAndTint();
    }

    public final int getTintColorInt$payments_core_release() {
        return this.getState().getTintColor();
    }

    public final void setTintColorInt$payments_core_release(int value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, null, null, false, false, value, 255, null))));
    }

    @Nullable
    public final PaymentMethodCreateParams.Card.Networks createNetworksParam() {
        PaymentMethodCreateParams.Card.Networks networks;
        CardBrand cardBrand;
        CardBrand it = cardBrand = this.getBrand();
        boolean bl = false;
        Object object = it != CardBrand.Unknown ? cardBrand : null;
        String string2 = object != null ? object.getCode() : null;
        PaymentMethodCreateParams.Card.Networks it2 = networks = new PaymentMethodCreateParams.Card.Networks(string2);
        boolean bl2 = false;
        return this.isCbcEligible() && this.getPossibleBrands().size() > 1 ? networks : null;
    }

    private final void handleBrandSelected(CardBrand brand) {
        block1: {
            State it;
            State nextValue$iv;
            Object prevValue$iv;
            CardBrand cardBrand = brand;
            if (cardBrand == null) break block1;
            CardBrand it2 = cardBrand;
            boolean bl = false;
            MutableStateFlow<State> $this$update$iv = this.stateFlow;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (State)prevValue$iv;
                boolean bl2 = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, brand, null, null, false, false, 0, 503, null))));
            this.determineCardBrandToDisplay();
        }
    }

    private final void setCardBrandIconAndTint() {
        PorterDuffColorFilter porterDuffColorFilter;
        int it;
        Integer n;
        this.iconView.setBackgroundResource(this.getShouldShowErrorIcon() ? this.getState().getBrand().getErrorIcon() : (this.getShouldShowCvc() ? this.getState().getBrand().getCvcIcon() : this.getState().getBrand().getIcon()));
        if (this.getShouldShowErrorIcon()) {
            n = null;
        } else if (this.getShouldShowCvc()) {
            n = this.getTintColorInt$payments_core_release();
        } else {
            Integer n2 = this.getTintColorInt$payments_core_release();
            it = ((Number)n2).intValue();
            boolean bl = false;
            n = this.getState().getBrand() == CardBrand.Unknown ? n2 : null;
        }
        Integer tint = n;
        ImageView imageView = this.iconView;
        Integer n3 = tint;
        if (n3 != null) {
            it = ((Number)n3).intValue();
            ImageView imageView2 = imageView;
            boolean bl = false;
            porterDuffColorFilter = new PorterDuffColorFilter(it, PorterDuff.Mode.LIGHTEN);
            imageView = imageView2;
        } else {
            porterDuffColorFilter = null;
        }
        imageView.setColorFilter((ColorFilter)porterDuffColorFilter);
    }

    private final void determineCardBrandToDisplay() {
        CardBrand newBrand;
        CardBrand cardBrand = newBrand = this.getState().getPossibleBrands().size() > 1 ? CardBrandSelectorKt.selectCardBrandToDisplay(this.getState().getUserSelectedBrand(), this.getState().getPossibleBrands(), this.getState().getMerchantPreferredNetworks()) : this.getState().getBrand();
        if (this.getBrand() != newBrand) {
            this.setBrand(newBrand);
        }
        this.setCardBrandIconAndTint();
    }

    private final void updateBrandSpinner() {
        boolean showDropdown;
        boolean bl = showDropdown = this.isCbcEligible() && this.getPossibleBrands().size() > 1 && !this.getShouldShowCvc() && !this.getShouldShowErrorIcon();
        if (showDropdown) {
            this.initListPopup();
            this.setOnClickListener(arg_0 -> CardBrandView.updateBrandSpinner$lambda$13(this, arg_0));
            this.chevron.setVisibility(0);
        } else {
            this.setOnClickListener(null);
            this.chevron.setVisibility(8);
        }
    }

    private final void initListPopup() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        BrandAdapter adapter2 = new BrandAdapter(context, this.getPossibleBrands(), this.getBrand());
        this.listPopup.setAdapter((ListAdapter)adapter2);
        this.listPopup.setModal(true);
        this.listPopup.setWidth(this.measureContentWidth(adapter2));
        this.listPopup.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> CardBrandView.initListPopup$lambda$15(this, arg_0, arg_1, arg_2, arg_3));
        this.listPopup.setAnchorView((View)this.iconView);
    }

    private final int measureContentWidth(BrandAdapter adapter2) {
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter2.getCount();
        int maxWidth = 0;
        for (int i = 0; i < count; ++i) {
            View itemView = adapter2.getView(i, null, (ViewGroup)this);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            maxWidth = RangesKt.coerceAtLeast((int)maxWidth, (int)itemView.getMeasuredWidth());
        }
        return maxWidth;
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.getState());
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        SavedState savedState = state instanceof SavedState ? (SavedState)state : null;
        Parcelable parcelable = savedState;
        if (parcelable == null || (parcelable = parcelable.getState()) == null) {
            parcelable = new State(false, false, null, null, null, null, false, false, 0, 511, null);
        }
        this.setState((State)parcelable);
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner();
        SavedState savedState2 = savedState;
        if (savedState2 == null || (savedState2 = savedState2.getSuperState()) == null) {
            savedState2 = state;
        }
        super.onRestoreInstanceState((Parcelable)savedState2);
    }

    @JvmOverloads
    public CardBrandView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardBrandView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void updateBrandSpinner$lambda$13(CardBrandView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.listPopup.isShowing()) {
            this$0.listPopup.dismiss();
        } else {
            this$0.listPopup.show();
        }
    }

    private static final void initListPopup$lambda$15(CardBrandView this$0, AdapterView adapterView, View view, int position, long l) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardBrand cardBrand = (CardBrand)CollectionsKt.getOrNull(this$0.getPossibleBrands(), (int)(position - 1));
        if (cardBrand != null) {
            CardBrand it = cardBrand;
            boolean bl = false;
            this$0.handleBrandSelected(it);
        }
        this$0.listPopup.dismiss();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/view/CardBrandView$SavedState;", "Landroid/view/View$BaseSavedState;", "Landroid/os/Parcelable;", "superSavedState", "state", "Lcom/stripe/android/view/CardBrandView$State;", "(Landroid/os/Parcelable;Lcom/stripe/android/view/CardBrandView$State;)V", "getState", "()Lcom/stripe/android/view/CardBrandView$State;", "getSuperSavedState", "()Landroid/os/Parcelable;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class SavedState
    extends View.BaseSavedState
    implements Parcelable {
        @Nullable
        private final Parcelable superSavedState;
        @NotNull
        private final State state;
        public static final int $stable = 8;
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;

        public SavedState(@Nullable Parcelable superSavedState, @NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super(superSavedState);
            this.superSavedState = superSavedState;
            this.state = state;
        }

        @Nullable
        public final Parcelable getSuperSavedState() {
            return this.superSavedState;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        @Nullable
        public final Parcelable component1() {
            return this.superSavedState;
        }

        @NotNull
        public final State component2() {
            return this.state;
        }

        @NotNull
        public final SavedState copy(@Nullable Parcelable superSavedState, @NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new SavedState(superSavedState, state);
        }

        public static /* synthetic */ SavedState copy$default(SavedState savedState, Parcelable parcelable, State state, int n, Object object) {
            if ((n & 1) != 0) {
                parcelable = savedState.superSavedState;
            }
            if ((n & 2) != 0) {
                state = savedState.state;
            }
            return savedState.copy(parcelable, state);
        }

        @NotNull
        public String toString() {
            return "SavedState(superSavedState=" + this.superSavedState + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result2 = this.superSavedState == null ? 0 : this.superSavedState.hashCode();
            result2 = result2 * 31 + this.state.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SavedState)) {
                return false;
            }
            SavedState savedState = (SavedState)((Object)other);
            if (!Intrinsics.areEqual((Object)this.superSavedState, (Object)savedState.superSavedState)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.state, (Object)savedState.state);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeParcelable(this.superSavedState, flags);
            this.state.writeToParcel(out, flags);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<SavedState> {
                @NotNull
                public final SavedState[] newArray(int size) {
                    return new SavedState[size];
                }

                @NotNull
                public final SavedState createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new SavedState(parcel.readParcelable(SavedState.class.getClassLoader()), (State)State.CREATOR.createFromParcel(parcel));
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001Bm\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u000eH\u00c6\u0003Jq\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\t\u0010%\u001a\u00020\u000eH\u00d6\u0001J\u0013\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\u000eH\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u0019\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011\u00a8\u00061"}, d2={"Lcom/stripe/android/view/CardBrandView$State;", "Landroid/os/Parcelable;", "isCbcEligible", "", "isLoading", "brand", "Lcom/stripe/android/model/CardBrand;", "userSelectedBrand", "possibleBrands", "", "merchantPreferredNetworks", "shouldShowCvc", "shouldShowErrorIcon", "tintColor", "", "(ZZLcom/stripe/android/model/CardBrand;Lcom/stripe/android/model/CardBrand;Ljava/util/List;Ljava/util/List;ZZI)V", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "()Z", "getMerchantPreferredNetworks", "()Ljava/util/List;", "getPossibleBrands", "getShouldShowCvc", "getShouldShowErrorIcon", "getTintColor", "()I", "getUserSelectedBrand", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "describeContents", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class State
    implements Parcelable {
        private final boolean isCbcEligible;
        private final boolean isLoading;
        @NotNull
        private final CardBrand brand;
        @Nullable
        private final CardBrand userSelectedBrand;
        @NotNull
        private final List<CardBrand> possibleBrands;
        @NotNull
        private final List<CardBrand> merchantPreferredNetworks;
        private final boolean shouldShowCvc;
        private final boolean shouldShowErrorIcon;
        private final int tintColor;
        public static final int $stable = 8;
        @NotNull
        public static final Parcelable.Creator<State> CREATOR;

        public State(boolean isCbcEligible, boolean isLoading, @NotNull CardBrand brand, @Nullable CardBrand userSelectedBrand, @NotNull List<? extends CardBrand> possibleBrands, @NotNull List<? extends CardBrand> merchantPreferredNetworks, boolean shouldShowCvc, boolean shouldShowErrorIcon, int tintColor) {
            Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
            Intrinsics.checkNotNullParameter(possibleBrands, (String)"possibleBrands");
            Intrinsics.checkNotNullParameter(merchantPreferredNetworks, (String)"merchantPreferredNetworks");
            this.isCbcEligible = isCbcEligible;
            this.isLoading = isLoading;
            this.brand = brand;
            this.userSelectedBrand = userSelectedBrand;
            this.possibleBrands = possibleBrands;
            this.merchantPreferredNetworks = merchantPreferredNetworks;
            this.shouldShowCvc = shouldShowCvc;
            this.shouldShowErrorIcon = shouldShowErrorIcon;
            this.tintColor = tintColor;
        }

        public /* synthetic */ State(boolean bl, boolean bl2, CardBrand cardBrand, CardBrand cardBrand2, List list, List list2, boolean bl3, boolean bl4, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                cardBrand = CardBrand.Unknown;
            }
            if ((n2 & 8) != 0) {
                cardBrand2 = null;
            }
            if ((n2 & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 0x20) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n2 & 0x40) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x80) != 0) {
                bl4 = false;
            }
            if ((n2 & 0x100) != 0) {
                n = 0;
            }
            this(bl, bl2, cardBrand, cardBrand2, list, list2, bl3, bl4, n);
        }

        public final boolean isCbcEligible() {
            return this.isCbcEligible;
        }

        public final boolean isLoading() {
            return this.isLoading;
        }

        @NotNull
        public final CardBrand getBrand() {
            return this.brand;
        }

        @Nullable
        public final CardBrand getUserSelectedBrand() {
            return this.userSelectedBrand;
        }

        @NotNull
        public final List<CardBrand> getPossibleBrands() {
            return this.possibleBrands;
        }

        @NotNull
        public final List<CardBrand> getMerchantPreferredNetworks() {
            return this.merchantPreferredNetworks;
        }

        public final boolean getShouldShowCvc() {
            return this.shouldShowCvc;
        }

        public final boolean getShouldShowErrorIcon() {
            return this.shouldShowErrorIcon;
        }

        public final int getTintColor() {
            return this.tintColor;
        }

        public final boolean component1() {
            return this.isCbcEligible;
        }

        public final boolean component2() {
            return this.isLoading;
        }

        @NotNull
        public final CardBrand component3() {
            return this.brand;
        }

        @Nullable
        public final CardBrand component4() {
            return this.userSelectedBrand;
        }

        @NotNull
        public final List<CardBrand> component5() {
            return this.possibleBrands;
        }

        @NotNull
        public final List<CardBrand> component6() {
            return this.merchantPreferredNetworks;
        }

        public final boolean component7() {
            return this.shouldShowCvc;
        }

        public final boolean component8() {
            return this.shouldShowErrorIcon;
        }

        public final int component9() {
            return this.tintColor;
        }

        @NotNull
        public final State copy(boolean isCbcEligible, boolean isLoading, @NotNull CardBrand brand, @Nullable CardBrand userSelectedBrand, @NotNull List<? extends CardBrand> possibleBrands, @NotNull List<? extends CardBrand> merchantPreferredNetworks, boolean shouldShowCvc, boolean shouldShowErrorIcon, int tintColor) {
            Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
            Intrinsics.checkNotNullParameter(possibleBrands, (String)"possibleBrands");
            Intrinsics.checkNotNullParameter(merchantPreferredNetworks, (String)"merchantPreferredNetworks");
            return new State(isCbcEligible, isLoading, brand, userSelectedBrand, possibleBrands, merchantPreferredNetworks, shouldShowCvc, shouldShowErrorIcon, tintColor);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, boolean bl2, CardBrand cardBrand, CardBrand cardBrand2, List list, List list2, boolean bl3, boolean bl4, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = state.isCbcEligible;
            }
            if ((n2 & 2) != 0) {
                bl2 = state.isLoading;
            }
            if ((n2 & 4) != 0) {
                cardBrand = state.brand;
            }
            if ((n2 & 8) != 0) {
                cardBrand2 = state.userSelectedBrand;
            }
            if ((n2 & 0x10) != 0) {
                list = state.possibleBrands;
            }
            if ((n2 & 0x20) != 0) {
                list2 = state.merchantPreferredNetworks;
            }
            if ((n2 & 0x40) != 0) {
                bl3 = state.shouldShowCvc;
            }
            if ((n2 & 0x80) != 0) {
                bl4 = state.shouldShowErrorIcon;
            }
            if ((n2 & 0x100) != 0) {
                n = state.tintColor;
            }
            return state.copy(bl, bl2, cardBrand, cardBrand2, list, list2, bl3, bl4, n);
        }

        @NotNull
        public String toString() {
            return "State(isCbcEligible=" + this.isCbcEligible + ", isLoading=" + this.isLoading + ", brand=" + this.brand + ", userSelectedBrand=" + this.userSelectedBrand + ", possibleBrands=" + this.possibleBrands + ", merchantPreferredNetworks=" + this.merchantPreferredNetworks + ", shouldShowCvc=" + this.shouldShowCvc + ", shouldShowErrorIcon=" + this.shouldShowErrorIcon + ", tintColor=" + this.tintColor + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isCbcEligible);
            result2 = result2 * 31 + Boolean.hashCode(this.isLoading);
            result2 = result2 * 31 + this.brand.hashCode();
            result2 = result2 * 31 + (this.userSelectedBrand == null ? 0 : this.userSelectedBrand.hashCode());
            result2 = result2 * 31 + ((Object)this.possibleBrands).hashCode();
            result2 = result2 * 31 + ((Object)this.merchantPreferredNetworks).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.shouldShowCvc);
            result2 = result2 * 31 + Boolean.hashCode(this.shouldShowErrorIcon);
            result2 = result2 * 31 + Integer.hashCode(this.tintColor);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.isCbcEligible != state.isCbcEligible) {
                return false;
            }
            if (this.isLoading != state.isLoading) {
                return false;
            }
            if (this.brand != state.brand) {
                return false;
            }
            if (this.userSelectedBrand != state.userSelectedBrand) {
                return false;
            }
            if (!Intrinsics.areEqual(this.possibleBrands, state.possibleBrands)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.merchantPreferredNetworks, state.merchantPreferredNetworks)) {
                return false;
            }
            if (this.shouldShowCvc != state.shouldShowCvc) {
                return false;
            }
            if (this.shouldShowErrorIcon != state.shouldShowErrorIcon) {
                return false;
            }
            return this.tintColor == state.tintColor;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(this.isCbcEligible ? 1 : 0);
            out.writeInt(this.isLoading ? 1 : 0);
            out.writeString(this.brand.name());
            Object object = this.userSelectedBrand;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeString(object.name());
            }
            object = this.possibleBrands;
            out.writeInt(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                out.writeString(((CardBrand)iterator.next()).name());
            }
            object = this.merchantPreferredNetworks;
            out.writeInt(object.size());
            iterator = object.iterator();
            while (iterator.hasNext()) {
                out.writeString(((CardBrand)iterator.next()).name());
            }
            out.writeInt(this.shouldShowCvc ? 1 : 0);
            out.writeInt(this.shouldShowErrorIcon ? 1 : 0);
            out.writeInt(this.tintColor);
        }

        public State() {
            this(false, false, null, null, null, null, false, false, 0, 511, null);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<State> {
                @NotNull
                public final State[] newArray(int size) {
                    return new State[size];
                }

                @NotNull
                public final State createFromParcel(@NotNull Parcel parcel) {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n2 = parcel.readInt();
                    ArrayList<CardBrand> arrayList = new ArrayList<CardBrand>(n2);
                    CardBrand cardBrand = parcel.readInt() == 0 ? null : CardBrand.valueOf((String)parcel.readString());
                    CardBrand cardBrand2 = CardBrand.valueOf((String)parcel.readString());
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    for (n = 0; n != n2; ++n) {
                        arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                    }
                    List list = arrayList;
                    n2 = parcel.readInt();
                    arrayList = new ArrayList(n2);
                    List list2 = list;
                    for (n = 0; n != n2; ++n) {
                        arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                    }
                    int n3 = parcel.readInt();
                    boolean bl3 = parcel.readInt() != 0;
                    boolean bl4 = parcel.readInt() != 0;
                    List list3 = arrayList;
                    List list4 = list2;
                    CardBrand cardBrand3 = cardBrand;
                    CardBrand cardBrand4 = cardBrand2;
                    boolean bl5 = bl;
                    boolean bl6 = bl2;
                    return new State(bl6, bl5, cardBrand4, cardBrand3, list4, list3, bl4, bl3, n3);
                }
            }
            CREATOR = new Creator();
        }
    }
}

