/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.os.IBinder;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.R;
import com.stripe.android.core.model.Country;
import com.stripe.android.core.model.CountryCode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0012\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0016J\"\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u000bH\u0016J\u001b\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0002\b*R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lcom/stripe/android/view/CountryAdapter;", "Landroid/widget/ArrayAdapter;", "Lcom/stripe/android/core/model/Country;", "context", "Landroid/content/Context;", "unfilteredCountries", "", "itemLayoutId", "", "textViewFactory", "Lkotlin/Function1;", "Landroid/view/ViewGroup;", "Landroid/widget/TextView;", "(Landroid/content/Context;Ljava/util/List;ILkotlin/jvm/functions/Function1;)V", "countryFilter", "Lcom/stripe/android/view/CountryAdapter$CountryFilter;", "firstItem", "getFirstItem$payments_core_release", "()Lcom/stripe/android/core/model/Country;", "suggestions", "getUnfilteredCountries$payments_core_release", "()Ljava/util/List;", "setUnfilteredCountries$payments_core_release", "(Ljava/util/List;)V", "getCount", "getFilter", "Landroid/widget/Filter;", "getItem", "i", "getItemId", "", "getPosition", "item", "getView", "Landroid/view/View;", "view", "viewGroup", "updateUnfilteredCountries", "", "allowedCountryCodes", "", "", "updateUnfilteredCountries$payments_core_release", "CountryFilter", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCountryAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountryAdapter.kt\ncom/stripe/android/view/CountryAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n766#2:151\n857#2:152\n1747#2,3:153\n858#2:156\n*S KotlinDebug\n*F\n+ 1 CountryAdapter.kt\ncom/stripe/android/view/CountryAdapter\n*L\n76#1:151\n76#1:152\n77#1:153,3\n76#1:156\n*E\n"})
public final class CountryAdapter
extends ArrayAdapter<Country> {
    @NotNull
    private List<Country> unfilteredCountries;
    @NotNull
    private final Function1<ViewGroup, TextView> textViewFactory;
    @NotNull
    private final CountryFilter countryFilter;
    @NotNull
    private List<Country> suggestions;
    public static final int $stable = 8;

    public CountryAdapter(@NotNull Context context, @NotNull List<Country> unfilteredCountries, int itemLayoutId, @NotNull Function1<? super ViewGroup, ? extends TextView> textViewFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(unfilteredCountries, (String)"unfilteredCountries");
        Intrinsics.checkNotNullParameter(textViewFactory, (String)"textViewFactory");
        super(context, itemLayoutId);
        this.unfilteredCountries = unfilteredCountries;
        this.textViewFactory = textViewFactory;
        this.countryFilter = new CountryFilter(this.unfilteredCountries, this, context instanceof Activity ? (Activity)context : null);
        this.suggestions = this.unfilteredCountries;
    }

    public /* synthetic */ CountryAdapter(Context context, List list, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = R.layout.stripe_country_text_view;
        }
        this(context, list, n, (Function1<? super ViewGroup, ? extends TextView>)function1);
    }

    @NotNull
    public final List<Country> getUnfilteredCountries$payments_core_release() {
        return this.unfilteredCountries;
    }

    public final void setUnfilteredCountries$payments_core_release(@NotNull List<Country> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.unfilteredCountries = list;
    }

    public final /* synthetic */ Country getFirstItem$payments_core_release() {
        return this.getItem(0);
    }

    public int getCount() {
        return this.suggestions.size();
    }

    @NotNull
    public Country getItem(int i) {
        return this.suggestions.get(i);
    }

    public int getPosition(@Nullable Country item) {
        return CollectionsKt.indexOf(this.suggestions, (Object)item);
    }

    public long getItemId(int i) {
        return this.getItem(i).hashCode();
    }

    @NotNull
    public View getView(int i, @Nullable View view, @NotNull ViewGroup viewGroup) {
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        TextView countryText = textView = view instanceof TextView ? (TextView)view : (TextView)this.textViewFactory.invoke((Object)viewGroup);
        boolean bl = false;
        countryText.setText((CharSequence)this.getItem(i).getName());
        return (View)textView;
    }

    @NotNull
    public Filter getFilter() {
        return this.countryFilter;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean updateUnfilteredCountries$payments_core_release(@NotNull Set<String> allowedCountryCodes) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(allowedCountryCodes, (String)"allowedCountryCodes");
        if (allowedCountryCodes.isEmpty()) {
            return false;
        }
        Iterable iterable = this.unfilteredCountries;
        CountryAdapter countryAdapter = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                Country country = (Country)element$iv$iv;
                boolean bl2 = false;
                CountryCode countryCode = country.component1();
                Iterable $this$any$iv = allowedCountryCodes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String allowedCountryCode = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)allowedCountryCode, (String)countryCode.getValue(), (boolean)true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        countryAdapter.unfilteredCountries = (List)destination$iv$iv;
        this.countryFilter.setUnfilteredCountries(this.unfilteredCountries);
        this.suggestions = this.unfilteredCountries;
        this.notifyDataSetChanged();
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u001c\u0010\u001b\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aH\u0014R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/view/CountryAdapter$CountryFilter;", "Landroid/widget/Filter;", "unfilteredCountries", "", "Lcom/stripe/android/core/model/Country;", "adapter", "Lcom/stripe/android/view/CountryAdapter;", "activity", "Landroid/app/Activity;", "(Ljava/util/List;Lcom/stripe/android/view/CountryAdapter;Landroid/app/Activity;)V", "activityRef", "Ljava/lang/ref/WeakReference;", "getUnfilteredCountries", "()Ljava/util/List;", "setUnfilteredCountries", "(Ljava/util/List;)V", "filteredSuggestedCountries", "constraint", "", "getSuggestedCountries", "hideKeyboard", "", "isMatch", "", "countries", "performFiltering", "Landroid/widget/Filter$FilterResults;", "publishResults", "filterResults", "payments-core_release"})
    @SourceDebugExtension(value={"SMAP\nCountryAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountryAdapter.kt\ncom/stripe/android/view/CountryAdapter$CountryFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1747#2,3:151\n766#2:154\n857#2,2:155\n*S KotlinDebug\n*F\n+ 1 CountryAdapter.kt\ncom/stripe/android/view/CountryAdapter$CountryFilter\n*L\n109#1:151,3\n130#1:154\n130#1:155,2\n*E\n"})
    private static final class CountryFilter
    extends Filter {
        @NotNull
        private List<Country> unfilteredCountries;
        @NotNull
        private final CountryAdapter adapter;
        @NotNull
        private final WeakReference<Activity> activityRef;

        public CountryFilter(@NotNull List<Country> unfilteredCountries, @NotNull CountryAdapter adapter2, @Nullable Activity activity) {
            Intrinsics.checkNotNullParameter(unfilteredCountries, (String)"unfilteredCountries");
            Intrinsics.checkNotNullParameter((Object)((Object)adapter2), (String)"adapter");
            this.unfilteredCountries = unfilteredCountries;
            this.adapter = adapter2;
            this.activityRef = new WeakReference<Activity>(activity);
        }

        @NotNull
        public final List<Country> getUnfilteredCountries() {
            return this.unfilteredCountries;
        }

        public final void setUnfilteredCountries(@NotNull List<Country> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.unfilteredCountries = list;
        }

        @NotNull
        protected Filter.FilterResults performFiltering(@Nullable CharSequence constraint) {
            Object object;
            Filter.FilterResults filterResults;
            block3: {
                block2: {
                    Filter.FilterResults filterResults2 = filterResults = new Filter.FilterResults();
                    object = constraint;
                    if (object == null) break block2;
                    CharSequence charSequence = object;
                    Filter.FilterResults filterResults3 = filterResults2;
                    boolean bl = false;
                    List<Country> list = this.filteredSuggestedCountries(constraint);
                    filterResults2 = filterResults3;
                    object = list;
                    if (list != null) break block3;
                }
                object = this.unfilteredCountries;
            }
            filterResults2.values = object;
            return filterResults;
        }

        protected void publishResults(@Nullable CharSequence constraint, @Nullable Filter.FilterResults filterResults) {
            Filter.FilterResults filterResults2 = filterResults;
            Object object = filterResults2 != null ? filterResults2.values : null;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<com.stripe.android.core.model.Country>");
            List suggestions = (List)object;
            Activity activity = (Activity)this.activityRef.get();
            if (activity != null) {
                boolean bl;
                Activity activity2;
                block5: {
                    activity2 = activity;
                    boolean bl2 = false;
                    Iterable $this$any$iv = suggestions;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Country it = (Country)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)constraint)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.hideKeyboard(activity2);
                }
            }
            this.adapter.suggestions = suggestions;
            this.adapter.notifyDataSetChanged();
        }

        private final List<Country> filteredSuggestedCountries(CharSequence constraint) {
            List<Country> suggestedCountries = this.getSuggestedCountries(constraint);
            return suggestedCountries.isEmpty() || this.isMatch(suggestedCountries, constraint) ? this.unfilteredCountries : suggestedCountries;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Country> getSuggestedCountries(CharSequence constraint) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.unfilteredCountries;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Country country = (Country)element$iv$iv;
                boolean bl = false;
                String string2 = country.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = String.valueOf(constraint).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isMatch(List<Country> countries, CharSequence constraint) {
            return countries.size() == 1 && Intrinsics.areEqual((Object)countries.get(0).getName(), (Object)String.valueOf(constraint));
        }

        private final void hideKeyboard(Activity activity) {
            InputMethodManager inputMethodManager;
            Object object = activity.getSystemService("input_method");
            InputMethodManager inputMethodManager2 = inputMethodManager = object instanceof InputMethodManager ? (InputMethodManager)object : null;
            boolean bl = inputMethodManager2 != null ? inputMethodManager2.isAcceptingText() : false;
            if (bl) {
                View view = activity.getCurrentFocus();
                inputMethodManager.hideSoftInputFromWindow((IBinder)(view != null ? view.getWindowToken() : null), 0);
            }
        }
    }
}

