/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.annotation.AnnotationRetention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003:\u0001\u0018B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/StripeIntentResult;", "T", "Lcom/stripe/android/model/StripeIntent;", "Lcom/stripe/android/core/model/StripeModel;", "outcomeFromFlow", "", "<init>", "(I)V", "intent", "getIntent", "()Lcom/stripe/android/model/StripeIntent;", "failureMessage", "", "getFailureMessage", "()Ljava/lang/String;", "outcome", "getOutcome$annotations", "()V", "getOutcome", "()I", "determineOutcome", "stripeIntent", "isRequireActionSuccessState", "", "Outcome", "payments-core_release"})
@StabilityInferred(parameters=2)
public abstract class StripeIntentResult<T extends StripeIntent>
implements StripeModel {
    private final int outcomeFromFlow;
    public static final int $stable;

    public StripeIntentResult(int outcomeFromFlow) {
        this.outcomeFromFlow = outcomeFromFlow;
    }

    @NotNull
    public abstract T getIntent();

    @Nullable
    public abstract String getFailureMessage();

    public final int getOutcome() {
        return this.determineOutcome((StripeIntent)this.getIntent(), this.outcomeFromFlow);
    }

    public static /* synthetic */ void getOutcome$annotations() {
    }

    private final int determineOutcome(StripeIntent stripeIntent, int outcome) {
        if (outcome != 0) {
            return outcome;
        }
        return this.getOutcome(stripeIntent);
    }

    private final int getOutcome(StripeIntent stripeIntent) {
        int n;
        StripeIntent.Status status = stripeIntent.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                if (stripeIntent.getNextActionData() == null) {
                    n = 2;
                    break;
                }
                if (this.isRequireActionSuccessState((StripeIntent)this.getIntent())) {
                    n = 1;
                    break;
                }
                n = 3;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n = 1;
                break;
            }
            case 7: {
                Object object = this.getIntent().getPaymentMethod();
                boolean bl = object != null && (object = ((PaymentMethod)object).type) != null ? ((PaymentMethod.Type)((Object)object)).hasDelayedSettlement() : false;
                if (bl) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private final boolean isRequireActionSuccessState(StripeIntent stripeIntent) {
        boolean bl;
        StripeIntent.NextActionType nextActionType = stripeIntent.getNextActionType();
        switch (nextActionType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[nextActionType.ordinal()]) {
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = false;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @kotlin.annotation.Retention(value=AnnotationRetention.SOURCE)
    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/StripeIntentResult$Outcome;", "", "Companion", "payments-core_release"})
    public static @interface Outcome {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int UNKNOWN = 0;
        public static final int SUCCEEDED = 1;
        public static final int FAILED = 2;
        public static final int CANCELED = 3;
        public static final int TIMEDOUT = 4;

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/StripeIntentResult$Outcome$Companion;", "", "<init>", "()V", "UNKNOWN", "", "SUCCEEDED", "FAILED", "CANCELED", "TIMEDOUT", "payments-core_release"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            public static final int UNKNOWN = 0;
            public static final int SUCCEEDED = 1;
            public static final int FAILED = 2;
            public static final int CANCELED = 3;
            public static final int TIMEDOUT = 4;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StripeIntent.Status.values().length];
            try {
                nArray[StripeIntent.Status.RequiresAction.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Status.Canceled.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Status.RequiresPaymentMethod.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Status.Succeeded.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Status.RequiresCapture.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Status.RequiresConfirmation.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Status.Processing.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StripeIntent.NextActionType.values().length];
            try {
                nArray[StripeIntent.NextActionType.RedirectToUrl.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.UseStripeSdk.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.AlipayRedirect.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.WeChatPayRedirect.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.CashAppRedirect.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.SwishRedirect.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.BlikAuthorize.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.DisplayOxxoDetails.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.DisplayBoletoDetails.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.DisplayKonbiniDetails.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.DisplayMultibancoDetails.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.UpiAwaitNotification.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.NextActionType.VerifyWithMicrodeposits.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

