/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.auth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleKt;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.StripeBrowserLauncherActivity;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.view.PaymentAuthWebViewActivity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00102\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "<init>", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "Companion", "payments-core_release"})
@StabilityInferred(parameters=1)
public final class PaymentBrowserAuthContract
extends ActivityResultContract<Args, PaymentFlowResult.Unvalidated> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String EXTRA_ARGS = "extra_args";

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Intent intent;
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        DefaultReturnUrl defaultReturnUrl = DefaultReturnUrl.Companion.create(context);
        boolean shouldUseBrowser = !input.getForceInAppWebView() && (input.hasDefaultReturnUrl$payments_core_release(defaultReturnUrl) || input.isInstantApp());
        Bundle extras = input.toBundle();
        boolean bl = shouldUseBrowser;
        if (bl) {
            clazz = StripeBrowserLauncherActivity.class;
        } else if (!bl) {
            clazz = PaymentAuthWebViewActivity.class;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intent intent2 = intent = new Intent(context, clazz);
        boolean bl2 = false;
        intent2.putExtras(extras);
        return intent;
    }

    @NotNull
    public PaymentFlowResult.Unvalidated parseResult(int resultCode, @Nullable Intent intent) {
        Object object = intent;
        if (object == null || (object = (PaymentFlowResult.Unvalidated)object.getParcelableExtra(EXTRA_ARGS)) == null) {
            object = new PaymentFlowResult.Unvalidated(null, 0, null, false, null, null, null, 127, null);
        }
        return object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0081\b\u0018\u0000 N2\u00020\u0001:\u0001NB\u0099\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0016B\u0011\b\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0015\u0010\u0019J\u0015\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b1J\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u0002052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u0005H\u0016J\b\u00107\u001a\u00020\u0005H\u0016J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0005H\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\nH\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010@\u001a\u00020\nH\u00c6\u0003J\t\u0010A\u001a\u00020\nH\u00c6\u0003J\u0010\u0010B\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010)J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\t\u0010D\u001a\u00020\nH\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010F\u001a\u00020\nH\u00c6\u0003J\u00ae\u0001\u0010G\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0014\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010HJ\u0013\u0010I\u001a\u00020\n2\b\u0010J\u001a\u0004\u0018\u00010KH\u00d6\u0003J\t\u0010L\u001a\u00020\u0005H\u00d6\u0001J\t\u0010M\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\"R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010*\u001a\u0004\b(\u0010)R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001bR\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\"R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001bR\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\"\u00a8\u0006O"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "Landroid/os/Parcelable;", "objectId", "", "requestCode", "", "clientSecret", "url", "returnUrl", "enableLogging", "", "toolbarCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;", "stripeAccountId", "shouldCancelSource", "shouldCancelIntentOnUserNavigation", "statusBarColor", "publishableKey", "isInstantApp", "referrer", "forceInAppWebView", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;Ljava/lang/String;ZZLjava/lang/Integer;Ljava/lang/String;ZLjava/lang/String;Z)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getObjectId", "()Ljava/lang/String;", "getRequestCode", "()I", "getClientSecret", "getUrl", "getReturnUrl", "getEnableLogging", "()Z", "getToolbarCustomization", "()Lcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;", "getStripeAccountId", "getShouldCancelSource", "getShouldCancelIntentOnUserNavigation", "getStatusBarColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPublishableKey", "getReferrer", "getForceInAppWebView", "hasDefaultReturnUrl", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "hasDefaultReturnUrl$payments_core_release", "toBundle", "Landroid/os/Bundle;", "writeToParcel", "", "flags", "describeContents", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;Ljava/lang/String;ZZLjava/lang/Integer;Ljava/lang/String;ZLjava/lang/String;Z)Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "equals", "other", "", "hashCode", "toString", "CREATOR", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Args
    implements Parcelable {
        @NotNull
        public static final CREATOR CREATOR = new CREATOR(null);
        @NotNull
        private final String objectId;
        private final int requestCode;
        @NotNull
        private final String clientSecret;
        @NotNull
        private final String url;
        @Nullable
        private final String returnUrl;
        private final boolean enableLogging;
        @Nullable
        private final StripeToolbarCustomization toolbarCustomization;
        @Nullable
        private final String stripeAccountId;
        private final boolean shouldCancelSource;
        private final boolean shouldCancelIntentOnUserNavigation;
        @Nullable
        private final Integer statusBarColor;
        @NotNull
        private final String publishableKey;
        private final boolean isInstantApp;
        @Nullable
        private final String referrer;
        private final boolean forceInAppWebView;
        public static final int $stable = 8;

        public Args(@NotNull String objectId, int requestCode, @NotNull String clientSecret, @NotNull String url, @Nullable String returnUrl, boolean enableLogging, @Nullable StripeToolbarCustomization toolbarCustomization, @Nullable String stripeAccountId, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, @Nullable Integer statusBarColor, @NotNull String publishableKey, boolean isInstantApp, @Nullable String referrer, boolean forceInAppWebView) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
            this.objectId = objectId;
            this.requestCode = requestCode;
            this.clientSecret = clientSecret;
            this.url = url;
            this.returnUrl = returnUrl;
            this.enableLogging = enableLogging;
            this.toolbarCustomization = toolbarCustomization;
            this.stripeAccountId = stripeAccountId;
            this.shouldCancelSource = shouldCancelSource;
            this.shouldCancelIntentOnUserNavigation = shouldCancelIntentOnUserNavigation;
            this.statusBarColor = statusBarColor;
            this.publishableKey = publishableKey;
            this.isInstantApp = isInstantApp;
            this.referrer = referrer;
            this.forceInAppWebView = forceInAppWebView;
        }

        public /* synthetic */ Args(String string2, int n, String string3, String string4, String string5, boolean bl, StripeToolbarCustomization stripeToolbarCustomization, String string6, boolean bl2, boolean bl3, Integer n2, String string7, boolean bl4, String string8, boolean bl5, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                string5 = null;
            }
            if ((n3 & 0x20) != 0) {
                bl = false;
            }
            if ((n3 & 0x40) != 0) {
                stripeToolbarCustomization = null;
            }
            if ((n3 & 0x80) != 0) {
                string6 = null;
            }
            if ((n3 & 0x100) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = true;
            }
            if ((n3 & 0x2000) != 0) {
                string8 = null;
            }
            if ((n3 & 0x4000) != 0) {
                bl5 = false;
            }
            this(string2, n, string3, string4, string5, bl, stripeToolbarCustomization, string6, bl2, bl3, n2, string7, bl4, string8, bl5);
        }

        @NotNull
        public final String getObjectId() {
            return this.objectId;
        }

        public final int getRequestCode() {
            return this.requestCode;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getReturnUrl() {
            return this.returnUrl;
        }

        public final boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Nullable
        public final StripeToolbarCustomization getToolbarCustomization() {
            return this.toolbarCustomization;
        }

        @Nullable
        public final String getStripeAccountId() {
            return this.stripeAccountId;
        }

        public final boolean getShouldCancelSource() {
            return this.shouldCancelSource;
        }

        public final boolean getShouldCancelIntentOnUserNavigation() {
            return this.shouldCancelIntentOnUserNavigation;
        }

        @Nullable
        public final Integer getStatusBarColor() {
            return this.statusBarColor;
        }

        @NotNull
        public final String getPublishableKey() {
            return this.publishableKey;
        }

        public final boolean isInstantApp() {
            return this.isInstantApp;
        }

        @Nullable
        public final String getReferrer() {
            return this.referrer;
        }

        public final boolean getForceInAppWebView() {
            return this.forceInAppWebView;
        }

        public Args(@NotNull Parcel parcel) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            String string3 = parcel.readString();
            if (string3 == null) {
                string3 = "";
            }
            int n = parcel.readInt();
            String string4 = parcel.readString();
            if (string4 == null) {
                string4 = "";
            }
            if ((string2 = parcel.readString()) == null) {
                string2 = "";
            }
            String string5 = parcel.readString();
            boolean bl = parcel.readByte() != 0;
            StripeToolbarCustomization stripeToolbarCustomization = (StripeToolbarCustomization)parcel.readParcelable(StripeToolbarCustomization.class.getClassLoader());
            String string6 = parcel.readString();
            boolean bl2 = parcel.readByte() != 0;
            boolean bl3 = parcel.readByte() != 0;
            Object object = parcel.readValue(Integer.TYPE.getClassLoader());
            Integer n2 = object instanceof Integer ? (Integer)object : null;
            String string7 = parcel.readString();
            if (string7 == null) {
                string7 = "";
            }
            this(string3, n, string4, string2, string5, bl, stripeToolbarCustomization, string6, bl2, bl3, n2, string7, parcel.readByte() != 0, parcel.readString(), parcel.readByte() != 0);
        }

        public final boolean hasDefaultReturnUrl$payments_core_release(@NotNull DefaultReturnUrl defaultReturnUrl) {
            Intrinsics.checkNotNullParameter((Object)defaultReturnUrl, (String)"defaultReturnUrl");
            return Intrinsics.areEqual((Object)this.returnUrl, (Object)defaultReturnUrl.getValue());
        }

        @NotNull
        public final Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentBrowserAuthContract.EXTRA_ARGS, (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeString(this.objectId);
            parcel.writeInt(this.requestCode);
            parcel.writeString(this.clientSecret);
            parcel.writeString(this.url);
            parcel.writeString(this.returnUrl);
            parcel.writeByte(this.enableLogging ? (byte)1 : 0);
            parcel.writeParcelable((Parcelable)this.toolbarCustomization, flags);
            parcel.writeString(this.stripeAccountId);
            parcel.writeByte(this.shouldCancelSource ? (byte)1 : 0);
            parcel.writeByte(this.shouldCancelIntentOnUserNavigation ? (byte)1 : 0);
            parcel.writeValue((Object)this.statusBarColor);
            parcel.writeString(this.publishableKey);
            parcel.writeByte(this.isInstantApp ? (byte)1 : 0);
            parcel.writeString(this.referrer);
            parcel.writeByte(this.forceInAppWebView ? (byte)1 : 0);
        }

        public int describeContents() {
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.objectId;
        }

        public final int component2() {
            return this.requestCode;
        }

        @NotNull
        public final String component3() {
            return this.clientSecret;
        }

        @NotNull
        public final String component4() {
            return this.url;
        }

        @Nullable
        public final String component5() {
            return this.returnUrl;
        }

        public final boolean component6() {
            return this.enableLogging;
        }

        @Nullable
        public final StripeToolbarCustomization component7() {
            return this.toolbarCustomization;
        }

        @Nullable
        public final String component8() {
            return this.stripeAccountId;
        }

        public final boolean component9() {
            return this.shouldCancelSource;
        }

        public final boolean component10() {
            return this.shouldCancelIntentOnUserNavigation;
        }

        @Nullable
        public final Integer component11() {
            return this.statusBarColor;
        }

        @NotNull
        public final String component12() {
            return this.publishableKey;
        }

        public final boolean component13() {
            return this.isInstantApp;
        }

        @Nullable
        public final String component14() {
            return this.referrer;
        }

        public final boolean component15() {
            return this.forceInAppWebView;
        }

        @NotNull
        public final Args copy(@NotNull String objectId, int requestCode, @NotNull String clientSecret, @NotNull String url, @Nullable String returnUrl, boolean enableLogging, @Nullable StripeToolbarCustomization toolbarCustomization, @Nullable String stripeAccountId, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, @Nullable Integer statusBarColor, @NotNull String publishableKey, boolean isInstantApp, @Nullable String referrer, boolean forceInAppWebView) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
            return new Args(objectId, requestCode, clientSecret, url, returnUrl, enableLogging, toolbarCustomization, stripeAccountId, shouldCancelSource, shouldCancelIntentOnUserNavigation, statusBarColor, publishableKey, isInstantApp, referrer, forceInAppWebView);
        }

        public static /* synthetic */ Args copy$default(Args args, String string2, int n, String string3, String string4, String string5, boolean bl, StripeToolbarCustomization stripeToolbarCustomization, String string6, boolean bl2, boolean bl3, Integer n2, String string7, boolean bl4, String string8, boolean bl5, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string2 = args.objectId;
            }
            if ((n3 & 2) != 0) {
                n = args.requestCode;
            }
            if ((n3 & 4) != 0) {
                string3 = args.clientSecret;
            }
            if ((n3 & 8) != 0) {
                string4 = args.url;
            }
            if ((n3 & 0x10) != 0) {
                string5 = args.returnUrl;
            }
            if ((n3 & 0x20) != 0) {
                bl = args.enableLogging;
            }
            if ((n3 & 0x40) != 0) {
                stripeToolbarCustomization = args.toolbarCustomization;
            }
            if ((n3 & 0x80) != 0) {
                string6 = args.stripeAccountId;
            }
            if ((n3 & 0x100) != 0) {
                bl2 = args.shouldCancelSource;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = args.shouldCancelIntentOnUserNavigation;
            }
            if ((n3 & 0x400) != 0) {
                n2 = args.statusBarColor;
            }
            if ((n3 & 0x800) != 0) {
                string7 = args.publishableKey;
            }
            if ((n3 & 0x1000) != 0) {
                bl4 = args.isInstantApp;
            }
            if ((n3 & 0x2000) != 0) {
                string8 = args.referrer;
            }
            if ((n3 & 0x4000) != 0) {
                bl5 = args.forceInAppWebView;
            }
            return args.copy(string2, n, string3, string4, string5, bl, stripeToolbarCustomization, string6, bl2, bl3, n2, string7, bl4, string8, bl5);
        }

        @NotNull
        public String toString() {
            return "Args(objectId=" + this.objectId + ", requestCode=" + this.requestCode + ", clientSecret=" + this.clientSecret + ", url=" + this.url + ", returnUrl=" + this.returnUrl + ", enableLogging=" + this.enableLogging + ", toolbarCustomization=" + this.toolbarCustomization + ", stripeAccountId=" + this.stripeAccountId + ", shouldCancelSource=" + this.shouldCancelSource + ", shouldCancelIntentOnUserNavigation=" + this.shouldCancelIntentOnUserNavigation + ", statusBarColor=" + this.statusBarColor + ", publishableKey=" + this.publishableKey + ", isInstantApp=" + this.isInstantApp + ", referrer=" + this.referrer + ", forceInAppWebView=" + this.forceInAppWebView + ")";
        }

        public int hashCode() {
            int result = this.objectId.hashCode();
            result = result * 31 + Integer.hashCode(this.requestCode);
            result = result * 31 + this.clientSecret.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + (this.returnUrl == null ? 0 : this.returnUrl.hashCode());
            result = result * 31 + Boolean.hashCode(this.enableLogging);
            result = result * 31 + (this.toolbarCustomization == null ? 0 : this.toolbarCustomization.hashCode());
            result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
            result = result * 31 + Boolean.hashCode(this.shouldCancelSource);
            result = result * 31 + Boolean.hashCode(this.shouldCancelIntentOnUserNavigation);
            result = result * 31 + (this.statusBarColor == null ? 0 : ((Object)this.statusBarColor).hashCode());
            result = result * 31 + this.publishableKey.hashCode();
            result = result * 31 + Boolean.hashCode(this.isInstantApp);
            result = result * 31 + (this.referrer == null ? 0 : this.referrer.hashCode());
            result = result * 31 + Boolean.hashCode(this.forceInAppWebView);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.objectId, (Object)args.objectId)) {
                return false;
            }
            if (this.requestCode != args.requestCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)args.clientSecret)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)args.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.returnUrl, (Object)args.returnUrl)) {
                return false;
            }
            if (this.enableLogging != args.enableLogging) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolbarCustomization, (Object)args.toolbarCustomization)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)args.stripeAccountId)) {
                return false;
            }
            if (this.shouldCancelSource != args.shouldCancelSource) {
                return false;
            }
            if (this.shouldCancelIntentOnUserNavigation != args.shouldCancelIntentOnUserNavigation) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statusBarColor, (Object)args.statusBarColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)args.publishableKey)) {
                return false;
            }
            if (this.isInstantApp != args.isInstantApp) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referrer, (Object)args.referrer)) {
                return false;
            }
            return this.forceInAppWebView == args.forceInAppWebView;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001d\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "<init>", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "payments-core_release"})
        public static final class CREATOR
        implements Parcelable.Creator<Args> {
            private CREATOR() {
            }

            @NotNull
            public Args createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new Args(parcel);
            }

            @NotNull
            public Args[] newArray(int size) {
                return new Args[size];
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract$Companion;", "", "<init>", "()V", "EXTRA_ARGS", "", "parseArgs", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "intent", "Landroid/content/Intent;", "parseArgs$payments_core_release", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Args parseArgs$payments_core_release(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            return (Args)intent.getParcelableExtra(PaymentBrowserAuthContract.EXTRA_ARGS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

