/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.cards;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.CardAccountRangeSource;
import com.stripe.android.cards.CardAccountRangeStore;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.cards.DefaultCardAccountRangeRepository;
import com.stripe.android.cards.InMemoryCardAccountRangeSource;
import com.stripe.android.cards.InMemoryCardAccountRangeStore;
import com.stripe.android.cards.RemoteCardAccountRangeSource;
import com.stripe.android.cards.StaticCardAccountRangeSource;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.model.AccountRange;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001 B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeRepositoryFactory;", "Lcom/stripe/android/cards/CardAccountRangeRepository$Factory;", "context", "Landroid/content/Context;", "productUsageTokens", "", "", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "<init>", "(Landroid/content/Context;Ljava/util/Set;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;)V", "(Landroid/content/Context;Ljava/util/Set;)V", "appContext", "kotlin.jvm.PlatformType", "Landroid/content/Context;", "cardAccountRangeRepository", "Lkotlin/Lazy;", "Lcom/stripe/android/cards/DefaultCardAccountRangeRepository;", "create", "Lcom/stripe/android/cards/CardAccountRangeRepository;", "createWithStripeRepository", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "publishableKey", "createRemoteCardAccountRangeSource", "Lcom/stripe/android/cards/CardAccountRangeSource;", "store", "Lcom/stripe/android/cards/CardAccountRangeStore;", "fireAnalyticsEvent", "", "event", "Lcom/stripe/android/networking/PaymentAnalyticsEvent;", "NullCardAccountRangeSource", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class DefaultCardAccountRangeRepositoryFactory
implements CardAccountRangeRepository.Factory {
    @NotNull
    private final Set<String> productUsageTokens;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final Context appContext;
    @NotNull
    private final Lazy<DefaultCardAccountRangeRepository> cardAccountRangeRepository;
    public static final int $stable = 8;

    @Inject
    public DefaultCardAccountRangeRepositoryFactory(@NotNull Context context, @Named(value="productUsage") @NotNull Set<String> productUsageTokens, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        this.productUsageTokens = productUsageTokens;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.appContext = context.getApplicationContext();
        this.cardAccountRangeRepository = LazyKt.lazy(() -> DefaultCardAccountRangeRepositoryFactory.cardAccountRangeRepository$lambda$0(this));
    }

    @JvmOverloads
    public DefaultCardAccountRangeRepositoryFactory(@NotNull Context context, @NotNull Set<String> productUsageTokens) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(productUsageTokens, (String)"productUsageTokens");
        this(context, productUsageTokens, (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor());
    }

    public /* synthetic */ DefaultCardAccountRangeRepositoryFactory(Context context, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        this(context, set);
    }

    @Override
    @NotNull
    public CardAccountRangeRepository create() throws IllegalStateException {
        return (CardAccountRangeRepository)this.cardAccountRangeRepository.getValue();
    }

    @Override
    @NotNull
    public CardAccountRangeRepository createWithStripeRepository(@NotNull StripeRepository stripeRepository, @NotNull String publishableKey) {
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
        InMemoryCardAccountRangeStore store = new InMemoryCardAccountRangeStore();
        CardAccountRangeSource cardAccountRangeSource = new InMemoryCardAccountRangeSource(store);
        ApiRequest.Options options = new ApiRequest.Options(publishableKey, null, null, 6, null);
        CardAccountRangeStore cardAccountRangeStore = store;
        AnalyticsRequestExecutor analyticsRequestExecutor = (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor();
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        return new DefaultCardAccountRangeRepository(cardAccountRangeSource, new RemoteCardAccountRangeSource(stripeRepository, options, cardAccountRangeStore, analyticsRequestExecutor, new PaymentAnalyticsRequestFactory(context, publishableKey, this.productUsageTokens)), new StaticCardAccountRangeSource(null, 1, null), store);
    }

    private final CardAccountRangeSource createRemoteCardAccountRangeSource(CardAccountRangeStore store) {
        CardAccountRangeSource cardAccountRangeSource;
        Object publishableKey;
        Object $this$createRemoteCardAccountRangeSource_u24lambda_u241;
        Object object = this;
        try {
            $this$createRemoteCardAccountRangeSource_u24lambda_u241 = object;
            boolean bl = false;
            Context context = ((DefaultCardAccountRangeRepositoryFactory)$this$createRemoteCardAccountRangeSource_u24lambda_u241).appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            $this$createRemoteCardAccountRangeSource_u24lambda_u241 = Result.constructor-impl((Object)PaymentConfiguration.Companion.getInstance(context).getPublishableKey());
        }
        catch (Throwable bl) {
            $this$createRemoteCardAccountRangeSource_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createRemoteCardAccountRangeSource_u24lambda_u241;
        if (Result.isSuccess-impl((Object)object)) {
            publishableKey = (String)object;
            boolean bl = false;
            this.fireAnalyticsEvent((String)publishableKey, PaymentAnalyticsEvent.CardMetadataPublishableKeyAvailable);
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = publishableKey = throwable;
            boolean bl = false;
            this.fireAnalyticsEvent("pk_undefined", PaymentAnalyticsEvent.CardMetadataPublishableKeyUnavailable);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 == null) {
            publishableKey = (String)object;
            boolean bl = false;
            Context context = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            StripeRepository stripeRepository = new StripeApiRepository(context, () -> DefaultCardAccountRangeRepositoryFactory.createRemoteCardAccountRangeSource$lambda$5$lambda$4((String)publishableKey), null, null, null, null, null, null, null, null, null, null, null, null, null, 32764, null);
            ApiRequest.Options options = new ApiRequest.Options((String)publishableKey, null, null, 6, null);
            AnalyticsRequestExecutor analyticsRequestExecutor = (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor();
            Context context2 = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"appContext");
            cardAccountRangeSource = new RemoteCardAccountRangeSource(stripeRepository, options, store, analyticsRequestExecutor, new PaymentAnalyticsRequestFactory(context2, (String)publishableKey, this.productUsageTokens));
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            cardAccountRangeSource = new NullCardAccountRangeSource();
        }
        return cardAccountRangeSource;
    }

    private final void fireAnalyticsEvent(String publishableKey, PaymentAnalyticsEvent event) {
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(new PaymentAnalyticsRequestFactory(context, publishableKey, this.productUsageTokens), event, null, null, null, null, null, 62, null));
    }

    @JvmOverloads
    public DefaultCardAccountRangeRepositoryFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final DefaultCardAccountRangeRepository cardAccountRangeRepository$lambda$0(DefaultCardAccountRangeRepositoryFactory this$0) {
        InMemoryCardAccountRangeStore store = new InMemoryCardAccountRangeStore();
        return new DefaultCardAccountRangeRepository(new InMemoryCardAccountRangeSource(store), this$0.createRemoteCardAccountRangeSource(store), new StaticCardAccountRangeSource(null, 1, null), store);
    }

    private static final String createRemoteCardAccountRangeSource$lambda$5$lambda$4(String $publishableKey) {
        return $publishableKey;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeRepositoryFactory$NullCardAccountRangeSource;", "Lcom/stripe/android/cards/CardAccountRangeSource;", "<init>", "()V", "getAccountRanges", "", "Lcom/stripe/android/model/AccountRange;", "cardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "(Lcom/stripe/android/cards/CardNumber$Unvalidated;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loading", "Lkotlinx/coroutines/flow/StateFlow;", "", "getLoading", "()Lkotlinx/coroutines/flow/StateFlow;", "payments-core_release"})
    private static final class NullCardAccountRangeSource
    implements CardAccountRangeSource {
        @NotNull
        private final StateFlow<Boolean> loading = StateFlowsKt.stateFlowOf((Object)false);

        @Override
        @Nullable
        public Object getAccountRanges(@NotNull CardNumber.Unvalidated cardNumber, @NotNull Continuation<? super List<AccountRange>> $completion) {
            return null;
        }

        @Override
        @NotNull
        public StateFlow<Boolean> getLoading() {
            return this.loading;
        }

        @Override
        @Nullable
        public Object getAccountRange(@NotNull CardNumber.Unvalidated cardNumber, @NotNull Continuation<? super AccountRange> $completion) {
            return CardAccountRangeSource.DefaultImpls.getAccountRange(this, cardNumber, $completion);
        }
    }
}

