/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.cards;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.cards.Bin;
import com.stripe.android.cards.CardAccountRangeStore;
import com.stripe.android.model.AccountRange;
import com.stripe.android.model.parsers.AccountRangeJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeStore;", "Lcom/stripe/android/cards/CardAccountRangeStore;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "accountRangeJsonParser", "Lcom/stripe/android/model/parsers/AccountRangeJsonParser;", "prefs", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "getPrefs", "()Landroid/content/SharedPreferences;", "prefs$delegate", "Lkotlin/Lazy;", "get", "", "Lcom/stripe/android/model/AccountRange;", "bin", "Lcom/stripe/android/cards/Bin;", "(Lcom/stripe/android/cards/Bin;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "save", "", "accountRanges", "contains", "", "createPrefKey", "", "createPrefKey$payments_core_release", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultCardAccountRangeStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCardAccountRangeStore.kt\ncom/stripe/android/cards/DefaultCardAccountRangeStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1611#2,9:53\n1863#2:62\n1864#2:64\n1620#2:65\n1557#2:66\n1628#2,3:67\n1#3:63\n*S KotlinDebug\n*F\n+ 1 DefaultCardAccountRangeStore.kt\ncom/stripe/android/cards/DefaultCardAccountRangeStore\n*L\n21#1:53,9\n21#1:62\n21#1:64\n21#1:65\n30#1:66\n30#1:67,3\n21#1:63\n*E\n"})
public final class DefaultCardAccountRangeStore
implements CardAccountRangeStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final AccountRangeJsonParser accountRangeJsonParser;
    @NotNull
    private final Lazy prefs$delegate;
    public static final int $stable = 8;
    private static final int VERSION = 2;
    @NotNull
    private static final String PREF_FILE = "InMemoryCardAccountRangeSource.Store.2";
    @NotNull
    private static final String PREF_KEY_ACCOUNT_RANGES = "key_account_ranges";

    public DefaultCardAccountRangeStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.accountRangeJsonParser = new AccountRangeJsonParser();
        this.prefs$delegate = LazyKt.lazy(() -> DefaultCardAccountRangeStore.prefs_delegate$lambda$0(this));
    }

    private final SharedPreferences getPrefs() {
        Lazy lazy = this.prefs$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object get(@NotNull Bin bin, @NotNull Continuation<? super List<AccountRange>> $completion) {
        void $this$mapNotNullTo$iv$iv;
        Set set = this.getPrefs().getStringSet(this.createPrefKey$payments_core_release(bin), null);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AccountRange it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.accountRangeJsonParser.parse(new JSONObject(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(@NotNull Bin bin, @NotNull List<AccountRange> accountRanges) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter(accountRanges, (String)"accountRanges");
        Iterable $this$map$iv = accountRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AccountRange accountRange = (AccountRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.accountRangeJsonParser.serialize((AccountRange)it).toString());
        }
        Set serializedAccountRanges = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.getPrefs().edit().putStringSet(this.createPrefKey$payments_core_release(bin), serializedAccountRanges).apply();
    }

    @Override
    @Nullable
    public Object contains(@NotNull Bin bin, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)this.getPrefs().contains(this.createPrefKey$payments_core_release(bin)));
    }

    @VisibleForTesting
    @NotNull
    public final String createPrefKey$payments_core_release(@NotNull Bin bin) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        return "key_account_ranges:" + bin;
    }

    private static final SharedPreferences prefs_delegate$lambda$0(DefaultCardAccountRangeStore this$0) {
        return this$0.context.getSharedPreferences(PREF_FILE, 0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeStore$Companion;", "", "<init>", "()V", "VERSION", "", "PREF_FILE", "", "PREF_KEY_ACCOUNT_RANGES", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

