/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.googlepaylauncher;

import android.app.Application;
import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.stripe.android.GooglePayJsonFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.utils.CreationExtrasKtxKt;
import com.stripe.android.googlepaylauncher.ConvertKt;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncher;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherContractV2;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherViewModel;
import com.stripe.android.googlepaylauncher.GooglePayRepository;
import com.stripe.android.googlepaylauncher.TasksKt;
import com.stripe.android.googlepaylauncher.injection.DaggerGooglePayPaymentMethodLauncherViewModelFactoryComponent;
import com.stripe.android.googlepaylauncher.injection.GooglePayPaymentMethodLauncherViewModelSubcomponent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.networking.StripeRepository;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 22\u00020\u0001:\u000212BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bJ\u000e\u0010#\u001a\u00020\u0013H\u0087@\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0007J\u0015\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0086@\u00a2\u0006\u0002\u0010$J\u0016\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020-H\u0086@\u00a2\u0006\u0002\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "paymentsClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "args", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "googlePayJsonFactory", "Lcom/stripe/android/GooglePayJsonFactory;", "googlePayRepository", "Lcom/stripe/android/googlepaylauncher/GooglePayRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "<init>", "(Lcom/google/android/gms/wallet/PaymentsClient;Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/GooglePayJsonFactory;Lcom/stripe/android/googlepaylauncher/GooglePayRepository;Landroidx/lifecycle/SavedStateHandle;)V", "value", "", "hasLaunched", "getHasLaunched$payments_core_release", "()Z", "setHasLaunched$payments_core_release", "(Z)V", "_googleResult", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncher$Result;", "googlePayResult", "Lkotlinx/coroutines/flow/StateFlow;", "getGooglePayResult$payments_core_release", "()Lkotlinx/coroutines/flow/StateFlow;", "updateResult", "", "result", "isReadyToPay", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPaymentDataRequest", "Lorg/json/JSONObject;", "createTransactionInfo", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "createTransactionInfo$payments_core_release", "shouldHidePrice", "loadPaymentData", "Lcom/google/android/gms/tasks/Task;", "Lcom/google/android/gms/wallet/PaymentData;", "createPaymentMethod", "paymentData", "(Lcom/google/android/gms/wallet/PaymentData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class GooglePayPaymentMethodLauncherViewModel
extends ViewModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentsClient paymentsClient;
    @NotNull
    private final ApiRequest.Options requestOptions;
    @NotNull
    private final GooglePayPaymentMethodLauncherContractV2.Args args;
    @NotNull
    private final StripeRepository stripeRepository;
    @NotNull
    private final GooglePayJsonFactory googlePayJsonFactory;
    @NotNull
    private final GooglePayRepository googlePayRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final MutableStateFlow<GooglePayPaymentMethodLauncher.Result> _googleResult;
    @NotNull
    private final StateFlow<GooglePayPaymentMethodLauncher.Result> googlePayResult;
    public static final int $stable = 8;
    @NotNull
    private static final String HAS_LAUNCHED_KEY = "has_launched";

    @Inject
    public GooglePayPaymentMethodLauncherViewModel(@NotNull PaymentsClient paymentsClient, @NotNull ApiRequest.Options requestOptions, @NotNull GooglePayPaymentMethodLauncherContractV2.Args args, @NotNull StripeRepository stripeRepository, @NotNull GooglePayJsonFactory googlePayJsonFactory, @NotNull GooglePayRepository googlePayRepository, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)paymentsClient, (String)"paymentsClient");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)googlePayJsonFactory, (String)"googlePayJsonFactory");
        Intrinsics.checkNotNullParameter((Object)googlePayRepository, (String)"googlePayRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.paymentsClient = paymentsClient;
        this.requestOptions = requestOptions;
        this.args = args;
        this.stripeRepository = stripeRepository;
        this.googlePayJsonFactory = googlePayJsonFactory;
        this.googlePayRepository = googlePayRepository;
        this.savedStateHandle = savedStateHandle;
        this._googleResult = StateFlowKt.MutableStateFlow(null);
        this.googlePayResult = FlowKt.asStateFlow(this._googleResult);
    }

    public final boolean getHasLaunched$payments_core_release() {
        return Intrinsics.areEqual((Object)this.savedStateHandle.get(HAS_LAUNCHED_KEY), (Object)true);
    }

    public final void setHasLaunched$payments_core_release(boolean value) {
        this.savedStateHandle.set(HAS_LAUNCHED_KEY, (Object)value);
    }

    @NotNull
    public final StateFlow<GooglePayPaymentMethodLauncher.Result> getGooglePayResult$payments_core_release() {
        return this.googlePayResult;
    }

    public final void updateResult(@NotNull GooglePayPaymentMethodLauncher.Result result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this._googleResult.setValue((Object)result);
    }

    @VisibleForTesting
    @Nullable
    public final Object isReadyToPay(@NotNull Continuation<? super Boolean> $completion) {
        return FlowKt.first(this.googlePayRepository.isReady(), $completion);
    }

    @VisibleForTesting
    @NotNull
    public final JSONObject createPaymentDataRequest() {
        GooglePayJsonFactory googlePayJsonFactory = this.googlePayJsonFactory;
        GooglePayJsonFactory.TransactionInfo transactionInfo = this.createTransactionInfo$payments_core_release(this.args);
        GooglePayJsonFactory.MerchantInfo merchantInfo = new GooglePayJsonFactory.MerchantInfo(this.args.getConfig$payments_core_release().getMerchantName());
        GooglePayJsonFactory.BillingAddressParameters billingAddressParameters = ConvertKt.convert(this.args.getConfig$payments_core_release().getBillingAddressConfig());
        boolean bl = this.args.getConfig$payments_core_release().isEmailRequired();
        boolean bl2 = this.args.getConfig$payments_core_release().getAllowCreditCards();
        return GooglePayJsonFactory.createPaymentDataRequest$default(googlePayJsonFactory, transactionInfo, billingAddressParameters, null, bl, merchantInfo, bl2, 4, null);
    }

    @VisibleForTesting
    @NotNull
    public final GooglePayJsonFactory.TransactionInfo createTransactionInfo$payments_core_release(@NotNull GooglePayPaymentMethodLauncherContractV2.Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.shouldHidePrice(args) ? new GooglePayJsonFactory.TransactionInfo(args.getCurrencyCode$payments_core_release(), GooglePayJsonFactory.TransactionInfo.TotalPriceStatus.NotCurrentlyKnown, args.getConfig$payments_core_release().getMerchantCountryCode(), args.getTransactionId$payments_core_release(), null, args.getLabel$payments_core_release(), GooglePayJsonFactory.TransactionInfo.CheckoutOption.Default, 16, null) : new GooglePayJsonFactory.TransactionInfo(args.getCurrencyCode$payments_core_release(), GooglePayJsonFactory.TransactionInfo.TotalPriceStatus.Estimated, args.getConfig$payments_core_release().getMerchantCountryCode(), args.getTransactionId$payments_core_release(), args.getAmount$payments_core_release(), args.getLabel$payments_core_release(), GooglePayJsonFactory.TransactionInfo.CheckoutOption.Default);
    }

    private final boolean shouldHidePrice(GooglePayPaymentMethodLauncherContractV2.Args args) {
        return (StringsKt.equals((String)args.getConfig$payments_core_release().getMerchantCountryCode(), (String)Locale.US.getCountry(), (boolean)true) || StringsKt.equals((String)args.getConfig$payments_core_release().getMerchantCountryCode(), (String)Locale.CANADA.getCountry(), (boolean)true)) && args.getAmount$payments_core_release() == 0L;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object loadPaymentData(@NotNull Continuation<? super Task<PaymentData>> $completion) {
        if (!($completion instanceof loadPaymentData.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GooglePayPaymentMethodLauncherViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadPaymentData((Continuation<? super Task<PaymentData>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.isReadyToPay((Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GooglePayPaymentMethodLauncherViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    $i$a$-check-GooglePayPaymentMethodLauncherViewModel$loadPaymentData$2 = false;
                    var2_6 = "Google Pay is unavailable.";
                    throw new IllegalStateException(var2_6.toString());
                }
                v1 = this.paymentsClient.loadPaymentData(PaymentDataRequest.fromJson((String)this.createPaymentDataRequest().toString()));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"loadPaymentData(...)");
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = TasksKt.awaitTask$default(v1, null, (Continuation)$continuation, 1, null);
                if (v2 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl37
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl37:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createPaymentMethod(@NotNull PaymentData var1_1, @NotNull Continuation<? super GooglePayPaymentMethodLauncher.Result> $completion) {
        if (!($completion instanceof createPaymentMethod.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ GooglePayPaymentMethodLauncherViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createPaymentMethod(null, (Continuation<? super GooglePayPaymentMethodLauncher.Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                paymentDataJson = new JSONObject(paymentData.toJson());
                params = PaymentMethodCreateParams.Companion.createFromGooglePay(paymentDataJson);
                $continuation.label = 1;
                v0 = this.stripeRepository.createPaymentMethod-0E7RQCE(params, this.requestOptions, (Continuation<? super Result<PaymentMethod>>)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl22:
                // 2 sources

                var5_8 = v0;
                v1 = Result.exceptionOrNull-impl((Object)var5_8);
                if (v1 == null) {
                    it = (PaymentMethod)var5_8;
                    $i$a$-fold-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$2 = false;
                    v2 = new GooglePayPaymentMethodLauncher.Result.Completed(it);
                } else {
                    it = v1;
                    $i$a$-fold-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$3 = false;
                    var8_13 = it;
                    v2 = new GooglePayPaymentMethodLauncher.Result.Failed(it, var8_13 instanceof APIConnectionException != false ? 3 : (var8_13 instanceof InvalidRequestException != false ? 2 : 1));
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Companion;", "", "<init>", "()V", "HAS_LAUNCHED_KEY", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "args", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;", "<init>", "(Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final GooglePayPaymentMethodLauncherContractV2.Args args;
        public static final int $stable = 8;

        public Factory(@NotNull GooglePayPaymentMethodLauncherContractV2.Args args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.args = args;
        }

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Application application = CreationExtrasKtxKt.requireApplication((CreationExtras)extras);
            SavedStateHandle savedStateHandle = SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras);
            GooglePayPaymentMethodLauncherViewModelSubcomponent.Builder subComponentBuilder = DaggerGooglePayPaymentMethodLauncherViewModelFactoryComponent.builder().context((Context)application).enableLogging(false).publishableKeyProvider((Function0<String>)((Function0)() -> Factory.create$lambda$0(application))).stripeAccountIdProvider((Function0<String>)((Function0)() -> Factory.create$lambda$1(application))).productUsage(SetsKt.setOf((Object)"GooglePayPaymentMethodLauncher")).googlePayConfig(this.args.getConfig$payments_core_release()).cardBrandFilter(this.args.getCardBrandFilter$payments_core_release()).build().getSubcomponentBuilder();
            GooglePayPaymentMethodLauncherViewModel googlePayPaymentMethodLauncherViewModel = subComponentBuilder.args(this.args).savedStateHandle(savedStateHandle).build().getViewModel();
            Intrinsics.checkNotNull((Object)((Object)googlePayPaymentMethodLauncherViewModel), (String)"null cannot be cast to non-null type T of com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherViewModel.Factory.create");
            return (T)((Object)googlePayPaymentMethodLauncherViewModel);
        }

        private static final String create$lambda$0(Application $application) {
            return PaymentConfiguration.Companion.getInstance((Context)$application).getPublishableKey();
        }

        private static final String create$lambda$1(Application $application) {
            return PaymentConfiguration.Companion.getInstance((Context)$application).getStripeAccountId();
        }
    }
}

