/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.SetupIntentJsonParser;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\b\u0018\u0000 d2\u00020\u0001:\u0004abcdB\u00c1\u0001\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0016\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010:09H\u0017J\b\u0010B\u001a\u00020\fH\u0016J\b\u0010C\u001a\u00020\fH\u0016J\u000b\u0010D\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010F\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010J\u001a\u00020\fH\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003J\u000f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u00c6\u0003J\u000f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u00c6\u0003J\u000b\u0010S\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010T\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u00dd\u0001\u0010U\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010V\u001a\u00020WJ\u0013\u0010X\u001a\u00020\f2\b\u0010Y\u001a\u0004\u0018\u00010:H\u00d6\u0003J\t\u0010Z\u001a\u00020WH\u00d6\u0001J\t\u0010[\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020WR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00038WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010 R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010 R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010 R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010(R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010 R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010-R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010-R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\u0004\u0018\u00010<8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010(R\u0016\u0010@\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010 \u00a8\u0006e"}, d2={"Lcom/stripe/android/model/SetupIntent;", "Lcom/stripe/android/model/StripeIntent;", "id", "", "cancellationReason", "Lcom/stripe/android/model/SetupIntent$CancellationReason;", "created", "", "countryCode", "clientSecret", "description", "isLiveMode", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "paymentMethodTypes", "", "status", "Lcom/stripe/android/model/StripeIntent$Status;", "usage", "Lcom/stripe/android/model/StripeIntent$Usage;", "lastSetupError", "Lcom/stripe/android/model/SetupIntent$Error;", "unactivatedPaymentMethods", "linkFundingSources", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "paymentMethodOptionsJsonString", "<init>", "(Ljava/lang/String;Lcom/stripe/android/model/SetupIntent$CancellationReason;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/stripe/android/model/PaymentMethod;Ljava/lang/String;Ljava/util/List;Lcom/stripe/android/model/StripeIntent$Status;Lcom/stripe/android/model/StripeIntent$Usage;Lcom/stripe/android/model/SetupIntent$Error;Ljava/util/List;Ljava/util/List;Lcom/stripe/android/model/StripeIntent$NextActionData;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getCancellationReason", "()Lcom/stripe/android/model/SetupIntent$CancellationReason;", "getCreated", "()J", "getCountryCode", "getClientSecret", "getDescription", "()Z", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethodId", "getPaymentMethodTypes", "()Ljava/util/List;", "getStatus", "()Lcom/stripe/android/model/StripeIntent$Status;", "getUsage", "()Lcom/stripe/android/model/StripeIntent$Usage;", "getLastSetupError", "()Lcom/stripe/android/model/SetupIntent$Error;", "getUnactivatedPaymentMethods", "getLinkFundingSources", "getNextActionData", "()Lcom/stripe/android/model/StripeIntent$NextActionData;", "getPaymentMethodOptions", "", "", "nextActionType", "Lcom/stripe/android/model/StripeIntent$NextActionType;", "getNextActionType", "()Lcom/stripe/android/model/StripeIntent$NextActionType;", "isConfirmed", "lastErrorMessage", "getLastErrorMessage", "requiresAction", "requiresConfirmation", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "copy", "describeContents", "", "equals", "other", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Error", "ClientSecret", "CancellationReason", "Companion", "payments-core_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class SetupIntent
implements StripeIntent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String id;
    @Nullable
    private final CancellationReason cancellationReason;
    private final long created;
    @Nullable
    private final String countryCode;
    @Nullable
    private final String clientSecret;
    @Nullable
    private final String description;
    private final boolean isLiveMode;
    @Nullable
    private final PaymentMethod paymentMethod;
    @Nullable
    private final String paymentMethodId;
    @NotNull
    private final List<String> paymentMethodTypes;
    @Nullable
    private final StripeIntent.Status status;
    @Nullable
    private final StripeIntent.Usage usage;
    @Nullable
    private final Error lastSetupError;
    @NotNull
    private final List<String> unactivatedPaymentMethods;
    @NotNull
    private final List<String> linkFundingSources;
    @Nullable
    private final StripeIntent.NextActionData nextActionData;
    @Nullable
    private final String paymentMethodOptionsJsonString;
    @NotNull
    public static final Parcelable.Creator<SetupIntent> CREATOR;
    public static final int $stable;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SetupIntent(@Nullable String id2, @Nullable CancellationReason cancellationReason, long created, @Nullable String countryCode, @Nullable String clientSecret, @Nullable String description, boolean isLiveMode, @Nullable PaymentMethod paymentMethod, @Nullable String paymentMethodId, @NotNull List<String> paymentMethodTypes, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage usage, @Nullable Error lastSetupError, @NotNull List<String> unactivatedPaymentMethods, @NotNull List<String> linkFundingSources, @Nullable StripeIntent.NextActionData nextActionData, @Nullable String paymentMethodOptionsJsonString) {
        Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
        Intrinsics.checkNotNullParameter(unactivatedPaymentMethods, (String)"unactivatedPaymentMethods");
        Intrinsics.checkNotNullParameter(linkFundingSources, (String)"linkFundingSources");
        this.id = id2;
        this.cancellationReason = cancellationReason;
        this.created = created;
        this.countryCode = countryCode;
        this.clientSecret = clientSecret;
        this.description = description;
        this.isLiveMode = isLiveMode;
        this.paymentMethod = paymentMethod;
        this.paymentMethodId = paymentMethodId;
        this.paymentMethodTypes = paymentMethodTypes;
        this.status = status;
        this.usage = usage;
        this.lastSetupError = lastSetupError;
        this.unactivatedPaymentMethods = unactivatedPaymentMethods;
        this.linkFundingSources = linkFundingSources;
        this.nextActionData = nextActionData;
        this.paymentMethodOptionsJsonString = paymentMethodOptionsJsonString;
    }

    public /* synthetic */ SetupIntent(String string2, CancellationReason cancellationReason, long l, String string3, String string4, String string5, boolean bl, PaymentMethod paymentMethod, String string6, List list, StripeIntent.Status status, StripeIntent.Usage usage, Error error, List list2, List list3, StripeIntent.NextActionData nextActionData, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            paymentMethod = null;
        }
        if ((n & 0x1000) != 0) {
            error = null;
        }
        if ((n & 0x10000) != 0) {
            string7 = null;
        }
        this(string2, cancellationReason, l, string3, string4, string5, bl, paymentMethod, string6, list, status, usage, error, list2, list3, nextActionData, string7);
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public final CancellationReason getCancellationReason() {
        return this.cancellationReason;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isLiveMode() {
        return this.isLiveMode;
    }

    @Override
    @Nullable
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @Override
    @Nullable
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Override
    @NotNull
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Override
    @Nullable
    public StripeIntent.Status getStatus() {
        return this.status;
    }

    @Nullable
    public final StripeIntent.Usage getUsage() {
        return this.usage;
    }

    @Nullable
    public final Error getLastSetupError() {
        return this.lastSetupError;
    }

    @Override
    @NotNull
    public List<String> getUnactivatedPaymentMethods() {
        return this.unactivatedPaymentMethods;
    }

    @Override
    @NotNull
    public List<String> getLinkFundingSources() {
        return this.linkFundingSources;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionData getNextActionData() {
        return this.nextActionData;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public Map<String, Object> getPaymentMethodOptions() {
        Object object;
        block3: {
            block2: {
                object = this.paymentMethodOptionsJsonString;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Map map = StripeJsonUtils.INSTANCE.jsonObjectToMap(new JSONObject(it));
                object = map;
                if (map != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionType getNextActionType() {
        StripeIntent.NextActionType nextActionType;
        StripeIntent.NextActionData nextActionData = this.getNextActionData();
        if (nextActionData instanceof StripeIntent.NextActionData.SdkData) {
            nextActionType = StripeIntent.NextActionType.UseStripeSdk;
        } else if (nextActionData instanceof StripeIntent.NextActionData.RedirectToUrl) {
            nextActionType = StripeIntent.NextActionType.RedirectToUrl;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayOxxoDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayOxxoDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayBoletoDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayBoletoDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayKonbiniDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayKonbiniDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayMultibancoDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayMultibancoDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.VerifyWithMicrodeposits) {
            nextActionType = StripeIntent.NextActionType.VerifyWithMicrodeposits;
        } else if (nextActionData instanceof StripeIntent.NextActionData.CashAppRedirect) {
            nextActionType = StripeIntent.NextActionType.CashAppRedirect;
        } else if (nextActionData instanceof StripeIntent.NextActionData.AlipayRedirect || nextActionData instanceof StripeIntent.NextActionData.BlikAuthorize || nextActionData instanceof StripeIntent.NextActionData.WeChatPayRedirect || nextActionData instanceof StripeIntent.NextActionData.UpiAwaitNotification || nextActionData instanceof StripeIntent.NextActionData.SwishRedirect || nextActionData == null) {
            nextActionType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nextActionType;
    }

    @Override
    public boolean isConfirmed() {
        StripeIntent.Status[] statusArray = new StripeIntent.Status[]{StripeIntent.Status.Processing, StripeIntent.Status.Succeeded};
        return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])statusArray), (Object)((Object)this.getStatus()));
    }

    @Override
    @Nullable
    public String getLastErrorMessage() {
        Error error = this.lastSetupError;
        return error != null ? error.getMessage() : null;
    }

    @Override
    public boolean requiresAction() {
        return this.getStatus() == StripeIntent.Status.RequiresAction;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.getStatus() == StripeIntent.Status.RequiresConfirmation;
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.id);
        Object object = this.cancellationReason;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(((Enum)object).name());
        }
        dest.writeLong(this.created);
        dest.writeString(this.countryCode);
        dest.writeString(this.clientSecret);
        dest.writeString(this.description);
        dest.writeInt(this.isLiveMode ? 1 : 0);
        object = this.paymentMethod;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((PaymentMethod)object).writeToParcel(dest, flags);
        }
        dest.writeString(this.paymentMethodId);
        dest.writeStringList(this.paymentMethodTypes);
        object = this.status;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(((Enum)object).name());
        }
        object = this.usage;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(((Enum)object).name());
        }
        object = this.lastSetupError;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((Error)object).writeToParcel(dest, flags);
        }
        dest.writeStringList(this.unactivatedPaymentMethods);
        dest.writeStringList(this.linkFundingSources);
        dest.writeParcelable((Parcelable)this.nextActionData, flags);
        dest.writeString(this.paymentMethodOptionsJsonString);
    }

    public final int describeContents() {
        return 0;
    }

    @Nullable
    public final String component1() {
        return this.id;
    }

    @Nullable
    public final CancellationReason component2() {
        return this.cancellationReason;
    }

    public final long component3() {
        return this.created;
    }

    @Nullable
    public final String component4() {
        return this.countryCode;
    }

    @Nullable
    public final String component5() {
        return this.clientSecret;
    }

    @Nullable
    public final String component6() {
        return this.description;
    }

    public final boolean component7() {
        return this.isLiveMode;
    }

    @Nullable
    public final PaymentMethod component8() {
        return this.paymentMethod;
    }

    @Nullable
    public final String component9() {
        return this.paymentMethodId;
    }

    @NotNull
    public final List<String> component10() {
        return this.paymentMethodTypes;
    }

    @Nullable
    public final StripeIntent.Status component11() {
        return this.status;
    }

    @Nullable
    public final StripeIntent.Usage component12() {
        return this.usage;
    }

    @Nullable
    public final Error component13() {
        return this.lastSetupError;
    }

    @NotNull
    public final List<String> component14() {
        return this.unactivatedPaymentMethods;
    }

    @NotNull
    public final List<String> component15() {
        return this.linkFundingSources;
    }

    @Nullable
    public final StripeIntent.NextActionData component16() {
        return this.nextActionData;
    }

    private final String component17() {
        return this.paymentMethodOptionsJsonString;
    }

    @NotNull
    public final SetupIntent copy(@Nullable String id2, @Nullable CancellationReason cancellationReason, long created, @Nullable String countryCode, @Nullable String clientSecret, @Nullable String description, boolean isLiveMode, @Nullable PaymentMethod paymentMethod, @Nullable String paymentMethodId, @NotNull List<String> paymentMethodTypes, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage usage, @Nullable Error lastSetupError, @NotNull List<String> unactivatedPaymentMethods, @NotNull List<String> linkFundingSources, @Nullable StripeIntent.NextActionData nextActionData, @Nullable String paymentMethodOptionsJsonString) {
        Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
        Intrinsics.checkNotNullParameter(unactivatedPaymentMethods, (String)"unactivatedPaymentMethods");
        Intrinsics.checkNotNullParameter(linkFundingSources, (String)"linkFundingSources");
        return new SetupIntent(id2, cancellationReason, created, countryCode, clientSecret, description, isLiveMode, paymentMethod, paymentMethodId, paymentMethodTypes, status, usage, lastSetupError, unactivatedPaymentMethods, linkFundingSources, nextActionData, paymentMethodOptionsJsonString);
    }

    public static /* synthetic */ SetupIntent copy$default(SetupIntent setupIntent, String string2, CancellationReason cancellationReason, long l, String string3, String string4, String string5, boolean bl, PaymentMethod paymentMethod, String string6, List list, StripeIntent.Status status, StripeIntent.Usage usage, Error error, List list2, List list3, StripeIntent.NextActionData nextActionData, String string7, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = setupIntent.id;
        }
        if ((n & 2) != 0) {
            cancellationReason = setupIntent.cancellationReason;
        }
        if ((n & 4) != 0) {
            l = setupIntent.created;
        }
        if ((n & 8) != 0) {
            string3 = setupIntent.countryCode;
        }
        if ((n & 0x10) != 0) {
            string4 = setupIntent.clientSecret;
        }
        if ((n & 0x20) != 0) {
            string5 = setupIntent.description;
        }
        if ((n & 0x40) != 0) {
            bl = setupIntent.isLiveMode;
        }
        if ((n & 0x80) != 0) {
            paymentMethod = setupIntent.paymentMethod;
        }
        if ((n & 0x100) != 0) {
            string6 = setupIntent.paymentMethodId;
        }
        if ((n & 0x200) != 0) {
            list = setupIntent.paymentMethodTypes;
        }
        if ((n & 0x400) != 0) {
            status = setupIntent.status;
        }
        if ((n & 0x800) != 0) {
            usage = setupIntent.usage;
        }
        if ((n & 0x1000) != 0) {
            error = setupIntent.lastSetupError;
        }
        if ((n & 0x2000) != 0) {
            list2 = setupIntent.unactivatedPaymentMethods;
        }
        if ((n & 0x4000) != 0) {
            list3 = setupIntent.linkFundingSources;
        }
        if ((n & 0x8000) != 0) {
            nextActionData = setupIntent.nextActionData;
        }
        if ((n & 0x10000) != 0) {
            string7 = setupIntent.paymentMethodOptionsJsonString;
        }
        return setupIntent.copy(string2, cancellationReason, l, string3, string4, string5, bl, paymentMethod, string6, list, status, usage, error, list2, list3, nextActionData, string7);
    }

    @NotNull
    public String toString() {
        return "SetupIntent(id=" + this.id + ", cancellationReason=" + this.cancellationReason + ", created=" + this.created + ", countryCode=" + this.countryCode + ", clientSecret=" + this.clientSecret + ", description=" + this.description + ", isLiveMode=" + this.isLiveMode + ", paymentMethod=" + this.paymentMethod + ", paymentMethodId=" + this.paymentMethodId + ", paymentMethodTypes=" + this.paymentMethodTypes + ", status=" + this.status + ", usage=" + this.usage + ", lastSetupError=" + this.lastSetupError + ", unactivatedPaymentMethods=" + this.unactivatedPaymentMethods + ", linkFundingSources=" + this.linkFundingSources + ", nextActionData=" + this.nextActionData + ", paymentMethodOptionsJsonString=" + this.paymentMethodOptionsJsonString + ")";
    }

    public int hashCode() {
        int result = this.id == null ? 0 : this.id.hashCode();
        result = result * 31 + (this.cancellationReason == null ? 0 : this.cancellationReason.hashCode());
        result = result * 31 + Long.hashCode(this.created);
        result = result * 31 + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = result * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + Boolean.hashCode(this.isLiveMode);
        result = result * 31 + (this.paymentMethod == null ? 0 : this.paymentMethod.hashCode());
        result = result * 31 + (this.paymentMethodId == null ? 0 : this.paymentMethodId.hashCode());
        result = result * 31 + ((Object)this.paymentMethodTypes).hashCode();
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        result = result * 31 + (this.usage == null ? 0 : this.usage.hashCode());
        result = result * 31 + (this.lastSetupError == null ? 0 : this.lastSetupError.hashCode());
        result = result * 31 + ((Object)this.unactivatedPaymentMethods).hashCode();
        result = result * 31 + ((Object)this.linkFundingSources).hashCode();
        result = result * 31 + (this.nextActionData == null ? 0 : this.nextActionData.hashCode());
        result = result * 31 + (this.paymentMethodOptionsJsonString == null ? 0 : this.paymentMethodOptionsJsonString.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetupIntent)) {
            return false;
        }
        SetupIntent setupIntent = (SetupIntent)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)setupIntent.id)) {
            return false;
        }
        if (this.cancellationReason != setupIntent.cancellationReason) {
            return false;
        }
        if (this.created != setupIntent.created) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.countryCode, (Object)setupIntent.countryCode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)setupIntent.clientSecret)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)setupIntent.description)) {
            return false;
        }
        if (this.isLiveMode != setupIntent.isLiveMode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)setupIntent.paymentMethod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethodId, (Object)setupIntent.paymentMethodId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paymentMethodTypes, setupIntent.paymentMethodTypes)) {
            return false;
        }
        if (this.status != setupIntent.status) {
            return false;
        }
        if (this.usage != setupIntent.usage) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastSetupError, (Object)setupIntent.lastSetupError)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unactivatedPaymentMethods, setupIntent.unactivatedPaymentMethods)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.linkFundingSources, setupIntent.linkFundingSources)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.nextActionData, (Object)setupIntent.nextActionData)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.paymentMethodOptionsJsonString, (Object)setupIntent.paymentMethodOptionsJsonString);
    }

    @JvmStatic
    @Nullable
    public static final SetupIntent fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<SetupIntent> {
            public final SetupIntent[] newArray(int size) {
                return new SetupIntent[size];
            }

            public final SetupIntent createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new SetupIntent(parcel.readString(), parcel.readInt() == 0 ? null : CancellationReason.valueOf(parcel.readString()), parcel.readLong(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt() != 0, (PaymentMethod)(parcel.readInt() == 0 ? null : PaymentMethod.CREATOR.createFromParcel(parcel)), parcel.readString(), parcel.createStringArrayList(), parcel.readInt() == 0 ? null : StripeIntent.Status.valueOf(parcel.readString()), parcel.readInt() == 0 ? null : StripeIntent.Usage.valueOf(parcel.readString()), (Error)(parcel.readInt() == 0 ? null : Error.CREATOR.createFromParcel(parcel)), parcel.createStringArrayList(), parcel.createStringArrayList(), (StripeIntent.NextActionData)parcel.readParcelable(SetupIntent.class.getClassLoader()), parcel.readString());
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/SetupIntent$CancellationReason;", "", "code", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Duplicate", "RequestedByCustomer", "Abandoned", "Companion", "payments-core_release"})
    public static final class CancellationReason
    extends Enum<CancellationReason> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ CancellationReason Duplicate;
        public static final /* enum */ CancellationReason RequestedByCustomer;
        public static final /* enum */ CancellationReason Abandoned;
        private static final /* synthetic */ CancellationReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CancellationReason(String code) {
            this.code = code;
        }

        public static CancellationReason[] values() {
            return (CancellationReason[])$VALUES.clone();
        }

        public static CancellationReason valueOf(String value) {
            return Enum.valueOf(CancellationReason.class, value);
        }

        @NotNull
        public static EnumEntries<CancellationReason> getEntries() {
            return $ENTRIES;
        }

        static {
            Duplicate = new CancellationReason("duplicate");
            RequestedByCustomer = new CancellationReason("requested_by_customer");
            Abandoned = new CancellationReason("abandoned");
            $VALUES = cancellationReasonArray = new CancellationReason[]{CancellationReason.Duplicate, CancellationReason.RequestedByCustomer, CancellationReason.Abandoned};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/SetupIntent$CancellationReason$Companion;", "", "<init>", "()V", "fromCode", "Lcom/stripe/android/model/SetupIntent$CancellationReason;", "code", "", "fromCode$payments_core_release", "payments-core_release"})
        @SourceDebugExtension(value={"SMAP\nSetupIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupIntent.kt\ncom/stripe/android/model/SetupIntent$CancellationReason$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n295#2,2:285\n*S KotlinDebug\n*F\n+ 1 SetupIntent.kt\ncom/stripe/android/model/SetupIntent$CancellationReason$Companion\n*L\n270#1:285,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final CancellationReason fromCode$payments_core_release(@Nullable String code) {
                Object v0;
                block1: {
                    Iterable $this$firstOrNull$iv = (Iterable)CancellationReason.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        CancellationReason it = (CancellationReason)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.code, (Object)code)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000bJ\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/model/SetupIntent$ClientSecret;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue$payments_core_release", "()Ljava/lang/String;", "setupIntentId", "getSetupIntentId$payments_core_release", "component1", "component1$payments_core_release", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nSetupIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupIntent.kt\ncom/stripe/android/model/SetupIntent$ClientSecret\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,284:1\n739#2,9:285\n37#3:294\n36#3,3:295\n*S KotlinDebug\n*F\n+ 1 SetupIntent.kt\ncom/stripe/android/model/SetupIntent$ClientSecret\n*L\n245#1:285,9\n245#1:294\n245#1:295,3\n*E\n"})
    public static final class ClientSecret {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String value;
        @NotNull
        private final String setupIntentId;
        public static final int $stable;
        private static final Pattern PATTERN;

        /*
         * WARNING - void declaration
         */
        public ClientSecret(@NotNull String value) {
            List list;
            void $this$dropLastWhile$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            Object object = this.value;
            Regex regex = new Regex("_secret");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            ClientSecret clientSecret = this;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            clientSecret.setupIntentId = thisCollection$iv.toArray(new String[0])[0];
            if (!Companion.isMatch(this.value)) {
                boolean bl = false;
                String string2 = "Invalid Setup Intent client secret: " + this.value;
                throw new IllegalArgumentException(string2.toString());
            }
        }

        @NotNull
        public final String getValue$payments_core_release() {
            return this.value;
        }

        @NotNull
        public final String getSetupIntentId$payments_core_release() {
            return this.setupIntentId;
        }

        @NotNull
        public final String component1$payments_core_release() {
            return this.value;
        }

        @NotNull
        public final ClientSecret copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ClientSecret(value);
        }

        public static /* synthetic */ ClientSecret copy$default(ClientSecret clientSecret, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = clientSecret.value;
            }
            return clientSecret.copy(string2);
        }

        @NotNull
        public String toString() {
            return "ClientSecret(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientSecret)) {
                return false;
            }
            ClientSecret clientSecret = (ClientSecret)other;
            return Intrinsics.areEqual((Object)this.value, (Object)clientSecret.value);
        }

        static {
            PATTERN = Pattern.compile("^seti_[^_]+_secret_[^_]+$");
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/SetupIntent$ClientSecret$Companion;", "", "<init>", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "isMatch", "", "value", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isMatch(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return PATTERN.matcher(value).matches();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/SetupIntent$Companion;", "", "<init>", "()V", "fromJson", "Lcom/stripe/android/model/SetupIntent;", "jsonObject", "Lorg/json/JSONObject;", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SetupIntent fromJson(@Nullable JSONObject jsonObject) {
            SetupIntent setupIntent;
            JSONObject jSONObject = jsonObject;
            if (jSONObject != null) {
                JSONObject it = jSONObject;
                boolean bl = false;
                setupIntent = new SetupIntentJsonParser().parse(it);
            } else {
                setupIntent = null;
            }
            return setupIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 /2\u00020\u0001:\u0002./BO\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003Jb\u0010\u001f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c0\u0001\u00a2\u0006\u0002\b J\u0006\u0010!\u001a\u00020\"J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\"H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\"R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lcom/stripe/android/model/SetupIntent$Error;", "Lcom/stripe/android/core/model/StripeModel;", "code", "", "declineCode", "docUrl", "message", "param", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "type", "Lcom/stripe/android/model/SetupIntent$Error$Type;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/model/SetupIntent$Error$Type;)V", "getCode", "()Ljava/lang/String;", "getDeclineCode", "getDocUrl", "getMessage", "getParam", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getType", "()Lcom/stripe/android/model/SetupIntent$Error$Type;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "copy$payments_core_release", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Type", "Companion", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Error
    implements StripeModel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String code;
        @Nullable
        private final String declineCode;
        @Nullable
        private final String docUrl;
        @Nullable
        private final String message;
        @Nullable
        private final String param;
        @Nullable
        private final PaymentMethod paymentMethod;
        @Nullable
        private final Type type;
        @NotNull
        public static final Parcelable.Creator<Error> CREATOR;
        public static final int $stable;
        @NotNull
        public static final String CODE_AUTHENTICATION_ERROR = "setup_intent_authentication_failure";

        public Error(@Nullable String code, @Nullable String declineCode, @Nullable String docUrl, @Nullable String message, @Nullable String param, @Nullable PaymentMethod paymentMethod, @Nullable Type type) {
            this.code = code;
            this.declineCode = declineCode;
            this.docUrl = docUrl;
            this.message = message;
            this.param = param;
            this.paymentMethod = paymentMethod;
            this.type = type;
        }

        @Nullable
        public final String getCode() {
            return this.code;
        }

        @Nullable
        public final String getDeclineCode() {
            return this.declineCode;
        }

        @Nullable
        public final String getDocUrl() {
            return this.docUrl;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getParam() {
            return this.param;
        }

        @Nullable
        public final PaymentMethod getPaymentMethod() {
            return this.paymentMethod;
        }

        @Nullable
        public final Type getType() {
            return this.type;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.code);
            dest.writeString(this.declineCode);
            dest.writeString(this.docUrl);
            dest.writeString(this.message);
            dest.writeString(this.param);
            Object object = this.paymentMethod;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                ((PaymentMethod)object).writeToParcel(dest, flags);
            }
            object = this.type;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(((Enum)object).name());
            }
        }

        public final int describeContents() {
            return 0;
        }

        @Nullable
        public final String component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.declineCode;
        }

        @Nullable
        public final String component3() {
            return this.docUrl;
        }

        @Nullable
        public final String component4() {
            return this.message;
        }

        @Nullable
        public final String component5() {
            return this.param;
        }

        @Nullable
        public final PaymentMethod component6() {
            return this.paymentMethod;
        }

        @Nullable
        public final Type component7() {
            return this.type;
        }

        @NotNull
        public final Error copy$payments_core_release(@Nullable String code, @Nullable String declineCode, @Nullable String docUrl, @Nullable String message, @Nullable String param, @Nullable PaymentMethod paymentMethod, @Nullable Type type) {
            return new Error(code, declineCode, docUrl, message, param, paymentMethod, type);
        }

        public static /* synthetic */ Error copy$payments_core_release$default(Error error, String string2, String string3, String string4, String string5, String string6, PaymentMethod paymentMethod, Type type, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = error.code;
            }
            if ((n & 2) != 0) {
                string3 = error.declineCode;
            }
            if ((n & 4) != 0) {
                string4 = error.docUrl;
            }
            if ((n & 8) != 0) {
                string5 = error.message;
            }
            if ((n & 0x10) != 0) {
                string6 = error.param;
            }
            if ((n & 0x20) != 0) {
                paymentMethod = error.paymentMethod;
            }
            if ((n & 0x40) != 0) {
                type = error.type;
            }
            return error.copy$payments_core_release(string2, string3, string4, string5, string6, paymentMethod, type);
        }

        @NotNull
        public String toString() {
            return "Error(code=" + this.code + ", declineCode=" + this.declineCode + ", docUrl=" + this.docUrl + ", message=" + this.message + ", param=" + this.param + ", paymentMethod=" + this.paymentMethod + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.code == null ? 0 : this.code.hashCode();
            result = result * 31 + (this.declineCode == null ? 0 : this.declineCode.hashCode());
            result = result * 31 + (this.docUrl == null ? 0 : this.docUrl.hashCode());
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            result = result * 31 + (this.param == null ? 0 : this.param.hashCode());
            result = result * 31 + (this.paymentMethod == null ? 0 : this.paymentMethod.hashCode());
            result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error = (Error)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)error.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.declineCode, (Object)error.declineCode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.docUrl, (Object)error.docUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)error.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.param, (Object)error.param)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)error.paymentMethod)) {
                return false;
            }
            return this.type == error.type;
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Error> {
                public final Error[] newArray(int size) {
                    return new Error[size];
                }

                public final Error createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Error(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), (PaymentMethod)(parcel.readInt() == 0 ? null : PaymentMethod.CREATOR.createFromParcel(parcel)), parcel.readInt() == 0 ? null : Type.valueOf(parcel.readString()));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/SetupIntent$Error$Companion;", "", "<init>", "()V", "CODE_AUTHENTICATION_ERROR", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/model/SetupIntent$Error$Type;", "", "code", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "ApiConnectionError", "ApiError", "AuthenticationError", "CardError", "IdempotencyError", "InvalidRequestError", "RateLimitError", "Companion", "payments-core_release"})
        public static final class Type
        extends Enum<Type> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String code;
            public static final /* enum */ Type ApiConnectionError;
            public static final /* enum */ Type ApiError;
            public static final /* enum */ Type AuthenticationError;
            public static final /* enum */ Type CardError;
            public static final /* enum */ Type IdempotencyError;
            public static final /* enum */ Type InvalidRequestError;
            public static final /* enum */ Type RateLimitError;
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(String code) {
                this.code = code;
            }

            @NotNull
            public final String getCode() {
                return this.code;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                ApiConnectionError = new Type("api_connection_error");
                ApiError = new Type("api_error");
                AuthenticationError = new Type("authentication_error");
                CardError = new Type("card_error");
                IdempotencyError = new Type("idempotency_error");
                InvalidRequestError = new Type("invalid_request_error");
                RateLimitError = new Type("rate_limit_error");
                $VALUES = typeArray = new Type[]{Type.ApiConnectionError, Type.ApiError, Type.AuthenticationError, Type.CardError, Type.IdempotencyError, Type.InvalidRequestError, Type.RateLimitError};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/SetupIntent$Error$Type$Companion;", "", "<init>", "()V", "fromCode", "Lcom/stripe/android/model/SetupIntent$Error$Type;", "typeCode", "", "fromCode$payments_core_release", "payments-core_release"})
            @SourceDebugExtension(value={"SMAP\nSetupIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupIntent.kt\ncom/stripe/android/model/SetupIntent$Error$Type$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n295#2,2:285\n*S KotlinDebug\n*F\n+ 1 SetupIntent.kt\ncom/stripe/android/model/SetupIntent$Error$Type$Companion\n*L\n232#1:285,2\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final Type fromCode$payments_core_release(@Nullable String typeCode) {
                    Object v0;
                    block1: {
                        Iterable $this$firstOrNull$iv = (Iterable)Type.getEntries();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Type it = (Type)((Object)element$iv);
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getCode(), (Object)typeCode)) continue;
                            v0 = element$iv;
                            break block1;
                        }
                        v0 = null;
                    }
                    return v0;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

