/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.AccountRange;
import com.stripe.android.model.BinRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/parsers/AccountRangeJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/AccountRange;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "serialize", "accountRange", "Companion", "payments-core_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAccountRangeJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountRangeJsonParser.kt\ncom/stripe/android/model/parsers/AccountRangeJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n295#2,2:53\n*S KotlinDebug\n*F\n+ 1 AccountRangeJsonParser.kt\ncom/stripe/android/model/parsers/AccountRangeJsonParser\n*L\n17#1:53,2\n*E\n"})
public final class AccountRangeJsonParser
implements ModelJsonParser<AccountRange> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @Deprecated
    @NotNull
    public static final String FIELD_ACCOUNT_RANGE_HIGH = "account_range_high";
    @Deprecated
    @NotNull
    public static final String FIELD_ACCOUNT_RANGE_LOW = "account_range_low";
    @Deprecated
    @NotNull
    public static final String FIELD_PAN_LENGTH = "pan_length";
    @Deprecated
    @NotNull
    public static final String FIELD_BRAND = "brand";
    @Deprecated
    @NotNull
    public static final String FIELD_COUNTRY = "country";

    @Nullable
    public AccountRange parse(@NotNull JSONObject json) {
        Object v0;
        Integer panLength;
        String accountRangeLow;
        String accountRangeHigh;
        block1: {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            accountRangeHigh = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_RANGE_HIGH);
            accountRangeLow = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_RANGE_LOW);
            panLength = StripeJsonUtils.INSTANCE.optInteger(json, FIELD_PAN_LENGTH);
            String brandName = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BRAND);
            boolean bl = false;
            Iterable $this$firstOrNull$iv = (Iterable)AccountRange.BrandInfo.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AccountRange.BrandInfo it = (AccountRange.BrandInfo)((Object)element$iv);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getBrandName(), (Object)brandName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AccountRange.BrandInfo brandInfo = v0;
        return accountRangeHigh != null && accountRangeLow != null && panLength != null && brandInfo != null ? new AccountRange(new BinRange(accountRangeLow, accountRangeHigh), panLength, brandInfo, StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY)) : null;
    }

    @NotNull
    public final JSONObject serialize(@NotNull AccountRange accountRange) {
        Intrinsics.checkNotNullParameter((Object)accountRange, (String)"accountRange");
        JSONObject jSONObject = new JSONObject().put(FIELD_ACCOUNT_RANGE_LOW, (Object)accountRange.getBinRange().getLow()).put(FIELD_ACCOUNT_RANGE_HIGH, (Object)accountRange.getBinRange().getHigh()).put(FIELD_PAN_LENGTH, accountRange.getPanLength()).put(FIELD_BRAND, (Object)accountRange.getBrandInfo().getBrandName()).put(FIELD_COUNTRY, (Object)accountRange.getCountry());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/AccountRangeJsonParser$Companion;", "", "<init>", "()V", "FIELD_ACCOUNT_RANGE_HIGH", "", "FIELD_ACCOUNT_RANGE_LOW", "FIELD_PAN_LENGTH", "FIELD_BRAND", "FIELD_COUNTRY", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

