/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.core.utils.FeatureFlags;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.ElementsSession;
import com.stripe.android.model.ElementsSessionParams;
import com.stripe.android.model.LinkConsumerIncentive;
import com.stripe.android.model.LinkMode;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.CustomPaymentMethodJsonParser;
import com.stripe.android.model.parsers.DeferredPaymentIntentJsonParser;
import com.stripe.android.model.parsers.DeferredSetupIntentJsonParser;
import com.stripe.android.model.parsers.LinkConsumerIncentiveJsonParser;
import com.stripe.android.model.parsers.PaymentIntentJsonParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import com.stripe.android.model.parsers.SetupIntentJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016JD\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00120+2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/stripe/android/model/parsers/ElementsSessionJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/ElementsSession;", "params", "Lcom/stripe/android/model/ElementsSessionParams;", "isLiveMode", "", "timeProvider", "Lkotlin/Function0;", "", "<init>", "(Lcom/stripe/android/model/ElementsSessionParams;ZLkotlin/jvm/functions/Function0;)V", "parse", "json", "Lorg/json/JSONObject;", "parseStripeIntent", "Lcom/stripe/android/model/StripeIntent;", "elementsSessionId", "", "paymentMethodPreference", "orderedPaymentMethodTypes", "Lorg/json/JSONArray;", "unactivatedPaymentMethodTypes", "linkFundingSources", "countryCode", "parseLinkSettings", "Lcom/stripe/android/model/ElementsSession$LinkSettings;", "parseCustomPaymentMethods", "", "Lcom/stripe/android/model/ElementsSession$CustomPaymentMethod;", "parseCustomer", "Lcom/stripe/android/model/ElementsSession$Customer;", "parseCustomerSession", "Lcom/stripe/android/model/ElementsSession$Customer$Session;", "parseComponents", "Lcom/stripe/android/model/ElementsSession$Customer$Components;", "parsePaymentElementComponent", "Lcom/stripe/android/model/ElementsSession$Customer$Components$MobilePaymentElement;", "parseCustomerSheetComponent", "Lcom/stripe/android/model/ElementsSession$Customer$Components$CustomerSheet;", "parseCardBrandChoice", "Lcom/stripe/android/model/ElementsSession$CardBrandChoice;", "parseLinkFlags", "", "parseSessionFlags", "Lcom/stripe/android/model/ElementsSession$Flag;", "parseExperimentAssignments", "Lcom/stripe/android/model/ElementsSession$ExperimentAssignment;", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nElementsSessionJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementsSessionJsonParser.kt\ncom/stripe/android/model/parsers/ElementsSessionJsonParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,455:1\n1#2:456\n1#2:469\n1#2:482\n295#3,2:457\n1611#3,9:459\n1863#3:468\n1864#3:470\n1620#3:471\n1611#3,9:472\n1863#3:481\n1864#3:483\n1620#3:484\n295#3,2:485\n295#3,2:490\n295#3,2:494\n32#4,2:487\n32#4:489\n33#4:492\n32#4:493\n33#4:496\n*S KotlinDebug\n*F\n+ 1 ElementsSessionJsonParser.kt\ncom/stripe/android/model/parsers/ElementsSessionJsonParser\n*L\n198#1:469\n212#1:482\n167#1:457,2\n198#1:459,9\n198#1:468\n198#1:470\n198#1:471\n212#1:472,9\n212#1:481\n212#1:483\n212#1:484\n288#1:485,2\n370#1:490,2\n390#1:494,2\n349#1:487,2\n367#1:489\n367#1:492\n387#1:493\n387#1:496\n*E\n"})
public final class ElementsSessionJsonParser
implements ModelJsonParser<ElementsSession> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ElementsSessionParams params;
    private final boolean isLiveMode;
    @NotNull
    private final Function0<Long> timeProvider;
    public static final int $stable = 8;
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @NotNull
    private static final String FIELD_ELEMENTS_SESSION_ID = "session_id";
    @NotNull
    private static final String FIELD_COUNTRY_CODE = "country_code";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @NotNull
    private static final String FIELD_ORDERED_PAYMENT_METHOD_TYPES = "ordered_payment_method_types";
    @NotNull
    private static final String FIELD_LINK_SETTINGS = "link_settings";
    @NotNull
    private static final String FIELD_LINK_FUNDING_SOURCES = "link_funding_sources";
    @NotNull
    private static final String FIELD_FLAGS = "flags";
    @NotNull
    private static final String FIELD_LINK_PASSTHROUGH_MODE_ENABLED = "link_passthrough_mode_enabled";
    @NotNull
    private static final String FIELD_LINK_MODE = "link_mode";
    @NotNull
    private static final String FIELD_DISABLE_LINK_SIGNUP = "link_mobile_disable_signup";
    @NotNull
    private static final String FIELD_USE_LINK_ATTESTATION_ENDPOINTS = "link_mobile_use_attestation_endpoints";
    @NotNull
    private static final String FIELD_LINK_SUPPRESS_2FA_MODAL = "link_mobile_suppress_2fa_modal";
    @NotNull
    private static final String FIELD_MERCHANT_COUNTRY = "merchant_country";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_PREFERENCE = "payment_method_preference";
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_SPECS = "payment_method_specs";
    @NotNull
    private static final String FIELD_CARD_BRAND_CHOICE = "card_brand_choice";
    @NotNull
    private static final String FIELD_ELIGIBLE = "eligible";
    @NotNull
    private static final String FIELD_PREFERRED_NETWORKS = "preferred_networks";
    @NotNull
    private static final String FIELD_EXTERNAL_PAYMENT_METHOD_DATA = "external_payment_method_data";
    @NotNull
    private static final String FIELD_CUSTOMER = "customer";
    @NotNull
    private static final String FIELD_CUSTOMER_PAYMENT_METHODS = "payment_methods";
    @NotNull
    private static final String FIELD_CUSTOMER_SESSION = "customer_session";
    @NotNull
    private static final String FIELD_DEFAULT_PAYMENT_METHOD = "default_payment_method";
    @NotNull
    private static final String FIELD_CUSTOM_PAYMENT_METHODS_DATA = "custom_payment_method_data";
    @NotNull
    private static final String FIELD_CUSTOMER_ID = "id";
    @NotNull
    private static final String FIELD_CUSTOMER_LIVE_MODE = "livemode";
    @NotNull
    private static final String FIELD_CUSTOMER_API_KEY = "api_key";
    @NotNull
    private static final String FIELD_CUSTOMER_API_KEY_EXPIRY = "api_key_expiry";
    @NotNull
    private static final String FIELD_CUSTOMER_NAME = "customer";
    @NotNull
    private static final String FIELD_COMPONENTS = "components";
    @NotNull
    private static final String FIELD_MOBILE_PAYMENT_ELEMENT = "mobile_payment_element";
    @NotNull
    private static final String FIELD_CUSTOMER_SHEET = "customer_sheet";
    @NotNull
    private static final String FIELD_ENABLED = "enabled";
    @NotNull
    private static final String FIELD_FEATURES = "features";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_SAVE = "payment_method_save";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_REMOVE = "payment_method_remove";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_ALLOW_REDISPLAY_OVERRIDE = "payment_method_save_allow_redisplay_override";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_REMOVE_LAST = "payment_method_remove_last";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_SET_AS_DEFAULT = "payment_method_set_as_default";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_SYNC_DEFAULT = "payment_method_sync_default";
    @NotNull
    private static final String VALUE_ENABLED = "enabled";
    @NotNull
    public static final String FIELD_GOOGLE_PAY_PREFERENCE = "google_pay_preference";
    @NotNull
    private static final String FIELD_EXPERIMENTS_DATA = "experiments_data";
    @NotNull
    private static final String FIELD_EXPERIMENTS_ASSIGNMENTS = "experiment_assignments";
    @NotNull
    private static final String ARB_ID = "arb_id";
    @NotNull
    private static final PaymentMethodJsonParser PAYMENT_METHOD_JSON_PARSER = new PaymentMethodJsonParser();
    @NotNull
    private static final CustomPaymentMethodJsonParser CUSTOM_PAYMENT_METHOD_JSON_PARSER = new CustomPaymentMethodJsonParser();

    public ElementsSessionJsonParser(@NotNull ElementsSessionParams params, boolean isLiveMode, @NotNull Function0<Long> timeProvider) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this.params = params;
        this.isLiveMode = isLiveMode;
        this.timeProvider = timeProvider;
    }

    public /* synthetic */ ElementsSessionJsonParser(ElementsSessionParams elementsSessionParams, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = ElementsSessionJsonParser::_init_$lambda$0;
        }
        this(elementsSessionParams, bl, (Function0<Long>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ElementsSession parse(@NotNull JSONObject json) {
        ElementsSession elementsSession;
        ElementsSession.ExperimentsData experimentsData;
        Object object;
        StripeIntent stripeIntent;
        Object flags;
        JSONArray linkFundingSources;
        JSONObject linkSettings;
        ElementsSession.Customer customer;
        String elementsSessionId;
        String externalPaymentMethodData;
        String paymentMethodSpecs;
        block15: {
            block12: {
                Object object2;
                String string2;
                block14: {
                    block13: {
                        void it;
                        Object object3;
                        JSONArray orderedPaymentMethodTypes;
                        JSONArray unactivatedPaymentMethodTypes;
                        String countryCode;
                        JSONObject paymentMethodPreference;
                        block11: {
                            block10: {
                                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                                paymentMethodPreference = StripeJsonUtils.INSTANCE.mapToJsonObject(StripeJsonUtils.INSTANCE.optMap(json, FIELD_PAYMENT_METHOD_PREFERENCE));
                                String objectType = StripeJsonUtils.optString((JSONObject)paymentMethodPreference, (String)FIELD_OBJECT);
                                if (paymentMethodPreference == null || !Intrinsics.areEqual((Object)FIELD_PAYMENT_METHOD_PREFERENCE, (Object)objectType)) {
                                    return null;
                                }
                                countryCode = paymentMethodPreference.optString(FIELD_COUNTRY_CODE);
                                unactivatedPaymentMethodTypes = json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES);
                                JSONArray jSONArray = json.optJSONArray(FIELD_PAYMENT_METHOD_SPECS);
                                paymentMethodSpecs = jSONArray != null ? jSONArray.toString() : null;
                                JSONArray jSONArray2 = json.optJSONArray(FIELD_EXTERNAL_PAYMENT_METHOD_DATA);
                                externalPaymentMethodData = jSONArray2 != null ? jSONArray2.toString() : null;
                                orderedPaymentMethodTypes = paymentMethodPreference.optJSONArray(FIELD_ORDERED_PAYMENT_METHOD_TYPES);
                                elementsSessionId = json.optString(FIELD_ELEMENTS_SESSION_ID);
                                customer = this.parseCustomer(json.optJSONObject("customer"));
                                JSONObject jSONObject = linkSettings = json.optJSONObject(FIELD_LINK_SETTINGS);
                                linkFundingSources = jSONObject != null ? jSONObject.optJSONArray(FIELD_LINK_FUNDING_SOURCES) : null;
                                object3 = json.optJSONObject(FIELD_FLAGS);
                                if (object3 == null) break block10;
                                JSONObject flags2 = object3;
                                boolean bl = false;
                                Map<ElementsSession.Flag, Boolean> map = this.parseSessionFlags(flags2);
                                object3 = map;
                                if (map != null) break block11;
                            }
                            object3 = MapsKt.emptyMap();
                        }
                        flags = object3;
                        Intrinsics.checkNotNull((Object)countryCode);
                        stripeIntent = this.parseStripeIntent(elementsSessionId, paymentMethodPreference, orderedPaymentMethodTypes, unactivatedPaymentMethodTypes, linkFundingSources, countryCode);
                        JSONObject jSONObject = json.optJSONObject(FIELD_EXPERIMENTS_DATA);
                        if (jSONObject == null) break block12;
                        JSONObject experimentsDataJson = jSONObject;
                        boolean bl = false;
                        String string3 = experimentsDataJson.optString(ARB_ID);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"optString(...)");
                        object2 = experimentsDataJson.optJSONObject(FIELD_EXPERIMENTS_ASSIGNMENTS);
                        if (object2 == null) break block13;
                        object = object2;
                        String string4 = string2;
                        boolean bl2 = false;
                        Map<ElementsSession.ExperimentAssignment, String> map = this.parseExperimentAssignments((JSONObject)it);
                        string2 = string4;
                        object2 = map;
                        if (map != null) break block14;
                    }
                    object2 = MapsKt.emptyMap();
                }
                Object object4 = object2;
                String string5 = string2;
                experimentsData = new ElementsSession.ExperimentsData(string5, (Map<ElementsSession.ExperimentAssignment, String>)object4);
                break block15;
            }
            experimentsData = null;
        }
        ElementsSession.ExperimentsData experimentsData2 = experimentsData;
        List<ElementsSession.CustomPaymentMethod> customPaymentMethods = this.parseCustomPaymentMethods(json.optJSONArray(FIELD_CUSTOM_PAYMENT_METHODS_DATA));
        ElementsSession.CardBrandChoice cardBrandChoice = this.parseCardBrandChoice(json);
        String googlePayPreference = json.optString(FIELD_GOOGLE_PAY_PREFERENCE);
        String merchantCountry = json.optString(FIELD_MERCHANT_COUNTRY);
        if (stripeIntent != null) {
            String string6;
            object = this.parseLinkSettings(linkSettings, linkFundingSources);
            boolean bl = !Intrinsics.areEqual((Object)googlePayPreference, (Object)"disabled");
            String it = string6 = elementsSessionId;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            String string7 = !StringsKt.isBlank((CharSequence)it) ? string6 : null;
            if (string7 == null) {
                String string8 = UUID.randomUUID().toString();
                string7 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
            }
            String string9 = string7;
            elementsSession = new ElementsSession((ElementsSession.LinkSettings)object, paymentMethodSpecs, externalPaymentMethodData, stripeIntent, (Map)flags, experimentsData2, customer, merchantCountry, cardBrandChoice, bl, null, customPaymentMethods, string9, 1024, null);
        } else {
            elementsSession = null;
        }
        return elementsSession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final StripeIntent parseStripeIntent(String elementsSessionId, JSONObject paymentMethodPreference, JSONArray orderedPaymentMethodTypes, JSONArray unactivatedPaymentMethodTypes, JSONArray linkFundingSources, String countryCode) {
        StripeIntent stripeIntent;
        JSONObject jSONObject = paymentMethodPreference;
        if (jSONObject == null || (jSONObject = jSONObject.optJSONObject(this.params.getType())) == null) {
            jSONObject = new JSONObject();
        }
        JSONObject json = jSONObject;
        boolean bl = false;
        JSONArray jSONArray = orderedPaymentMethodTypes;
        if (jSONArray != null) {
            JSONArray it = jSONArray;
            boolean bl2 = false;
            json.put(FIELD_PAYMENT_METHOD_TYPES, (Object)orderedPaymentMethodTypes);
        }
        json.put(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES, (Object)unactivatedPaymentMethodTypes);
        json.put(FIELD_LINK_FUNDING_SOURCES, (Object)linkFundingSources);
        json.put(FIELD_COUNTRY_CODE, (Object)countryCode);
        ElementsSessionParams elementsSessionParams = this.params;
        if (elementsSessionParams instanceof ElementsSessionParams.PaymentIntentType) {
            stripeIntent = new PaymentIntentJsonParser().parse(json);
            return stripeIntent;
        } else if (elementsSessionParams instanceof ElementsSessionParams.SetupIntentType) {
            stripeIntent = new SetupIntentJsonParser().parse(json);
            return stripeIntent;
        } else {
            if (!(elementsSessionParams instanceof ElementsSessionParams.DeferredIntentType)) throw new NoWhenBranchMatchedException();
            DeferredIntentParams.Mode mode = ((ElementsSessionParams.DeferredIntentType)this.params).getDeferredIntentParams().getMode();
            if (mode instanceof DeferredIntentParams.Mode.Payment) {
                stripeIntent = new DeferredPaymentIntentJsonParser(elementsSessionId, (DeferredIntentParams.Mode.Payment)((ElementsSessionParams.DeferredIntentType)this.params).getDeferredIntentParams().getMode(), this.isLiveMode, this.timeProvider).parse(json);
                return stripeIntent;
            } else {
                if (!(mode instanceof DeferredIntentParams.Mode.Setup)) throw new NoWhenBranchMatchedException();
                stripeIntent = new DeferredSetupIntentJsonParser(elementsSessionId, (DeferredIntentParams.Mode.Setup)((ElementsSessionParams.DeferredIntentType)this.params).getDeferredIntentParams().getMode(), this.isLiveMode, this.timeProvider).parse(json);
            }
        }
        return stripeIntent;
    }

    private final ElementsSession.LinkSettings parseLinkSettings(JSONObject json, JSONArray linkFundingSources) {
        LinkConsumerIncentive linkConsumerIncentive;
        Object linkFlags;
        LinkMode linkMode;
        boolean suppressLink2faModal;
        boolean useLinkAttestationEndpoints;
        boolean linkPassthroughModeEnabled;
        boolean disableLinkSignup;
        block13: {
            Object object;
            block12: {
                LinkMode linkMode2;
                JSONObject jSONObject = json;
                disableLinkSignup = jSONObject != null ? jSONObject.optBoolean(FIELD_DISABLE_LINK_SIGNUP) : false;
                JSONObject jSONObject2 = json;
                linkPassthroughModeEnabled = jSONObject2 != null ? jSONObject2.optBoolean(FIELD_LINK_PASSTHROUGH_MODE_ENABLED) : false;
                JSONObject jSONObject3 = json;
                useLinkAttestationEndpoints = jSONObject3 != null ? jSONObject3.optBoolean(FIELD_USE_LINK_ATTESTATION_ENDPOINTS) : false;
                JSONObject jSONObject4 = json;
                boolean bl = jSONObject4 != null ? jSONObject4.optBoolean(FIELD_LINK_SUPPRESS_2FA_MODAL) : (suppressLink2faModal = false);
                Object object2 = json;
                if (object2 != null && (object2 = object2.optString(FIELD_LINK_MODE)) != null) {
                    Object v6;
                    block11: {
                        Object mode = object2;
                        boolean bl2 = false;
                        Iterable $this$firstOrNull$iv = (Iterable)LinkMode.getEntries();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            LinkMode it = (LinkMode)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)mode)) continue;
                            v6 = element$iv;
                            break block11;
                        }
                        v6 = null;
                    }
                    linkMode2 = v6;
                } else {
                    linkMode2 = linkMode = null;
                }
                if ((object = json) == null) break block12;
                JSONObject linkSettingsJson = object;
                boolean bl4 = false;
                Map<String, Boolean> map = this.parseLinkFlags(linkSettingsJson);
                object = map;
                if (map != null) break block13;
            }
            object = linkFlags = MapsKt.emptyMap();
        }
        if (FeatureFlags.INSTANCE.getInstantDebitsIncentives().isEnabled()) {
            JSONObject linkConsumerIncentiveJson;
            JSONObject jSONObject = json;
            JSONObject jSONObject5 = linkConsumerIncentiveJson = jSONObject != null ? jSONObject.optJSONObject("link_consumer_incentive") : null;
            if (jSONObject5 != null) {
                JSONObject it = jSONObject5;
                boolean bl = false;
                linkConsumerIncentive = LinkConsumerIncentiveJsonParser.INSTANCE.parse(it);
            } else {
                linkConsumerIncentive = null;
            }
        } else {
            linkConsumerIncentive = null;
        }
        LinkConsumerIncentive linkConsumerIncentive2 = linkConsumerIncentive;
        return new ElementsSession.LinkSettings(ModelJsonParser.Companion.jsonArrayToList(linkFundingSources), linkPassthroughModeEnabled, linkMode, (Map<String, Boolean>)linkFlags, disableLinkSignup, linkConsumerIncentive2, useLinkAttestationEndpoints, suppressLink2faModal);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ElementsSession.CustomPaymentMethod> parseCustomPaymentMethods(JSONArray json) {
        void $this$mapNotNullTo$iv$iv;
        if (json == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)json.length());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ElementsSession.CustomPaymentMethod it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int index = element$iv$iv;
            boolean bl2 = false;
            JSONObject jSONObject = json.optJSONObject(index);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"optJSONObject(...)");
            if (CUSTOM_PAYMENT_METHOD_JSON_PARSER.parse(jSONObject) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List customPaymentMethods = (List)destination$iv$iv;
        return customPaymentMethods;
    }

    /*
     * WARNING - void declaration
     */
    private final ElementsSession.Customer parseCustomer(JSONObject json) {
        String string2;
        List list;
        JSONArray paymentMethodsJson;
        if (json == null) {
            return null;
        }
        JSONArray jSONArray = paymentMethodsJson = json.optJSONArray(FIELD_CUSTOMER_PAYMENT_METHODS);
        if (jSONArray != null) {
            void $this$mapNotNullTo$iv$iv;
            JSONArray pmsJson = jSONArray;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)pmsJson.length());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PaymentMethod it$iv$iv;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                int index = element$iv$iv;
                boolean bl3 = false;
                JSONObject jSONObject = pmsJson.optJSONObject(index);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"optJSONObject(...)");
                if (PAYMENT_METHOD_JSON_PARSER.parse(jSONObject) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List paymentMethods = list;
        ElementsSession.Customer.Session session = this.parseCustomerSession(json.optJSONObject(FIELD_CUSTOMER_SESSION));
        if (session == null) {
            return null;
        }
        ElementsSession.Customer.Session customerSession = session;
        String it = string2 = json.optString(FIELD_DEFAULT_PAYMENT_METHOD);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String defaultPaymentMethod = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        return new ElementsSession.Customer(paymentMethods, defaultPaymentMethod, customerSession);
    }

    private final ElementsSession.Customer.Session parseCustomerSession(JSONObject json) {
        if (json == null) {
            return null;
        }
        String string2 = json.optString(FIELD_CUSTOMER_ID);
        if (string2 == null) {
            return null;
        }
        String id2 = string2;
        boolean liveMode = json.optBoolean(FIELD_CUSTOMER_LIVE_MODE);
        String string3 = json.optString(FIELD_CUSTOMER_API_KEY);
        if (string3 == null) {
            return null;
        }
        String apiKey = string3;
        int apiKeyExpiry = json.optInt(FIELD_CUSTOMER_API_KEY_EXPIRY);
        String string4 = json.optString("customer");
        if (string4 == null) {
            return null;
        }
        String name = string4;
        ElementsSession.Customer.Components components = this.parseComponents(json.optJSONObject(FIELD_COMPONENTS));
        if (components == null) {
            return null;
        }
        ElementsSession.Customer.Components components2 = components;
        return new ElementsSession.Customer.Session(id2, liveMode, apiKey, apiKeyExpiry, name, components2);
    }

    private final ElementsSession.Customer.Components parseComponents(JSONObject json) {
        if (json == null) {
            return null;
        }
        ElementsSession.Customer.Components.MobilePaymentElement mobilePaymentElement = this.parsePaymentElementComponent(json.optJSONObject(FIELD_MOBILE_PAYMENT_ELEMENT));
        if (mobilePaymentElement == null) {
            return null;
        }
        ElementsSession.Customer.Components.MobilePaymentElement paymentElementComponent = mobilePaymentElement;
        ElementsSession.Customer.Components.CustomerSheet customerSheet = this.parseCustomerSheetComponent(json.optJSONObject(FIELD_CUSTOMER_SHEET));
        if (customerSheet == null) {
            return null;
        }
        ElementsSession.Customer.Components.CustomerSheet customerSheetComponent = customerSheet;
        return new ElementsSession.Customer.Components(paymentElementComponent, customerSheetComponent);
    }

    private final ElementsSession.Customer.Components.MobilePaymentElement parsePaymentElementComponent(JSONObject json) {
        ElementsSession.Customer.Components.MobilePaymentElement mobilePaymentElement;
        if (json == null) {
            return null;
        }
        boolean paymentSheetEnabled = json.optBoolean("enabled");
        if (paymentSheetEnabled) {
            Object v1;
            String paymentMethodSetAsDefaultFeature;
            String paymentMethodRemoveLastFeature;
            String paymentMethodRemoveFeature;
            String paymentMethodSaveFeature;
            block5: {
                JSONObject jSONObject = json.optJSONObject(FIELD_FEATURES);
                if (jSONObject == null) {
                    return null;
                }
                JSONObject paymentSheetFeatures = jSONObject;
                paymentMethodSaveFeature = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_SAVE);
                paymentMethodRemoveFeature = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_REMOVE);
                paymentMethodRemoveLastFeature = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_REMOVE_LAST);
                paymentMethodSetAsDefaultFeature = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_SET_AS_DEFAULT);
                String allowRedisplayOverrideValue = paymentSheetFeatures.optString(FIELD_PAYMENT_METHOD_ALLOW_REDISPLAY_OVERRIDE);
                Iterable $this$firstOrNull$iv = (Iterable)PaymentMethod.AllowRedisplay.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethod.AllowRedisplay allowRedisplay = (PaymentMethod.AllowRedisplay)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)allowRedisplay.getValue(), (Object)allowRedisplayOverrideValue)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            PaymentMethod.AllowRedisplay allowRedisplayOverride = v1;
            boolean bl = Intrinsics.areEqual((Object)paymentMethodSaveFeature, (Object)"enabled");
            boolean bl2 = Intrinsics.areEqual((Object)paymentMethodRemoveFeature, (Object)"enabled");
            boolean bl3 = Intrinsics.areEqual((Object)paymentMethodRemoveLastFeature, (Object)"enabled");
            boolean bl4 = Intrinsics.areEqual((Object)paymentMethodSetAsDefaultFeature, (Object)"enabled");
            mobilePaymentElement = new ElementsSession.Customer.Components.MobilePaymentElement.Enabled(bl, bl2, bl3, allowRedisplayOverride, bl4);
        } else {
            mobilePaymentElement = ElementsSession.Customer.Components.MobilePaymentElement.Disabled.INSTANCE;
        }
        return mobilePaymentElement;
    }

    private final ElementsSession.Customer.Components.CustomerSheet parseCustomerSheetComponent(JSONObject json) {
        ElementsSession.Customer.Components.CustomerSheet customerSheet;
        if (json == null) {
            return null;
        }
        boolean customerSheetEnabled = json.optBoolean("enabled");
        if (customerSheetEnabled) {
            JSONObject jSONObject = json.optJSONObject(FIELD_FEATURES);
            if (jSONObject == null) {
                return null;
            }
            JSONObject customerSheetFeatures = jSONObject;
            String paymentMethodRemoveFeature = customerSheetFeatures.optString(FIELD_PAYMENT_METHOD_REMOVE);
            String paymentMethodRemoveLastFeature = customerSheetFeatures.optString(FIELD_PAYMENT_METHOD_REMOVE_LAST);
            String paymentMethodSyncDefaultFeature = customerSheetFeatures.optString(FIELD_PAYMENT_METHOD_SYNC_DEFAULT);
            customerSheet = new ElementsSession.Customer.Components.CustomerSheet.Enabled(Intrinsics.areEqual((Object)paymentMethodRemoveFeature, (Object)"enabled"), Intrinsics.areEqual((Object)paymentMethodRemoveLastFeature, (Object)"enabled"), Intrinsics.areEqual((Object)paymentMethodSyncDefaultFeature, (Object)"enabled"));
        } else {
            customerSheet = ElementsSession.Customer.Components.CustomerSheet.Disabled.INSTANCE;
        }
        return customerSheet;
    }

    private final ElementsSession.CardBrandChoice parseCardBrandChoice(JSONObject json) {
        List preferredNetworks;
        JSONObject cardBrandChoice;
        block2: {
            JSONObject jSONObject = json.optJSONObject(FIELD_CARD_BRAND_CHOICE);
            if (jSONObject == null) {
                return null;
            }
            cardBrandChoice = jSONObject;
            preferredNetworks = new ArrayList();
            JSONArray jSONArray = cardBrandChoice.optJSONArray(FIELD_PREFERRED_NETWORKS);
            if (jSONArray == null) break block2;
            JSONArray jsonArray = jSONArray;
            boolean bl = false;
            int n = jsonArray.length();
            for (int index = 0; index < n; ++index) {
                String it;
                if (jsonArray.optString(index) == null) continue;
                boolean bl2 = false;
                preferredNetworks.add(it);
            }
        }
        return new ElementsSession.CardBrandChoice(cardBrandChoice.optBoolean(FIELD_ELIGIBLE, false), CollectionsKt.toList((Iterable)preferredNetworks));
    }

    private final Map<String, Boolean> parseLinkFlags(JSONObject json) {
        Map flags = new LinkedHashMap();
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String key = (String)element$iv;
            boolean bl = false;
            Object value = json.get(key);
            if (!(value instanceof Boolean)) continue;
            flags.put(key, value);
        }
        return MapsKt.toMap((Map)flags);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ElementsSession.Flag, Boolean> parseSessionFlags(JSONObject json) {
        Map flags = new LinkedHashMap();
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            ElementsSession.Flag flag;
            Object v1;
            Object value;
            block2: {
                void $this$firstOrNull$iv;
                Object element$iv = iterator2.next();
                String key = (String)element$iv;
                boolean bl = false;
                value = json.get(key);
                Iterable iterable = (Iterable)ElementsSession.Flag.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    ElementsSession.Flag it = (ElementsSession.Flag)((Object)element$iv2);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFlagValue(), (Object)key)) continue;
                    v1 = element$iv2;
                    break block2;
                }
                v1 = null;
            }
            if ((flag = (ElementsSession.Flag)v1) == null) continue;
            ElementsSession.Flag flag2 = flag;
            boolean bl = false;
            if (!(value instanceof Boolean)) continue;
            flags.put(flag2, value);
        }
        return MapsKt.toMap((Map)flags);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ElementsSession.ExperimentAssignment, String> parseExperimentAssignments(JSONObject json) {
        Map specs = new LinkedHashMap();
        Iterator iterator = json.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            ElementsSession.ExperimentAssignment experimentAssignment;
            Object v1;
            Object value;
            block2: {
                void $this$firstOrNull$iv;
                Object element$iv = iterator2.next();
                String key = (String)element$iv;
                boolean bl = false;
                value = json.get(key);
                Iterable iterable = (Iterable)ElementsSession.ExperimentAssignment.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    ElementsSession.ExperimentAssignment it = (ElementsSession.ExperimentAssignment)((Object)element$iv2);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getExperimentValue(), (Object)key)) continue;
                    v1 = element$iv2;
                    break block2;
                }
                v1 = null;
            }
            if ((experimentAssignment = (ElementsSession.ExperimentAssignment)v1) == null) continue;
            ElementsSession.ExperimentAssignment flag = experimentAssignment;
            boolean bl = false;
            if (!(value instanceof String)) continue;
            specs.put(flag, value);
        }
        return MapsKt.toMap((Map)specs);
    }

    private static final long _init_$lambda$0() {
        return System.currentTimeMillis();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b/\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/stripe/android/model/parsers/ElementsSessionJsonParser$Companion;", "", "<init>", "()V", "FIELD_OBJECT", "", "FIELD_ELEMENTS_SESSION_ID", "FIELD_COUNTRY_CODE", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_ORDERED_PAYMENT_METHOD_TYPES", "FIELD_LINK_SETTINGS", "FIELD_LINK_FUNDING_SOURCES", "FIELD_FLAGS", "FIELD_LINK_PASSTHROUGH_MODE_ENABLED", "FIELD_LINK_MODE", "FIELD_DISABLE_LINK_SIGNUP", "FIELD_USE_LINK_ATTESTATION_ENDPOINTS", "FIELD_LINK_SUPPRESS_2FA_MODAL", "FIELD_MERCHANT_COUNTRY", "FIELD_PAYMENT_METHOD_PREFERENCE", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "FIELD_PAYMENT_METHOD_SPECS", "FIELD_CARD_BRAND_CHOICE", "FIELD_ELIGIBLE", "FIELD_PREFERRED_NETWORKS", "FIELD_EXTERNAL_PAYMENT_METHOD_DATA", "FIELD_CUSTOMER", "FIELD_CUSTOMER_PAYMENT_METHODS", "FIELD_CUSTOMER_SESSION", "FIELD_DEFAULT_PAYMENT_METHOD", "FIELD_CUSTOM_PAYMENT_METHODS_DATA", "FIELD_CUSTOMER_ID", "FIELD_CUSTOMER_LIVE_MODE", "FIELD_CUSTOMER_API_KEY", "FIELD_CUSTOMER_API_KEY_EXPIRY", "FIELD_CUSTOMER_NAME", "FIELD_COMPONENTS", "FIELD_MOBILE_PAYMENT_ELEMENT", "FIELD_CUSTOMER_SHEET", "FIELD_ENABLED", "FIELD_FEATURES", "FIELD_PAYMENT_METHOD_SAVE", "FIELD_PAYMENT_METHOD_REMOVE", "FIELD_PAYMENT_METHOD_ALLOW_REDISPLAY_OVERRIDE", "FIELD_PAYMENT_METHOD_REMOVE_LAST", "FIELD_PAYMENT_METHOD_SET_AS_DEFAULT", "FIELD_PAYMENT_METHOD_SYNC_DEFAULT", "VALUE_ENABLED", "FIELD_GOOGLE_PAY_PREFERENCE", "FIELD_EXPERIMENTS_DATA", "FIELD_EXPERIMENTS_ASSIGNMENTS", "ARB_ID", "PAYMENT_METHOD_JSON_PARSER", "Lcom/stripe/android/model/parsers/PaymentMethodJsonParser;", "CUSTOM_PAYMENT_METHOD_JSON_PARSER", "Lcom/stripe/android/model/parsers/CustomPaymentMethodJsonParser;", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

