/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.bankaccount.navigation;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleKt;
import com.stripe.android.payments.bankaccount.CollectBankAccountConfiguration;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountResultInternal;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountActivity;
import com.stripe.android.payments.financialconnections.FinancialConnectionsAvailability;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00112\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal;", "<init>", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "Result", "Companion", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=1)
public final class CollectBankAccountContract
extends ActivityResultContract<Args, CollectBankAccountResultInternal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    public static final String EXTRA_ARGS = "com.stripe.android.payments.bankaccount.navigation.CollectBankAccountContract.extra_args";
    @NotNull
    private static final String EXTRA_RESULT = "com.stripe.android.payments.bankaccount.navigation.CollectBankAccountContract.extra_result";

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intent intent = new Intent(context, CollectBankAccountActivity.class).putExtra(EXTRA_ARGS, (Parcelable)input);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtra(...)");
        return intent;
    }

    @NotNull
    public CollectBankAccountResultInternal parseResult(int resultCode, @Nullable Intent intent) {
        Object object = intent;
        CollectBankAccountResultInternal result = object != null && (object = (Result)object.getParcelableExtra(EXTRA_RESULT)) != null ? ((Result)object).getCollectBankAccountResult() : null;
        CollectBankAccountResultInternal collectBankAccountResultInternal = result;
        if (collectBankAccountResultInternal == null) {
            collectBankAccountResultInternal = new CollectBankAccountResultInternal.Failed(new IllegalArgumentException("Failed to retrieve a CollectBankAccountResult."));
        }
        return collectBankAccountResultInternal;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \"2\u00020\u0001:\u0005\u001e\u001f !\"BI\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010\u0082\u0001\u0004#$%&\u00a8\u0006'"}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "Landroid/os/Parcelable;", "publishableKey", "", "stripeAccountId", "clientSecret", "configuration", "Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "attachToIntent", "", "financialConnectionsAvailability", "Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "hostedSurface", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;ZLcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;Ljava/lang/String;)V", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "getClientSecret", "getConfiguration", "()Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "getAttachToIntent", "()Z", "getFinancialConnectionsAvailability", "()Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "getHostedSurface", "toBundle", "Landroid/os/Bundle;", "product", "getProduct", "ForPaymentIntent", "ForSetupIntent", "ForDeferredPaymentIntent", "ForDeferredSetupIntent", "Companion", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForDeferredPaymentIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForDeferredSetupIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForPaymentIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForSetupIntent;", "payments-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @StabilityInferred(parameters=0)
    public static abstract class Args
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String publishableKey;
        @Nullable
        private final String stripeAccountId;
        @Nullable
        private final String clientSecret;
        @NotNull
        private final CollectBankAccountConfiguration configuration;
        private final boolean attachToIntent;
        @Nullable
        private final FinancialConnectionsAvailability financialConnectionsAvailability;
        @Nullable
        private final String hostedSurface;
        public static final int $stable = 8;

        private Args(String publishableKey, String stripeAccountId, String clientSecret, CollectBankAccountConfiguration configuration, boolean attachToIntent, FinancialConnectionsAvailability financialConnectionsAvailability, String hostedSurface) {
            this.publishableKey = publishableKey;
            this.stripeAccountId = stripeAccountId;
            this.clientSecret = clientSecret;
            this.configuration = configuration;
            this.attachToIntent = attachToIntent;
            this.financialConnectionsAvailability = financialConnectionsAvailability;
            this.hostedSurface = hostedSurface;
        }

        @NotNull
        public String getPublishableKey() {
            return this.publishableKey;
        }

        @Nullable
        public String getStripeAccountId() {
            return this.stripeAccountId;
        }

        @Nullable
        public String getClientSecret() {
            return this.clientSecret;
        }

        @NotNull
        public CollectBankAccountConfiguration getConfiguration() {
            return this.configuration;
        }

        public boolean getAttachToIntent() {
            return this.attachToIntent;
        }

        @Nullable
        public FinancialConnectionsAvailability getFinancialConnectionsAvailability() {
            return this.financialConnectionsAvailability;
        }

        @Nullable
        public String getHostedSurface() {
            return this.hostedSurface;
        }

        @NotNull
        public final Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CollectBankAccountContract.EXTRA_ARGS, (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        @Nullable
        public final String getProduct() {
            String string2;
            CollectBankAccountConfiguration collectBankAccountConfiguration = this.getConfiguration();
            if (collectBankAccountConfiguration instanceof CollectBankAccountConfiguration.InstantDebits) {
                string2 = "instant_debits";
            } else if (collectBankAccountConfiguration instanceof CollectBankAccountConfiguration.USBankAccountInternal || collectBankAccountConfiguration instanceof CollectBankAccountConfiguration.USBankAccount) {
                string2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string2;
        }

        public /* synthetic */ Args(String publishableKey, String stripeAccountId, String clientSecret, CollectBankAccountConfiguration configuration, boolean attachToIntent, FinancialConnectionsAvailability financialConnectionsAvailability, String hostedSurface, DefaultConstructorMarker $constructor_marker) {
            this(publishableKey, stripeAccountId, clientSecret, configuration, attachToIntent, financialConnectionsAvailability, hostedSurface);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$Companion;", "", "<init>", "()V", "fromIntent", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "intent", "Landroid/content/Intent;", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Args fromIntent(@NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                return (Args)intent.getParcelableExtra(CollectBankAccountContract.EXTRA_ARGS);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b \n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010)\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0080\u0001\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u000eJ\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u00020\u000eH\u00d6\u0001J\t\u00103\u001a\u00020\u0003H\u00d6\u0001J\u0016\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013\u00a8\u00069"}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForDeferredPaymentIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "publishableKey", "", "stripeAccountId", "configuration", "Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "financialConnectionsAvailability", "Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "hostedSurface", "elementsSessionId", "customerId", "onBehalfOf", "amount", "", "currency", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)V", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "getConfiguration", "()Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "getFinancialConnectionsAvailability", "()Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "getHostedSurface", "getElementsSessionId", "getCustomerId", "getOnBehalfOf", "getAmount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getCurrency", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForDeferredPaymentIntent;", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class ForDeferredPaymentIntent
        extends Args {
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final CollectBankAccountConfiguration configuration;
            @Nullable
            private final FinancialConnectionsAvailability financialConnectionsAvailability;
            @Nullable
            private final String hostedSurface;
            @NotNull
            private final String elementsSessionId;
            @Nullable
            private final String customerId;
            @Nullable
            private final String onBehalfOf;
            @Nullable
            private final Integer amount;
            @Nullable
            private final String currency;
            @NotNull
            public static final Parcelable.Creator<ForDeferredPaymentIntent> CREATOR;
            public static final int $stable;

            public ForDeferredPaymentIntent(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CollectBankAccountConfiguration configuration, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @Nullable String hostedSurface, @NotNull String elementsSessionId, @Nullable String customerId, @Nullable String onBehalfOf, @Nullable Integer amount, @Nullable String currency) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)elementsSessionId, (String)"elementsSessionId");
                super(publishableKey, stripeAccountId, null, configuration, false, financialConnectionsAvailability, hostedSurface, null);
                this.publishableKey = publishableKey;
                this.stripeAccountId = stripeAccountId;
                this.configuration = configuration;
                this.financialConnectionsAvailability = financialConnectionsAvailability;
                this.hostedSurface = hostedSurface;
                this.elementsSessionId = elementsSessionId;
                this.customerId = customerId;
                this.onBehalfOf = onBehalfOf;
                this.amount = amount;
                this.currency = currency;
            }

            @Override
            @NotNull
            public String getPublishableKey() {
                return this.publishableKey;
            }

            @Override
            @Nullable
            public String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @Override
            @NotNull
            public CollectBankAccountConfiguration getConfiguration() {
                return this.configuration;
            }

            @Override
            @Nullable
            public FinancialConnectionsAvailability getFinancialConnectionsAvailability() {
                return this.financialConnectionsAvailability;
            }

            @Override
            @Nullable
            public String getHostedSurface() {
                return this.hostedSurface;
            }

            @NotNull
            public final String getElementsSessionId() {
                return this.elementsSessionId;
            }

            @Nullable
            public final String getCustomerId() {
                return this.customerId;
            }

            @Nullable
            public final String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            @Nullable
            public final Integer getAmount() {
                return this.amount;
            }

            @Nullable
            public final String getCurrency() {
                return this.currency;
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                dest.writeString(this.publishableKey);
                dest.writeString(this.stripeAccountId);
                dest.writeParcelable((Parcelable)this.configuration, flags);
                Object object = this.financialConnectionsAvailability;
                if (object == null) {
                    dest.writeInt(0);
                } else {
                    dest.writeInt(1);
                    dest.writeString(((Enum)object).name());
                }
                dest.writeString(this.hostedSurface);
                dest.writeString(this.elementsSessionId);
                dest.writeString(this.customerId);
                dest.writeString(this.onBehalfOf);
                object = this.amount;
                if (object == null) {
                    dest.writeInt(0);
                } else {
                    dest.writeInt(1);
                    dest.writeInt(((Integer)object).intValue());
                }
                dest.writeString(this.currency);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final String component1() {
                return this.publishableKey;
            }

            @Nullable
            public final String component2() {
                return this.stripeAccountId;
            }

            @NotNull
            public final CollectBankAccountConfiguration component3() {
                return this.configuration;
            }

            @Nullable
            public final FinancialConnectionsAvailability component4() {
                return this.financialConnectionsAvailability;
            }

            @Nullable
            public final String component5() {
                return this.hostedSurface;
            }

            @NotNull
            public final String component6() {
                return this.elementsSessionId;
            }

            @Nullable
            public final String component7() {
                return this.customerId;
            }

            @Nullable
            public final String component8() {
                return this.onBehalfOf;
            }

            @Nullable
            public final Integer component9() {
                return this.amount;
            }

            @Nullable
            public final String component10() {
                return this.currency;
            }

            @NotNull
            public final ForDeferredPaymentIntent copy(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CollectBankAccountConfiguration configuration, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @Nullable String hostedSurface, @NotNull String elementsSessionId, @Nullable String customerId, @Nullable String onBehalfOf, @Nullable Integer amount, @Nullable String currency) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)elementsSessionId, (String)"elementsSessionId");
                return new ForDeferredPaymentIntent(publishableKey, stripeAccountId, configuration, financialConnectionsAvailability, hostedSurface, elementsSessionId, customerId, onBehalfOf, amount, currency);
            }

            public static /* synthetic */ ForDeferredPaymentIntent copy$default(ForDeferredPaymentIntent forDeferredPaymentIntent, String string2, String string3, CollectBankAccountConfiguration collectBankAccountConfiguration, FinancialConnectionsAvailability financialConnectionsAvailability, String string4, String string5, String string6, String string7, Integer n, String string8, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string2 = forDeferredPaymentIntent.publishableKey;
                }
                if ((n2 & 2) != 0) {
                    string3 = forDeferredPaymentIntent.stripeAccountId;
                }
                if ((n2 & 4) != 0) {
                    collectBankAccountConfiguration = forDeferredPaymentIntent.configuration;
                }
                if ((n2 & 8) != 0) {
                    financialConnectionsAvailability = forDeferredPaymentIntent.financialConnectionsAvailability;
                }
                if ((n2 & 0x10) != 0) {
                    string4 = forDeferredPaymentIntent.hostedSurface;
                }
                if ((n2 & 0x20) != 0) {
                    string5 = forDeferredPaymentIntent.elementsSessionId;
                }
                if ((n2 & 0x40) != 0) {
                    string6 = forDeferredPaymentIntent.customerId;
                }
                if ((n2 & 0x80) != 0) {
                    string7 = forDeferredPaymentIntent.onBehalfOf;
                }
                if ((n2 & 0x100) != 0) {
                    n = forDeferredPaymentIntent.amount;
                }
                if ((n2 & 0x200) != 0) {
                    string8 = forDeferredPaymentIntent.currency;
                }
                return forDeferredPaymentIntent.copy(string2, string3, collectBankAccountConfiguration, financialConnectionsAvailability, string4, string5, string6, string7, n, string8);
            }

            @NotNull
            public String toString() {
                return "ForDeferredPaymentIntent(publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", configuration=" + this.configuration + ", financialConnectionsAvailability=" + this.financialConnectionsAvailability + ", hostedSurface=" + this.hostedSurface + ", elementsSessionId=" + this.elementsSessionId + ", customerId=" + this.customerId + ", onBehalfOf=" + this.onBehalfOf + ", amount=" + this.amount + ", currency=" + this.currency + ")";
            }

            public int hashCode() {
                int result = this.publishableKey.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result = result * 31 + this.configuration.hashCode();
                result = result * 31 + (this.financialConnectionsAvailability == null ? 0 : this.financialConnectionsAvailability.hashCode());
                result = result * 31 + (this.hostedSurface == null ? 0 : this.hostedSurface.hashCode());
                result = result * 31 + this.elementsSessionId.hashCode();
                result = result * 31 + (this.customerId == null ? 0 : this.customerId.hashCode());
                result = result * 31 + (this.onBehalfOf == null ? 0 : this.onBehalfOf.hashCode());
                result = result * 31 + (this.amount == null ? 0 : ((Object)this.amount).hashCode());
                result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ForDeferredPaymentIntent)) {
                    return false;
                }
                ForDeferredPaymentIntent forDeferredPaymentIntent = (ForDeferredPaymentIntent)other;
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)forDeferredPaymentIntent.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)forDeferredPaymentIntent.stripeAccountId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.configuration, (Object)forDeferredPaymentIntent.configuration)) {
                    return false;
                }
                if (this.financialConnectionsAvailability != forDeferredPaymentIntent.financialConnectionsAvailability) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.hostedSurface, (Object)forDeferredPaymentIntent.hostedSurface)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.elementsSessionId, (Object)forDeferredPaymentIntent.elementsSessionId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.customerId, (Object)forDeferredPaymentIntent.customerId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.onBehalfOf, (Object)forDeferredPaymentIntent.onBehalfOf)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.amount, (Object)forDeferredPaymentIntent.amount)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.currency, (Object)forDeferredPaymentIntent.currency);
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<ForDeferredPaymentIntent> {
                    public final ForDeferredPaymentIntent[] newArray(int size) {
                        return new ForDeferredPaymentIntent[size];
                    }

                    public final ForDeferredPaymentIntent createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new ForDeferredPaymentIntent(parcel.readString(), parcel.readString(), (CollectBankAccountConfiguration)parcel.readParcelable(ForDeferredPaymentIntent.class.getClassLoader()), parcel.readInt() == 0 ? null : FinancialConnectionsAvailability.valueOf(parcel.readString()), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()), parcel.readString());
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003Jc\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010#\u001a\u00020$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020$H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u00060"}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForDeferredSetupIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "publishableKey", "", "stripeAccountId", "configuration", "Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "hostedSurface", "financialConnectionsAvailability", "Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "elementsSessionId", "customerId", "onBehalfOf", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;Ljava/lang/String;Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "getConfiguration", "()Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "getHostedSurface", "getFinancialConnectionsAvailability", "()Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "getElementsSessionId", "getCustomerId", "getOnBehalfOf", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class ForDeferredSetupIntent
        extends Args {
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final CollectBankAccountConfiguration configuration;
            @Nullable
            private final String hostedSurface;
            @Nullable
            private final FinancialConnectionsAvailability financialConnectionsAvailability;
            @NotNull
            private final String elementsSessionId;
            @Nullable
            private final String customerId;
            @Nullable
            private final String onBehalfOf;
            @NotNull
            public static final Parcelable.Creator<ForDeferredSetupIntent> CREATOR;
            public static final int $stable;

            public ForDeferredSetupIntent(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CollectBankAccountConfiguration configuration, @Nullable String hostedSurface, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @NotNull String elementsSessionId, @Nullable String customerId, @Nullable String onBehalfOf) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)elementsSessionId, (String)"elementsSessionId");
                super(publishableKey, stripeAccountId, null, configuration, false, financialConnectionsAvailability, hostedSurface, null);
                this.publishableKey = publishableKey;
                this.stripeAccountId = stripeAccountId;
                this.configuration = configuration;
                this.hostedSurface = hostedSurface;
                this.financialConnectionsAvailability = financialConnectionsAvailability;
                this.elementsSessionId = elementsSessionId;
                this.customerId = customerId;
                this.onBehalfOf = onBehalfOf;
            }

            @Override
            @NotNull
            public String getPublishableKey() {
                return this.publishableKey;
            }

            @Override
            @Nullable
            public String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @Override
            @NotNull
            public CollectBankAccountConfiguration getConfiguration() {
                return this.configuration;
            }

            @Override
            @Nullable
            public String getHostedSurface() {
                return this.hostedSurface;
            }

            @Override
            @Nullable
            public FinancialConnectionsAvailability getFinancialConnectionsAvailability() {
                return this.financialConnectionsAvailability;
            }

            @NotNull
            public final String getElementsSessionId() {
                return this.elementsSessionId;
            }

            @Nullable
            public final String getCustomerId() {
                return this.customerId;
            }

            @Nullable
            public final String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                dest.writeString(this.publishableKey);
                dest.writeString(this.stripeAccountId);
                dest.writeParcelable((Parcelable)this.configuration, flags);
                dest.writeString(this.hostedSurface);
                FinancialConnectionsAvailability financialConnectionsAvailability = this.financialConnectionsAvailability;
                if (financialConnectionsAvailability == null) {
                    dest.writeInt(0);
                } else {
                    dest.writeInt(1);
                    dest.writeString(financialConnectionsAvailability.name());
                }
                dest.writeString(this.elementsSessionId);
                dest.writeString(this.customerId);
                dest.writeString(this.onBehalfOf);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final String component1() {
                return this.publishableKey;
            }

            @Nullable
            public final String component2() {
                return this.stripeAccountId;
            }

            @NotNull
            public final CollectBankAccountConfiguration component3() {
                return this.configuration;
            }

            @Nullable
            public final String component4() {
                return this.hostedSurface;
            }

            @Nullable
            public final FinancialConnectionsAvailability component5() {
                return this.financialConnectionsAvailability;
            }

            @NotNull
            public final String component6() {
                return this.elementsSessionId;
            }

            @Nullable
            public final String component7() {
                return this.customerId;
            }

            @Nullable
            public final String component8() {
                return this.onBehalfOf;
            }

            @NotNull
            public final ForDeferredSetupIntent copy(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CollectBankAccountConfiguration configuration, @Nullable String hostedSurface, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @NotNull String elementsSessionId, @Nullable String customerId, @Nullable String onBehalfOf) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)elementsSessionId, (String)"elementsSessionId");
                return new ForDeferredSetupIntent(publishableKey, stripeAccountId, configuration, hostedSurface, financialConnectionsAvailability, elementsSessionId, customerId, onBehalfOf);
            }

            public static /* synthetic */ ForDeferredSetupIntent copy$default(ForDeferredSetupIntent forDeferredSetupIntent, String string2, String string3, CollectBankAccountConfiguration collectBankAccountConfiguration, String string4, FinancialConnectionsAvailability financialConnectionsAvailability, String string5, String string6, String string7, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = forDeferredSetupIntent.publishableKey;
                }
                if ((n & 2) != 0) {
                    string3 = forDeferredSetupIntent.stripeAccountId;
                }
                if ((n & 4) != 0) {
                    collectBankAccountConfiguration = forDeferredSetupIntent.configuration;
                }
                if ((n & 8) != 0) {
                    string4 = forDeferredSetupIntent.hostedSurface;
                }
                if ((n & 0x10) != 0) {
                    financialConnectionsAvailability = forDeferredSetupIntent.financialConnectionsAvailability;
                }
                if ((n & 0x20) != 0) {
                    string5 = forDeferredSetupIntent.elementsSessionId;
                }
                if ((n & 0x40) != 0) {
                    string6 = forDeferredSetupIntent.customerId;
                }
                if ((n & 0x80) != 0) {
                    string7 = forDeferredSetupIntent.onBehalfOf;
                }
                return forDeferredSetupIntent.copy(string2, string3, collectBankAccountConfiguration, string4, financialConnectionsAvailability, string5, string6, string7);
            }

            @NotNull
            public String toString() {
                return "ForDeferredSetupIntent(publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", configuration=" + this.configuration + ", hostedSurface=" + this.hostedSurface + ", financialConnectionsAvailability=" + this.financialConnectionsAvailability + ", elementsSessionId=" + this.elementsSessionId + ", customerId=" + this.customerId + ", onBehalfOf=" + this.onBehalfOf + ")";
            }

            public int hashCode() {
                int result = this.publishableKey.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result = result * 31 + this.configuration.hashCode();
                result = result * 31 + (this.hostedSurface == null ? 0 : this.hostedSurface.hashCode());
                result = result * 31 + (this.financialConnectionsAvailability == null ? 0 : this.financialConnectionsAvailability.hashCode());
                result = result * 31 + this.elementsSessionId.hashCode();
                result = result * 31 + (this.customerId == null ? 0 : this.customerId.hashCode());
                result = result * 31 + (this.onBehalfOf == null ? 0 : this.onBehalfOf.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ForDeferredSetupIntent)) {
                    return false;
                }
                ForDeferredSetupIntent forDeferredSetupIntent = (ForDeferredSetupIntent)other;
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)forDeferredSetupIntent.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)forDeferredSetupIntent.stripeAccountId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.configuration, (Object)forDeferredSetupIntent.configuration)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.hostedSurface, (Object)forDeferredSetupIntent.hostedSurface)) {
                    return false;
                }
                if (this.financialConnectionsAvailability != forDeferredSetupIntent.financialConnectionsAvailability) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.elementsSessionId, (Object)forDeferredSetupIntent.elementsSessionId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.customerId, (Object)forDeferredSetupIntent.customerId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.onBehalfOf, (Object)forDeferredSetupIntent.onBehalfOf);
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<ForDeferredSetupIntent> {
                    public final ForDeferredSetupIntent[] newArray(int size) {
                        return new ForDeferredSetupIntent[size];
                    }

                    public final ForDeferredSetupIntent createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new ForDeferredSetupIntent(parcel.readString(), parcel.readString(), (CollectBankAccountConfiguration)parcel.readParcelable(ForDeferredSetupIntent.class.getClassLoader()), parcel.readString(), parcel.readInt() == 0 ? null : FinancialConnectionsAvailability.valueOf(parcel.readString()), parcel.readString(), parcel.readString(), parcel.readString());
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JU\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010\"\u001a\u00020#J\u0013\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020#H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006."}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForPaymentIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "publishableKey", "", "stripeAccountId", "clientSecret", "configuration", "Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "attachToIntent", "", "financialConnectionsAvailability", "Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "hostedSurface", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;ZLcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;Ljava/lang/String;)V", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "getClientSecret", "getConfiguration", "()Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "getAttachToIntent", "()Z", "getFinancialConnectionsAvailability", "()Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "getHostedSurface", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class ForPaymentIntent
        extends Args {
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final String clientSecret;
            @NotNull
            private final CollectBankAccountConfiguration configuration;
            private final boolean attachToIntent;
            @Nullable
            private final FinancialConnectionsAvailability financialConnectionsAvailability;
            @Nullable
            private final String hostedSurface;
            @NotNull
            public static final Parcelable.Creator<ForPaymentIntent> CREATOR;
            public static final int $stable;

            public ForPaymentIntent(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull String clientSecret, @NotNull CollectBankAccountConfiguration configuration, boolean attachToIntent, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @Nullable String hostedSurface) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                super(publishableKey, stripeAccountId, clientSecret, configuration, attachToIntent, financialConnectionsAvailability, hostedSurface, null);
                this.publishableKey = publishableKey;
                this.stripeAccountId = stripeAccountId;
                this.clientSecret = clientSecret;
                this.configuration = configuration;
                this.attachToIntent = attachToIntent;
                this.financialConnectionsAvailability = financialConnectionsAvailability;
                this.hostedSurface = hostedSurface;
            }

            @Override
            @NotNull
            public String getPublishableKey() {
                return this.publishableKey;
            }

            @Override
            @Nullable
            public String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @Override
            @NotNull
            public String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            @NotNull
            public CollectBankAccountConfiguration getConfiguration() {
                return this.configuration;
            }

            @Override
            public boolean getAttachToIntent() {
                return this.attachToIntent;
            }

            @Override
            @Nullable
            public FinancialConnectionsAvailability getFinancialConnectionsAvailability() {
                return this.financialConnectionsAvailability;
            }

            @Override
            @Nullable
            public String getHostedSurface() {
                return this.hostedSurface;
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                dest.writeString(this.publishableKey);
                dest.writeString(this.stripeAccountId);
                dest.writeString(this.clientSecret);
                dest.writeParcelable((Parcelable)this.configuration, flags);
                dest.writeInt(this.attachToIntent ? 1 : 0);
                FinancialConnectionsAvailability financialConnectionsAvailability = this.financialConnectionsAvailability;
                if (financialConnectionsAvailability == null) {
                    dest.writeInt(0);
                } else {
                    dest.writeInt(1);
                    dest.writeString(financialConnectionsAvailability.name());
                }
                dest.writeString(this.hostedSurface);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final String component1() {
                return this.publishableKey;
            }

            @Nullable
            public final String component2() {
                return this.stripeAccountId;
            }

            @NotNull
            public final String component3() {
                return this.clientSecret;
            }

            @NotNull
            public final CollectBankAccountConfiguration component4() {
                return this.configuration;
            }

            public final boolean component5() {
                return this.attachToIntent;
            }

            @Nullable
            public final FinancialConnectionsAvailability component6() {
                return this.financialConnectionsAvailability;
            }

            @Nullable
            public final String component7() {
                return this.hostedSurface;
            }

            @NotNull
            public final ForPaymentIntent copy(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull String clientSecret, @NotNull CollectBankAccountConfiguration configuration, boolean attachToIntent, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @Nullable String hostedSurface) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                return new ForPaymentIntent(publishableKey, stripeAccountId, clientSecret, configuration, attachToIntent, financialConnectionsAvailability, hostedSurface);
            }

            public static /* synthetic */ ForPaymentIntent copy$default(ForPaymentIntent forPaymentIntent2, String string2, String string3, String string4, CollectBankAccountConfiguration collectBankAccountConfiguration, boolean bl, FinancialConnectionsAvailability financialConnectionsAvailability, String string5, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = forPaymentIntent2.publishableKey;
                }
                if ((n & 2) != 0) {
                    string3 = forPaymentIntent2.stripeAccountId;
                }
                if ((n & 4) != 0) {
                    string4 = forPaymentIntent2.clientSecret;
                }
                if ((n & 8) != 0) {
                    collectBankAccountConfiguration = forPaymentIntent2.configuration;
                }
                if ((n & 0x10) != 0) {
                    bl = forPaymentIntent2.attachToIntent;
                }
                if ((n & 0x20) != 0) {
                    financialConnectionsAvailability = forPaymentIntent2.financialConnectionsAvailability;
                }
                if ((n & 0x40) != 0) {
                    string5 = forPaymentIntent2.hostedSurface;
                }
                return forPaymentIntent2.copy(string2, string3, string4, collectBankAccountConfiguration, bl, financialConnectionsAvailability, string5);
            }

            @NotNull
            public String toString() {
                return "ForPaymentIntent(publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", clientSecret=" + this.clientSecret + ", configuration=" + this.configuration + ", attachToIntent=" + this.attachToIntent + ", financialConnectionsAvailability=" + this.financialConnectionsAvailability + ", hostedSurface=" + this.hostedSurface + ")";
            }

            public int hashCode() {
                int result = this.publishableKey.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result = result * 31 + this.clientSecret.hashCode();
                result = result * 31 + this.configuration.hashCode();
                result = result * 31 + Boolean.hashCode(this.attachToIntent);
                result = result * 31 + (this.financialConnectionsAvailability == null ? 0 : this.financialConnectionsAvailability.hashCode());
                result = result * 31 + (this.hostedSurface == null ? 0 : this.hostedSurface.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ForPaymentIntent)) {
                    return false;
                }
                ForPaymentIntent forPaymentIntent2 = (ForPaymentIntent)other;
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)forPaymentIntent2.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)forPaymentIntent2.stripeAccountId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)forPaymentIntent2.clientSecret)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.configuration, (Object)forPaymentIntent2.configuration)) {
                    return false;
                }
                if (this.attachToIntent != forPaymentIntent2.attachToIntent) {
                    return false;
                }
                if (this.financialConnectionsAvailability != forPaymentIntent2.financialConnectionsAvailability) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.hostedSurface, (Object)forPaymentIntent2.hostedSurface);
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<ForPaymentIntent> {
                    public final ForPaymentIntent[] newArray(int size) {
                        return new ForPaymentIntent[size];
                    }

                    public final ForPaymentIntent createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new ForPaymentIntent(parcel.readString(), parcel.readString(), parcel.readString(), (CollectBankAccountConfiguration)parcel.readParcelable(ForPaymentIntent.class.getClassLoader()), parcel.readInt() != 0, parcel.readInt() == 0 ? null : FinancialConnectionsAvailability.valueOf(parcel.readString()), parcel.readString());
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JU\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010\"\u001a\u00020#J\u0013\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020#H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006."}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args$ForSetupIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "publishableKey", "", "stripeAccountId", "clientSecret", "configuration", "Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "attachToIntent", "", "financialConnectionsAvailability", "Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "hostedSurface", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;ZLcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;Ljava/lang/String;)V", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "getClientSecret", "getConfiguration", "()Lcom/stripe/android/payments/bankaccount/CollectBankAccountConfiguration;", "getAttachToIntent", "()Z", "getFinancialConnectionsAvailability", "()Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "getHostedSurface", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @StabilityInferred(parameters=1)
        public static final class ForSetupIntent
        extends Args {
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final String clientSecret;
            @NotNull
            private final CollectBankAccountConfiguration configuration;
            private final boolean attachToIntent;
            @Nullable
            private final FinancialConnectionsAvailability financialConnectionsAvailability;
            @Nullable
            private final String hostedSurface;
            @NotNull
            public static final Parcelable.Creator<ForSetupIntent> CREATOR;
            public static final int $stable;

            public ForSetupIntent(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull String clientSecret, @NotNull CollectBankAccountConfiguration configuration, boolean attachToIntent, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @Nullable String hostedSurface) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                super(publishableKey, stripeAccountId, clientSecret, configuration, attachToIntent, financialConnectionsAvailability, hostedSurface, null);
                this.publishableKey = publishableKey;
                this.stripeAccountId = stripeAccountId;
                this.clientSecret = clientSecret;
                this.configuration = configuration;
                this.attachToIntent = attachToIntent;
                this.financialConnectionsAvailability = financialConnectionsAvailability;
                this.hostedSurface = hostedSurface;
            }

            @Override
            @NotNull
            public String getPublishableKey() {
                return this.publishableKey;
            }

            @Override
            @Nullable
            public String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @Override
            @NotNull
            public String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            @NotNull
            public CollectBankAccountConfiguration getConfiguration() {
                return this.configuration;
            }

            @Override
            public boolean getAttachToIntent() {
                return this.attachToIntent;
            }

            @Override
            @Nullable
            public FinancialConnectionsAvailability getFinancialConnectionsAvailability() {
                return this.financialConnectionsAvailability;
            }

            @Override
            @Nullable
            public String getHostedSurface() {
                return this.hostedSurface;
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                dest.writeString(this.publishableKey);
                dest.writeString(this.stripeAccountId);
                dest.writeString(this.clientSecret);
                dest.writeParcelable((Parcelable)this.configuration, flags);
                dest.writeInt(this.attachToIntent ? 1 : 0);
                FinancialConnectionsAvailability financialConnectionsAvailability = this.financialConnectionsAvailability;
                if (financialConnectionsAvailability == null) {
                    dest.writeInt(0);
                } else {
                    dest.writeInt(1);
                    dest.writeString(financialConnectionsAvailability.name());
                }
                dest.writeString(this.hostedSurface);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final String component1() {
                return this.publishableKey;
            }

            @Nullable
            public final String component2() {
                return this.stripeAccountId;
            }

            @NotNull
            public final String component3() {
                return this.clientSecret;
            }

            @NotNull
            public final CollectBankAccountConfiguration component4() {
                return this.configuration;
            }

            public final boolean component5() {
                return this.attachToIntent;
            }

            @Nullable
            public final FinancialConnectionsAvailability component6() {
                return this.financialConnectionsAvailability;
            }

            @Nullable
            public final String component7() {
                return this.hostedSurface;
            }

            @NotNull
            public final ForSetupIntent copy(@NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull String clientSecret, @NotNull CollectBankAccountConfiguration configuration, boolean attachToIntent, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @Nullable String hostedSurface) {
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                return new ForSetupIntent(publishableKey, stripeAccountId, clientSecret, configuration, attachToIntent, financialConnectionsAvailability, hostedSurface);
            }

            public static /* synthetic */ ForSetupIntent copy$default(ForSetupIntent forSetupIntent2, String string2, String string3, String string4, CollectBankAccountConfiguration collectBankAccountConfiguration, boolean bl, FinancialConnectionsAvailability financialConnectionsAvailability, String string5, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = forSetupIntent2.publishableKey;
                }
                if ((n & 2) != 0) {
                    string3 = forSetupIntent2.stripeAccountId;
                }
                if ((n & 4) != 0) {
                    string4 = forSetupIntent2.clientSecret;
                }
                if ((n & 8) != 0) {
                    collectBankAccountConfiguration = forSetupIntent2.configuration;
                }
                if ((n & 0x10) != 0) {
                    bl = forSetupIntent2.attachToIntent;
                }
                if ((n & 0x20) != 0) {
                    financialConnectionsAvailability = forSetupIntent2.financialConnectionsAvailability;
                }
                if ((n & 0x40) != 0) {
                    string5 = forSetupIntent2.hostedSurface;
                }
                return forSetupIntent2.copy(string2, string3, string4, collectBankAccountConfiguration, bl, financialConnectionsAvailability, string5);
            }

            @NotNull
            public String toString() {
                return "ForSetupIntent(publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", clientSecret=" + this.clientSecret + ", configuration=" + this.configuration + ", attachToIntent=" + this.attachToIntent + ", financialConnectionsAvailability=" + this.financialConnectionsAvailability + ", hostedSurface=" + this.hostedSurface + ")";
            }

            public int hashCode() {
                int result = this.publishableKey.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result = result * 31 + this.clientSecret.hashCode();
                result = result * 31 + this.configuration.hashCode();
                result = result * 31 + Boolean.hashCode(this.attachToIntent);
                result = result * 31 + (this.financialConnectionsAvailability == null ? 0 : this.financialConnectionsAvailability.hashCode());
                result = result * 31 + (this.hostedSurface == null ? 0 : this.hostedSurface.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ForSetupIntent)) {
                    return false;
                }
                ForSetupIntent forSetupIntent2 = (ForSetupIntent)other;
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)forSetupIntent2.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)forSetupIntent2.stripeAccountId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)forSetupIntent2.clientSecret)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.configuration, (Object)forSetupIntent2.configuration)) {
                    return false;
                }
                if (this.attachToIntent != forSetupIntent2.attachToIntent) {
                    return false;
                }
                if (this.financialConnectionsAvailability != forSetupIntent2.financialConnectionsAvailability) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.hostedSurface, (Object)forSetupIntent2.hostedSurface);
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<ForSetupIntent> {
                    public final ForSetupIntent[] newArray(int size) {
                        return new ForSetupIntent[size];
                    }

                    public final ForSetupIntent createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new ForSetupIntent(parcel.readString(), parcel.readString(), parcel.readString(), (CollectBankAccountConfiguration)parcel.readParcelable(ForSetupIntent.class.getClassLoader()), parcel.readInt() != 0, parcel.readInt() == 0 ? null : FinancialConnectionsAvailability.valueOf(parcel.readString()), parcel.readString());
                    }
                }
                CREATOR = new Creator();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0081\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Companion;", "", "<init>", "()V", "EXTRA_ARGS", "", "getEXTRA_ARGS$annotations", "EXTRA_RESULT", "payments-core_release"})
    @VisibleForTesting(otherwise=2)
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting(otherwise=2)
        public static /* synthetic */ void getEXTRA_ARGS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Result;", "Landroid/os/Parcelable;", "collectBankAccountResult", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal;", "<init>", "(Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal;)V", "getCollectBankAccountResult", "()Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal;", "toBundle", "Landroid/os/Bundle;", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @StabilityInferred(parameters=0)
    public static final class Result
    implements Parcelable {
        @NotNull
        private final CollectBankAccountResultInternal collectBankAccountResult;
        @NotNull
        public static final Parcelable.Creator<Result> CREATOR;
        public static final int $stable;

        public Result(@NotNull CollectBankAccountResultInternal collectBankAccountResult) {
            Intrinsics.checkNotNullParameter((Object)collectBankAccountResult, (String)"collectBankAccountResult");
            this.collectBankAccountResult = collectBankAccountResult;
        }

        @NotNull
        public final CollectBankAccountResultInternal getCollectBankAccountResult() {
            return this.collectBankAccountResult;
        }

        @NotNull
        public final Bundle toBundle() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CollectBankAccountContract.EXTRA_RESULT, (Object)this)};
            return BundleKt.bundleOf((Pair[])pairArray);
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeParcelable((Parcelable)this.collectBankAccountResult, flags);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final CollectBankAccountResultInternal component1() {
            return this.collectBankAccountResult;
        }

        @NotNull
        public final Result copy(@NotNull CollectBankAccountResultInternal collectBankAccountResult) {
            Intrinsics.checkNotNullParameter((Object)collectBankAccountResult, (String)"collectBankAccountResult");
            return new Result(collectBankAccountResult);
        }

        public static /* synthetic */ Result copy$default(Result result, CollectBankAccountResultInternal collectBankAccountResultInternal, int n, Object object) {
            if ((n & 1) != 0) {
                collectBankAccountResultInternal = result.collectBankAccountResult;
            }
            return result.copy(collectBankAccountResultInternal);
        }

        @NotNull
        public String toString() {
            return "Result(collectBankAccountResult=" + this.collectBankAccountResult + ")";
        }

        public int hashCode() {
            return this.collectBankAccountResult.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            return Intrinsics.areEqual((Object)this.collectBankAccountResult, (Object)result.collectBankAccountResult);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Result> {
                public final Result[] newArray(int size) {
                    return new Result[size];
                }

                public final Result createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Result((CollectBankAccountResultInternal)parcel.readParcelable(Result.class.getClassLoader()));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }
}

