/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.analytics;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.core.frauddetection.FraudDetectionErrorReporter;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.payments.core.analytics.DaggerDefaultErrorReporterComponent;
import com.stripe.android.payments.core.analytics.DefaultErrorReporterComponent;
import com.stripe.android.utils.MapUtilsKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\bg\u0018\u0000 \r2\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011J2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "Lcom/stripe/android/core/frauddetection/FraudDetectionErrorReporter;", "report", "", "errorEvent", "Lcom/stripe/android/payments/core/analytics/ErrorReporter$ErrorEvent;", "stripeException", "Lcom/stripe/android/core/exception/StripeException;", "additionalNonPiiParams", "", "", "reportFraudDetectionError", "error", "Companion", "ErrorEvent", "ExpectedErrorEvent", "UnexpectedErrorEvent", "SuccessEvent", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public interface ErrorReporter
extends FraudDetectionErrorReporter {
    @NotNull
    public static final Companion Companion = com.stripe.android.payments.core.analytics.ErrorReporter$Companion.$$INSTANCE;

    public void report(@NotNull ErrorEvent var1, @Nullable StripeException var2, @NotNull Map<String, String> var3);

    public void reportFraudDetectionError(@NotNull StripeException var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/payments/core/analytics/ErrorReporter$Companion;", "", "<init>", "()V", "createFallbackInstance", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "context", "Landroid/content/Context;", "productUsage", "", "", "getAdditionalParamsFromError", "", "error", "", "getAdditionalParamsFromStripeException", "stripeException", "Lcom/stripe/android/core/exception/StripeException;", "payments-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final ErrorReporter createFallbackInstance(@NotNull Context context, @NotNull Set<String> productUsage) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
            DefaultErrorReporterComponent.Builder builder = DaggerDefaultErrorReporterComponent.builder();
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
            return builder.context(context2).productUsage(productUsage).build().getErrorReporter();
        }

        public static /* synthetic */ ErrorReporter createFallbackInstance$default(Companion companion, Context context, Set set, int n, Object object) {
            if ((n & 2) != 0) {
                set = SetsKt.emptySet();
            }
            return companion.createFallbackInstance(context, set);
        }

        @NotNull
        public final Map<String, String> getAdditionalParamsFromError(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return error instanceof StripeException ? this.getAdditionalParamsFromStripeException((StripeException)error) : this.getAdditionalParamsFromStripeException(StripeException.Companion.create(error));
        }

        @NotNull
        public final Map<String, String> getAdditionalParamsFromStripeException(@NotNull StripeException stripeException) {
            Intrinsics.checkNotNullParameter((Object)stripeException, (String)"stripeException");
            Integer statusCode = stripeException.getStatusCode() == 0 ? null : Integer.valueOf(stripeException.getStatusCode());
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"analytics_value", (Object)stripeException.analyticsValue());
            Integer n = statusCode;
            pairArray[1] = TuplesKt.to((Object)"status_code", (Object)(n != null ? n.toString() : null));
            pairArray[2] = TuplesKt.to((Object)"request_id", (Object)stripeException.getRequestId());
            StripeError stripeError = stripeException.getStripeError();
            pairArray[3] = TuplesKt.to((Object)"error_type", (Object)(stripeError != null ? stripeError.getType() : null));
            StripeError stripeError2 = stripeException.getStripeError();
            pairArray[4] = TuplesKt.to((Object)"error_code", (Object)(stripeError2 != null ? stripeError2.getCode() : null));
            return MapUtilsKt.filterNotNullValues(MapsKt.mapOf((Pair[])pairArray));
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ void report$default(ErrorReporter errorReporter, ErrorEvent errorEvent, StripeException stripeException, Map map, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
            }
            if ((n & 2) != 0) {
                stripeException = null;
            }
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            errorReporter.report(errorEvent, stripeException, map);
        }

        public static void reportFraudDetectionError(@NotNull ErrorReporter $this, @NotNull StripeException error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            DefaultImpls.report$default($this, ExpectedErrorEvent.FRAUD_DETECTION_API_FAILURE, error, null, 4, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lcom/stripe/android/payments/core/analytics/ErrorReporter$ErrorEvent;", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "payments-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ErrorEvent
    extends AnalyticsEvent {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001f\b\u0087\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"\u00a8\u0006#"}, d2={"Lcom/stripe/android/payments/core/analytics/ErrorReporter$ExpectedErrorEvent;", "Lcom/stripe/android/payments/core/analytics/ErrorReporter$ErrorEvent;", "", "eventName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getEventName", "()Ljava/lang/String;", "AUTH_WEB_VIEW_FAILURE", "AUTH_WEB_VIEW_NULL_ARGS", "GET_SAVED_PAYMENT_METHODS_FAILURE", "GOOGLE_PAY_IS_READY_API_CALL", "CUSTOMER_SHEET_ELEMENTS_SESSION_LOAD_FAILURE", "CUSTOMER_SHEET_CUSTOMER_SESSION_ELEMENTS_SESSION_LOAD_FAILURE", "CUSTOMER_SHEET_PAYMENT_METHODS_LOAD_FAILURE", "CUSTOMER_SHEET_PAYMENT_METHODS_REFRESH_FAILURE", "CUSTOMER_SHEET_ADAPTER_NOT_FOUND", "PLACES_FIND_AUTOCOMPLETE_ERROR", "PLACES_FETCH_PLACE_ERROR", "LINK_CREATE_CARD_FAILURE", "LINK_SHARE_CARD_FAILURE", "LINK_LOG_OUT_FAILURE", "LINK_NATIVE_FAILED_TO_GET_INTEGRITY_TOKEN", "LINK_NATIVE_FAILED_TO_ATTEST_REQUEST", "LINK_NATIVE_FAILED_TO_PREPARE_INTEGRITY_MANAGER", "PAYMENT_LAUNCHER_CONFIRMATION_NULL_ARGS", "BROWSER_LAUNCHER_ACTIVITY_NOT_FOUND", "BROWSER_LAUNCHER_NULL_ARGS", "GOOGLE_PAY_FAILED", "FRAUD_DETECTION_API_FAILURE", "EXTERNAL_PAYMENT_METHOD_CONFIRM_HANDLER_NULL", "CUSTOM_PAYMENT_METHOD_CONFIRM_HANDLER_NULL", "EXTERNAL_PAYMENT_METHOD_LAUNCHER_NULL", "CREATE_INTENT_CALLBACK_NULL", "payments-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class ExpectedErrorEvent
    extends Enum<ExpectedErrorEvent>
    implements ErrorEvent {
        @NotNull
        private final String eventName;
        public static final /* enum */ ExpectedErrorEvent AUTH_WEB_VIEW_FAILURE = new ExpectedErrorEvent("payments.auth_web_view.failure");
        public static final /* enum */ ExpectedErrorEvent AUTH_WEB_VIEW_NULL_ARGS = new ExpectedErrorEvent("payments.auth_web_view.null_args");
        public static final /* enum */ ExpectedErrorEvent GET_SAVED_PAYMENT_METHODS_FAILURE = new ExpectedErrorEvent("elements.customer_repository.get_saved_payment_methods_failure");
        public static final /* enum */ ExpectedErrorEvent GOOGLE_PAY_IS_READY_API_CALL = new ExpectedErrorEvent("elements.google_pay_repository.is_ready_request_api_call_failure");
        public static final /* enum */ ExpectedErrorEvent CUSTOMER_SHEET_ELEMENTS_SESSION_LOAD_FAILURE = new ExpectedErrorEvent("elements.customer_sheet.elements_session.load_failure");
        public static final /* enum */ ExpectedErrorEvent CUSTOMER_SHEET_CUSTOMER_SESSION_ELEMENTS_SESSION_LOAD_FAILURE = new ExpectedErrorEvent("elements.customer_sheet.customer_session.elements_session.load_failure");
        public static final /* enum */ ExpectedErrorEvent CUSTOMER_SHEET_PAYMENT_METHODS_LOAD_FAILURE = new ExpectedErrorEvent("elements.customer_sheet.payment_methods.load_failure");
        public static final /* enum */ ExpectedErrorEvent CUSTOMER_SHEET_PAYMENT_METHODS_REFRESH_FAILURE = new ExpectedErrorEvent("elements.customer_sheet.payment_methods.refresh_failure");
        public static final /* enum */ ExpectedErrorEvent CUSTOMER_SHEET_ADAPTER_NOT_FOUND = new ExpectedErrorEvent("elements.customer_sheet.customer_adapter.not_found");
        public static final /* enum */ ExpectedErrorEvent PLACES_FIND_AUTOCOMPLETE_ERROR = new ExpectedErrorEvent("address_element.find_autocomplete.error");
        public static final /* enum */ ExpectedErrorEvent PLACES_FETCH_PLACE_ERROR = new ExpectedErrorEvent("address_element.fetch_place.error");
        public static final /* enum */ ExpectedErrorEvent LINK_CREATE_CARD_FAILURE = new ExpectedErrorEvent("link.create_new_card.create_payment_details_failure");
        public static final /* enum */ ExpectedErrorEvent LINK_SHARE_CARD_FAILURE = new ExpectedErrorEvent("link.create_new_card.share_payment_details_failure");
        public static final /* enum */ ExpectedErrorEvent LINK_LOG_OUT_FAILURE = new ExpectedErrorEvent("link.log_out.failure");
        public static final /* enum */ ExpectedErrorEvent LINK_NATIVE_FAILED_TO_GET_INTEGRITY_TOKEN = new ExpectedErrorEvent("link.native.failed_to_get_integrity_token");
        public static final /* enum */ ExpectedErrorEvent LINK_NATIVE_FAILED_TO_ATTEST_REQUEST = new ExpectedErrorEvent("link.native.failed_to_attest_request");
        public static final /* enum */ ExpectedErrorEvent LINK_NATIVE_FAILED_TO_PREPARE_INTEGRITY_MANAGER = new ExpectedErrorEvent("link.native.integrity.preparation_failed");
        public static final /* enum */ ExpectedErrorEvent PAYMENT_LAUNCHER_CONFIRMATION_NULL_ARGS = new ExpectedErrorEvent("payments.paymentlauncherconfirmation.null_args");
        public static final /* enum */ ExpectedErrorEvent BROWSER_LAUNCHER_ACTIVITY_NOT_FOUND = new ExpectedErrorEvent("payments.browserlauncher.activity_not_found");
        public static final /* enum */ ExpectedErrorEvent BROWSER_LAUNCHER_NULL_ARGS = new ExpectedErrorEvent("payments.browserlauncher.null_args");
        public static final /* enum */ ExpectedErrorEvent GOOGLE_PAY_FAILED = new ExpectedErrorEvent("google_pay.confirm.error");
        public static final /* enum */ ExpectedErrorEvent FRAUD_DETECTION_API_FAILURE = new ExpectedErrorEvent("fraud_detection_data_repository.api_failure");
        public static final /* enum */ ExpectedErrorEvent EXTERNAL_PAYMENT_METHOD_CONFIRM_HANDLER_NULL = new ExpectedErrorEvent("paymentsheet.external_payment_method.confirm_handler_is_null");
        public static final /* enum */ ExpectedErrorEvent CUSTOM_PAYMENT_METHOD_CONFIRM_HANDLER_NULL = new ExpectedErrorEvent("paymentsheet.custom_payment_method.confirm_handler_is_null");
        public static final /* enum */ ExpectedErrorEvent EXTERNAL_PAYMENT_METHOD_LAUNCHER_NULL = new ExpectedErrorEvent("paymentsheet.external_payment_method.launcher_is_null");
        public static final /* enum */ ExpectedErrorEvent CREATE_INTENT_CALLBACK_NULL = new ExpectedErrorEvent("paymentsheet.create_intent_callback.is_null");
        private static final /* synthetic */ ExpectedErrorEvent[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ExpectedErrorEvent(String eventName) {
            this.eventName = eventName;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        public static ExpectedErrorEvent[] values() {
            return (ExpectedErrorEvent[])$VALUES.clone();
        }

        public static ExpectedErrorEvent valueOf(String value) {
            return Enum.valueOf(ExpectedErrorEvent.class, value);
        }

        @NotNull
        public static EnumEntries<ExpectedErrorEvent> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = expectedErrorEventArray = new ExpectedErrorEvent[]{ExpectedErrorEvent.AUTH_WEB_VIEW_FAILURE, ExpectedErrorEvent.AUTH_WEB_VIEW_NULL_ARGS, ExpectedErrorEvent.GET_SAVED_PAYMENT_METHODS_FAILURE, ExpectedErrorEvent.GOOGLE_PAY_IS_READY_API_CALL, ExpectedErrorEvent.CUSTOMER_SHEET_ELEMENTS_SESSION_LOAD_FAILURE, ExpectedErrorEvent.CUSTOMER_SHEET_CUSTOMER_SESSION_ELEMENTS_SESSION_LOAD_FAILURE, ExpectedErrorEvent.CUSTOMER_SHEET_PAYMENT_METHODS_LOAD_FAILURE, ExpectedErrorEvent.CUSTOMER_SHEET_PAYMENT_METHODS_REFRESH_FAILURE, ExpectedErrorEvent.CUSTOMER_SHEET_ADAPTER_NOT_FOUND, ExpectedErrorEvent.PLACES_FIND_AUTOCOMPLETE_ERROR, ExpectedErrorEvent.PLACES_FETCH_PLACE_ERROR, ExpectedErrorEvent.LINK_CREATE_CARD_FAILURE, ExpectedErrorEvent.LINK_SHARE_CARD_FAILURE, ExpectedErrorEvent.LINK_LOG_OUT_FAILURE, ExpectedErrorEvent.LINK_NATIVE_FAILED_TO_GET_INTEGRITY_TOKEN, ExpectedErrorEvent.LINK_NATIVE_FAILED_TO_ATTEST_REQUEST, ExpectedErrorEvent.LINK_NATIVE_FAILED_TO_PREPARE_INTEGRITY_MANAGER, ExpectedErrorEvent.PAYMENT_LAUNCHER_CONFIRMATION_NULL_ARGS, ExpectedErrorEvent.BROWSER_LAUNCHER_ACTIVITY_NOT_FOUND, ExpectedErrorEvent.BROWSER_LAUNCHER_NULL_ARGS, ExpectedErrorEvent.GOOGLE_PAY_FAILED, ExpectedErrorEvent.FRAUD_DETECTION_API_FAILURE, ExpectedErrorEvent.EXTERNAL_PAYMENT_METHOD_CONFIRM_HANDLER_NULL, ExpectedErrorEvent.CUSTOM_PAYMENT_METHOD_CONFIRM_HANDLER_NULL, ExpectedErrorEvent.EXTERNAL_PAYMENT_METHOD_LAUNCHER_NULL, ExpectedErrorEvent.CREATE_INTENT_CALLBACK_NULL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0087\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/payments/core/analytics/ErrorReporter$SuccessEvent;", "Lcom/stripe/android/payments/core/analytics/ErrorReporter$ErrorEvent;", "", "eventName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getEventName", "()Ljava/lang/String;", "CUSTOMER_SHEET_ELEMENTS_SESSION_LOAD_SUCCESS", "CUSTOMER_SHEET_CUSTOMER_SESSION_ELEMENTS_SESSION_LOAD_SUCCESS", "CUSTOMER_SHEET_PAYMENT_METHODS_LOAD_SUCCESS", "GET_SAVED_PAYMENT_METHODS_SUCCESS", "PLACES_FIND_AUTOCOMPLETE_SUCCESS", "PLACES_FETCH_PLACE_SUCCESS", "LINK_CREATE_CARD_SUCCESS", "LINK_LOG_OUT_SUCCESS", "CUSTOMER_SHEET_PAYMENT_METHODS_REFRESH_SUCCESS", "EXTERNAL_PAYMENT_METHODS_LAUNCH_SUCCESS", "CUSTOM_PAYMENT_METHODS_LAUNCH_SUCCESS", "FOUND_CREATE_INTENT_CALLBACK_WHILE_POLLING", "payments-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class SuccessEvent
    extends Enum<SuccessEvent>
    implements ErrorEvent {
        @NotNull
        private final String eventName;
        public static final /* enum */ SuccessEvent CUSTOMER_SHEET_ELEMENTS_SESSION_LOAD_SUCCESS = new SuccessEvent("elements.customer_sheet.elements_session.load_success");
        public static final /* enum */ SuccessEvent CUSTOMER_SHEET_CUSTOMER_SESSION_ELEMENTS_SESSION_LOAD_SUCCESS = new SuccessEvent("elements.customer_sheet.customer_session.elements_session.load_success");
        public static final /* enum */ SuccessEvent CUSTOMER_SHEET_PAYMENT_METHODS_LOAD_SUCCESS = new SuccessEvent("elements.customer_sheet.payment_methods.load_success");
        public static final /* enum */ SuccessEvent GET_SAVED_PAYMENT_METHODS_SUCCESS = new SuccessEvent("elements.customer_repository.get_saved_payment_methods_success");
        public static final /* enum */ SuccessEvent PLACES_FIND_AUTOCOMPLETE_SUCCESS = new SuccessEvent("address_element.find_autocomplete.success");
        public static final /* enum */ SuccessEvent PLACES_FETCH_PLACE_SUCCESS = new SuccessEvent("address_element.fetch_place.success");
        public static final /* enum */ SuccessEvent LINK_CREATE_CARD_SUCCESS = new SuccessEvent("link.create_new_card.success");
        public static final /* enum */ SuccessEvent LINK_LOG_OUT_SUCCESS = new SuccessEvent("link.log_out.success");
        public static final /* enum */ SuccessEvent CUSTOMER_SHEET_PAYMENT_METHODS_REFRESH_SUCCESS = new SuccessEvent("elements.customer_sheet.payment_methods.refresh_success");
        public static final /* enum */ SuccessEvent EXTERNAL_PAYMENT_METHODS_LAUNCH_SUCCESS = new SuccessEvent("paymentsheet.external_payment_method.launch_success");
        public static final /* enum */ SuccessEvent CUSTOM_PAYMENT_METHODS_LAUNCH_SUCCESS = new SuccessEvent("paymentsheet.custom_payment_method.launch_success");
        public static final /* enum */ SuccessEvent FOUND_CREATE_INTENT_CALLBACK_WHILE_POLLING = new SuccessEvent("paymentsheet.polling_for_create_intent_callback.found");
        private static final /* synthetic */ SuccessEvent[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SuccessEvent(String eventName) {
            this.eventName = eventName;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        public static SuccessEvent[] values() {
            return (SuccessEvent[])$VALUES.clone();
        }

        public static SuccessEvent valueOf(String value) {
            return Enum.valueOf(SuccessEvent.class, value);
        }

        @NotNull
        public static EnumEntries<SuccessEvent> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = successEventArray = new SuccessEvent[]{SuccessEvent.CUSTOMER_SHEET_ELEMENTS_SESSION_LOAD_SUCCESS, SuccessEvent.CUSTOMER_SHEET_CUSTOMER_SESSION_ELEMENTS_SESSION_LOAD_SUCCESS, SuccessEvent.CUSTOMER_SHEET_PAYMENT_METHODS_LOAD_SUCCESS, SuccessEvent.GET_SAVED_PAYMENT_METHODS_SUCCESS, SuccessEvent.PLACES_FIND_AUTOCOMPLETE_SUCCESS, SuccessEvent.PLACES_FETCH_PLACE_SUCCESS, SuccessEvent.LINK_CREATE_CARD_SUCCESS, SuccessEvent.LINK_LOG_OUT_SUCCESS, SuccessEvent.CUSTOMER_SHEET_PAYMENT_METHODS_REFRESH_SUCCESS, SuccessEvent.EXTERNAL_PAYMENT_METHODS_LAUNCH_SUCCESS, SuccessEvent.CUSTOM_PAYMENT_METHODS_LAUNCH_SUCCESS, SuccessEvent.FOUND_CREATE_INTENT_CALLBACK_WHILE_POLLING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b \b\u0087\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\"\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!\u00a8\u0006$"}, d2={"Lcom/stripe/android/payments/core/analytics/ErrorReporter$UnexpectedErrorEvent;", "Lcom/stripe/android/payments/core/analytics/ErrorReporter$ErrorEvent;", "", "partialEventName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getPartialEventName", "()Ljava/lang/String;", "AUTH_WEB_VIEW_BLANK_CLIENT_SECRET", "MISSING_CARDSCAN_DEPENDENCY", "MISSING_HOSTED_VOUCHER_URL", "MISSING_POLLING_AUTHENTICATOR", "LINK_INVALID_SESSION_STATE", "GOOGLE_PAY_JSON_REQUEST_PARSING", "GOOGLE_PAY_UNEXPECTED_CONFIRM_RESULT", "GOOGLE_PAY_MISSING_INTENT_DATA", "FIND_AUTOCOMPLETE_PREDICTIONS_WITHOUT_DEPENDENCY", "FETCH_PLACE_WITHOUT_DEPENDENCY", "LINK_ATTACH_CARD_WITH_NULL_ACCOUNT", "LINK_WEB_FAILED_TO_PARSE_RESULT_URI", "LINK_NATIVE_FAILED_TO_ATTEST_SIGNUP_REQUEST", "PAYMENT_SHEET_AUTHENTICATORS_NOT_FOUND", "PAYMENT_SHEET_LOADER_ELEMENTS_SESSION_CUSTOMER_NOT_FOUND", "EXTERNAL_PAYMENT_METHOD_SERIALIZATION_FAILURE", "PAYMENT_SHEET_NO_PAYMENT_SELECTION_ON_CHECKOUT", "PAYMENT_SHEET_INVALID_PAYMENT_SELECTION_ON_CHECKOUT", "FLOW_CONTROLLER_INVALID_PAYMENT_SELECTION_ON_CHECKOUT", "INTENT_CONFIRMATION_HANDLER_INVALID_PAYMENT_CONFIRMATION_OPTION", "EXTERNAL_PAYMENT_METHOD_UNEXPECTED_RESULT_CODE", "CVC_RECOLLECTION_UNEXPECTED_PAYMENT_SELECTION", "CUSTOMER_SHEET_ATTACH_CALLED_WITH_CUSTOMER_SESSION", "CUSTOMER_SESSION_ON_CUSTOMER_SHEET_ELEMENTS_SESSION_NO_CUSTOMER_FIELD", "EMBEDDED_SHEET_LAUNCHER_EMBEDDED_STATE_IS_NULL", "eventName", "getEventName", "payments-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class UnexpectedErrorEvent
    extends Enum<UnexpectedErrorEvent>
    implements ErrorEvent {
        @NotNull
        private final String partialEventName;
        public static final /* enum */ UnexpectedErrorEvent AUTH_WEB_VIEW_BLANK_CLIENT_SECRET = new UnexpectedErrorEvent("payments.auth_web_view.blank_client_secret");
        public static final /* enum */ UnexpectedErrorEvent MISSING_CARDSCAN_DEPENDENCY = new UnexpectedErrorEvent("cardscan.missing_dependency");
        public static final /* enum */ UnexpectedErrorEvent MISSING_HOSTED_VOUCHER_URL = new UnexpectedErrorEvent("payments.missing_hosted_voucher_url");
        public static final /* enum */ UnexpectedErrorEvent MISSING_POLLING_AUTHENTICATOR = new UnexpectedErrorEvent("payments.missing_polling_authenticator");
        public static final /* enum */ UnexpectedErrorEvent LINK_INVALID_SESSION_STATE = new UnexpectedErrorEvent("link.signup.failure.invalidSessionState");
        public static final /* enum */ UnexpectedErrorEvent GOOGLE_PAY_JSON_REQUEST_PARSING = new UnexpectedErrorEvent("google_pay_repository.is_ready_request_json_parsing_failure");
        public static final /* enum */ UnexpectedErrorEvent GOOGLE_PAY_UNEXPECTED_CONFIRM_RESULT = new UnexpectedErrorEvent("google_pay.confirm.unexpected_result");
        public static final /* enum */ UnexpectedErrorEvent GOOGLE_PAY_MISSING_INTENT_DATA = new UnexpectedErrorEvent("google_pay.on_result.missing_data");
        public static final /* enum */ UnexpectedErrorEvent FIND_AUTOCOMPLETE_PREDICTIONS_WITHOUT_DEPENDENCY = new UnexpectedErrorEvent("address_element.find_autocomplete.without_dependency");
        public static final /* enum */ UnexpectedErrorEvent FETCH_PLACE_WITHOUT_DEPENDENCY = new UnexpectedErrorEvent("address_element.fetch_place.without_dependency");
        public static final /* enum */ UnexpectedErrorEvent LINK_ATTACH_CARD_WITH_NULL_ACCOUNT = new UnexpectedErrorEvent("link.create_new_card.missing_link_account");
        public static final /* enum */ UnexpectedErrorEvent LINK_WEB_FAILED_TO_PARSE_RESULT_URI = new UnexpectedErrorEvent("link.web.result.parsing_failed");
        public static final /* enum */ UnexpectedErrorEvent LINK_NATIVE_FAILED_TO_ATTEST_SIGNUP_REQUEST = new UnexpectedErrorEvent("link.native.signup.failed_to_attest_request");
        public static final /* enum */ UnexpectedErrorEvent PAYMENT_SHEET_AUTHENTICATORS_NOT_FOUND = new UnexpectedErrorEvent("paymentsheet.authenticators.not_found");
        public static final /* enum */ UnexpectedErrorEvent PAYMENT_SHEET_LOADER_ELEMENTS_SESSION_CUSTOMER_NOT_FOUND = new UnexpectedErrorEvent("paymentsheet.loader.elements_session.customer.not_found");
        public static final /* enum */ UnexpectedErrorEvent EXTERNAL_PAYMENT_METHOD_SERIALIZATION_FAILURE = new UnexpectedErrorEvent("elements.external_payment_methods_serializer.error");
        public static final /* enum */ UnexpectedErrorEvent PAYMENT_SHEET_NO_PAYMENT_SELECTION_ON_CHECKOUT = new UnexpectedErrorEvent("paymentsheet.no_payment_selection");
        public static final /* enum */ UnexpectedErrorEvent PAYMENT_SHEET_INVALID_PAYMENT_SELECTION_ON_CHECKOUT = new UnexpectedErrorEvent("paymentsheet.invalid_payment_selection");
        public static final /* enum */ UnexpectedErrorEvent FLOW_CONTROLLER_INVALID_PAYMENT_SELECTION_ON_CHECKOUT = new UnexpectedErrorEvent("flow_controller.invalid_payment_selection");
        public static final /* enum */ UnexpectedErrorEvent INTENT_CONFIRMATION_HANDLER_INVALID_PAYMENT_CONFIRMATION_OPTION = new UnexpectedErrorEvent("intent_confirmation_handler.invalid_payment_confirmation_option");
        public static final /* enum */ UnexpectedErrorEvent EXTERNAL_PAYMENT_METHOD_UNEXPECTED_RESULT_CODE = new UnexpectedErrorEvent("paymentsheet.external_payment_method.unexpected_result_code");
        public static final /* enum */ UnexpectedErrorEvent CVC_RECOLLECTION_UNEXPECTED_PAYMENT_SELECTION = new UnexpectedErrorEvent("payments.cvc_recollection_unexpected_payment_selection");
        public static final /* enum */ UnexpectedErrorEvent CUSTOMER_SHEET_ATTACH_CALLED_WITH_CUSTOMER_SESSION = new UnexpectedErrorEvent("customersheet.customer_session.attach_called");
        public static final /* enum */ UnexpectedErrorEvent CUSTOMER_SESSION_ON_CUSTOMER_SHEET_ELEMENTS_SESSION_NO_CUSTOMER_FIELD = new UnexpectedErrorEvent("customersheet.customer_session.elements_session.no_customer_field");
        public static final /* enum */ UnexpectedErrorEvent EMBEDDED_SHEET_LAUNCHER_EMBEDDED_STATE_IS_NULL = new UnexpectedErrorEvent("embedded.embedded_sheet_launcher.embedded_state_is_null");
        private static final /* synthetic */ UnexpectedErrorEvent[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private UnexpectedErrorEvent(String partialEventName) {
            this.partialEventName = partialEventName;
        }

        @NotNull
        public final String getPartialEventName() {
            return this.partialEventName;
        }

        @NotNull
        public String getEventName() {
            return "unexpected_error." + this.partialEventName;
        }

        public static UnexpectedErrorEvent[] values() {
            return (UnexpectedErrorEvent[])$VALUES.clone();
        }

        public static UnexpectedErrorEvent valueOf(String value) {
            return Enum.valueOf(UnexpectedErrorEvent.class, value);
        }

        @NotNull
        public static EnumEntries<UnexpectedErrorEvent> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = unexpectedErrorEventArray = new UnexpectedErrorEvent[]{UnexpectedErrorEvent.AUTH_WEB_VIEW_BLANK_CLIENT_SECRET, UnexpectedErrorEvent.MISSING_CARDSCAN_DEPENDENCY, UnexpectedErrorEvent.MISSING_HOSTED_VOUCHER_URL, UnexpectedErrorEvent.MISSING_POLLING_AUTHENTICATOR, UnexpectedErrorEvent.LINK_INVALID_SESSION_STATE, UnexpectedErrorEvent.GOOGLE_PAY_JSON_REQUEST_PARSING, UnexpectedErrorEvent.GOOGLE_PAY_UNEXPECTED_CONFIRM_RESULT, UnexpectedErrorEvent.GOOGLE_PAY_MISSING_INTENT_DATA, UnexpectedErrorEvent.FIND_AUTOCOMPLETE_PREDICTIONS_WITHOUT_DEPENDENCY, UnexpectedErrorEvent.FETCH_PLACE_WITHOUT_DEPENDENCY, UnexpectedErrorEvent.LINK_ATTACH_CARD_WITH_NULL_ACCOUNT, UnexpectedErrorEvent.LINK_WEB_FAILED_TO_PARSE_RESULT_URI, UnexpectedErrorEvent.LINK_NATIVE_FAILED_TO_ATTEST_SIGNUP_REQUEST, UnexpectedErrorEvent.PAYMENT_SHEET_AUTHENTICATORS_NOT_FOUND, UnexpectedErrorEvent.PAYMENT_SHEET_LOADER_ELEMENTS_SESSION_CUSTOMER_NOT_FOUND, UnexpectedErrorEvent.EXTERNAL_PAYMENT_METHOD_SERIALIZATION_FAILURE, UnexpectedErrorEvent.PAYMENT_SHEET_NO_PAYMENT_SELECTION_ON_CHECKOUT, UnexpectedErrorEvent.PAYMENT_SHEET_INVALID_PAYMENT_SELECTION_ON_CHECKOUT, UnexpectedErrorEvent.FLOW_CONTROLLER_INVALID_PAYMENT_SELECTION_ON_CHECKOUT, UnexpectedErrorEvent.INTENT_CONFIRMATION_HANDLER_INVALID_PAYMENT_CONFIRMATION_OPTION, UnexpectedErrorEvent.EXTERNAL_PAYMENT_METHOD_UNEXPECTED_RESULT_CODE, UnexpectedErrorEvent.CVC_RECOLLECTION_UNEXPECTED_PAYMENT_SELECTION, UnexpectedErrorEvent.CUSTOMER_SHEET_ATTACH_CALLED_WITH_CUSTOMER_SESSION, UnexpectedErrorEvent.CUSTOMER_SESSION_ON_CUSTOMER_SHEET_ELEMENTS_SESSION_NO_CUSTOMER_FIELD, UnexpectedErrorEvent.EMBEDDED_SHEET_LAUNCHER_EMBEDDED_STATE_IS_NULL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

