/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication.threeds2;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.authentication.PaymentNextActionHandler;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2TransactionContract;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2TransactionStarter;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.view.AuthActivityStarterHost;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J&\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'H\u0094@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3DS2NextActionHandler;", "Lcom/stripe/android/payments/core/authentication/PaymentNextActionHandler;", "Lcom/stripe/android/model/StripeIntent;", "config", "Lcom/stripe/android/PaymentAuthConfig;", "enableLogging", "", "publishableKeyProvider", "Lkotlin/Function0;", "", "productUsage", "", "<init>", "(Lcom/stripe/android/PaymentAuthConfig;ZLkotlin/jvm/functions/Function0;Ljava/util/Set;)V", "stripe3ds2CompletionLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionContract$Args;", "getStripe3ds2CompletionLauncher$payments_core_release$annotations", "()V", "getStripe3ds2CompletionLauncher$payments_core_release", "()Landroidx/activity/result/ActivityResultLauncher;", "setStripe3ds2CompletionLauncher$payments_core_release", "(Landroidx/activity/result/ActivityResultLauncher;)V", "stripe3ds2CompletionStarterFactory", "Lkotlin/Function1;", "Lcom/stripe/android/view/AuthActivityStarterHost;", "Lcom/stripe/android/payments/core/authentication/threeds2/Stripe3ds2TransactionStarter;", "onNewActivityResultCaller", "", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "activityResultCallback", "Landroidx/activity/result/ActivityResultCallback;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "onLauncherInvalidated", "performNextActionOnResumed", "host", "actionable", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/core/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class Stripe3DS2NextActionHandler
extends PaymentNextActionHandler<StripeIntent> {
    @NotNull
    private final PaymentAuthConfig config;
    private final boolean enableLogging;
    @NotNull
    private final Function0<String> publishableKeyProvider;
    @NotNull
    private final Set<String> productUsage;
    @Nullable
    private ActivityResultLauncher<Stripe3ds2TransactionContract.Args> stripe3ds2CompletionLauncher;
    @NotNull
    private final Function1<AuthActivityStarterHost, Stripe3ds2TransactionStarter> stripe3ds2CompletionStarterFactory;
    public static final int $stable = 8;

    @Inject
    public Stripe3DS2NextActionHandler(@NotNull PaymentAuthConfig config2, @Named(value="enableLogging") boolean enableLogging, @Named(value="publishableKey") @NotNull Function0<String> publishableKeyProvider, @Named(value="productUsage") @NotNull Set<String> productUsage) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
        this.config = config2;
        this.enableLogging = enableLogging;
        this.publishableKeyProvider = publishableKeyProvider;
        this.productUsage = productUsage;
        this.stripe3ds2CompletionStarterFactory = arg_0 -> Stripe3DS2NextActionHandler.stripe3ds2CompletionStarterFactory$lambda$1(this, arg_0);
    }

    @Nullable
    public final ActivityResultLauncher<Stripe3ds2TransactionContract.Args> getStripe3ds2CompletionLauncher$payments_core_release() {
        return this.stripe3ds2CompletionLauncher;
    }

    public final void setStripe3ds2CompletionLauncher$payments_core_release(@Nullable ActivityResultLauncher<Stripe3ds2TransactionContract.Args> activityResultLauncher2) {
        this.stripe3ds2CompletionLauncher = activityResultLauncher2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStripe3ds2CompletionLauncher$payments_core_release$annotations() {
    }

    @Override
    public void onNewActivityResultCaller(@NotNull ActivityResultCaller activityResultCaller, @NotNull ActivityResultCallback<PaymentFlowResult.Unvalidated> activityResultCallback) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(activityResultCallback, (String)"activityResultCallback");
        this.stripe3ds2CompletionLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)new Stripe3ds2TransactionContract(), activityResultCallback);
    }

    @Override
    public void onLauncherInvalidated() {
        ActivityResultLauncher<Stripe3ds2TransactionContract.Args> activityResultLauncher2 = this.stripe3ds2CompletionLauncher;
        if (activityResultLauncher2 != null) {
            activityResultLauncher2.unregister();
        }
        this.stripe3ds2CompletionLauncher = null;
    }

    @Override
    @Nullable
    protected Object performNextActionOnResumed(@NotNull AuthActivityStarterHost host, @NotNull StripeIntent actionable, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) {
        Stripe3ds2TransactionStarter stripe3ds2TransactionStarter = (Stripe3ds2TransactionStarter)this.stripe3ds2CompletionStarterFactory.invoke((Object)host);
        SdkTransactionId sdkTransactionId = SdkTransactionId.Companion.create();
        PaymentAuthConfig.Stripe3ds2Config stripe3ds2Config = this.config.getStripe3ds2Config$payments_core_release();
        StripeIntent.NextActionData nextActionData = actionable.getNextActionData();
        Intrinsics.checkNotNull((Object)nextActionData, (String)"null cannot be cast to non-null type com.stripe.android.model.StripeIntent.NextActionData.SdkData.Use3DS2");
        stripe3ds2TransactionStarter.start(new Stripe3ds2TransactionContract.Args(sdkTransactionId, stripe3ds2Config, actionable, (StripeIntent.NextActionData.SdkData.Use3DS2)nextActionData, requestOptions, this.enableLogging, host.getStatusBarColor(), (String)this.publishableKeyProvider.invoke(), this.productUsage));
        return Unit.INSTANCE;
    }

    private static final Stripe3ds2TransactionStarter stripe3ds2CompletionStarterFactory$lambda$1(Stripe3DS2NextActionHandler this$0, AuthActivityStarterHost host) {
        Stripe3ds2TransactionStarter stripe3ds2TransactionStarter;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        ActivityResultLauncher<Stripe3ds2TransactionContract.Args> activityResultLauncher2 = this$0.stripe3ds2CompletionLauncher;
        if (activityResultLauncher2 != null) {
            ActivityResultLauncher<Stripe3ds2TransactionContract.Args> it = activityResultLauncher2;
            boolean bl = false;
            stripe3ds2TransactionStarter = new Stripe3ds2TransactionStarter.Modern(it);
        } else {
            stripe3ds2TransactionStarter = new Stripe3ds2TransactionStarter.Legacy(host);
        }
        return stripe3ds2TransactionStarter;
    }
}

