/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.injection;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLoggerFactory;
import com.stripe.android.core.injection.CoroutineContextModule;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.core.networking.LinearRetryDelaySupplier;
import com.stripe.android.core.networking.LinearRetryDelaySupplier_Factory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.payments.core.authentication.threeds2.DefaultStripe3ds2ChallengeResultProcessor;
import com.stripe.android.payments.core.authentication.threeds2.DefaultStripe3ds2ChallengeResultProcessor_Factory;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2ChallengeResultProcessor;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2TransactionContract;
import com.stripe.android.payments.core.authentication.threeds2.Stripe3ds2TransactionViewModel;
import com.stripe.android.payments.core.injection.Stripe3ds2TransactionModule_Companion_ProvideMessageVersionRegistryFactory;
import com.stripe.android.payments.core.injection.Stripe3ds2TransactionModule_Companion_ProvideStripeThreeDs2ServiceFactory;
import com.stripe.android.payments.core.injection.Stripe3ds2TransactionViewModelFactoryComponent;
import com.stripe.android.payments.core.injection.Stripe3ds2TransactionViewModelSubcomponent;
import com.stripe.android.payments.core.injection.Stripe3dsTransactionViewModelModule;
import com.stripe.android.payments.core.injection.Stripe3dsTransactionViewModelModule_ProvidesInitChallengeRepositoryFactory;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.transaction.InitChallengeRepository;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.util.Set;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerStripe3ds2TransactionViewModelFactoryComponent {
    private DaggerStripe3ds2TransactionViewModelFactoryComponent() {
    }

    public static Stripe3ds2TransactionViewModelFactoryComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements Stripe3ds2TransactionViewModelFactoryComponent.Builder {
        private Context context;
        private Boolean enableLogging;
        private Function0<String> publishableKeyProvider;
        private Set<String> productUsage;
        private Boolean isInstantApp;

        private Builder() {
        }

        @Override
        public Builder context(Context context) {
            this.context = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder enableLogging(boolean enableLogging) {
            this.enableLogging = (Boolean)Preconditions.checkNotNull((Object)enableLogging);
            return this;
        }

        @Override
        public Builder publishableKeyProvider(Function0<String> publishableKeyProvider) {
            this.publishableKeyProvider = (Function0)Preconditions.checkNotNull(publishableKeyProvider);
            return this;
        }

        @Override
        public Builder productUsage(Set<String> productUsage) {
            this.productUsage = (Set)Preconditions.checkNotNull(productUsage);
            return this;
        }

        @Override
        public Builder isInstantApp(boolean isInstantApp) {
            this.isInstantApp = (Boolean)Preconditions.checkNotNull((Object)isInstantApp);
            return this;
        }

        @Override
        public Stripe3ds2TransactionViewModelFactoryComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.context, Context.class);
            Preconditions.checkBuilderRequirement((Object)this.enableLogging, Boolean.class);
            Preconditions.checkBuilderRequirement(this.publishableKeyProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.productUsage, Set.class);
            Preconditions.checkBuilderRequirement((Object)this.isInstantApp, Boolean.class);
            return new Stripe3ds2TransactionViewModelFactoryComponentImpl(new CoroutineContextModule(), new CoreCommonModule(), this.context, this.enableLogging, this.publishableKeyProvider, this.productUsage, this.isInstantApp);
        }
    }

    private static final class Stripe3ds2TransactionViewModelFactoryComponentImpl
    implements Stripe3ds2TransactionViewModelFactoryComponent {
        private final Context context;
        private final Function0<String> publishableKeyProvider;
        private final Set<String> productUsage;
        private final Boolean isInstantApp;
        private final Stripe3ds2TransactionViewModelFactoryComponentImpl stripe3ds2TransactionViewModelFactoryComponentImpl = this;
        private Provider<CoroutineContext> provideWorkContextProvider;
        private Provider<Boolean> enableLoggingProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<Context> contextProvider;
        private Provider<StripeThreeDs2Service> provideStripeThreeDs2ServiceProvider;
        private Provider<MessageVersionRegistry> provideMessageVersionRegistryProvider;
        private Provider<Function0<String>> publishableKeyProvider2;
        private Provider<Set<String>> productUsageProvider;
        private Provider<PaymentAnalyticsRequestFactory> paymentAnalyticsRequestFactoryProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<StripeApiRepository> stripeApiRepositoryProvider;
        private Provider<LinearRetryDelaySupplier> linearRetryDelaySupplierProvider;
        private Provider<DefaultStripe3ds2ChallengeResultProcessor> defaultStripe3ds2ChallengeResultProcessorProvider;

        private Stripe3ds2TransactionViewModelFactoryComponentImpl(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Boolean enableLoggingParam, Function0<String> publishableKeyProviderParam, Set<String> productUsageParam, Boolean isInstantAppParam) {
            this.context = contextParam;
            this.publishableKeyProvider = publishableKeyProviderParam;
            this.productUsage = productUsageParam;
            this.isInstantApp = isInstantAppParam;
            this.initialize(coroutineContextModuleParam, coreCommonModuleParam, contextParam, enableLoggingParam, publishableKeyProviderParam, productUsageParam, isInstantAppParam);
        }

        private PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory() {
            return new PaymentAnalyticsRequestFactory(this.context, this.publishableKeyProvider, this.productUsage);
        }

        private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
            return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private StripeApiRepository stripeApiRepository() {
            return new StripeApiRepository(this.context, this.publishableKeyProvider, (CoroutineContext)this.provideWorkContextProvider.get(), this.productUsage, this.paymentAnalyticsRequestFactory(), (AnalyticsRequestExecutor)this.defaultAnalyticsRequestExecutor(), (Logger)this.provideLoggerProvider.get());
        }

        private void initialize(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Boolean enableLoggingParam, Function0<String> publishableKeyProviderParam, Set<String> productUsageParam, Boolean isInstantAppParam) {
            this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
            this.enableLoggingProvider = InstanceFactory.create((Object)enableLoggingParam);
            this.provideLoggerProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLoggerFactory.create((CoreCommonModule)coreCommonModuleParam, this.enableLoggingProvider));
            this.contextProvider = InstanceFactory.create((Object)contextParam);
            this.provideStripeThreeDs2ServiceProvider = DoubleCheck.provider((Provider)Stripe3ds2TransactionModule_Companion_ProvideStripeThreeDs2ServiceFactory.create(this.contextProvider, this.enableLoggingProvider, this.provideWorkContextProvider));
            this.provideMessageVersionRegistryProvider = DoubleCheck.provider((Provider)Stripe3ds2TransactionModule_Companion_ProvideMessageVersionRegistryFactory.create());
            this.publishableKeyProvider2 = InstanceFactory.create(publishableKeyProviderParam);
            this.productUsageProvider = InstanceFactory.create(productUsageParam);
            this.paymentAnalyticsRequestFactoryProvider = PaymentAnalyticsRequestFactory_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.productUsageProvider);
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.provideWorkContextProvider);
            this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.contextProvider, this.publishableKeyProvider2, this.provideWorkContextProvider, this.productUsageProvider, this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
            this.linearRetryDelaySupplierProvider = DoubleCheck.provider((Provider)LinearRetryDelaySupplier_Factory.create());
            this.defaultStripe3ds2ChallengeResultProcessorProvider = DoubleCheck.provider((Provider)DefaultStripe3ds2ChallengeResultProcessor_Factory.create(this.stripeApiRepositoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.paymentAnalyticsRequestFactoryProvider, this.linearRetryDelaySupplierProvider, this.provideLoggerProvider, this.provideWorkContextProvider));
        }

        @Override
        public Stripe3ds2TransactionViewModelSubcomponent.Builder getSubcomponentBuilder() {
            return new Stripe3ds2TransactionViewModelSubcomponentBuilder(this.stripe3ds2TransactionViewModelFactoryComponentImpl);
        }
    }

    private static final class Stripe3ds2TransactionViewModelSubcomponentImpl
    implements Stripe3ds2TransactionViewModelSubcomponent {
        private final Stripe3ds2TransactionContract.Args args;
        private final Stripe3dsTransactionViewModelModule stripe3dsTransactionViewModelModule;
        private final Application application;
        private final SavedStateHandle savedStateHandle;
        private final Stripe3ds2TransactionViewModelFactoryComponentImpl stripe3ds2TransactionViewModelFactoryComponentImpl;
        private final Stripe3ds2TransactionViewModelSubcomponentImpl stripe3ds2TransactionViewModelSubcomponentImpl = this;

        private Stripe3ds2TransactionViewModelSubcomponentImpl(Stripe3ds2TransactionViewModelFactoryComponentImpl stripe3ds2TransactionViewModelFactoryComponentImpl, Stripe3dsTransactionViewModelModule stripe3dsTransactionViewModelModuleParam, Stripe3ds2TransactionContract.Args argsParam, SavedStateHandle savedStateHandleParam, Application applicationParam) {
            this.stripe3ds2TransactionViewModelFactoryComponentImpl = stripe3ds2TransactionViewModelFactoryComponentImpl;
            this.args = argsParam;
            this.stripe3dsTransactionViewModelModule = stripe3dsTransactionViewModelModuleParam;
            this.application = applicationParam;
            this.savedStateHandle = savedStateHandleParam;
        }

        private InitChallengeRepository initChallengeRepository() {
            return Stripe3dsTransactionViewModelModule_ProvidesInitChallengeRepositoryFactory.providesInitChallengeRepository(this.stripe3dsTransactionViewModelModule, this.application, this.args, (CoroutineContext)this.stripe3ds2TransactionViewModelFactoryComponentImpl.provideWorkContextProvider.get());
        }

        @Override
        public Stripe3ds2TransactionViewModel getViewModel() {
            return new Stripe3ds2TransactionViewModel(this.args, this.stripe3ds2TransactionViewModelFactoryComponentImpl.stripeApiRepository(), (AnalyticsRequestExecutor)this.stripe3ds2TransactionViewModelFactoryComponentImpl.defaultAnalyticsRequestExecutor(), this.stripe3ds2TransactionViewModelFactoryComponentImpl.paymentAnalyticsRequestFactory(), (StripeThreeDs2Service)this.stripe3ds2TransactionViewModelFactoryComponentImpl.provideStripeThreeDs2ServiceProvider.get(), (MessageVersionRegistry)this.stripe3ds2TransactionViewModelFactoryComponentImpl.provideMessageVersionRegistryProvider.get(), (Stripe3ds2ChallengeResultProcessor)this.stripe3ds2TransactionViewModelFactoryComponentImpl.defaultStripe3ds2ChallengeResultProcessorProvider.get(), this.initChallengeRepository(), (CoroutineContext)this.stripe3ds2TransactionViewModelFactoryComponentImpl.provideWorkContextProvider.get(), this.savedStateHandle, this.stripe3ds2TransactionViewModelFactoryComponentImpl.isInstantApp);
        }
    }

    private static final class Stripe3ds2TransactionViewModelSubcomponentBuilder
    implements Stripe3ds2TransactionViewModelSubcomponent.Builder {
        private final Stripe3ds2TransactionViewModelFactoryComponentImpl stripe3ds2TransactionViewModelFactoryComponentImpl;
        private Stripe3ds2TransactionContract.Args args;
        private SavedStateHandle savedStateHandle;
        private Application application;

        private Stripe3ds2TransactionViewModelSubcomponentBuilder(Stripe3ds2TransactionViewModelFactoryComponentImpl stripe3ds2TransactionViewModelFactoryComponentImpl) {
            this.stripe3ds2TransactionViewModelFactoryComponentImpl = stripe3ds2TransactionViewModelFactoryComponentImpl;
        }

        @Override
        public Stripe3ds2TransactionViewModelSubcomponentBuilder args(Stripe3ds2TransactionContract.Args args) {
            this.args = (Stripe3ds2TransactionContract.Args)Preconditions.checkNotNull((Object)args);
            return this;
        }

        @Override
        public Stripe3ds2TransactionViewModelSubcomponentBuilder savedStateHandle(SavedStateHandle handle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)handle);
            return this;
        }

        @Override
        public Stripe3ds2TransactionViewModelSubcomponentBuilder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Stripe3ds2TransactionViewModelSubcomponent build() {
            Preconditions.checkBuilderRequirement((Object)this.args, Stripe3ds2TransactionContract.Args.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            return new Stripe3ds2TransactionViewModelSubcomponentImpl(this.stripe3ds2TransactionViewModelFactoryComponentImpl, new Stripe3dsTransactionViewModelModule(), this.args, this.savedStateHandle, this.application);
        }
    }
}

