/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.DrawableRes;
import androidx.annotation.RestrictTo;
import com.stripe.android.cards.CardNumber;
import com.stripe.payments.model.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0086\u0001\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001.B\u0085\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0003\u0010\b\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0003H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0003J\u0010\u0010#\u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-\u00a8\u0006/"}, d2={"Lcom/stripe/android/model/CardBrand;", "", "code", "", "displayName", "icon", "", "cvcIcon", "errorIcon", "cvcLength", "", "defaultMaxLength", "pattern", "Ljava/util/regex/Pattern;", "partialPatterns", "", "variantMaxLength", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;IIILjava/util/Set;ILjava/util/regex/Pattern;Ljava/util/Map;Ljava/util/Map;)V", "getCode", "()Ljava/lang/String;", "getCvcIcon", "()I", "getCvcLength", "()Ljava/util/Set;", "getDisplayName", "getErrorIcon", "getIcon", "maxCvcLength", "getMaxCvcLength", "getMaxLengthForCardNumber", "cardNumber", "getPatternForLength", "isMaxCvc", "", "cvcText", "isValidCardNumberLength", "isValidCvc", "cvc", "AmericanExpress", "Discover", "JCB", "DinersClub", "Visa", "MasterCard", "UnionPay", "Unknown", "Companion", "payments-model_release"})
public final class CardBrand
extends Enum<CardBrand> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String code;
    @NotNull
    private final String displayName;
    private final int icon;
    private final int cvcIcon;
    private final int errorIcon;
    @NotNull
    private final Set<Integer> cvcLength;
    private final int defaultMaxLength;
    @Nullable
    private final Pattern pattern;
    @NotNull
    private final Map<Integer, Pattern> partialPatterns;
    @NotNull
    private final Map<Pattern, Integer> variantMaxLength;
    private static final int CVC_COMMON_LENGTH = 3;
    public static final /* enum */ CardBrand AmericanExpress;
    public static final /* enum */ CardBrand Discover;
    public static final /* enum */ CardBrand JCB;
    public static final /* enum */ CardBrand DinersClub;
    public static final /* enum */ CardBrand Visa;
    public static final /* enum */ CardBrand MasterCard;
    public static final /* enum */ CardBrand UnionPay;
    public static final /* enum */ CardBrand Unknown;
    private static final /* synthetic */ CardBrand[] $VALUES;

    private CardBrand(@DrawableRes String code, @DrawableRes String displayName, @DrawableRes int icon, int cvcIcon, int errorIcon, Set<Integer> cvcLength, int defaultMaxLength, Pattern pattern, Map<Integer, Pattern> partialPatterns, Map<Pattern, Integer> variantMaxLength) {
        this.code = code;
        this.displayName = displayName;
        this.icon = icon;
        this.cvcIcon = cvcIcon;
        this.errorIcon = errorIcon;
        this.cvcLength = cvcLength;
        this.defaultMaxLength = defaultMaxLength;
        this.pattern = pattern;
        this.partialPatterns = partialPatterns;
        this.variantMaxLength = variantMaxLength;
    }

    /* synthetic */ CardBrand(String string, int n, String string2, String string3, int n2, int n3, int n4, Set set, int n5, Pattern pattern, Map map, Map map2, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 8) != 0) {
            n3 = R.drawable.stripe_ic_cvc;
        }
        if ((n6 & 0x10) != 0) {
            n4 = R.drawable.stripe_ic_error;
        }
        if ((n6 & 0x20) != 0) {
            set = SetsKt.setOf((Object)3);
        }
        if ((n6 & 0x40) != 0) {
            n5 = 16;
        }
        if ((n6 & 0x80) != 0) {
            pattern = null;
        }
        if ((n6 & 0x200) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(string2, string3, n2, n3, n4, set, n5, pattern, map, map2);
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final int getIcon() {
        return this.icon;
    }

    public final int getCvcIcon() {
        return this.cvcIcon;
    }

    public final int getErrorIcon() {
        return this.errorIcon;
    }

    @NotNull
    public final Set<Integer> getCvcLength() {
        return this.cvcLength;
    }

    public final int getMaxCvcLength() {
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)this.cvcLength);
        return n == null ? 3 : n;
    }

    public final boolean isValidCardNumberLength(@Nullable String cardNumber) {
        return cardNumber != null && Unknown != this && cardNumber.length() == this.getMaxLengthForCardNumber(cardNumber);
    }

    public final boolean isValidCvc(@NotNull String cvc) {
        Intrinsics.checkNotNullParameter((Object)cvc, (String)"cvc");
        return this.cvcLength.contains(cvc.length());
    }

    public final boolean isMaxCvc(@Nullable String cvcText) {
        int n;
        String string = cvcText;
        if (string == null) {
            n = 0;
        } else {
            int n2;
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            n = string2 == null ? 0 : (n2 = string2.length());
        }
        int cvcLength = n;
        return this.getMaxCvcLength() == cvcLength;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getMaxLengthForCardNumber(@NotNull String cardNumber) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
            String normalizedCardNumber = new CardNumber.Unvalidated(cardNumber).getNormalized();
            Iterable $this$firstOrNull$iv = this.variantMaxLength.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry $dstr$pattern$_u24__u24 = (Map.Entry)element$iv;
                boolean bl = false;
                Pattern pattern = (Pattern)$dstr$pattern$_u24__u24.getKey();
                if (!pattern.matcher(normalizedCardNumber).matches()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        Integer n = entry == null ? null : (Integer)entry.getValue();
        return n == null ? this.defaultMaxLength : n;
    }

    private final Pattern getPatternForLength(String cardNumber) {
        Pattern pattern = this.partialPatterns.get(cardNumber.length());
        if (pattern == null) {
            pattern = this.pattern;
        }
        return pattern;
    }

    public static CardBrand[] values() {
        return (CardBrand[])$VALUES.clone();
    }

    public static CardBrand valueOf(String value) {
        return Enum.valueOf(CardBrand.class, value);
    }

    static {
        Object[] objectArray = new Integer[]{3, 4};
        AmericanExpress = new CardBrand("AmericanExpress", 0, "amex", "American Express", R.drawable.stripe_ic_amex, R.drawable.stripe_ic_cvc_amex, 0, SetsKt.setOf((Object[])objectArray), 15, Pattern.compile("^(34|37)[0-9]*$"), MapsKt.mapOf((Pair)TuplesKt.to((Object)1, (Object)Pattern.compile("^3$"))), null, 528, null);
        Discover = new CardBrand("Discover", 1, "discover", "Discover", R.drawable.stripe_ic_discover, 0, 0, null, 0, Pattern.compile("^(60|64|65)[0-9]*$"), MapsKt.mapOf((Pair)TuplesKt.to((Object)1, (Object)Pattern.compile("^6$"))), null, 632, null);
        objectArray = new Pair[]{TuplesKt.to((Object)1, (Object)Pattern.compile("^3$")), TuplesKt.to((Object)2, (Object)Pattern.compile("^(35)$")), TuplesKt.to((Object)3, (Object)Pattern.compile("^(35[2-8])$"))};
        JCB = new CardBrand("JCB", 2, "jcb", "JCB", R.drawable.stripe_ic_jcb, 0, 0, null, 0, Pattern.compile("^(352[89]|35[3-8][0-9])[0-9]*$"), MapsKt.mapOf((Pair[])objectArray), null, 632, null);
        DinersClub = new CardBrand("DinersClub", 3, "diners", "Diners Club", R.drawable.stripe_ic_diners, 0, 0, null, 16, Pattern.compile("^(36|30|38|39)[0-9]*$"), MapsKt.mapOf((Pair)TuplesKt.to((Object)1, (Object)Pattern.compile("^3$"))), MapsKt.mapOf((Pair)TuplesKt.to((Object)Pattern.compile("^(36)[0-9]*$"), (Object)14)), 56, null);
        Visa = new CardBrand("Visa", 4, "visa", "Visa", R.drawable.stripe_ic_visa, 0, 0, null, 0, Pattern.compile("^(4)[0-9]*$"), MapsKt.mapOf((Pair)TuplesKt.to((Object)1, (Object)Pattern.compile("^4$"))), null, 632, null);
        objectArray = new Pair[]{TuplesKt.to((Object)1, (Object)Pattern.compile("^2|5|6$")), TuplesKt.to((Object)2, (Object)Pattern.compile("^(22|23|24|25|26|27|50|51|52|53|54|55|56|57|58|59|67)$"))};
        MasterCard = new CardBrand("MasterCard", 5, "mastercard", "Mastercard", R.drawable.stripe_ic_mastercard, 0, 0, null, 0, Pattern.compile("^(2221|2222|2223|2224|2225|2226|2227|2228|2229|222|223|224|225|226|227|228|229|23|24|25|26|270|271|2720|50|51|52|53|54|55|56|57|58|59|67)[0-9]*$"), MapsKt.mapOf((Pair[])objectArray), null, 632, null);
        UnionPay = new CardBrand("UnionPay", 6, "unionpay", "UnionPay", R.drawable.stripe_ic_unionpay, 0, 0, null, 0, Pattern.compile("^(62|81)[0-9]*$"), MapsKt.mapOf((Pair)TuplesKt.to((Object)1, (Object)Pattern.compile("^6|8$"))), null, 632, null);
        objectArray = new Integer[]{3, 4};
        Unknown = new CardBrand("Unknown", 7, "unknown", "Unknown", R.drawable.stripe_ic_unknown, 0, 0, SetsKt.setOf((Object[])objectArray), 0, null, MapsKt.emptyMap(), null, 728, null);
        $VALUES = cardBrandArray = new CardBrand[]{CardBrand.AmericanExpress, CardBrand.Discover, CardBrand.JCB, CardBrand.DinersClub, CardBrand.Visa, CardBrand.MasterCard, CardBrand.UnionPay, CardBrand.Unknown};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/model/CardBrand$Companion;", "", "()V", "CVC_COMMON_LENGTH", "", "fromCardNumber", "Lcom/stripe/android/model/CardBrand;", "cardNumber", "", "fromCode", "code", "getCardBrands", "", "getMatchingCards", "payments-model_release"})
    public static final class Companion {
        private Companion() {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final CardBrand fromCardNumber(@Nullable String cardNumber) {
            List<CardBrand> list;
            Object object = cardNumber;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                return Unknown;
            }
            List<CardBrand> it = list = this.getMatchingCards(cardNumber);
            boolean bl = false;
            object = it.size() == 1 ? list : null;
            return (CardBrand)((Object)CollectionsKt.first((List)(object == null ? CollectionsKt.listOf((Object)((Object)Unknown)) : object)));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final List<CardBrand> getCardBrands(@Nullable String cardNumber) {
            List<CardBrand> list;
            Object object = cardNumber;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                return CollectionsKt.listOf((Object)((Object)Unknown));
            }
            List<CardBrand> it = list = this.getMatchingCards(cardNumber);
            boolean bl = false;
            object = !((Collection)it).isEmpty() ? list : null;
            return object == null ? CollectionsKt.listOf((Object)((Object)Unknown)) : object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<CardBrand> getMatchingCards(String cardNumber) {
            void $this$filterTo$iv$iv;
            CardBrand[] $this$filter$iv = CardBrand.values();
            boolean $i$f$filter = false;
            CardBrand[] cardBrandArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var7_7 = $this$filterTo$iv$iv;
            int n = 0;
            int n2 = ((void)var7_7).length;
            while (n < n2) {
                boolean bl;
                void element$iv$iv = var7_7[n];
                ++n;
                void cardBrand = element$iv$iv;
                boolean bl2 = false;
                Pattern pattern = ((CardBrand)cardBrand).getPatternForLength(cardNumber);
                if (pattern == null) {
                    bl = false;
                } else {
                    Matcher matcher = pattern.matcher(cardNumber);
                    bl = matcher == null ? false : matcher.matches();
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final CardBrand fromCode(@Nullable String code) {
            CardBrand cardBrand;
            CardBrand cardBrand2;
            block2: {
                CardBrand[] $this$firstOrNull$iv = CardBrand.values();
                boolean $i$f$firstOrNull = false;
                for (CardBrand element$iv : $this$firstOrNull$iv) {
                    CardBrand it = element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getCode(), (String)code, (boolean)true)) continue;
                    cardBrand2 = element$iv;
                    break block2;
                }
                cardBrand2 = cardBrand = null;
            }
            if (cardBrand2 == null) {
                cardBrand = Unknown;
            }
            return cardBrand;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

