/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.RestrictTo;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.model.CardBrand;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/stripe/android/CardUtils;", "", "()V", "getPossibleCardBrand", "Lcom/stripe/android/model/CardBrand;", "cardNumber", "", "isValidLuhnNumber", "", "payments-model_release"})
public final class CardUtils {
    @NotNull
    public static final CardUtils INSTANCE = new CardUtils();

    private CardUtils() {
    }

    @Deprecated(message="CardInputWidget and CardMultilineWidget handle card brand lookup. This method should not be relied on for determining CardBrand.")
    @JvmStatic
    @NotNull
    public static final CardBrand getPossibleCardBrand(@Nullable String cardNumber) {
        CharSequence charSequence = cardNumber;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? CardBrand.Unknown : CardBrand.Companion.fromCardNumber(new CardNumber.Unvalidated(cardNumber).getNormalized());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isValidLuhnNumber(@Nullable String cardNumber) {
        if (cardNumber == null) {
            return false;
        }
        boolean isOdd = true;
        int sum = 0;
        for (int index = cardNumber.length() - 1; -1 < index; --index) {
            char c = cardNumber.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Character.getNumericValue(c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }
}

