/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.parsers.TokenJsonParser;
import java.io.Serializable;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 22\u00020\u00012\u00020\u0002:\u000223BG\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003JS\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u0013\u0010(\u001a\u00020\n2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020'H\u00d6\u0001J\t\u0010,\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020'H\u00d6\u0001R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001a\u00a8\u00064"}, d2={"Lcom/stripe/android/model/Token;", "Lcom/stripe/android/core/model/StripeModel;", "Lcom/stripe/android/model/StripePaymentSource;", "id", "", "type", "Lcom/stripe/android/model/Token$Type;", "created", "Ljava/util/Date;", "livemode", "", "used", "bankAccount", "Lcom/stripe/android/model/BankAccount;", "card", "Lcom/stripe/android/model/Card;", "(Ljava/lang/String;Lcom/stripe/android/model/Token$Type;Ljava/util/Date;ZZLcom/stripe/android/model/BankAccount;Lcom/stripe/android/model/Card;)V", "getBankAccount", "()Lcom/stripe/android/model/BankAccount;", "getCard", "()Lcom/stripe/android/model/Card;", "getCreated", "()Ljava/util/Date;", "getId", "()Ljava/lang/String;", "getLivemode", "()Z", "getType", "()Lcom/stripe/android/model/Token$Type;", "getUsed", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "Type", "payments-model_release"})
@Parcelize
public final class Token
implements StripeModel,
StripePaymentSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Type type;
    @NotNull
    private final Date created;
    private final boolean livemode;
    private final boolean used;
    @Nullable
    private final BankAccount bankAccount;
    @Nullable
    private final Card card;
    @NotNull
    public static final Parcelable.Creator<Token> CREATOR;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Token(@NotNull String id, @NotNull Type type, @NotNull Date created, boolean livemode, boolean used, @Nullable BankAccount bankAccount, @Nullable Card card) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        this.id = id;
        this.type = type;
        this.created = created;
        this.livemode = livemode;
        this.used = used;
        this.bankAccount = bankAccount;
        this.card = card;
    }

    public /* synthetic */ Token(String string, Type type, Date date, boolean bl, boolean bl2, BankAccount bankAccount, Card card, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bankAccount = null;
        }
        if ((n & 0x40) != 0) {
            card = null;
        }
        this(string, type, date, bl, bl2, bankAccount, card);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final Date getCreated() {
        return this.created;
    }

    public final boolean getLivemode() {
        return this.livemode;
    }

    public final boolean getUsed() {
        return this.used;
    }

    @Nullable
    public final BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @Nullable
    public final Card getCard() {
        return this.card;
    }

    @NotNull
    public final String component1() {
        return this.getId();
    }

    @NotNull
    public final Type component2() {
        return this.type;
    }

    @NotNull
    public final Date component3() {
        return this.created;
    }

    public final boolean component4() {
        return this.livemode;
    }

    public final boolean component5() {
        return this.used;
    }

    @Nullable
    public final BankAccount component6() {
        return this.bankAccount;
    }

    @Nullable
    public final Card component7() {
        return this.card;
    }

    @NotNull
    public final Token copy(@NotNull String id, @NotNull Type type, @NotNull Date created, boolean livemode, boolean used, @Nullable BankAccount bankAccount, @Nullable Card card) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        return new Token(id, type, created, livemode, used, bankAccount, card);
    }

    public static /* synthetic */ Token copy$default(Token token, String string, Type type, Date date, boolean bl, boolean bl2, BankAccount bankAccount, Card card, int n, Object object) {
        if ((n & 1) != 0) {
            string = token.getId();
        }
        if ((n & 2) != 0) {
            type = token.type;
        }
        if ((n & 4) != 0) {
            date = token.created;
        }
        if ((n & 8) != 0) {
            bl = token.livemode;
        }
        if ((n & 0x10) != 0) {
            bl2 = token.used;
        }
        if ((n & 0x20) != 0) {
            bankAccount = token.bankAccount;
        }
        if ((n & 0x40) != 0) {
            card = token.card;
        }
        return token.copy(string, type, date, bl, bl2, bankAccount, card);
    }

    @NotNull
    public String toString() {
        return "Token(id=" + this.getId() + ", type=" + this.type + ", created=" + this.created + ", livemode=" + this.livemode + ", used=" + this.used + ", bankAccount=" + this.bankAccount + ", card=" + this.card + ")";
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.created.hashCode();
        int n = this.livemode ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.used ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        result = result * 31 + (this.bankAccount == null ? 0 : this.bankAccount.hashCode());
        result = result * 31 + (this.card == null ? 0 : this.card.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Token)) {
            return false;
        }
        Token token = (Token)other;
        if (!Intrinsics.areEqual((Object)this.getId(), (Object)token.getId())) {
            return false;
        }
        if (this.type != token.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.created, (Object)token.created)) {
            return false;
        }
        if (this.livemode != token.livemode) {
            return false;
        }
        if (this.used != token.used) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bankAccount, (Object)token.bankAccount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.card, (Object)token.card);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeString(this.type.name());
        out.writeSerializable((Serializable)this.created);
        out.writeInt(this.livemode ? 1 : 0);
        out.writeInt(this.used ? 1 : 0);
        StripeModel stripeModel = this.bankAccount;
        if (stripeModel == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            stripeModel.writeToParcel(out, flags);
        }
        stripeModel = this.card;
        if (stripeModel == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            stripeModel.writeToParcel(out, flags);
        }
    }

    @JvmStatic
    @Nullable
    public static final Token fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    static {
        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<Token> {
            @NotNull
            public final Token[] newArray(int size) {
                return new Token[size];
            }

            @NotNull
            public final Token createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new Token(parcel.readString(), Type.valueOf(parcel.readString()), (Date)parcel.readSerializable(), parcel.readInt() != 0, parcel.readInt() != 0, (BankAccount)(parcel.readInt() == 0 ? null : BankAccount.CREATOR.createFromParcel(parcel)), (Card)(parcel.readInt() == 0 ? null : Card.CREATOR.createFromParcel(parcel)));
            }
        }
        CREATOR = new Creator();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/model/Token$Type;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "Card", "BankAccount", "Pii", "Account", "CvcUpdate", "Person", "Companion", "payments-model_release"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ Type Card;
        public static final /* enum */ Type BankAccount;
        public static final /* enum */ Type Pii;
        public static final /* enum */ Type Account;
        public static final /* enum */ Type CvcUpdate;
        public static final /* enum */ Type Person;
        private static final /* synthetic */ Type[] $VALUES;

        private Type(String code) {
            this.code = code;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String getCode() {
            return this.code;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            Card = new Type("card");
            BankAccount = new Type("bank_account");
            Pii = new Type("pii");
            Account = new Type("account");
            CvcUpdate = new Type("cvc_update");
            Person = new Type("person");
            $VALUES = typeArray = new Type[]{Type.Card, Type.BankAccount, Type.Pii, Type.Account, Type.CvcUpdate, Type.Person};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/Token$Type$Companion;", "", "()V", "fromCode", "Lcom/stripe/android/model/Token$Type;", "code", "", "payments-model_release"})
        @SourceDebugExtension(value={"SMAP\nToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Token.kt\ncom/stripe/android/model/Token$Type$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,80:1\n1282#2,2:81\n*S KotlinDebug\n*F\n+ 1 Token.kt\ncom/stripe/android/model/Token$Type$Companion\n*L\n67#1:81,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Type fromCode(@Nullable String code) {
                Type type;
                block1: {
                    Type[] $this$firstOrNull$iv = Type.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Type element$iv;
                        Type it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getCode(), (Object)code)) continue;
                        type = element$iv;
                        break block1;
                    }
                    type = null;
                }
                return type;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/Token$Companion;", "", "()V", "fromJson", "Lcom/stripe/android/model/Token;", "jsonObject", "Lorg/json/JSONObject;", "payments-model_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Token fromJson(@Nullable JSONObject jsonObject) {
            Token token;
            JSONObject jSONObject = jsonObject;
            if (jSONObject != null) {
                JSONObject it = jSONObject;
                boolean bl = false;
                token = new TokenJsonParser().parse(it);
            } else {
                token = null;
            }
            return token;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

