/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.core.utils.DateUtils;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.CvcCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0087\b\u0018\u00002\u00020\u0001:\u0005\u0019\u001a\u001b\u001c\u001dB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0006\u0010\u000b\u001a\u00020\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails;", "Lcom/stripe/android/core/model/StripeModel;", "paymentDetails", "", "Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;", "<init>", "(Ljava/util/List;)V", "getPaymentDetails", "()Ljava/util/List;", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "PaymentDetails", "Card", "Passthrough", "BankAccount", "BillingAddress", "payments-model_release"})
@Parcelize
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ConsumerPaymentDetails
implements StripeModel {
    @NotNull
    private final List<PaymentDetails> paymentDetails;
    @NotNull
    public static final Parcelable.Creator<ConsumerPaymentDetails> CREATOR;

    public ConsumerPaymentDetails(@NotNull List<? extends PaymentDetails> paymentDetails) {
        Intrinsics.checkNotNullParameter(paymentDetails, (String)"paymentDetails");
        this.paymentDetails = paymentDetails;
    }

    @NotNull
    public final List<PaymentDetails> getPaymentDetails() {
        return this.paymentDetails;
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        List<PaymentDetails> list = this.paymentDetails;
        dest.writeInt(list.size());
        Iterator<PaymentDetails> iterator = list.iterator();
        while (iterator.hasNext()) {
            dest.writeParcelable((Parcelable)iterator.next(), flags);
        }
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final List<PaymentDetails> component1() {
        return this.paymentDetails;
    }

    @NotNull
    public final ConsumerPaymentDetails copy(@NotNull List<? extends PaymentDetails> paymentDetails) {
        Intrinsics.checkNotNullParameter(paymentDetails, (String)"paymentDetails");
        return new ConsumerPaymentDetails(paymentDetails);
    }

    public static /* synthetic */ ConsumerPaymentDetails copy$default(ConsumerPaymentDetails consumerPaymentDetails, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = consumerPaymentDetails.paymentDetails;
        }
        return consumerPaymentDetails.copy(list);
    }

    @NotNull
    public String toString() {
        return "ConsumerPaymentDetails(paymentDetails=" + this.paymentDetails + ")";
    }

    public int hashCode() {
        return ((Object)this.paymentDetails).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConsumerPaymentDetails)) {
            return false;
        }
        ConsumerPaymentDetails consumerPaymentDetails = (ConsumerPaymentDetails)other;
        return Intrinsics.areEqual(this.paymentDetails, consumerPaymentDetails.paymentDetails);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<ConsumerPaymentDetails> {
            public final ConsumerPaymentDetails[] newArray(int size) {
                return new ConsumerPaymentDetails[size];
            }

            public final ConsumerPaymentDetails createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList.add(parcel.readParcelable(ConsumerPaymentDetails.class.getClassLoader()));
                }
                List list = arrayList;
                return new ConsumerPaymentDetails(list);
            }
        }
        CREATOR = new Creator();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0001&B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JK\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u001bH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000fR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006'"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$BankAccount;", "Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;", "id", "", "last4", "isDefault", "", "nickname", "bankName", "bankIconCode", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getLast4", "()Z", "getNickname", "getBankName", "getBankIconCode", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "payments-model_release"})
    @Parcelize
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class BankAccount
    extends PaymentDetails {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String last4;
        private final boolean isDefault;
        @Nullable
        private final String nickname;
        @Nullable
        private final String bankName;
        @Nullable
        private final String bankIconCode;
        @NotNull
        public static final Parcelable.Creator<BankAccount> CREATOR;
        @NotNull
        public static final String TYPE = "bank_account";

        public BankAccount(@NotNull String id, @NotNull String last4, boolean isDefault, @Nullable String nickname, @Nullable String bankName, @Nullable String bankIconCode) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)last4, (String)"last4");
            super(id, isDefault, TYPE, nickname, null);
            this.id = id;
            this.last4 = last4;
            this.isDefault = isDefault;
            this.nickname = nickname;
            this.bankName = bankName;
            this.bankIconCode = bankIconCode;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getLast4() {
            return this.last4;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        @Override
        @Nullable
        public String getNickname() {
            return this.nickname;
        }

        @Nullable
        public final String getBankName() {
            return this.bankName;
        }

        @Nullable
        public final String getBankIconCode() {
            return this.bankIconCode;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.id);
            dest.writeString(this.last4);
            dest.writeInt(this.isDefault ? 1 : 0);
            dest.writeString(this.nickname);
            dest.writeString(this.bankName);
            dest.writeString(this.bankIconCode);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.last4;
        }

        public final boolean component3() {
            return this.isDefault;
        }

        @Nullable
        public final String component4() {
            return this.nickname;
        }

        @Nullable
        public final String component5() {
            return this.bankName;
        }

        @Nullable
        public final String component6() {
            return this.bankIconCode;
        }

        @NotNull
        public final BankAccount copy(@NotNull String id, @NotNull String last4, boolean isDefault, @Nullable String nickname, @Nullable String bankName, @Nullable String bankIconCode) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)last4, (String)"last4");
            return new BankAccount(id, last4, isDefault, nickname, bankName, bankIconCode);
        }

        public static /* synthetic */ BankAccount copy$default(BankAccount bankAccount, String string, String string2, boolean bl, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = bankAccount.id;
            }
            if ((n & 2) != 0) {
                string2 = bankAccount.last4;
            }
            if ((n & 4) != 0) {
                bl = bankAccount.isDefault;
            }
            if ((n & 8) != 0) {
                string3 = bankAccount.nickname;
            }
            if ((n & 0x10) != 0) {
                string4 = bankAccount.bankName;
            }
            if ((n & 0x20) != 0) {
                string5 = bankAccount.bankIconCode;
            }
            return bankAccount.copy(string, string2, bl, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "BankAccount(id=" + this.id + ", last4=" + this.last4 + ", isDefault=" + this.isDefault + ", nickname=" + this.nickname + ", bankName=" + this.bankName + ", bankIconCode=" + this.bankIconCode + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.last4.hashCode();
            result = result * 31 + Boolean.hashCode(this.isDefault);
            result = result * 31 + (this.nickname == null ? 0 : this.nickname.hashCode());
            result = result * 31 + (this.bankName == null ? 0 : this.bankName.hashCode());
            result = result * 31 + (this.bankIconCode == null ? 0 : this.bankIconCode.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BankAccount)) {
                return false;
            }
            BankAccount bankAccount = (BankAccount)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)bankAccount.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.last4, (Object)bankAccount.last4)) {
                return false;
            }
            if (this.isDefault != bankAccount.isDefault) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nickname, (Object)bankAccount.nickname)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bankName, (Object)bankAccount.bankName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bankIconCode, (Object)bankAccount.bankIconCode);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<BankAccount> {
                public final BankAccount[] newArray(int size) {
                    return new BankAccount[size];
                }

                public final BankAccount createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new BankAccount(parcel.readString(), parcel.readString(), parcel.readInt() != 0, parcel.readString(), parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$BankAccount$Companion;", "", "<init>", "()V", "TYPE", "", "payments-model_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BM\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\nH\u00c6\u0003J]\u0010\u001d\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020\u001fH\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$BillingAddress;", "Landroid/os/Parcelable;", "name", "", "line1", "line2", "administrativeArea", "locality", "postalCode", "countryCode", "Lcom/stripe/android/core/model/CountryCode;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/core/model/CountryCode;)V", "getName", "()Ljava/lang/String;", "getLine1", "getLine2", "getAdministrativeArea", "getLocality", "getPostalCode", "getCountryCode", "()Lcom/stripe/android/core/model/CountryCode;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-model_release"})
    @Parcelize
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class BillingAddress
    implements Parcelable {
        @Nullable
        private final String name;
        @Nullable
        private final String line1;
        @Nullable
        private final String line2;
        @Nullable
        private final String administrativeArea;
        @Nullable
        private final String locality;
        @Nullable
        private final String postalCode;
        @Nullable
        private final CountryCode countryCode;
        @NotNull
        public static final Parcelable.Creator<BillingAddress> CREATOR;

        public BillingAddress(@Nullable String name, @Nullable String line1, @Nullable String line2, @Nullable String administrativeArea, @Nullable String locality, @Nullable String postalCode, @Nullable CountryCode countryCode) {
            this.name = name;
            this.line1 = line1;
            this.line2 = line2;
            this.administrativeArea = administrativeArea;
            this.locality = locality;
            this.postalCode = postalCode;
            this.countryCode = countryCode;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getLine1() {
            return this.line1;
        }

        @Nullable
        public final String getLine2() {
            return this.line2;
        }

        @Nullable
        public final String getAdministrativeArea() {
            return this.administrativeArea;
        }

        @Nullable
        public final String getLocality() {
            return this.locality;
        }

        @Nullable
        public final String getPostalCode() {
            return this.postalCode;
        }

        @Nullable
        public final CountryCode getCountryCode() {
            return this.countryCode;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.name);
            dest.writeString(this.line1);
            dest.writeString(this.line2);
            dest.writeString(this.administrativeArea);
            dest.writeString(this.locality);
            dest.writeString(this.postalCode);
            dest.writeParcelable((Parcelable)this.countryCode, flags);
        }

        public final int describeContents() {
            return 0;
        }

        @Nullable
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.line1;
        }

        @Nullable
        public final String component3() {
            return this.line2;
        }

        @Nullable
        public final String component4() {
            return this.administrativeArea;
        }

        @Nullable
        public final String component5() {
            return this.locality;
        }

        @Nullable
        public final String component6() {
            return this.postalCode;
        }

        @Nullable
        public final CountryCode component7() {
            return this.countryCode;
        }

        @NotNull
        public final BillingAddress copy(@Nullable String name, @Nullable String line1, @Nullable String line2, @Nullable String administrativeArea, @Nullable String locality, @Nullable String postalCode, @Nullable CountryCode countryCode) {
            return new BillingAddress(name, line1, line2, administrativeArea, locality, postalCode, countryCode);
        }

        public static /* synthetic */ BillingAddress copy$default(BillingAddress billingAddress, String string, String string2, String string3, String string4, String string5, String string6, CountryCode countryCode, int n, Object object) {
            if ((n & 1) != 0) {
                string = billingAddress.name;
            }
            if ((n & 2) != 0) {
                string2 = billingAddress.line1;
            }
            if ((n & 4) != 0) {
                string3 = billingAddress.line2;
            }
            if ((n & 8) != 0) {
                string4 = billingAddress.administrativeArea;
            }
            if ((n & 0x10) != 0) {
                string5 = billingAddress.locality;
            }
            if ((n & 0x20) != 0) {
                string6 = billingAddress.postalCode;
            }
            if ((n & 0x40) != 0) {
                countryCode = billingAddress.countryCode;
            }
            return billingAddress.copy(string, string2, string3, string4, string5, string6, countryCode);
        }

        @NotNull
        public String toString() {
            return "BillingAddress(name=" + this.name + ", line1=" + this.line1 + ", line2=" + this.line2 + ", administrativeArea=" + this.administrativeArea + ", locality=" + this.locality + ", postalCode=" + this.postalCode + ", countryCode=" + this.countryCode + ")";
        }

        public int hashCode() {
            int result = this.name == null ? 0 : this.name.hashCode();
            result = result * 31 + (this.line1 == null ? 0 : this.line1.hashCode());
            result = result * 31 + (this.line2 == null ? 0 : this.line2.hashCode());
            result = result * 31 + (this.administrativeArea == null ? 0 : this.administrativeArea.hashCode());
            result = result * 31 + (this.locality == null ? 0 : this.locality.hashCode());
            result = result * 31 + (this.postalCode == null ? 0 : this.postalCode.hashCode());
            result = result * 31 + (this.countryCode == null ? 0 : this.countryCode.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BillingAddress)) {
                return false;
            }
            BillingAddress billingAddress = (BillingAddress)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)billingAddress.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.line1, (Object)billingAddress.line1)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.line2, (Object)billingAddress.line2)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.administrativeArea, (Object)billingAddress.administrativeArea)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.locality, (Object)billingAddress.locality)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.postalCode, (Object)billingAddress.postalCode)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.countryCode, (Object)billingAddress.countryCode);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<BillingAddress> {
                public final BillingAddress[] newArray(int size) {
                    return new BillingAddress[size];
                }

                public final BillingAddress createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new BillingAddress(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), (CountryCode)parcel.readParcelable(BillingAddress.class.getClassLoader()));
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 F2\u00020\u0001:\u0001FBw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\tH\u00c6\u0003J\t\u00103\u001a\u00020\tH\u00c6\u0003J\t\u00104\u001a\u00020\fH\u00c6\u0003J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0003J\t\u00106\u001a\u00020\u0010H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u008d\u0001\u0010:\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010;\u001a\u00020\tJ\u0013\u0010<\u001a\u00020\u00062\b\u0010=\u001a\u0004\u0018\u00010>H\u00d6\u0003J\t\u0010?\u001a\u00020\tH\u00d6\u0001J\t\u0010@\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u001aR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0018R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018R\u0011\u0010)\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001aR\u0011\u0010+\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001aR\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\"\u00a8\u0006G"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$Card;", "Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;", "id", "", "last4", "isDefault", "", "nickname", "expiryYear", "", "expiryMonth", "brand", "Lcom/stripe/android/model/CardBrand;", "networks", "", "cvcCheck", "Lcom/stripe/android/model/CvcCheck;", "funding", "billingAddress", "Lcom/stripe/android/model/ConsumerPaymentDetails$BillingAddress;", "billingEmailAddress", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;IILcom/stripe/android/model/CardBrand;Ljava/util/List;Lcom/stripe/android/model/CvcCheck;Ljava/lang/String;Lcom/stripe/android/model/ConsumerPaymentDetails$BillingAddress;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getLast4", "()Z", "getNickname", "getExpiryYear", "()I", "getExpiryMonth", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "getNetworks", "()Ljava/util/List;", "getCvcCheck", "()Lcom/stripe/android/model/CvcCheck;", "getFunding", "getBillingAddress", "()Lcom/stripe/android/model/ConsumerPaymentDetails$BillingAddress;", "getBillingEmailAddress", "requiresCardDetailsRecollection", "getRequiresCardDetailsRecollection", "isExpired", "availableNetworks", "getAvailableNetworks", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "describeContents", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "payments-model_release"})
    @Parcelize
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @SourceDebugExtension(value={"SMAP\nConsumerPaymentDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerPaymentDetails.kt\ncom/stripe/android/model/ConsumerPaymentDetails$Card\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1557#2:140\n1628#2,3:141\n774#2:144\n865#2,2:145\n*S KotlinDebug\n*F\n+ 1 ConsumerPaymentDetails.kt\ncom/stripe/android/model/ConsumerPaymentDetails$Card\n*L\n60#1:140\n60#1:141,3\n61#1:144\n61#1:145,2\n*E\n"})
    public static final class Card
    extends PaymentDetails {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String last4;
        private final boolean isDefault;
        @Nullable
        private final String nickname;
        private final int expiryYear;
        private final int expiryMonth;
        @NotNull
        private final CardBrand brand;
        @NotNull
        private final List<String> networks;
        @NotNull
        private final CvcCheck cvcCheck;
        @NotNull
        private final String funding;
        @Nullable
        private final BillingAddress billingAddress;
        @Nullable
        private final String billingEmailAddress;
        @NotNull
        public static final Parcelable.Creator<Card> CREATOR;
        @NotNull
        public static final String TYPE = "card";

        public Card(@NotNull String id, @NotNull String last4, boolean isDefault, @Nullable String nickname, int expiryYear, int expiryMonth, @NotNull CardBrand brand, @NotNull List<String> networks, @NotNull CvcCheck cvcCheck, @NotNull String funding, @Nullable BillingAddress billingAddress, @Nullable String billingEmailAddress) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)last4, (String)"last4");
            Intrinsics.checkNotNullParameter((Object)((Object)brand), (String)"brand");
            Intrinsics.checkNotNullParameter(networks, (String)"networks");
            Intrinsics.checkNotNullParameter((Object)((Object)cvcCheck), (String)"cvcCheck");
            Intrinsics.checkNotNullParameter((Object)funding, (String)"funding");
            super(id, isDefault, TYPE, nickname, null);
            this.id = id;
            this.last4 = last4;
            this.isDefault = isDefault;
            this.nickname = nickname;
            this.expiryYear = expiryYear;
            this.expiryMonth = expiryMonth;
            this.brand = brand;
            this.networks = networks;
            this.cvcCheck = cvcCheck;
            this.funding = funding;
            this.billingAddress = billingAddress;
            this.billingEmailAddress = billingEmailAddress;
        }

        public /* synthetic */ Card(String string, String string2, boolean bl, String string3, int n, int n2, CardBrand cardBrand, List list, CvcCheck cvcCheck, String string4, BillingAddress billingAddress, String string5, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x400) != 0) {
                billingAddress = null;
            }
            if ((n3 & 0x800) != 0) {
                string5 = null;
            }
            this(string, string2, bl, string3, n, n2, cardBrand, list, cvcCheck, string4, billingAddress, string5);
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getLast4() {
            return this.last4;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        @Override
        @Nullable
        public String getNickname() {
            return this.nickname;
        }

        public final int getExpiryYear() {
            return this.expiryYear;
        }

        public final int getExpiryMonth() {
            return this.expiryMonth;
        }

        @NotNull
        public final CardBrand getBrand() {
            return this.brand;
        }

        @NotNull
        public final List<String> getNetworks() {
            return this.networks;
        }

        @NotNull
        public final CvcCheck getCvcCheck() {
            return this.cvcCheck;
        }

        @NotNull
        public final String getFunding() {
            return this.funding;
        }

        @Nullable
        public final BillingAddress getBillingAddress() {
            return this.billingAddress;
        }

        @Nullable
        public final String getBillingEmailAddress() {
            return this.billingEmailAddress;
        }

        public final boolean getRequiresCardDetailsRecollection() {
            return this.isExpired() || this.cvcCheck.getRequiresRecollection();
        }

        public final boolean isExpired() {
            return !DateUtils.isExpiryDataValid((int)this.expiryMonth, (int)this.expiryYear);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<CardBrand> getAvailableNetworks() {
            void $this$filterTo$iv$iv;
            CardBrand it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.networks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CardBrand.Companion.fromCode((String)((Object)it)));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CardBrand)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != CardBrand.Unknown)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.id);
            dest.writeString(this.last4);
            dest.writeInt(this.isDefault ? 1 : 0);
            dest.writeString(this.nickname);
            dest.writeInt(this.expiryYear);
            dest.writeInt(this.expiryMonth);
            dest.writeString(this.brand.name());
            dest.writeStringList(this.networks);
            dest.writeString(this.cvcCheck.name());
            dest.writeString(this.funding);
            BillingAddress billingAddress = this.billingAddress;
            if (billingAddress == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                billingAddress.writeToParcel(dest, flags);
            }
            dest.writeString(this.billingEmailAddress);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.last4;
        }

        public final boolean component3() {
            return this.isDefault;
        }

        @Nullable
        public final String component4() {
            return this.nickname;
        }

        public final int component5() {
            return this.expiryYear;
        }

        public final int component6() {
            return this.expiryMonth;
        }

        @NotNull
        public final CardBrand component7() {
            return this.brand;
        }

        @NotNull
        public final List<String> component8() {
            return this.networks;
        }

        @NotNull
        public final CvcCheck component9() {
            return this.cvcCheck;
        }

        @NotNull
        public final String component10() {
            return this.funding;
        }

        @Nullable
        public final BillingAddress component11() {
            return this.billingAddress;
        }

        @Nullable
        public final String component12() {
            return this.billingEmailAddress;
        }

        @NotNull
        public final Card copy(@NotNull String id, @NotNull String last4, boolean isDefault, @Nullable String nickname, int expiryYear, int expiryMonth, @NotNull CardBrand brand, @NotNull List<String> networks, @NotNull CvcCheck cvcCheck, @NotNull String funding, @Nullable BillingAddress billingAddress, @Nullable String billingEmailAddress) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)last4, (String)"last4");
            Intrinsics.checkNotNullParameter((Object)((Object)brand), (String)"brand");
            Intrinsics.checkNotNullParameter(networks, (String)"networks");
            Intrinsics.checkNotNullParameter((Object)((Object)cvcCheck), (String)"cvcCheck");
            Intrinsics.checkNotNullParameter((Object)funding, (String)"funding");
            return new Card(id, last4, isDefault, nickname, expiryYear, expiryMonth, brand, networks, cvcCheck, funding, billingAddress, billingEmailAddress);
        }

        public static /* synthetic */ Card copy$default(Card card, String string, String string2, boolean bl, String string3, int n, int n2, CardBrand cardBrand, List list, CvcCheck cvcCheck, String string4, BillingAddress billingAddress, String string5, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = card.id;
            }
            if ((n3 & 2) != 0) {
                string2 = card.last4;
            }
            if ((n3 & 4) != 0) {
                bl = card.isDefault;
            }
            if ((n3 & 8) != 0) {
                string3 = card.nickname;
            }
            if ((n3 & 0x10) != 0) {
                n = card.expiryYear;
            }
            if ((n3 & 0x20) != 0) {
                n2 = card.expiryMonth;
            }
            if ((n3 & 0x40) != 0) {
                cardBrand = card.brand;
            }
            if ((n3 & 0x80) != 0) {
                list = card.networks;
            }
            if ((n3 & 0x100) != 0) {
                cvcCheck = card.cvcCheck;
            }
            if ((n3 & 0x200) != 0) {
                string4 = card.funding;
            }
            if ((n3 & 0x400) != 0) {
                billingAddress = card.billingAddress;
            }
            if ((n3 & 0x800) != 0) {
                string5 = card.billingEmailAddress;
            }
            return card.copy(string, string2, bl, string3, n, n2, cardBrand, list, cvcCheck, string4, billingAddress, string5);
        }

        @NotNull
        public String toString() {
            return "Card(id=" + this.id + ", last4=" + this.last4 + ", isDefault=" + this.isDefault + ", nickname=" + this.nickname + ", expiryYear=" + this.expiryYear + ", expiryMonth=" + this.expiryMonth + ", brand=" + this.brand + ", networks=" + this.networks + ", cvcCheck=" + this.cvcCheck + ", funding=" + this.funding + ", billingAddress=" + this.billingAddress + ", billingEmailAddress=" + this.billingEmailAddress + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.last4.hashCode();
            result = result * 31 + Boolean.hashCode(this.isDefault);
            result = result * 31 + (this.nickname == null ? 0 : this.nickname.hashCode());
            result = result * 31 + Integer.hashCode(this.expiryYear);
            result = result * 31 + Integer.hashCode(this.expiryMonth);
            result = result * 31 + this.brand.hashCode();
            result = result * 31 + ((Object)this.networks).hashCode();
            result = result * 31 + this.cvcCheck.hashCode();
            result = result * 31 + this.funding.hashCode();
            result = result * 31 + (this.billingAddress == null ? 0 : this.billingAddress.hashCode());
            result = result * 31 + (this.billingEmailAddress == null ? 0 : this.billingEmailAddress.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Card)) {
                return false;
            }
            Card card = (Card)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)card.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.last4, (Object)card.last4)) {
                return false;
            }
            if (this.isDefault != card.isDefault) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nickname, (Object)card.nickname)) {
                return false;
            }
            if (this.expiryYear != card.expiryYear) {
                return false;
            }
            if (this.expiryMonth != card.expiryMonth) {
                return false;
            }
            if (this.brand != card.brand) {
                return false;
            }
            if (!Intrinsics.areEqual(this.networks, card.networks)) {
                return false;
            }
            if (this.cvcCheck != card.cvcCheck) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.funding, (Object)card.funding)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.billingAddress, (Object)card.billingAddress)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.billingEmailAddress, (Object)card.billingEmailAddress);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Card> {
                public final Card[] newArray(int size) {
                    return new Card[size];
                }

                public final Card createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Card(parcel.readString(), parcel.readString(), parcel.readInt() != 0, parcel.readString(), parcel.readInt(), parcel.readInt(), CardBrand.valueOf(parcel.readString()), parcel.createStringArrayList(), CvcCheck.valueOf(parcel.readString()), parcel.readString(), (BillingAddress)(parcel.readInt() == 0 ? null : BillingAddress.CREATOR.createFromParcel(parcel)), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tH\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$Card$Companion;", "", "<init>", "()V", "TYPE", "", "getAddressFromMap", "Lkotlin/Pair;", "cardPaymentMethodCreateParamsMap", "", "getAddressFromMap$payments_model_release", "payments-model_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Pair<String, Object> getAddressFromMap$payments_model_release(@NotNull Map<String, ? extends Object> cardPaymentMethodCreateParamsMap) {
                Pair pair;
                Map address;
                Map billingDetails;
                Intrinsics.checkNotNullParameter(cardPaymentMethodCreateParamsMap, (String)"cardPaymentMethodCreateParamsMap");
                Object object = cardPaymentMethodCreateParamsMap.get("billing_details");
                Map map = billingDetails = object instanceof Map ? (Map)object : null;
                Object v = map != null ? map.get("address") : null;
                Map map2 = address = v instanceof Map ? (Map)v : null;
                if (map2 != null) {
                    Map it = map2;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"country_code", it.get("country")), TuplesKt.to((Object)"postal_code", it.get("postal_code"))};
                    pair = TuplesKt.to((Object)"billing_address", (Object)MapsKt.mapOf((Pair[])pairArray));
                } else {
                    pair = null;
                }
                return pair;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010\r\u001a\u00020\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$Passthrough;", "Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;", "id", "", "last4", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getLast4", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "payments-model_release"})
    @Parcelize
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Passthrough
    extends PaymentDetails {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String last4;
        @NotNull
        public static final Parcelable.Creator<Passthrough> CREATOR;
        @NotNull
        public static final String TYPE = "card";

        public Passthrough(@NotNull String id, @NotNull String last4) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)last4, (String)"last4");
            super(id, false, TYPE, null, null);
            this.id = id;
            this.last4 = last4;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getLast4() {
            return this.last4;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.id);
            dest.writeString(this.last4);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.last4;
        }

        @NotNull
        public final Passthrough copy(@NotNull String id, @NotNull String last4) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)last4, (String)"last4");
            return new Passthrough(id, last4);
        }

        public static /* synthetic */ Passthrough copy$default(Passthrough passthrough, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = passthrough.id;
            }
            if ((n & 2) != 0) {
                string2 = passthrough.last4;
            }
            return passthrough.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Passthrough(id=" + this.id + ", last4=" + this.last4 + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.last4.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Passthrough)) {
                return false;
            }
            Passthrough passthrough = (Passthrough)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)passthrough.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.last4, (Object)passthrough.last4);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Passthrough> {
                public final Passthrough[] newArray(int size) {
                    return new Passthrough[size];
                }

                public final Passthrough createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Passthrough(parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$Passthrough$Companion;", "", "<init>", "()V", "TYPE", "", "payments-model_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0012\u0010\u000f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;", "Landroid/os/Parcelable;", "id", "", "isDefault", "", "type", "nickname", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "()Z", "getType", "getNickname", "last4", "getLast4", "Lcom/stripe/android/model/ConsumerPaymentDetails$BankAccount;", "Lcom/stripe/android/model/ConsumerPaymentDetails$Card;", "Lcom/stripe/android/model/ConsumerPaymentDetails$Passthrough;", "payments-model_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static abstract class PaymentDetails
    implements Parcelable {
        @NotNull
        private final String id;
        private final boolean isDefault;
        @NotNull
        private final String type;
        @Nullable
        private final String nickname;

        private PaymentDetails(String id, boolean isDefault, String type, String nickname) {
            this.id = id;
            this.isDefault = isDefault;
            this.type = type;
            this.nickname = nickname;
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        @NotNull
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getNickname() {
            return this.nickname;
        }

        @NotNull
        public abstract String getLast4();

        public /* synthetic */ PaymentDetails(String id, boolean isDefault, String type, String nickname, DefaultConstructorMarker $constructor_marker) {
            this(id, isDefault, type, nickname);
        }
    }
}

