/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.ConsumerPaymentDetails;
import com.stripe.android.model.CvcCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/model/parsers/ConsumerPaymentDetailsJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/ConsumerPaymentDetails;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "parsePaymentDetails", "Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;", "parseBillingAddress", "Lcom/stripe/android/model/ConsumerPaymentDetails$BillingAddress;", "cardBrandFix", "", "original", "payments-model_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nConsumerPaymentDetailsJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerPaymentDetailsJsonParser.kt\ncom/stripe/android/model/parsers/ConsumerPaymentDetailsJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n1611#2,9:131\n1863#2:140\n1864#2:142\n1620#2:143\n1#3:141\n1#3:144\n*S KotlinDebug\n*F\n+ 1 ConsumerPaymentDetailsJsonParser.kt\ncom/stripe/android/model/parsers/ConsumerPaymentDetailsJsonParser\n*L\n51#1:127\n51#1:128,3\n52#1:131,9\n52#1:140\n52#1:142\n52#1:143\n52#1:141\n*E\n"})
public final class ConsumerPaymentDetailsJsonParser
implements ModelJsonParser<ConsumerPaymentDetails> {
    @NotNull
    public static final ConsumerPaymentDetailsJsonParser INSTANCE = new ConsumerPaymentDetailsJsonParser();

    private ConsumerPaymentDetailsJsonParser() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public ConsumerPaymentDetails parse(@NotNull JSONObject json) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                v0 = json.optJSONArray("redacted_payment_details");
                if (v0 == null) break block4;
                paymentDetailsArray = v0;
                $i$a$-let-ConsumerPaymentDetailsJsonParser$parse$paymentDetails$1 = false;
                var6_4 = (Iterable)RangesKt.until((int)0, (int)paymentDetailsArray.length());
                $i$f$map = false;
                var8_6 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var11_9 = $this$mapTo$iv$iv.iterator();
                while (var11_9.hasNext()) {
                    var13_11 = item$iv$iv = ((IntIterator)var11_9).nextInt();
                    var14_13 = destination$iv$iv;
                    $i$a$-map-ConsumerPaymentDetailsJsonParser$parse$paymentDetails$1$1 = false;
                    var14_13.add(paymentDetailsArray.getJSONObject((int)index));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$mapNotNull = false;
                $this$mapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var13_12 = $this$forEach$iv$iv$iv.iterator();
                while (var13_12.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var13_12.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (JSONObject)element$iv$iv;
                    $i$a$-mapNotNull-ConsumerPaymentDetailsJsonParser$parse$paymentDetails$1$2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (ConsumerPaymentDetailsJsonParser.INSTANCE.parsePaymentDetails(it) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                v1 = (List)destination$iv$iv;
                break block5;
            }
            var3_22 = json.optJSONObject("redacted_payment_details");
            if (var3_22 == null) ** GOTO lbl-1000
            it /* !! */  = var3_22;
            $i$a$-let-ConsumerPaymentDetailsJsonParser$parse$paymentDetails$2 = false;
            var4_2 = ConsumerPaymentDetailsJsonParser.INSTANCE.parsePaymentDetails(it /* !! */ );
            if (var4_2 != null) {
                it /* !! */  = var4_2;
                $i$a$-let-ConsumerPaymentDetailsJsonParser$parse$paymentDetails$3 = false;
                v1 = CollectionsKt.listOf((Object)it /* !! */ );
            } else lbl-1000:
            // 2 sources

            {
                v1 = CollectionsKt.emptyList();
            }
        }
        paymentDetails = v1;
        return new ConsumerPaymentDetails(paymentDetails);
    }

    private final ConsumerPaymentDetails.PaymentDetails parsePaymentDetails(JSONObject json) {
        ConsumerPaymentDetails.PaymentDetails paymentDetails;
        String string = StripeJsonUtils.optString((JSONObject)json, (String)"type");
        if (string != null) {
            String string2;
            String type = string;
            boolean bl = false;
            String id = json.getString("id");
            boolean isDefault = json.optBoolean("is_default");
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)"nickname");
            if (string3 != null) {
                String string4;
                String it = string4 = string3;
                boolean bl2 = false;
                string2 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
            } else {
                string2 = null;
            }
            String nickname = string2;
            String string5 = type.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            String string6 = string5;
            if (Intrinsics.areEqual((Object)string6, (Object)"card")) {
                JSONObject cardDetails = json.getJSONObject("card_details");
                JSONObject checks = cardDetails.optJSONObject("checks");
                List networks = ModelJsonParser.Companion.jsonArrayToList(cardDetails.optJSONArray("networks"));
                Intrinsics.checkNotNull((Object)id);
                String string7 = id;
                int n = cardDetails.getInt("exp_year");
                int n2 = cardDetails.getInt("exp_month");
                String string8 = cardDetails.getString("brand");
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(...)");
                CardBrand cardBrand = CardBrand.Companion.fromCode(INSTANCE.cardBrandFix(string8));
                String string9 = cardDetails.getString("last4");
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getString(...)");
                String string10 = string9;
                JSONObject jSONObject = checks;
                CvcCheck cvcCheck = CvcCheck.Companion.fromCode(jSONObject != null ? jSONObject.getString("cvc_check") : null);
                String string11 = cardDetails.getString("funding");
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getString(...)");
                String string12 = string11;
                ConsumerPaymentDetails.BillingAddress billingAddress = INSTANCE.parseBillingAddress(json);
                String string13 = StripeJsonUtils.optString((JSONObject)json, (String)"billing_email_address");
                paymentDetails = new ConsumerPaymentDetails.Card(string7, string10, isDefault, nickname, n, n2, cardBrand, networks, cvcCheck, string12, billingAddress, string13);
            } else if (Intrinsics.areEqual((Object)string6, (Object)"bank_account")) {
                JSONObject bankAccountDetails = json.getJSONObject("bank_account_details");
                Intrinsics.checkNotNull((Object)id);
                String string14 = id;
                String string15 = bankAccountDetails.getString("last4");
                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getString(...)");
                String string16 = string15;
                String string17 = StripeJsonUtils.optString((JSONObject)bankAccountDetails, (String)"bank_name");
                String string18 = StripeJsonUtils.optString((JSONObject)bankAccountDetails, (String)"bank_icon_code");
                paymentDetails = new ConsumerPaymentDetails.BankAccount(string14, string16, isDefault, nickname, string17, string18);
            } else {
                paymentDetails = null;
            }
        } else {
            paymentDetails = null;
        }
        return paymentDetails;
    }

    private final ConsumerPaymentDetails.BillingAddress parseBillingAddress(JSONObject json) {
        ConsumerPaymentDetails.BillingAddress billingAddress;
        JSONObject jSONObject = json.optJSONObject("billing_address");
        if (jSONObject != null) {
            CountryCode countryCode;
            JSONObject address = jSONObject;
            boolean bl = false;
            String string = StripeJsonUtils.optString((JSONObject)address, (String)"name");
            String string2 = StripeJsonUtils.optString((JSONObject)address, (String)"line1");
            String string3 = StripeJsonUtils.optString((JSONObject)address, (String)"line2");
            String string4 = StripeJsonUtils.optString((JSONObject)address, (String)"locality");
            String string5 = StripeJsonUtils.optString((JSONObject)address, (String)"postal_code");
            String string6 = StripeJsonUtils.optString((JSONObject)address, (String)"administrative_area");
            String string7 = StripeJsonUtils.optString((JSONObject)address, (String)"country_code");
            if (string7 != null) {
                String it = string7;
                boolean bl2 = false;
                countryCode = new CountryCode(it);
            } else {
                countryCode = null;
            }
            CountryCode countryCode2 = countryCode;
            billingAddress = new ConsumerPaymentDetails.BillingAddress(string, string2, string3, string6, string4, string5, countryCode2);
        } else {
            billingAddress = null;
        }
        return billingAddress;
    }

    private final String cardBrandFix(String original) {
        String string = original.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String it = string;
        boolean bl = false;
        String string2 = it;
        return Intrinsics.areEqual((Object)string2, (Object)"american_express") ? "amex" : (Intrinsics.areEqual((Object)string2, (Object)"diners_club") ? "diners" : it);
    }
}

