/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.CurrencyFormatter;
import com.stripe.android.ui.core.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/ui/core/Amount;", "Landroid/os/Parcelable;", "value", "", "currencyCode", "", "(JLjava/lang/String;)V", "getCurrencyCode", "()Ljava/lang/String;", "getValue", "()J", "buildPayButtonLabel", "resources", "Landroid/content/res/Resources;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-ui-core_release"})
@Parcelize
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class Amount
implements Parcelable {
    private final long value;
    @NotNull
    private final String currencyCode;
    @NotNull
    public static final Parcelable.Creator<Amount> CREATOR;
    public static final int $stable;

    public Amount(long value, @NotNull String currencyCode) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        this.value = value;
        this.currencyCode = currencyCode;
    }

    public final long getValue() {
        return this.value;
    }

    @NotNull
    public final String getCurrencyCode() {
        return this.currencyCode;
    }

    @NotNull
    public final String buildPayButtonLabel(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Object[] objectArray = new Object[]{CurrencyFormatter.Companion.format$default(CurrencyFormatter.Companion, this.value, this.currencyCode, null, 4, null)};
        String string2 = resources.getString(R.string.stripe_pay_button_amount, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(\n   \u2026, currencyCode)\n        )");
        return string2;
    }

    public final long component1() {
        return this.value;
    }

    @NotNull
    public final String component2() {
        return this.currencyCode;
    }

    @NotNull
    public final Amount copy(long value, @NotNull String currencyCode) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        return new Amount(value, currencyCode);
    }

    public static /* synthetic */ Amount copy$default(Amount amount, long l, String string, int n, Object object) {
        if ((n & 1) != 0) {
            l = amount.value;
        }
        if ((n & 2) != 0) {
            string = amount.currencyCode;
        }
        return amount.copy(l, string);
    }

    @NotNull
    public String toString() {
        return "Amount(value=" + this.value + ", currencyCode=" + this.currencyCode + ')';
    }

    public int hashCode() {
        int result = Long.hashCode(this.value);
        result = result * 31 + this.currencyCode.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Amount)) {
            return false;
        }
        Amount amount = (Amount)other;
        if (this.value != amount.value) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currencyCode, (Object)amount.currencyCode);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeLong(this.value);
        out.writeString(this.currencyCode);
    }

    static {
        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<Amount> {
            @NotNull
            public final Amount[] newArray(int size) {
                return new Amount[size];
            }

            @NotNull
            public final Amount createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new Amount(parcel.readLong(), parcel.readString());
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

