/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/ui/core/CurrencyFormatter;", "", "()V", "Companion", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class CurrencyFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final double MAJOR_UNIT_BASE = 10.0;
    @NotNull
    private static final Map<Set<String>, Integer> SERVER_DECIMAL_DIGITS;

    static {
        Object[] objectArray = new String[]{"UGX", "AFN", "ALL", "AMD", "COP", "IDR", "ISK", "PKR", "LBP"};
        SERVER_DECIMAL_DIGITS = MapsKt.mapOf((Pair)TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)2));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J \u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/ui/core/CurrencyFormatter$Companion;", "", "()V", "MAJOR_UNIT_BASE", "", "SERVER_DECIMAL_DIGITS", "", "", "", "", "format", "amount", "", "amountCurrency", "Ljava/util/Currency;", "targetLocale", "Ljava/util/Locale;", "amountCurrencyCode", "getDefaultDecimalDigits", "currency", "payments-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String format(long amount, @NotNull String amountCurrencyCode, @NotNull Locale targetLocale) {
            Intrinsics.checkNotNullParameter((Object)amountCurrencyCode, (String)"amountCurrencyCode");
            Intrinsics.checkNotNullParameter((Object)targetLocale, (String)"targetLocale");
            String string2 = amountCurrencyCode.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            Currency currency = Currency.getInstance(string2);
            Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(amountCurrencyCode.uppercase())");
            return this.format(amount, currency, targetLocale);
        }

        public static /* synthetic */ String format$default(Companion companion, long l, String string2, Locale locale, int n, Object object) {
            if ((n & 4) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
                locale = locale2;
            }
            return companion.format(l, string2, locale);
        }

        @NotNull
        public final String format(long amount, @NotNull Currency amountCurrency, @NotNull Locale targetLocale) {
            Intrinsics.checkNotNullParameter((Object)amountCurrency, (String)"amountCurrency");
            Intrinsics.checkNotNullParameter((Object)targetLocale, (String)"targetLocale");
            int amountCurrencyDecimalDigits = this.getDefaultDecimalDigits(amountCurrency);
            double majorUnitAmount = (double)amount / Math.pow(10.0, amountCurrencyDecimalDigits);
            NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(targetLocale);
            Companion companion = this;
            try {
                Companion $this$format_u24lambda_u2d0 = companion;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)currencyFormat, (String)"null cannot be cast to non-null type java.text.DecimalFormat");
                DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
                decimalFormatSymbols.setCurrency(amountCurrency);
                decimalFormatSymbols.setCurrencySymbol(amountCurrency.getSymbol(targetLocale));
                ((DecimalFormat)currencyFormat).setMinimumFractionDigits(amountCurrencyDecimalDigits);
                ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string2 = currencyFormat.format(majorUnitAmount);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currencyFormat.format(majorUnitAmount)");
            return string2;
        }

        public static /* synthetic */ String format$default(Companion companion, long l, Currency currency, Locale locale, int n, Object object) {
            if ((n & 4) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
                locale = locale2;
            }
            return companion.format(l, currency, locale);
        }

        /*
         * WARNING - void declaration
         */
        private final int getDefaultDecimalDigits(Currency currency) {
            void $this$mapTo$iv$iv;
            Map.Entry entry;
            Map $this$filterTo$iv$iv;
            Map $this$filter$iv = SERVER_DECIMAL_DIGITS;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                entry = element$iv$iv = iterator.next();
                boolean bl = false;
                Set set = (Set)entry.getKey();
                String string2 = currency.getCurrencyCode();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currency.currencyCode");
                String string3 = string2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                if (!set.contains(string3)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                void it;
                entry = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(((Number)it.getValue()).intValue());
            }
            Integer n = (Integer)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            return n != null ? n.intValue() : currency.getDefaultFractionDigits();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

