/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import android.content.res.Resources;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.intl.Locale;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.CurrencyFormatter;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.elements.Controller;
import com.stripe.android.ui.core.elements.FormElement;
import com.stripe.android.ui.core.elements.IdentifierSpec;
import com.stripe.android.ui.core.forms.FormFieldEntry;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 '2\u00020\u0001:\u0001'B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c2\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J \u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b0\u001aH\u0016J\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u000eH\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/stripe/android/ui/core/elements/AfterpayClearpayHeaderElement;", "Lcom/stripe/android/ui/core/elements/FormElement;", "identifier", "Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "amount", "Lcom/stripe/android/ui/core/Amount;", "controller", "Lcom/stripe/android/ui/core/elements/Controller;", "(Lcom/stripe/android/ui/core/elements/IdentifierSpec;Lcom/stripe/android/ui/core/Amount;Lcom/stripe/android/ui/core/elements/Controller;)V", "getController", "()Lcom/stripe/android/ui/core/elements/Controller;", "getIdentifier", "()Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "infoUrl", "", "getInfoUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getFormFieldValueFlow", "Lkotlinx/coroutines/flow/Flow;", "", "Lkotlin/Pair;", "Lcom/stripe/android/ui/core/forms/FormFieldEntry;", "getLabel", "resources", "Landroid/content/res/Resources;", "getLocaleString", "locale", "Landroidx/compose/ui/text/intl/Locale;", "hashCode", "", "toString", "Companion", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class AfterpayClearpayHeaderElement
extends FormElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentifierSpec identifier;
    @NotNull
    private final Amount amount;
    @Nullable
    private final Controller controller;
    public static final int $stable;
    @NotNull
    public static final String url = "https://static.afterpay.com/modal/%s.html";
    @NotNull
    public static final String NO_BREAK_SPACE = "\u00a0";

    public AfterpayClearpayHeaderElement(@NotNull IdentifierSpec identifier, @NotNull Amount amount, @Nullable Controller controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        super(null);
        this.identifier = identifier;
        this.amount = amount;
        this.controller = controller;
    }

    public /* synthetic */ AfterpayClearpayHeaderElement(IdentifierSpec identifierSpec, Amount amount, Controller controller, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            controller = null;
        }
        this(identifierSpec, amount, controller);
    }

    @Override
    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public Controller getController() {
        return this.controller;
    }

    @Override
    @NotNull
    public Flow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return (Flow)StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
    }

    @NotNull
    public final String getInfoUrl() {
        String string2 = url;
        Object[] objectArray = new Object[]{this.getLocaleString(Locale.Companion.getCurrent())};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return string3;
    }

    private final String getLocaleString(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = locale.getLanguage().toLowerCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append('_');
        String string3 = locale.getRegion().toUpperCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return stringBuilder2.append(string3).toString();
    }

    @NotNull
    public final String getLabel(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        String string2 = this.amount.getCurrencyCode().toLowerCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        int numInstallments = Intrinsics.areEqual((Object)string2, (Object)"eur") ? 3 : 4;
        String string3 = resources.getString(R.string.afterpay_clearpay_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(\n   \u2026learpay_message\n        )");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"<num_installments/>", (String)String.valueOf(numInstallments), (boolean)false, (int)4, null), (String)"<installment_price/>", (String)CurrencyFormatter.Companion.format$default(CurrencyFormatter.Companion, this.amount.getValue() / (long)numInstallments, this.amount.getCurrencyCode(), null, 4, null), (boolean)false, (int)4, null), (String)"<img/>", (String)("<img/>\u00a0<a href=\"" + this.getInfoUrl() + "\"><b>\u24d8</b></a>"), (boolean)false, (int)4, null);
    }

    @NotNull
    public final IdentifierSpec component1() {
        return this.getIdentifier();
    }

    private final Amount component2() {
        return this.amount;
    }

    @Nullable
    public final Controller component3() {
        return this.getController();
    }

    @NotNull
    public final AfterpayClearpayHeaderElement copy(@NotNull IdentifierSpec identifier, @NotNull Amount amount, @Nullable Controller controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return new AfterpayClearpayHeaderElement(identifier, amount, controller);
    }

    public static /* synthetic */ AfterpayClearpayHeaderElement copy$default(AfterpayClearpayHeaderElement afterpayClearpayHeaderElement, IdentifierSpec identifierSpec, Amount amount, Controller controller, int n, Object object) {
        if ((n & 1) != 0) {
            identifierSpec = afterpayClearpayHeaderElement.getIdentifier();
        }
        if ((n & 2) != 0) {
            amount = afterpayClearpayHeaderElement.amount;
        }
        if ((n & 4) != 0) {
            controller = afterpayClearpayHeaderElement.getController();
        }
        return afterpayClearpayHeaderElement.copy(identifierSpec, amount, controller);
    }

    @NotNull
    public String toString() {
        return "AfterpayClearpayHeaderElement(identifier=" + this.getIdentifier() + ", amount=" + this.amount + ", controller=" + this.getController() + ')';
    }

    public int hashCode() {
        int result = this.getIdentifier().hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + (this.getController() == null ? 0 : this.getController().hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AfterpayClearpayHeaderElement)) {
            return false;
        }
        AfterpayClearpayHeaderElement afterpayClearpayHeaderElement = (AfterpayClearpayHeaderElement)other;
        if (!Intrinsics.areEqual((Object)this.getIdentifier(), (Object)afterpayClearpayHeaderElement.getIdentifier())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.amount, (Object)afterpayClearpayHeaderElement.amount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getController(), (Object)afterpayClearpayHeaderElement.getController());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/ui/core/elements/AfterpayClearpayHeaderElement$Companion;", "", "()V", "NO_BREAK_SPACE", "", "url", "isClearpay", "", "isClearpay$payments_ui_core_release", "payments-ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isClearpay$payments_ui_core_release() {
            Object[] objectArray = new String[]{"GB", "ES", "FR", "IT"};
            return SetsKt.setOf((Object[])objectArray).contains(Locale.Companion.getCurrent().getRegion());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

