/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.elements.IbanConfig;
import com.stripe.android.ui.core.elements.TextFieldConfig;
import com.stripe.android.ui.core.elements.TextFieldIcon;
import com.stripe.android.ui.core.elements.TextFieldState;
import com.stripe.android.ui.core.elements.TextFieldStateConstants;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\tH\u0002R\u001f\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u00020\rX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000e\u0010\u0006R\u0016\u0010\u000f\u001a\u00020\u00108\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006,"}, d2={"Lcom/stripe/android/ui/core/elements/IbanConfig;", "Lcom/stripe/android/ui/core/elements/TextFieldConfig;", "()V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "label", "", "getLabel", "loading", "Lkotlinx/coroutines/flow/StateFlow;", "", "getLoading", "()Lkotlinx/coroutines/flow/StateFlow;", "trailingIcon", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/ui/core/elements/TextFieldIcon;", "getTrailingIcon", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "determineState", "Lcom/stripe/android/ui/core/elements/TextFieldState;", "input", "filter", "userTyped", "isIbanValid", "iban", "Companion", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class IbanConfig
implements TextFieldConfig {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int capitalization = KeyboardCapitalization.Companion.getCharacters-IUNYP9k();
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label = R.string.iban;
    private final int keyboard = KeyboardType.Companion.getAscii-PjHm6EE();
    @NotNull
    private final MutableStateFlow<TextFieldIcon> trailingIcon = StateFlowKt.MutableStateFlow((Object)new TextFieldIcon.Trailing(R.drawable.stripe_ic_bank_generic, null, true, null, 10, null));
    @NotNull
    private final StateFlow<Boolean> loading = (StateFlow)StateFlowKt.MutableStateFlow((Object)false);
    @NotNull
    private final VisualTransformation visualTransformation = visualTransformation.1.INSTANCE;
    public static final int $stable = 8;
    @Deprecated
    public static final int MIN_LENGTH = 8;
    @Deprecated
    public static final int MAX_LENGTH = 34;
    @Deprecated
    @NotNull
    private static final List<Character> VALID_INPUT_RANGES = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('0', '9')), (Iterable)((Iterable)new CharRange('a', 'z'))), (Iterable)((Iterable)new CharRange('A', 'Z')));

    public IbanConfig() {
        this.debugLabel = "iban";
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @NotNull
    public MutableStateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @Override
    @NotNull
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        String $this$filter$iv = userTyped;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!VALID_INPUT_RANGES.contains(Character.valueOf(it))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filterTo(StringBuilder(), predicate).toString()");
        String string3 = StringsKt.take((String)string2, (int)34).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string3;
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        boolean bl;
        String countryCode;
        block6: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            CharSequence charSequence = input;
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                boolean bl2 = false;
                return TextFieldStateConstants.Error.Blank.INSTANCE;
            }
            String string2 = StringsKt.take((String)input, (int)2).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            countryCode = string2;
            CharSequence $this$any$iv = countryCode;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl3 = false;
                if (!Character.isDigit(it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return new TextFieldStateConstants.Error.Invalid(R.string.iban_invalid_start, null, 2, null);
        }
        if (countryCode.length() < 2) {
            return new TextFieldStateConstants.Error.Incomplete(R.string.iban_incomplete);
        }
        String[] stringArray = Locale.getISOCountries();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getISOCountries()");
        if (!ArraysKt.contains((Object[])stringArray, (Object)countryCode)) {
            Object[] objectArray = new String[]{countryCode};
            return new TextFieldStateConstants.Error.Invalid(R.string.iban_invalid_country, objectArray);
        }
        if (input.length() < 8) {
            return new TextFieldStateConstants.Error.Incomplete(R.string.iban_incomplete);
        }
        return this.isIbanValid(input) ? (TextFieldState)(input.length() == 34 ? (TextFieldStateConstants.Valid)TextFieldStateConstants.Valid.Full.INSTANCE : (TextFieldStateConstants.Valid)TextFieldStateConstants.Valid.Limitless.INSTANCE) : (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.iban_invalid);
    }

    private final boolean isIbanValid(String iban) {
        String string2 = (StringsKt.takeLast((String)iban, (int)(iban.length() - 4)) + StringsKt.take((String)iban, (int)4)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("[A-Z]");
        Function1 function1 = isIbanValid.1.INSTANCE;
        charSequence = regex.replace(charSequence, function1);
        return new BigInteger((String)charSequence).mod(new BigInteger("97")).equals(BigInteger.ONE);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/ui/core/elements/IbanConfig$Companion;", "", "()V", "MAX_LENGTH", "", "MIN_LENGTH", "VALID_INPUT_RANGES", "", "", "getVALID_INPUT_RANGES", "()Ljava/util/List;", "payments-ui-core_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Character> getVALID_INPUT_RANGES() {
            return VALID_INPUT_RANGES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

