/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.elements.FieldError;
import com.stripe.android.ui.core.elements.PostalCodeVisualTransformation;
import com.stripe.android.ui.core.elements.TextFieldConfig;
import com.stripe.android.ui.core.elements.TextFieldIcon;
import com.stripe.android.ui.core.elements.TextFieldState;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001*B@\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fH\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0016R\u001f\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006+"}, d2={"Lcom/stripe/android/ui/core/elements/PostalCodeConfig;", "Lcom/stripe/android/ui/core/elements/TextFieldConfig;", "label", "", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "trailingIcon", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/ui/core/elements/TextFieldIcon;", "country", "", "(IIILkotlinx/coroutines/flow/MutableStateFlow;Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "getDebugLabel", "()Ljava/lang/String;", "format", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat;", "getKeyboard-PjHm6EE", "getLabel", "loading", "", "getLoading", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "getTrailingIcon", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "determineState", "Lcom/stripe/android/ui/core/elements/TextFieldState;", "input", "filter", "userTyped", "CountryPostalFormat", "payments-ui-core_release"})
public final class PostalCodeConfig
implements TextFieldConfig {
    private final int label;
    private final int capitalization;
    private final int keyboard;
    @NotNull
    private final MutableStateFlow<TextFieldIcon> trailingIcon;
    @NotNull
    private final String country;
    @NotNull
    private final CountryPostalFormat format;
    @NotNull
    private final String debugLabel;
    @NotNull
    private final VisualTransformation visualTransformation;
    @NotNull
    private final MutableStateFlow<Boolean> loading;

    private PostalCodeConfig(int label, int capitalization, int keyboard, MutableStateFlow<TextFieldIcon> trailingIcon, String country) {
        this.label = label;
        this.capitalization = capitalization;
        this.keyboard = keyboard;
        this.trailingIcon = trailingIcon;
        this.country = country;
        this.format = CountryPostalFormat.Companion.forCountry(this.country);
        this.debugLabel = "postal_code_text";
        this.visualTransformation = new PostalCodeVisualTransformation(this.format);
        this.loading = StateFlowKt.MutableStateFlow((Object)false);
    }

    public /* synthetic */ PostalCodeConfig(int n, int n2, int n3, MutableStateFlow mutableStateFlow, String string2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = KeyboardCapitalization.Companion.getWords-IUNYP9k();
        }
        if ((n4 & 4) != 0) {
            n3 = KeyboardType.Companion.getText-PjHm6EE();
        }
        if ((n4 & 8) != 0) {
            mutableStateFlow = StateFlowKt.MutableStateFlow(null);
        }
        this(n, n2, n3, mutableStateFlow, string2, null);
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @NotNull
    public MutableStateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    @NotNull
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    @NotNull
    public MutableStateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new TextFieldState(this, input){
            final /* synthetic */ PostalCodeConfig this$0;
            final /* synthetic */ String $input;
            {
                this.this$0 = $receiver;
                this.$input = $input;
            }

            public boolean shouldShowError(boolean hasFocus2) {
                return this.getError() != null && !hasFocus2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid() {
                if (PostalCodeConfig.access$getFormat$p(this.this$0) instanceof CountryPostalFormat.Other) {
                    if (StringsKt.isBlank((CharSequence)this.$input)) return false;
                    return true;
                }
                int n = PostalCodeConfig.access$getFormat$p(this.this$0).getMinimumLength();
                int n2 = PostalCodeConfig.access$getFormat$p(this.this$0).getMaximumLength();
                int n3 = this.$input.length();
                if (n > n3) return false;
                if (n3 > n2) return false;
                boolean bl = true;
                if (!bl) return false;
                CharSequence charSequence = this.$input;
                if (!PostalCodeConfig.access$getFormat$p(this.this$0).getRegexPattern().matches(charSequence)) return false;
                return true;
            }

            @Nullable
            public FieldError getError() {
                return !StringsKt.isBlank((CharSequence)this.$input) && !this.isFull() && Intrinsics.areEqual((Object)PostalCodeConfig.access$getCountry$p(this.this$0), (Object)"US") ? new FieldError(R.string.address_zip_invalid, null, 2, null) : (!StringsKt.isBlank((CharSequence)this.$input) && !this.isFull() ? new FieldError(R.string.address_zip_postal_invalid, null, 2, null) : null);
            }

            public boolean isFull() {
                return this.$input.length() >= PostalCodeConfig.access$getFormat$p(this.this$0).getMinimumLength();
            }

            public boolean isBlank() {
                return StringsKt.isBlank((CharSequence)this.$input);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        Object[] objectArray = new KeyboardType[]{KeyboardType.box-impl((int)KeyboardType.Companion.getNumber-PjHm6EE()), KeyboardType.box-impl((int)KeyboardType.Companion.getNumberPassword-PjHm6EE())};
        if (SetsKt.setOf((Object[])objectArray).contains(KeyboardType.box-impl((int)this.getKeyboard-PjHm6EE()))) {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = userTyped;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!Character.isDigit(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string3 = ((StringBuilder)destination$iv$iv).toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"filterTo(StringBuilder(), predicate).toString()");
        } else {
            string2 = userTyped;
        }
        return StringsKt.dropLast((String)string2, (int)Math.max(0, userTyped.length() - this.format.getMaximumLength()));
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        CharSequence charSequence = rawValue;
        Regex regex = new Regex("\\s+");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    public /* synthetic */ PostalCodeConfig(@StringRes int label, int capitalization, int keyboard, MutableStateFlow trailingIcon, String country, DefaultConstructorMarker $constructor_marker) {
        this(label, capitalization, keyboard, (MutableStateFlow<TextFieldIcon>)trailingIcon, country);
    }

    public static final /* synthetic */ CountryPostalFormat access$getFormat$p(PostalCodeConfig $this) {
        return $this.format;
    }

    public static final /* synthetic */ String access$getCountry$p(PostalCodeConfig $this) {
        return $this.country;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000e2\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat;", "", "minimumLength", "", "maximumLength", "regexPattern", "Lkotlin/text/Regex;", "(IILkotlin/text/Regex;)V", "getMaximumLength", "()I", "getMinimumLength", "getRegexPattern", "()Lkotlin/text/Regex;", "CA", "Companion", "Other", "US", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat$CA;", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat$Other;", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat$US;", "payments-ui-core_release"})
    @StabilityInferred(parameters=0)
    public static abstract class CountryPostalFormat {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int minimumLength;
        private final int maximumLength;
        @NotNull
        private final Regex regexPattern;
        public static final int $stable = 8;

        private CountryPostalFormat(int minimumLength, int maximumLength, Regex regexPattern) {
            this.minimumLength = minimumLength;
            this.maximumLength = maximumLength;
            this.regexPattern = regexPattern;
        }

        public final int getMinimumLength() {
            return this.minimumLength;
        }

        public final int getMaximumLength() {
            return this.maximumLength;
        }

        @NotNull
        public final Regex getRegexPattern() {
            return this.regexPattern;
        }

        public /* synthetic */ CountryPostalFormat(int minimumLength, int maximumLength, Regex regexPattern, DefaultConstructorMarker $constructor_marker) {
            this(minimumLength, maximumLength, regexPattern);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat$CA;", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat;", "()V", "payments-ui-core_release"})
        @StabilityInferred(parameters=0)
        public static final class CA
        extends CountryPostalFormat {
            @NotNull
            public static final CA INSTANCE = new CA();
            public static final int $stable;

            private CA() {
                super(6, 6, new Regex("[a-zA-Z]\\d[a-zA-Z][\\s-]?\\d[a-zA-Z]\\d"), null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat$US;", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat;", "()V", "payments-ui-core_release"})
        @StabilityInferred(parameters=0)
        public static final class US
        extends CountryPostalFormat {
            @NotNull
            public static final US INSTANCE = new US();
            public static final int $stable;

            private US() {
                super(5, 5, new Regex("\\d+"), null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat$Other;", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat;", "()V", "payments-ui-core_release"})
        @StabilityInferred(parameters=0)
        public static final class Other
        extends CountryPostalFormat {
            @NotNull
            public static final Other INSTANCE = new Other();
            public static final int $stable;

            private Other() {
                super(1, Integer.MAX_VALUE, new Regex(".*"), null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat$Companion;", "", "()V", "forCountry", "Lcom/stripe/android/ui/core/elements/PostalCodeConfig$CountryPostalFormat;", "country", "", "payments-ui-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CountryPostalFormat forCountry(@NotNull String country) {
                Intrinsics.checkNotNullParameter((Object)country, (String)"country");
                String string2 = country;
                return Intrinsics.areEqual((Object)string2, (Object)"US") ? (CountryPostalFormat)US.INSTANCE : (Intrinsics.areEqual((Object)string2, (Object)"CA") ? (CountryPostalFormat)CA.INSTANCE : (CountryPostalFormat)Other.INSTANCE);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

