/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements.autocomplete.model;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RestrictTo;
import com.stripe.android.model.Address;
import com.stripe.android.ui.core.elements.autocomplete.model.Address;
import com.stripe.android.ui.core.elements.autocomplete.model.AddressComponent;
import com.stripe.android.ui.core.elements.autocomplete.model.AddressLine1;
import com.stripe.android.ui.core.elements.autocomplete.model.Place;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a,\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\f\u0010\u000f\u001a\u00020\u000b*\u00020\u000bH\u0000\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"STREET_NAME_FIRST_COUNTRIES", "", "", "getSTREET_NAME_FIRST_COUNTRIES", "()Ljava/util/List;", "composeAddressLine1", "context", "Landroid/content/Context;", "addressLine1", "Lcom/stripe/android/ui/core/elements/autocomplete/model/AddressLine1;", "address", "Lcom/stripe/android/ui/core/elements/autocomplete/model/Address;", "composeJapaneseAddressLine1", "localityComponent", "premiseComponent", "combineDependentLocalityWithLine2", "filter", "Lcom/stripe/android/ui/core/elements/autocomplete/model/AddressComponent;", "Lcom/stripe/android/ui/core/elements/autocomplete/model/Place;", "type", "Lcom/stripe/android/ui/core/elements/autocomplete/model/Place$Type;", "modifyStripeAddressByCountry", "place", "transformGoogleToStripeAddress", "Lcom/stripe/android/model/Address;", "payments-ui-core_release"})
public final class TransformGoogleToStripeAddressKt {
    @NotNull
    private static final List<String> STREET_NAME_FIRST_COUNTRIES;

    @NotNull
    public static final List<String> getSTREET_NAME_FIRST_COUNTRIES() {
        return STREET_NAME_FIRST_COUNTRIES;
    }

    @Nullable
    public static final AddressComponent filter(@NotNull Place $this$filter, @NotNull Place.Type type) {
        AddressComponent addressComponent;
        Intrinsics.checkNotNullParameter((Object)$this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List<AddressComponent> list = $this$filter.getAddressComponents();
        if (list != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    AddressComponent it = (AddressComponent)t;
                    boolean bl = false;
                    if (!it.getTypes().contains(type.getValue())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            addressComponent = v1;
        } else {
            addressComponent = null;
        }
        return addressComponent;
    }

    @NotNull
    public static final String composeAddressLine1(@NotNull Context context, @NotNull AddressLine1 addressLine1, @NotNull Address address) {
        String string2;
        String string3;
        String streetNumber;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)addressLine1, (String)"addressLine1");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String string4 = addressLine1.getStreetNumber();
        if (string4 == null) {
            string4 = streetNumber = "";
        }
        if ((string3 = addressLine1.getRoute()) == null) {
            string3 = "";
        }
        String streetName = string3;
        String locality = address.getLocality();
        String countryCode = address.getCountry();
        if (Intrinsics.areEqual((Object)countryCode, (Object)"JP")) {
            String premise = address.getAddressLine2();
            string2 = TransformGoogleToStripeAddressKt.composeJapaneseAddressLine1(context, addressLine1, locality, premise);
        } else {
            if (!StringsKt.isBlank((CharSequence)streetNumber) || !StringsKt.isBlank((CharSequence)streetName)) {
                return CollectionsKt.contains((Iterable)STREET_NAME_FIRST_COUNTRIES, (Object)countryCode) ? ((Object)StringsKt.trim((CharSequence)(streetName + ' ' + streetNumber))).toString() : ((Object)StringsKt.trim((CharSequence)(streetNumber + ' ' + streetName))).toString();
            }
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public static final String composeJapaneseAddressLine1(@NotNull Context context, @NotNull AddressLine1 addressLine1, @Nullable String localityComponent, @Nullable String premiseComponent) {
        Locale locale;
        String string2;
        String buildingNumber;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)addressLine1, (String)"addressLine1");
        boolean districtBlockNumberAllExist = addressLine1.getSubLocalityLevel2() != null && addressLine1.getSubLocalityLevel3() != null && addressLine1.getSubLocalityLevel4() != null;
        String district = addressLine1.getSubLocalityLevel3();
        String block = addressLine1.getSubLocalityLevel4();
        String string3 = premiseComponent;
        if (string3 == null) {
            string3 = buildingNumber = "";
        }
        if ((string2 = localityComponent) == null) {
            string2 = "";
        }
        String locality = string2;
        String municipality = addressLine1.getSubLocalityLevel2();
        String composite = null;
        Locale locale2 = locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
        if (Intrinsics.areEqual((Object)locale, (Object)Locale.JAPANESE)) {
            String districtBlockNumber = districtBlockNumberAllExist ? district + block + '-' + buildingNumber : "";
            composite = locality + municipality + districtBlockNumber;
        } else {
            String districtBlockNumber = districtBlockNumberAllExist ? district + '-' + block + '-' + buildingNumber : "";
            composite = districtBlockNumber + ' ' + municipality + ' ' + locality;
        }
        return composite;
    }

    @NotNull
    public static final Address combineDependentLocalityWithLine2(@NotNull Address $this$combineDependentLocalityWithLine2) {
        Intrinsics.checkNotNullParameter((Object)$this$combineDependentLocalityWithLine2, (String)"<this>");
        Address newAddress = Address.copy$default($this$combineDependentLocalityWithLine2, null, null, null, null, null, null, null, 127, null);
        if ($this$combineDependentLocalityWithLine2.getDependentLocality() != null) {
            newAddress.setAddressLine2($this$combineDependentLocalityWithLine2.getAddressLine2() != null ? $this$combineDependentLocalityWithLine2.getAddressLine2() + ", " + $this$combineDependentLocalityWithLine2.getDependentLocality() : $this$combineDependentLocalityWithLine2.getDependentLocality());
        }
        return newAddress;
    }

    @NotNull
    public static final Address modifyStripeAddressByCountry(@NotNull Address $this$modifyStripeAddressByCountry, @NotNull Place place) {
        Address newAddress;
        block30: {
            Intrinsics.checkNotNullParameter((Object)$this$modifyStripeAddressByCountry, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            AddressComponent addressComponent = TransformGoogleToStripeAddressKt.filter(place, Place.Type.ADMINISTRATIVE_AREA_LEVEL_2);
            String administrativeAreaLevel2 = addressComponent != null ? addressComponent.getShortName() : null;
            AddressComponent addressComponent2 = TransformGoogleToStripeAddressKt.filter(place, Place.Type.ADMINISTRATIVE_AREA_LEVEL_1);
            String administrativeAreaLevel1 = addressComponent2 != null ? addressComponent2.getLongName() : null;
            newAddress = Address.copy$default($this$modifyStripeAddressByCountry, null, null, null, null, null, null, null, 127, null);
            String string2 = $this$modifyStripeAddressByCountry.getCountry();
            if (string2 == null) break block30;
            int n = -1;
            switch (string2.hashCode()) {
                case 2128: {
                    if (string2.equals("BR")) {
                        n = 1;
                    }
                    break;
                }
                case 2374: {
                    if (string2.equals("JP")) {
                        n = 2;
                    }
                    break;
                }
                case 2855: {
                    if (string2.equals("ZA")) {
                        n = 3;
                    }
                    break;
                }
                case 2552: {
                    if (string2.equals("PH")) {
                        n = 3;
                    }
                    break;
                }
                case 2347: {
                    if (string2.equals("IT")) {
                        n = 4;
                    }
                    break;
                }
                case 2475: {
                    if (string2.equals("MX")) {
                        n = 3;
                    }
                    break;
                }
                case 2332: {
                    if (string2.equals("IE")) {
                        n = 5;
                    }
                    break;
                }
                case 2476: {
                    if (string2.equals("MY")) {
                        n = 3;
                    }
                    break;
                }
                case 2686: {
                    if (string2.equals("TR")) {
                        n = 1;
                    }
                    break;
                }
                case 2222: {
                    if (string2.equals("ES")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 5: {
                    if (administrativeAreaLevel1 == null) break;
                    newAddress.setAdministrativeArea(administrativeAreaLevel1);
                    newAddress = TransformGoogleToStripeAddressKt.combineDependentLocalityWithLine2(newAddress);
                    break;
                }
                case 2: {
                    newAddress.setAddressLine2(null);
                    break;
                }
                case 1: {
                    if ($this$modifyStripeAddressByCountry.getLocality() == null && administrativeAreaLevel2 != null) {
                        newAddress.setLocality(administrativeAreaLevel2);
                    }
                    newAddress = TransformGoogleToStripeAddressKt.combineDependentLocalityWithLine2(newAddress);
                    break;
                }
                case 4: {
                    if (administrativeAreaLevel2 == null) break;
                    newAddress.setAdministrativeArea(administrativeAreaLevel2);
                    break;
                }
                case 3: {
                    newAddress = TransformGoogleToStripeAddressKt.combineDependentLocalityWithLine2(newAddress);
                }
            }
        }
        return newAddress;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final com.stripe.android.model.Address transformGoogleToStripeAddress(@NotNull Place $this$transformGoogleToStripeAddress, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$transformGoogleToStripeAddress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Address address = null;
        address = new Address(null, null, null, null, null, null, null, 127, null);
        AddressLine1 addressLine1 = new AddressLine1(null, null, null, null, null, 31, null);
        List<AddressComponent> list = $this$transformGoogleToStripeAddress.getAddressComponents();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AddressComponent field = (AddressComponent)element$iv;
                boolean bl = false;
                String string2 = field.getTypes().get(0);
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.STREET_NUMBER.getValue())) {
                    addressLine1.setStreetNumber(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.ROUTE.getValue())) {
                    addressLine1.setRoute(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.PREMISE.getValue())) {
                    address.setAddressLine2(field.getLongName());
                    continue;
                }
                if ((Intrinsics.areEqual((Object)string2, (Object)Place.Type.LOCALITY.getValue()) ? true : Intrinsics.areEqual((Object)string2, (Object)Place.Type.SUBLOCALITY.getValue())) ? true : Intrinsics.areEqual((Object)string2, (Object)Place.Type.POSTAL_TOWN.getValue())) {
                    address.setLocality(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.ADMINISTRATIVE_AREA_LEVEL_1.getValue())) {
                    address.setAdministrativeArea(field.getShortName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.ADMINISTRATIVE_AREA_LEVEL_3.getValue())) {
                    if (address.getLocality() != null) continue;
                    address.setLocality(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.ADMINISTRATIVE_AREA_LEVEL_2.getValue())) {
                    if (address.getAdministrativeArea() == null && address.getDependentLocality() == null) {
                        address.setDependentLocality(field.getLongName());
                        continue;
                    }
                    address.setAdministrativeArea(field.getShortName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.NEIGHBORHOOD.getValue())) {
                    if (address.getLocality() == null) {
                        address.setLocality(field.getLongName());
                        continue;
                    }
                    address.setDependentLocality(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.POSTAL_CODE.getValue())) {
                    address.setPostalCode(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.COUNTRY.getValue())) {
                    address.setCountry(field.getShortName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.SUBLOCALITY_LEVEL_1.getValue())) {
                    if (address.getLocality() == null) {
                        address.setDependentLocality(field.getLongName());
                        continue;
                    }
                    address.setLocality(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.SUBLOCALITY_LEVEL_2.getValue())) {
                    addressLine1.setSubLocalityLevel2(field.getLongName());
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)Place.Type.SUBLOCALITY_LEVEL_3.getValue())) {
                    addressLine1.setSubLocalityLevel3(field.getLongName());
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)Place.Type.SUBLOCALITY_LEVEL_4.getValue())) continue;
                addressLine1.setSubLocalityLevel4(field.getLongName());
            }
        }
        address.setAddressLine1(TransformGoogleToStripeAddressKt.composeAddressLine1(context, addressLine1, address));
        address = TransformGoogleToStripeAddressKt.modifyStripeAddressByCountry(address, $this$transformGoogleToStripeAddress);
        return new Address.Builder().setLine1(address.getAddressLine1()).setLine2(address.getAddressLine2()).setCity(address.getLocality()).setState(address.getAdministrativeArea()).setCountry(address.getCountry()).setPostalCode(address.getPostalCode()).build();
    }

    static {
        Object[] objectArray = new String[]{"BE", "BR", "CH", "ES", "ID", "IT", "MX", "NL", "NO", "PL", "RU", "SE"};
        STREET_NAME_FIRST_COUNTRIES = CollectionsKt.listOf((Object[])objectArray);
    }
}

