/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.forms.resources;

import android.content.res.Resources;
import androidx.annotation.DrawableRes;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.LuxePostConfirmActionRepository;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.payments.financialconnections.DefaultIsFinancialConnectionsAvailable;
import com.stripe.android.payments.financialconnections.IsFinancialConnectionsAvailable;
import com.stripe.android.paymentsheet.forms.PaymentMethodRequirements;
import com.stripe.android.paymentsheet.forms.PaymentMethodRequirementsKt;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.elements.AfterpayClearpayHeaderElement;
import com.stripe.android.ui.core.elements.CardBillingSpec;
import com.stripe.android.ui.core.elements.CardDetailsSectionSpec;
import com.stripe.android.ui.core.elements.EmptyFormSpec;
import com.stripe.android.ui.core.elements.FormItemSpec;
import com.stripe.android.ui.core.elements.LayoutSpec;
import com.stripe.android.ui.core.elements.LpmSerializer;
import com.stripe.android.ui.core.elements.NextActionSpecKt;
import com.stripe.android.ui.core.elements.SaveForFutureUseSpec;
import com.stripe.android.ui.core.elements.SharedDataSpec;
import com.stripe.android.ui.core.forms.resources.LpmRepository;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0002\b\u0007\b\u0007\u0018\u0000 /2\u00020\u0001:\u0005/0123B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0007J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u001e\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001fJ\u0014\u0010 \u001a\u0004\u0018\u00010\u001b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J*\u0010#\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020%J\u001a\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001aH\u0002J\u0018\u0010)\u001a\u00020\u00182\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001aH\u0002J \u0010)\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0007J\b\u0010+\u001a\u00020\u0018H\u0007J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140-J\u0006\u0010.\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u00064"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository;", "", "arguments", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmRepositoryArguments;", "lpmInitialFormData", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmInitialFormData;", "lpmPostConfirmData", "Lcom/stripe/android/model/LuxePostConfirmActionRepository;", "(Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmRepositoryArguments;Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmInitialFormData;Lcom/stripe/android/model/LuxePostConfirmActionRepository;)V", "lpmSerializer", "Lcom/stripe/android/ui/core/elements/LpmSerializer;", "serverInitializedLatch", "Ljava/util/concurrent/CountDownLatch;", "serverSpecLoadingState", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;", "getServerSpecLoadingState", "()Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;", "setServerSpecLoadingState", "(Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;)V", "convertToSupportedPaymentMethod", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$SupportedPaymentMethod;", "sharedDataSpec", "Lcom/stripe/android/ui/core/elements/SharedDataSpec;", "forceUpdate", "", "expectedLpms", "", "", "serverLpmSpecs", "fromCode", "code", "Lcom/stripe/android/model/PaymentMethodCode;", "getJsonStringFromInputStream", "inputStream", "Ljava/io/InputStream;", "internalUpdate", "force", "", "isLoaded", "parseLpms", "readFromDisk", "update", "lpms", "updateFromDisk", "values", "", "waitUntilLoaded", "Companion", "LpmInitialFormData", "LpmRepositoryArguments", "ServerSpecState", "SupportedPaymentMethod", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class LpmRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LpmRepositoryArguments arguments;
    @NotNull
    private final LpmInitialFormData lpmInitialFormData;
    @NotNull
    private final LuxePostConfirmActionRepository lpmPostConfirmData;
    @NotNull
    private final LpmSerializer lpmSerializer;
    @NotNull
    private final CountDownLatch serverInitializedLatch;
    @NotNull
    private ServerSpecState serverSpecLoadingState;
    public static final int $stable = 8;
    @Nullable
    private static volatile LpmRepository INSTANCE;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private static final SupportedPaymentMethod HardcodedCard;
    @NotNull
    private static final Lazy<List<String>> exposedPaymentMethods$delegate;

    public LpmRepository(@NotNull LpmRepositoryArguments arguments, @NotNull LpmInitialFormData lpmInitialFormData, @NotNull LuxePostConfirmActionRepository lpmPostConfirmData) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)lpmInitialFormData, (String)"lpmInitialFormData");
        Intrinsics.checkNotNullParameter((Object)lpmPostConfirmData, (String)"lpmPostConfirmData");
        this.arguments = arguments;
        this.lpmInitialFormData = lpmInitialFormData;
        this.lpmPostConfirmData = lpmPostConfirmData;
        this.lpmSerializer = new LpmSerializer();
        this.serverInitializedLatch = new CountDownLatch(1);
        this.serverSpecLoadingState = ServerSpecState.Uninitialized.INSTANCE;
    }

    public /* synthetic */ LpmRepository(LpmRepositoryArguments lpmRepositoryArguments, LpmInitialFormData lpmInitialFormData, LuxePostConfirmActionRepository luxePostConfirmActionRepository, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lpmInitialFormData = LpmInitialFormData.Companion.getInstance();
        }
        if ((n & 4) != 0) {
            luxePostConfirmActionRepository = LuxePostConfirmActionRepository.Companion.getInstance();
        }
        this(lpmRepositoryArguments, lpmInitialFormData, luxePostConfirmActionRepository);
    }

    @NotNull
    public final ServerSpecState getServerSpecLoadingState() {
        return this.serverSpecLoadingState;
    }

    public final void setServerSpecLoadingState(@NotNull ServerSpecState serverSpecState) {
        Intrinsics.checkNotNullParameter((Object)serverSpecState, (String)"<set-?>");
        this.serverSpecLoadingState = serverSpecState;
    }

    public final boolean isLoaded() {
        return this.serverInitializedLatch.getCount() <= 0L;
    }

    @Nullable
    public final SupportedPaymentMethod fromCode(@Nullable String code) {
        return this.lpmInitialFormData.fromCode(code);
    }

    @NotNull
    public final Collection<SupportedPaymentMethod> values() {
        return this.lpmInitialFormData.values();
    }

    public final void waitUntilLoaded() {
        this.serverInitializedLatch.await(20L, TimeUnit.SECONDS);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void update(@NotNull List<String> expectedLpms, @Nullable String serverLpmSpecs) {
        Intrinsics.checkNotNullParameter(expectedLpms, (String)"expectedLpms");
        this.internalUpdate(expectedLpms, serverLpmSpecs, false);
    }

    @VisibleForTesting
    public final void forceUpdate(@NotNull List<String> expectedLpms, @Nullable String serverLpmSpecs) {
        Intrinsics.checkNotNullParameter(expectedLpms, (String)"expectedLpms");
        this.internalUpdate(expectedLpms, serverLpmSpecs, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void internalUpdate(List<String> expectedLpms, String serverLpmSpecs, boolean force) {
        boolean newSpecsToLoad;
        Object v0;
        Object element$iv;
        Object $this$firstOrNull$iv;
        block15: {
            $this$firstOrNull$iv = expectedLpms;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!this.lpmInitialFormData.containsKey(it))) continue;
                v0 = element$iv;
                break block15;
            }
            v0 = null;
        }
        boolean bl = newSpecsToLoad = v0 != null;
        if (!this.isLoaded() || force || newSpecsToLoad) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            this.serverSpecLoadingState = new ServerSpecState.NoServerSpec(serverLpmSpecs);
            $this$firstOrNull$iv = serverLpmSpecs;
            if (!($this$firstOrNull$iv == null || $this$firstOrNull$iv.length() == 0)) {
                this.serverSpecLoadingState = new ServerSpecState.ServerNotParsed(serverLpmSpecs);
                List<SharedDataSpec> serverLpmObjects = this.lpmSerializer.deserializeList(serverLpmSpecs);
                if (!((Collection)serverLpmObjects).isEmpty()) {
                    this.serverSpecLoadingState = new ServerSpecState.ServerParsed(serverLpmSpecs);
                }
                this.update(serverLpmObjects);
            }
            Iterable $i$f$firstOrNull = expectedLpms;
            boolean $i$f$filter2 = false;
            element$iv = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv2;
                boolean bl2 = false;
                if (!(!this.lpmInitialFormData.containsKey(it))) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List lpmsNotParsedFromServerSpec = (List)destination$iv$iv;
            if (!((Collection)lpmsNotParsedFromServerSpec).isEmpty()) {
                Map map2;
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                boolean bl3;
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Map map3;
                void $this$filterKeys$iv;
                Object object;
                Object element$iv$iv;
                Iterable<SharedDataSpec> $i$f$filter2 = this.readFromDisk();
                if ($i$f$filter2 != null) {
                    Iterator $this$associateByTo$iv$iv2;
                    Map $this$associateBy$iv2;
                    Object element$iv$iv2;
                    destination$iv$iv = $i$f$filter2;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv2), (int)10)), (int)16);
                    element$iv$iv2 = $this$associateBy$iv2;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    Iterator iterator = $this$associateByTo$iv$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        element$iv$iv = iterator.next();
                        SharedDataSpec sharedDataSpec = (SharedDataSpec)element$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl4 = false;
                        object.put(it.getType(), element$iv$iv);
                    }
                    $this$associateBy$iv2 = destination$iv$iv2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl5 = false;
                        if (!expectedLpms.contains(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map3 = result$iv;
                } else {
                    map3 = null;
                }
                Map mapFromDisk = map3;
                $i$f$filter2 = lpmsNotParsedFromServerSpec;
                object = this.lpmInitialFormData;
                boolean $i$f$mapNotNull = false;
                $this$filterKeys$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl6 = false;
                    String it2 = (String)element$iv$iv;
                    boolean bl7 = false;
                    Map map4 = mapFromDisk;
                    if ((map4 != null ? (SharedDataSpec)map4.get(it2) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    bl3 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv3;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv3 = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl8 = false;
                    SharedDataSpec it3 = (SharedDataSpec)element$iv$iv;
                    boolean bl9 = false;
                    if (this.convertToSupportedPaymentMethod(it3) == null) continue;
                    bl3 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv3;
                boolean $i$f$associateBy2 = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv3 = $this$associateBy$iv;
                Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv3 : $this$associateByTo$iv$iv) {
                    void it4;
                    element$iv$iv$iv = (SupportedPaymentMethod)element$iv$iv3;
                    map2 = destination$iv$iv4;
                    boolean bl10 = false;
                    map2.put(it4.getCode(), element$iv$iv3);
                }
                ((LpmInitialFormData)object).putAll(destination$iv$iv4);
                if (mapFromDisk != null) {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Map $i$f$associateBy2 = mapFromDisk;
                    boolean $i$f$mapValues = false;
                    $this$associateByTo$iv$iv = $this$mapValues$iv;
                    destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
                        void it5;
                        void it$iv$iv2;
                        Map.Entry bl8 = (Map.Entry)element$iv$iv$iv2;
                        Map map5 = destination$iv$iv4;
                        boolean bl11 = false;
                        it$iv$iv = (Map.Entry)element$iv$iv$iv2;
                        map2 = it$iv$iv2.getKey();
                        object = map5;
                        boolean bl12 = false;
                        LuxePostConfirmActionRepository.LuxeAction luxeAction = NextActionSpecKt.transform(((SharedDataSpec)it5.getValue()).getNextActionSpec());
                        object.put(map2, luxeAction);
                    }
                    Map it6 = destination$iv$iv4;
                    boolean bl13 = false;
                    this.lpmPostConfirmData.update(it6);
                }
            }
            this.serverInitializedLatch.countDown();
        }
    }

    static /* synthetic */ void internalUpdate$default(LpmRepository lpmRepository, List list, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        lpmRepository.internalUpdate(list, string2, bl);
    }

    @VisibleForTesting
    public final void updateFromDisk() {
        this.update(this.readFromDisk());
    }

    private final List<SharedDataSpec> readFromDisk() {
        Resources resources = this.arguments.getResources();
        return this.parseLpms(resources != null && (resources = resources.getAssets()) != null ? resources.open("lpms.json") : null);
    }

    /*
     * WARNING - void declaration
     */
    private final void update(List<SharedDataSpec> lpms) {
        block9: {
            void $this$associateTo$iv$iv;
            List parsedSharedData;
            List list;
            Iterable $this$filterNotTo$iv$iv;
            Object it;
            Collection destination$iv$iv;
            if (lpms != null) {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = lpms;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SharedDataSpec)element$iv$iv;
                    boolean bl = false;
                    if (!Companion.getExposedPaymentMethods().contains(((SharedDataSpec)it).getType())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$filterNot = false;
                $this$filterTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (SharedDataSpec)element$iv$iv;
                    boolean bl = false;
                    if (!this.arguments.isFinancialConnectionsAvailable().invoke() && Intrinsics.areEqual((Object)((SharedDataSpec)it).getType(), (Object)PaymentMethod.Type.USBankAccount.code)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = parsedSharedData = null;
            }
            if (parsedSharedData != null) {
                SupportedPaymentMethod it$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = parsedSharedData;
                boolean $i$f$mapNotNull = false;
                $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                LpmInitialFormData $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    SharedDataSpec it2 = (SharedDataSpec)element$iv$iv;
                    boolean bl2 = false;
                    if (this.convertToSupportedPaymentMethod(it2) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                if ($this$mapNotNull$iv != null) {
                    void $this$associateByTo$iv$iv;
                    void $this$associateBy$iv;
                    Iterable it3 = $this$mapNotNull$iv;
                    boolean bl = false;
                    Iterable $i$f$mapNotNullTo2 = it3;
                    $this$forEach$iv$iv$iv = this.lpmInitialFormData;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    void element$iv$iv$iv = $this$associateBy$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it4;
                        it$iv$iv = (SupportedPaymentMethod)element$iv$iv;
                        Map map2 = destination$iv$iv2;
                        boolean bl4 = false;
                        map2.put(it4.getCode(), element$iv$iv);
                    }
                    $this$forEach$iv$iv$iv.putAll(destination$iv$iv2);
                }
            }
            if (parsedSharedData == null) break block9;
            Iterable $this$associate$iv = parsedSharedData;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable bl = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv3;
                SharedDataSpec it5 = (SharedDataSpec)element$iv$iv;
                boolean bl5 = false;
                Pair pair = TuplesKt.to((Object)it5.getType(), (Object)NextActionSpecKt.transform(it5.getNextActionSpec()));
                map3.put(pair.getFirst(), pair.getSecond());
            }
            Map it6 = destination$iv$iv3;
            boolean bl6 = false;
            this.lpmPostConfirmData.update(it6);
        }
    }

    private final List<SharedDataSpec> parseLpms(InputStream inputStream) {
        List<SharedDataSpec> list;
        String string2 = this.getJsonStringFromInputStream(inputStream);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            list = this.lpmSerializer.deserializeList(string3);
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getJsonStringFromInputStream(InputStream inputStream) {
        BufferedReader bufferedReader;
        Object object;
        Object object2;
        Closeable closeable;
        InputStream inputStream2 = inputStream;
        if (inputStream2 != null) {
            closeable = inputStream2;
            object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)closeable, (Charset)object2);
            int n = 8192;
            bufferedReader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        } else {
            bufferedReader = null;
        }
        closeable = bufferedReader;
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            BufferedReader bufferedReader2 = it;
            object = bufferedReader2 != null ? TextStreamsKt.readText((Reader)bufferedReader2) : null;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        return object;
    }

    private final SupportedPaymentMethod convertToSupportedPaymentMethod(SharedDataSpec sharedDataSpec) {
        String string2 = sharedDataSpec.getType();
        return Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Card.code) ? new SupportedPaymentMethod("card", false, R.string.stripe_paymentsheet_payment_method_card, R.drawable.stripe_ic_paymentsheet_pm_card, true, PaymentMethodRequirementsKt.getCardRequirement(), sharedDataSpec.getFields().isEmpty() || Intrinsics.areEqual(sharedDataSpec.getFields(), (Object)CollectionsKt.listOf((Object)EmptyFormSpec.INSTANCE)) ? HardcodedCard.getFormSpec() : new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Bancontact.code) ? new SupportedPaymentMethod("bancontact", true, R.string.stripe_paymentsheet_payment_method_bancontact, R.drawable.stripe_ic_paymentsheet_pm_bancontact, false, PaymentMethodRequirementsKt.getBancontactRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Sofort.code) ? new SupportedPaymentMethod("sofort", true, R.string.stripe_paymentsheet_payment_method_sofort, R.drawable.stripe_ic_paymentsheet_pm_klarna, false, PaymentMethodRequirementsKt.getSofortRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Ideal.code) ? new SupportedPaymentMethod("ideal", true, R.string.stripe_paymentsheet_payment_method_ideal, R.drawable.stripe_ic_paymentsheet_pm_ideal, false, PaymentMethodRequirementsKt.getIdealRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.SepaDebit.code) ? new SupportedPaymentMethod("sepa_debit", true, R.string.stripe_paymentsheet_payment_method_sepa_debit, R.drawable.stripe_ic_paymentsheet_pm_sepa_debit, false, PaymentMethodRequirementsKt.getSepaDebitRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Eps.code) ? new SupportedPaymentMethod("eps", true, R.string.stripe_paymentsheet_payment_method_eps, R.drawable.stripe_ic_paymentsheet_pm_eps, false, PaymentMethodRequirementsKt.getEpsRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.P24.code) ? new SupportedPaymentMethod("p24", false, R.string.stripe_paymentsheet_payment_method_p24, R.drawable.stripe_ic_paymentsheet_pm_p24, false, PaymentMethodRequirementsKt.getP24Requirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Giropay.code) ? new SupportedPaymentMethod("giropay", false, R.string.stripe_paymentsheet_payment_method_giropay, R.drawable.stripe_ic_paymentsheet_pm_giropay, false, PaymentMethodRequirementsKt.getGiropayRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.AfterpayClearpay.code) ? new SupportedPaymentMethod("afterpay_clearpay", false, AfterpayClearpayHeaderElement.Companion.isClearpay$payments_ui_core_release() ? R.string.stripe_paymentsheet_payment_method_clearpay : R.string.stripe_paymentsheet_payment_method_afterpay, R.drawable.stripe_ic_paymentsheet_pm_afterpay_clearpay, false, PaymentMethodRequirementsKt.getAfterpayClearpayRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Klarna.code) ? new SupportedPaymentMethod("klarna", false, R.string.stripe_paymentsheet_payment_method_klarna, R.drawable.stripe_ic_paymentsheet_pm_klarna, false, PaymentMethodRequirementsKt.getKlarnaRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.PayPal.code) ? new SupportedPaymentMethod("paypal", false, R.string.stripe_paymentsheet_payment_method_paypal, R.drawable.stripe_ic_paymentsheet_pm_paypal, false, PaymentMethodRequirementsKt.getPaypalRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.Affirm.code) ? new SupportedPaymentMethod("affirm", false, R.string.stripe_paymentsheet_payment_method_affirm, R.drawable.stripe_ic_paymentsheet_pm_affirm, false, PaymentMethodRequirementsKt.getAffirmRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.AuBecsDebit.code) ? new SupportedPaymentMethod("au_becs_debit", true, R.string.stripe_paymentsheet_payment_method_au_becs_debit, R.drawable.stripe_ic_paymentsheet_pm_bank, true, PaymentMethodRequirementsKt.getAuBecsDebitRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : (Intrinsics.areEqual((Object)string2, (Object)PaymentMethod.Type.USBankAccount.code) ? new SupportedPaymentMethod("us_bank_account", true, R.string.stripe_paymentsheet_payment_method_us_bank_account, R.drawable.stripe_ic_paymentsheet_pm_bank, true, PaymentMethodRequirementsKt.getUSBankAccountRequirement(), new LayoutSpec((List<? extends FormItemSpec>)sharedDataSpec.getFields())) : null)))))))))))));
    }

    static {
        Object[] objectArray = new FormItemSpec[]{new CardDetailsSectionSpec(null, 1, null), new CardBillingSpec(null, null, 3, null), new SaveForFutureUseSpec(null, 1, null)};
        HardcodedCard = new SupportedPaymentMethod("card", false, R.string.stripe_paymentsheet_payment_method_card, R.drawable.stripe_ic_paymentsheet_pm_card, true, PaymentMethodRequirementsKt.getCardRequirement(), new LayoutSpec(CollectionsKt.listOf((Object[])objectArray)));
        exposedPaymentMethods$delegate = LazyKt.lazy((Function0)Companion.exposedPaymentMethods.2.INSTANCE);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0087\b\u0018\u00002\u00020\u0001BE\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u001c\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J\t\u0010\"\u001a\u00020\u000eH\u00c6\u0003JS\u0010#\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0003\u0010\u0007\u001a\u00020\b2\b\b\u0003\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\bH\u00d6\u0001J\u0006\u0010'\u001a\u00020\u0006J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$SupportedPaymentMethod;", "", "code", "", "Lcom/stripe/android/model/PaymentMethodCode;", "requiresMandate", "", "displayNameResource", "", "iconResource", "tintIconOnSelection", "requirement", "Lcom/stripe/android/paymentsheet/forms/PaymentMethodRequirements;", "formSpec", "Lcom/stripe/android/ui/core/elements/LayoutSpec;", "(Ljava/lang/String;ZIIZLcom/stripe/android/paymentsheet/forms/PaymentMethodRequirements;Lcom/stripe/android/ui/core/elements/LayoutSpec;)V", "getCode", "()Ljava/lang/String;", "getDisplayNameResource", "()I", "getFormSpec", "()Lcom/stripe/android/ui/core/elements/LayoutSpec;", "getIconResource", "getRequirement", "()Lcom/stripe/android/paymentsheet/forms/PaymentMethodRequirements;", "getRequiresMandate", "()Z", "getTintIconOnSelection", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "supportsCustomerSavedPM", "toString", "payments-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @StabilityInferred(parameters=0)
    public static final class SupportedPaymentMethod {
        @NotNull
        private final String code;
        private final boolean requiresMandate;
        private final int displayNameResource;
        private final int iconResource;
        private final boolean tintIconOnSelection;
        @NotNull
        private final PaymentMethodRequirements requirement;
        @NotNull
        private final LayoutSpec formSpec;
        public static final int $stable = 8;

        public SupportedPaymentMethod(@NotNull String code, boolean requiresMandate, @StringRes int displayNameResource, @DrawableRes int iconResource, boolean tintIconOnSelection, @NotNull PaymentMethodRequirements requirement, @NotNull LayoutSpec formSpec) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
            Intrinsics.checkNotNullParameter((Object)formSpec, (String)"formSpec");
            this.code = code;
            this.requiresMandate = requiresMandate;
            this.displayNameResource = displayNameResource;
            this.iconResource = iconResource;
            this.tintIconOnSelection = tintIconOnSelection;
            this.requirement = requirement;
            this.formSpec = formSpec;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public final boolean getRequiresMandate() {
            return this.requiresMandate;
        }

        public final int getDisplayNameResource() {
            return this.displayNameResource;
        }

        public final int getIconResource() {
            return this.iconResource;
        }

        public final boolean getTintIconOnSelection() {
            return this.tintIconOnSelection;
        }

        @NotNull
        public final PaymentMethodRequirements getRequirement() {
            return this.requirement;
        }

        @NotNull
        public final LayoutSpec getFormSpec() {
            return this.formSpec;
        }

        public final boolean supportsCustomerSavedPM() {
            return this.requirement.getConfirmPMFromCustomer(this.code);
        }

        @NotNull
        public final String component1() {
            return this.code;
        }

        public final boolean component2() {
            return this.requiresMandate;
        }

        public final int component3() {
            return this.displayNameResource;
        }

        public final int component4() {
            return this.iconResource;
        }

        public final boolean component5() {
            return this.tintIconOnSelection;
        }

        @NotNull
        public final PaymentMethodRequirements component6() {
            return this.requirement;
        }

        @NotNull
        public final LayoutSpec component7() {
            return this.formSpec;
        }

        @NotNull
        public final SupportedPaymentMethod copy(@NotNull String code, boolean requiresMandate, @StringRes int displayNameResource, @DrawableRes int iconResource, boolean tintIconOnSelection, @NotNull PaymentMethodRequirements requirement, @NotNull LayoutSpec formSpec) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
            Intrinsics.checkNotNullParameter((Object)formSpec, (String)"formSpec");
            return new SupportedPaymentMethod(code, requiresMandate, displayNameResource, iconResource, tintIconOnSelection, requirement, formSpec);
        }

        public static /* synthetic */ SupportedPaymentMethod copy$default(SupportedPaymentMethod supportedPaymentMethod, String string2, boolean bl, int n, int n2, boolean bl2, PaymentMethodRequirements paymentMethodRequirements, LayoutSpec layoutSpec, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string2 = supportedPaymentMethod.code;
            }
            if ((n3 & 2) != 0) {
                bl = supportedPaymentMethod.requiresMandate;
            }
            if ((n3 & 4) != 0) {
                n = supportedPaymentMethod.displayNameResource;
            }
            if ((n3 & 8) != 0) {
                n2 = supportedPaymentMethod.iconResource;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = supportedPaymentMethod.tintIconOnSelection;
            }
            if ((n3 & 0x20) != 0) {
                paymentMethodRequirements = supportedPaymentMethod.requirement;
            }
            if ((n3 & 0x40) != 0) {
                layoutSpec = supportedPaymentMethod.formSpec;
            }
            return supportedPaymentMethod.copy(string2, bl, n, n2, bl2, paymentMethodRequirements, layoutSpec);
        }

        @NotNull
        public String toString() {
            return "SupportedPaymentMethod(code=" + this.code + ", requiresMandate=" + this.requiresMandate + ", displayNameResource=" + this.displayNameResource + ", iconResource=" + this.iconResource + ", tintIconOnSelection=" + this.tintIconOnSelection + ", requirement=" + this.requirement + ", formSpec=" + this.formSpec + ')';
        }

        public int hashCode() {
            int result = this.code.hashCode();
            int n = this.requiresMandate ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + Integer.hashCode(this.displayNameResource);
            result = result * 31 + Integer.hashCode(this.iconResource);
            int n2 = this.tintIconOnSelection ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.requirement.hashCode();
            result = result * 31 + this.formSpec.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SupportedPaymentMethod)) {
                return false;
            }
            SupportedPaymentMethod supportedPaymentMethod = (SupportedPaymentMethod)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)supportedPaymentMethod.code)) {
                return false;
            }
            if (this.requiresMandate != supportedPaymentMethod.requiresMandate) {
                return false;
            }
            if (this.displayNameResource != supportedPaymentMethod.displayNameResource) {
                return false;
            }
            if (this.iconResource != supportedPaymentMethod.iconResource) {
                return false;
            }
            if (this.tintIconOnSelection != supportedPaymentMethod.tintIconOnSelection) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requirement, (Object)supportedPaymentMethod.requirement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.formSpec, (Object)supportedPaymentMethod.formSpec);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0010\u0012\u0004\u0012\u00020\u00060\u000fJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmInitialFormData;", "", "()V", "codeToSupportedPaymentMethod", "", "", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$SupportedPaymentMethod;", "containsKey", "", "it", "fromCode", "code", "putAll", "", "map", "", "Lcom/stripe/android/model/PaymentMethodCode;", "values", "", "Companion", "payments-ui-core_release"})
    @VisibleForTesting(otherwise=4)
    @StabilityInferred(parameters=0)
    public static final class LpmInitialFormData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private Map<String, SupportedPaymentMethod> codeToSupportedPaymentMethod = new LinkedHashMap();
        public static final int $stable = 8;
        @NotNull
        private static final LpmInitialFormData Instance = new LpmInitialFormData();

        @NotNull
        public final Collection<SupportedPaymentMethod> values() {
            return this.codeToSupportedPaymentMethod.values();
        }

        @Nullable
        public final SupportedPaymentMethod fromCode(@Nullable String code) {
            SupportedPaymentMethod supportedPaymentMethod;
            String string2 = code;
            if (string2 != null) {
                String paymentMethodCode = string2;
                boolean bl = false;
                supportedPaymentMethod = this.codeToSupportedPaymentMethod.get(paymentMethodCode);
            } else {
                supportedPaymentMethod = null;
            }
            return supportedPaymentMethod;
        }

        public final boolean containsKey(@NotNull String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this.codeToSupportedPaymentMethod.containsKey(it);
        }

        public final void putAll(@NotNull Map<String, SupportedPaymentMethod> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            this.codeToSupportedPaymentMethod.putAll(map2);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmInitialFormData$Companion;", "", "()V", "Instance", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmInitialFormData;", "getInstance", "()Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmInitialFormData;", "payments-ui-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LpmInitialFormData getInstance() {
                return Instance;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$Companion;", "", "()V", "HardcodedCard", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$SupportedPaymentMethod;", "getHardcodedCard", "()Lcom/stripe/android/ui/core/forms/resources/LpmRepository$SupportedPaymentMethod;", "INSTANCE", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository;", "exposedPaymentMethods", "", "", "getExposedPaymentMethods", "()Ljava/util/List;", "exposedPaymentMethods$delegate", "Lkotlin/Lazy;", "getInstance", "args", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmRepositoryArguments;", "payments-ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final LpmRepository getInstance(@NotNull LpmRepositoryArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            LpmRepository lpmRepository = INSTANCE;
            if (lpmRepository == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    LpmRepository lpmRepository2 = INSTANCE;
                    if (lpmRepository2 == null) {
                        LpmRepository lpmRepository3;
                        LpmRepository it = lpmRepository3 = new LpmRepository(args, null, null, 6, null);
                        boolean bl2 = false;
                        INSTANCE = it;
                        lpmRepository2 = lpmRepository3;
                    }
                    LpmRepository lpmRepository4 = lpmRepository2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                    lpmRepository = lpmRepository4;
                }
            }
            return lpmRepository;
        }

        @NotNull
        public final SupportedPaymentMethod getHardcodedCard() {
            return HardcodedCard;
        }

        @NotNull
        public final List<String> getExposedPaymentMethods() {
            Lazy lazy = exposedPaymentMethods$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;", "", "serverLpmSpecs", "", "(Ljava/lang/String;)V", "getServerLpmSpecs", "()Ljava/lang/String;", "NoServerSpec", "ServerNotParsed", "ServerParsed", "Uninitialized", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$NoServerSpec;", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$ServerNotParsed;", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$ServerParsed;", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$Uninitialized;", "payments-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @StabilityInferred(parameters=0)
    public static abstract class ServerSpecState {
        @Nullable
        private final String serverLpmSpecs;
        public static final int $stable;

        private ServerSpecState(String serverLpmSpecs) {
            this.serverLpmSpecs = serverLpmSpecs;
        }

        @Nullable
        public final String getServerLpmSpecs() {
            return this.serverLpmSpecs;
        }

        public /* synthetic */ ServerSpecState(String serverLpmSpecs, DefaultConstructorMarker $constructor_marker) {
            this(serverLpmSpecs);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$Uninitialized;", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;", "()V", "payments-ui-core_release"})
        @StabilityInferred(parameters=0)
        public static final class Uninitialized
        extends ServerSpecState {
            @NotNull
            public static final Uninitialized INSTANCE = new Uninitialized();
            public static final int $stable;

            private Uninitialized() {
                super(null, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$NoServerSpec;", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;", "serverLpmSpecs", "", "(Ljava/lang/String;)V", "payments-ui-core_release"})
        @StabilityInferred(parameters=0)
        public static final class NoServerSpec
        extends ServerSpecState {
            public static final int $stable;

            public NoServerSpec(@Nullable String serverLpmSpecs) {
                super(serverLpmSpecs, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$ServerParsed;", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;", "serverLpmSpecs", "", "(Ljava/lang/String;)V", "payments-ui-core_release"})
        @StabilityInferred(parameters=0)
        public static final class ServerParsed
        extends ServerSpecState {
            public static final int $stable;

            public ServerParsed(@Nullable String serverLpmSpecs) {
                super(serverLpmSpecs, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState$ServerNotParsed;", "Lcom/stripe/android/ui/core/forms/resources/LpmRepository$ServerSpecState;", "serverLpmSpecs", "", "(Ljava/lang/String;)V", "payments-ui-core_release"})
        @StabilityInferred(parameters=0)
        public static final class ServerNotParsed
        extends ServerSpecState {
            public static final int $stable;

            public ServerNotParsed(@Nullable String serverLpmSpecs) {
                super(serverLpmSpecs, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/ui/core/forms/resources/LpmRepository$LpmRepositoryArguments;", "", "resources", "Landroid/content/res/Resources;", "isFinancialConnectionsAvailable", "Lcom/stripe/android/payments/financialconnections/IsFinancialConnectionsAvailable;", "(Landroid/content/res/Resources;Lcom/stripe/android/payments/financialconnections/IsFinancialConnectionsAvailable;)V", "()Lcom/stripe/android/payments/financialconnections/IsFinancialConnectionsAvailable;", "getResources", "()Landroid/content/res/Resources;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "payments-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @StabilityInferred(parameters=0)
    public static final class LpmRepositoryArguments {
        @Nullable
        private final Resources resources;
        @NotNull
        private final IsFinancialConnectionsAvailable isFinancialConnectionsAvailable;
        public static final int $stable = 8;

        public LpmRepositoryArguments(@Nullable Resources resources, @NotNull IsFinancialConnectionsAvailable isFinancialConnectionsAvailable) {
            Intrinsics.checkNotNullParameter((Object)isFinancialConnectionsAvailable, (String)"isFinancialConnectionsAvailable");
            this.resources = resources;
            this.isFinancialConnectionsAvailable = isFinancialConnectionsAvailable;
        }

        public /* synthetic */ LpmRepositoryArguments(Resources resources, IsFinancialConnectionsAvailable isFinancialConnectionsAvailable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                isFinancialConnectionsAvailable = (IsFinancialConnectionsAvailable)new DefaultIsFinancialConnectionsAvailable();
            }
            this(resources, isFinancialConnectionsAvailable);
        }

        @Nullable
        public final Resources getResources() {
            return this.resources;
        }

        @NotNull
        public final IsFinancialConnectionsAvailable isFinancialConnectionsAvailable() {
            return this.isFinancialConnectionsAvailable;
        }

        @Nullable
        public final Resources component1() {
            return this.resources;
        }

        @NotNull
        public final IsFinancialConnectionsAvailable component2() {
            return this.isFinancialConnectionsAvailable;
        }

        @NotNull
        public final LpmRepositoryArguments copy(@Nullable Resources resources, @NotNull IsFinancialConnectionsAvailable isFinancialConnectionsAvailable) {
            Intrinsics.checkNotNullParameter((Object)isFinancialConnectionsAvailable, (String)"isFinancialConnectionsAvailable");
            return new LpmRepositoryArguments(resources, isFinancialConnectionsAvailable);
        }

        public static /* synthetic */ LpmRepositoryArguments copy$default(LpmRepositoryArguments lpmRepositoryArguments, Resources resources, IsFinancialConnectionsAvailable isFinancialConnectionsAvailable, int n, Object object) {
            if ((n & 1) != 0) {
                resources = lpmRepositoryArguments.resources;
            }
            if ((n & 2) != 0) {
                isFinancialConnectionsAvailable = lpmRepositoryArguments.isFinancialConnectionsAvailable;
            }
            return lpmRepositoryArguments.copy(resources, isFinancialConnectionsAvailable);
        }

        @NotNull
        public String toString() {
            return "LpmRepositoryArguments(resources=" + this.resources + ", isFinancialConnectionsAvailable=" + this.isFinancialConnectionsAvailable + ')';
        }

        public int hashCode() {
            int result = this.resources == null ? 0 : this.resources.hashCode();
            result = result * 31 + this.isFinancialConnectionsAvailable.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LpmRepositoryArguments)) {
                return false;
            }
            LpmRepositoryArguments lpmRepositoryArguments = (LpmRepositoryArguments)other;
            if (!Intrinsics.areEqual((Object)this.resources, (Object)lpmRepositoryArguments.resources)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isFinancialConnectionsAvailable, (Object)lpmRepositoryArguments.isFinancialConnectionsAvailable);
        }
    }
}

