/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.address;

import android.content.res.AssetManager;
import android.content.res.Resources;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.address.CountryAddressSchema;
import com.stripe.android.ui.core.address.TransformAddressToElementKt;
import com.stripe.android.ui.core.elements.SectionFieldElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0001\u00a2\u0006\u0002\b\u0010J\u001f\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0013\u001a\u00020\r2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\b0\u0017H\u0002R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/ui/core/address/AddressFieldElementRepository;", "", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "countryFieldMap", "", "", "", "Lcom/stripe/android/ui/core/elements/SectionFieldElement;", "getResources", "()Landroid/content/res/Resources;", "add", "", "countryCode", "listElements", "add$payments_ui_core_release", "get", "get$payments_ui_core_release", "initialize", "schema", "Ljava/io/ByteArrayInputStream;", "countryAddressSchemaPair", "", "Lcom/stripe/android/ui/core/address/CountryAddressSchema;", "Companion", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class AddressFieldElementRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Resources resources;
    @NotNull
    private final Map<String, List<SectionFieldElement>> countryFieldMap;
    public static final int $stable = 8;
    @NotNull
    public static final String DEFAULT_COUNTRY_CODE = "ZZ";
    @NotNull
    private static final Set<String> supportedCountries;

    /*
     * WARNING - void declaration
     */
    @Inject
    public AddressFieldElementRepository(@Nullable Resources resources) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        String string2;
        Map map2;
        Object object;
        Map $this$associateWith$iv;
        this.resources = resources;
        this.countryFieldMap = new LinkedHashMap();
        Iterable iterable = supportedCountries;
        AddressFieldElementRepository addressFieldElementRepository = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void countryCode;
            String string3 = (String)element$iv$iv;
            object = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            string2 = "addressinfo/" + (String)countryCode + ".json";
            map2.put(object, string2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            InputStream inputStream;
            void $dstr$_u24__u24$assetFileName;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            map2 = map3;
            boolean bl2 = false;
            String assetFileName = (String)$dstr$_u24__u24$assetFileName.getValue();
            Resources resources2 = this.getResources();
            if (resources2 == null) {
                inputStream = null;
            } else {
                AssetManager assetManager = resources2.getAssets();
                inputStream = assetManager == null ? null : assetManager.open(assetFileName);
            }
            if (TransformAddressToElementKt.parseAddressesSchema(inputStream) == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            map2.put(object, string2);
        }
        addressFieldElementRepository.initialize(destination$iv$iv);
    }

    @Nullable
    public final Resources getResources() {
        return this.resources;
    }

    @Nullable
    public final List<SectionFieldElement> get$payments_ui_core_release(@Nullable String countryCode) {
        List<SectionFieldElement> list;
        String string2 = countryCode;
        if (string2 == null) {
            list = null;
        } else {
            String it = string2;
            boolean bl = false;
            list = this.countryFieldMap.get(it);
        }
        List<SectionFieldElement> list2 = list;
        return list2 == null ? this.countryFieldMap.get(DEFAULT_COUNTRY_CODE) : list2;
    }

    @VisibleForTesting
    public final void initialize(@NotNull String countryCode, @NotNull ByteArrayInputStream schema) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        List<CountryAddressSchema> list = TransformAddressToElementKt.parseAddressesSchema(schema);
        Intrinsics.checkNotNull(list);
        this.initialize(MapsKt.mapOf((Pair)TuplesKt.to((Object)countryCode, list)));
    }

    /*
     * WARNING - void declaration
     */
    private final void initialize(Map<String, ? extends List<CountryAddressSchema>> countryAddressSchemaPair) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends List<CountryAddressSchema>> $this$map$iv = countryAddressSchemaPair;
        boolean $i$f$map = false;
        Map<String, ? extends List<CountryAddressSchema>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$countryCode$schemaList;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String countryCode = (String)$dstr$countryCode$schemaList.getKey();
            List schemaList = (List)$dstr$countryCode$schemaList.getValue();
            List<SectionFieldElement> list = TransformAddressToElementKt.transformToElementList(schemaList);
            if (list == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            collection.add(TuplesKt.to((Object)countryCode, list));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.add$payments_ui_core_release((String)it.getFirst(), (List)it.getSecond());
        }
    }

    @VisibleForTesting
    public final void add$payments_ui_core_release(@NotNull String countryCode, @NotNull List<? extends SectionFieldElement> listElements) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter(listElements, (String)"listElements");
        this.countryFieldMap.put(countryCode, listElements);
    }

    static {
        Object[] objectArray = new String[]{"AC", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CV", "CW", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MK", "ML", "MM", "MN", "MO", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SZ", "TA", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VN", "VU", "WF", "WS", "XK", "YE", "YT", "ZA", "ZM", "ZW", DEFAULT_COUNTRY_CODE};
        supportedCountries = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/ui/core/address/AddressFieldElementRepository$Companion;", "", "()V", "DEFAULT_COUNTRY_CODE", "", "getDEFAULT_COUNTRY_CODE$payments_ui_core_release$annotations", "supportedCountries", "", "getSupportedCountries$payments_ui_core_release$annotations", "getSupportedCountries$payments_ui_core_release", "()Ljava/util/Set;", "payments-ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getDEFAULT_COUNTRY_CODE$payments_ui_core_release$annotations() {
        }

        @NotNull
        public final Set<String> getSupportedCountries$payments_ui_core_release() {
            return supportedCountries;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSupportedCountries$payments_ui_core_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

