/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.elements.BankRepository;
import com.stripe.android.ui.core.elements.DropdownFieldController;
import com.stripe.android.ui.core.elements.IdentifierSpec;
import com.stripe.android.ui.core.elements.SectionFieldElement;
import com.stripe.android.ui.core.elements.SectionFieldSpec;
import com.stripe.android.ui.core.elements.SimpleDropdownConfig;
import com.stripe.android.ui.core.elements.SimpleDropdownElement;
import com.stripe.android.ui.core.elements.SupportedBankType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aJ\u0019\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/stripe/android/ui/core/elements/BankDropdownSpec;", "Lcom/stripe/android/ui/core/elements/SectionFieldSpec;", "identifier", "Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "label", "", "bankType", "Lcom/stripe/android/ui/core/elements/SupportedBankType;", "(Lcom/stripe/android/ui/core/elements/IdentifierSpec;ILcom/stripe/android/ui/core/elements/SupportedBankType;)V", "getBankType", "()Lcom/stripe/android/ui/core/elements/SupportedBankType;", "getIdentifier", "()Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "getLabel", "()I", "component1", "component2", "component3", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "", "transform", "Lcom/stripe/android/ui/core/elements/SectionFieldElement;", "bankRepository", "Lcom/stripe/android/ui/core/elements/BankRepository;", "initialValue", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-ui-core_release"})
@Parcelize
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@StabilityInferred(parameters=0)
public final class BankDropdownSpec
extends SectionFieldSpec {
    @NotNull
    private final IdentifierSpec identifier;
    private final int label;
    @NotNull
    private final SupportedBankType bankType;
    @NotNull
    public static final Parcelable.Creator<BankDropdownSpec> CREATOR;
    public static final int $stable;

    public BankDropdownSpec(@NotNull IdentifierSpec identifier, @StringRes int label, @NotNull SupportedBankType bankType) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)((Object)bankType), (String)"bankType");
        super(identifier, null);
        this.identifier = identifier;
        this.label = label;
        this.bankType = bankType;
    }

    @Override
    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    public final int getLabel() {
        return this.label;
    }

    @NotNull
    public final SupportedBankType getBankType() {
        return this.bankType;
    }

    @NotNull
    public final SectionFieldElement transform(@NotNull BankRepository bankRepository, @Nullable String initialValue) {
        Intrinsics.checkNotNullParameter((Object)bankRepository, (String)"bankRepository");
        return new SimpleDropdownElement(this.getIdentifier(), new DropdownFieldController(new SimpleDropdownConfig(this.label, bankRepository.get(this.bankType)), initialValue));
    }

    @NotNull
    public final IdentifierSpec component1() {
        return this.getIdentifier();
    }

    public final int component2() {
        return this.label;
    }

    @NotNull
    public final SupportedBankType component3() {
        return this.bankType;
    }

    @NotNull
    public final BankDropdownSpec copy(@NotNull IdentifierSpec identifier, @StringRes int label, @NotNull SupportedBankType bankType) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)((Object)bankType), (String)"bankType");
        return new BankDropdownSpec(identifier, label, bankType);
    }

    public static /* synthetic */ BankDropdownSpec copy$default(BankDropdownSpec bankDropdownSpec, IdentifierSpec identifierSpec, int n, SupportedBankType supportedBankType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            identifierSpec = bankDropdownSpec.getIdentifier();
        }
        if ((n2 & 2) != 0) {
            n = bankDropdownSpec.label;
        }
        if ((n2 & 4) != 0) {
            supportedBankType = bankDropdownSpec.bankType;
        }
        return bankDropdownSpec.copy(identifierSpec, n, supportedBankType);
    }

    @NotNull
    public String toString() {
        return "BankDropdownSpec(identifier=" + this.getIdentifier() + ", label=" + this.label + ", bankType=" + (Object)((Object)this.bankType) + ')';
    }

    public int hashCode() {
        int result = this.getIdentifier().hashCode();
        result = result * 31 + Integer.hashCode(this.label);
        result = result * 31 + this.bankType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BankDropdownSpec)) {
            return false;
        }
        BankDropdownSpec bankDropdownSpec = (BankDropdownSpec)other;
        if (!Intrinsics.areEqual((Object)this.getIdentifier(), (Object)bankDropdownSpec.getIdentifier())) {
            return false;
        }
        if (this.label != bankDropdownSpec.label) {
            return false;
        }
        return this.bankType == bankDropdownSpec.bankType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeParcelable((Parcelable)this.identifier, flags);
        out.writeInt(this.label);
        out.writeString(this.bankType.name());
    }

    static {
        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<BankDropdownSpec> {
            @NotNull
            public final BankDropdownSpec[] newArray(int size) {
                return new BankDropdownSpec[size];
            }

            @NotNull
            public final BankDropdownSpec createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new BankDropdownSpec((IdentifierSpec)parcel.readParcelable(BankDropdownSpec.class.getClassLoader()), parcel.readInt(), SupportedBankType.valueOf(parcel.readString()));
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

